/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.common.stereotype.RoutinelyUsedInExtensionCode;
import com.dataiku.dip.activity.UsageSummaryModel;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.LLMModelHandle;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.custom.CustomLLMClient;
import com.dataiku.dip.llm.governance.GuardrailsPipelineSettings;
import com.dataiku.dip.llm.utils.OnlineLLMUtils;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.retries.DefaultRetryStrategy;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.retries.StandardRetryStrategy;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.retries.api.BackoffStrategy;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.retries.api.RetryStrategy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractLLMConnection<M extends BaseModel, HM extends IHardcodedConnectionModel, CM extends CustomModel>
extends DSSConnection
implements ConnectionWithEncryptedFields {
    protected static final LinkedHashSet<LLMUsagePurpose> PROMPT_DRIVEN_PURPOSE_SET = new LinkedHashSet<LLMUsagePurpose>(Arrays.asList(LLMUsagePurpose.GENERIC_COMPLETION, LLMUsagePurpose.CLASSIFICATION_WITH_USER_PROVIDED_CLASSES, LLMUsagePurpose.SENTIMENT_ANALYSIS, LLMUsagePurpose.EMOTION_ANALYSIS, LLMUsagePurpose.SUMMARIZATION));
    protected static final LinkedHashSet<LLMUsagePurpose> PROMPT_DRIVEN_PURPOSE_SET_WITH_VISION = new LinkedHashSet<LLMUsagePurpose>(Arrays.asList(LLMUsagePurpose.GENERIC_COMPLETION, LLMUsagePurpose.CLASSIFICATION_WITH_USER_PROVIDED_CLASSES, LLMUsagePurpose.SENTIMENT_ANALYSIS, LLMUsagePurpose.EMOTION_ANALYSIS, LLMUsagePurpose.SUMMARIZATION, LLMUsagePurpose.IMAGE_INPUT));
    protected static final LinkedHashSet<LLMUsagePurpose> PROMPT_DRIVEN_PURPOSE_SET_WITH_FT = new LinkedHashSet<LLMUsagePurpose>(Arrays.asList(LLMUsagePurpose.GENERIC_COMPLETION, LLMUsagePurpose.CLASSIFICATION_WITH_USER_PROVIDED_CLASSES, LLMUsagePurpose.SENTIMENT_ANALYSIS, LLMUsagePurpose.EMOTION_ANALYSIS, LLMUsagePurpose.SUMMARIZATION, LLMUsagePurpose.FINE_TUNING));
    public static String ENABLED_MODELS = "Enabled models";
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.connections.llmconnection");

    public AbstractLLMConnection() {
        this.allowWrite = false;
        this.allowManagedDatasets = false;
        this.allowManagedFolders = false;
    }

    protected abstract DKULogger getLogger();

    public final List<M> listAllModels() {
        return this.listModels(null);
    }

    public final List<? extends M> listAvailableModels(@Nullable LLMUsagePurpose purpose) {
        return this.listModels(m -> m.isValid() && m.isEnabled() && (purpose == null || m.canBeUsedForPurpose(purpose)));
    }

    public ConnectionModelHandle getLLMModel(LLMStructuredRef llmRef) {
        return this.listAllModels().stream().map(x$0 -> new ConnectionModelHandle(this, x$0)).filter(m -> m.getRef().equals(llmRef)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Could not find the model %s in connection %s", llmRef.getModelNameForAudit(), this.name)));
    }

    protected List<CM> listRawCustomModels() {
        return Collections.emptyList();
    }

    protected M loadRawCustomModel(CM rawCustomModel) {
        throw new UnsupportedOperationException("No custom models for " + this.type + " connection");
    }

    protected void loadDefaultCustomModelSettings(CM customModel, BaseModel model) {
        model.canBeFineTuned = model.canBeFineTuned && this.getLLMConnectionParams().allowFinetuning;
        model.batchSize = this.getCustomBatchSizeOrNull(QueryType.fromModel(model), model.getId());
    }

    protected List<HM> listRawHardcodedModels() {
        return Collections.emptyList();
    }

    protected M loadRawHardcodedModel(HM hardcodedModel) {
        throw new UnsupportedOperationException("No hardcoded models for " + this.type + " connection");
    }

    protected void loadDefaultHardcodedModelSettings(HM hardcodedModel, BaseModel model) {
        model.enabled = this.isHardcodedModelEnabled(hardcodedModel);
        model.canBeFineTuned = model.canBeFineTuned && this.getLLMConnectionParams().allowFinetuning;
        model.batchSize = this.getCustomBatchSizeOrNull(QueryType.fromModel(model), model.getId());
    }

    protected boolean isHardcodedModelEnabled(HM model) {
        return true;
    }

    private List<? extends M> listCustomModels() {
        ArrayList<M> customModels = new ArrayList<M>();
        for (CustomModel rawCustomModel : this.listRawCustomModels()) {
            try {
                customModels.add(this.loadRawCustomModel(rawCustomModel));
            }
            catch (Exception e) {
                this.getLogger().warn((Object)"Ignoring custom model due to underlying error during load", (Throwable)e);
            }
        }
        return customModels;
    }

    private List<? extends M> listHardcodedModels() {
        ArrayList<M> hardcodedModels = new ArrayList<M>();
        for (IHardcodedConnectionModel rawHardcodedModel : this.listRawHardcodedModels()) {
            try {
                hardcodedModels.add(this.loadRawHardcodedModel(rawHardcodedModel));
            }
            catch (Exception e) {
                this.getLogger().warn((Object)"Ignoring hardcoded model due to underlying error during load", (Throwable)e);
            }
        }
        return hardcodedModels;
    }

    private List<M> listModels(@Nullable Predicate<M> filterPredicate) {
        String key;
        ArrayList<BaseModel> refs = new ArrayList<BaseModel>();
        HashSet<String> alreadyListed = new HashSet<String>();
        for (BaseModel customModel : this.listCustomModels()) {
            if (filterPredicate != null && !filterPredicate.test(customModel)) continue;
            key = this.generateUniqueModelIdentifier(customModel);
            if (alreadyListed.contains(key)) {
                this.getLogger().infoV("%s overridden by another custom model in connection %s", new Object[]{customModel.getId(), this.name});
                continue;
            }
            refs.add(customModel);
            alreadyListed.add(key);
        }
        for (BaseModel hardcodedModel : this.listHardcodedModels()) {
            if (filterPredicate != null && !filterPredicate.test(hardcodedModel)) continue;
            key = this.generateUniqueModelIdentifier(hardcodedModel);
            if (alreadyListed.contains(key)) {
                this.getLogger().infoV("%s overridden by a custom model in connection %s", new Object[]{hardcodedModel.getId(), this.name});
                continue;
            }
            refs.add(hardcodedModel);
        }
        return refs;
    }

    protected String generateUniqueModelIdentifier(M model) {
        return ((BaseModel)model).getId();
    }

    public abstract AbstractLLMConnectionParams getLLMConnectionParams();

    public void throwIfBadImageAuditFolder() {
        AbstractLLMConnectionParams params = this.getLLMConnectionParams();
        if (params == null || !params.storeImages) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)params.imageAuditManagedFolderRef)) {
            throw new IllegalArgumentException(String.format("Misconfigured image audit managed folder '%s'.", params.imageAuditManagedFolderRef));
        }
        String[] refChunks = params.imageAuditManagedFolderRef.split("\\.");
        if (refChunks.length != 2 || Arrays.stream(refChunks).anyMatch(String::isBlank)) {
            throw new IllegalArgumentException(String.format("Misconfigured image audit managed folder '%s'.", params.imageAuditManagedFolderRef));
        }
    }

    public List<EnrichedLLMStructuredRef> listAvailableLLMStructuredRefs(LLMUsagePurpose purpose) {
        return this.listAvailableModels(purpose).stream().map(m -> m.asEnrichedRef(this.name)).collect(Collectors.toList());
    }

    public boolean ignoreConnectionTest(LLMStructuredRef llmRef) {
        return false;
    }

    public void ensureDecrypted() {
        this.decryptFields((PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class));
    }

    @Nullable
    protected Integer getCustomBatchSizeOrNull(QueryType queryType, String modelId) {
        Optional<AbstractSQLConnection.CustomDatabaseProperty> match = this.getCustomProperty("batchSize", queryType, modelId);
        try {
            return match.map(p -> Integer.parseInt(p.value)).orElse(null);
        }
        catch (NumberFormatException e) {
            this.getLogger().warn((Object)("Unable to parse batch property value: " + String.valueOf(match)), (Throwable)e);
            return null;
        }
    }

    Optional<Boolean> getCustomPropertyFlag(String keyPrefix, @Nullable QueryType queryType, @Nullable String modelId) {
        return this.getCustomProperty(keyPrefix, queryType, modelId).flatMap(property -> {
            if ("true".equalsIgnoreCase(property.value)) {
                return Optional.of(Boolean.TRUE);
            }
            if ("false".equalsIgnoreCase(property.value)) {
                return Optional.of(Boolean.FALSE);
            }
            return Optional.empty();
        });
    }

    <T extends Enum<T>> T getCustomPropertyEnum(String keyPrefix, @Nullable QueryType queryType, @Nullable String modelId, @Nonnull T defaultValue) {
        Optional optionalValue = this.getCustomProperty(keyPrefix, queryType, modelId).flatMap(property -> Optional.of(property.value));
        if (optionalValue.isEmpty()) {
            return defaultValue;
        }
        String value = (String)optionalValue.get();
        EnumSet<Enum> possibleValues = EnumSet.allOf(defaultValue.getClass());
        for (Enum e : possibleValues) {
            if (!e.name().equalsIgnoreCase(value)) continue;
            return (T)e;
        }
        return defaultValue;
    }

    @VisibleForTesting
    Optional<AbstractSQLConnection.CustomDatabaseProperty> getCustomProperty(String keyPrefix, @Nullable QueryType queryType, @Nullable String modelId) {
        Optional<AbstractSQLConnection.CustomDatabaseProperty> match;
        if (queryType != null && modelId != null && (match = this.getDkuProperties().stream().filter(p -> AbstractLLMConnection.modelPropertyKey(keyPrefix, queryType, modelId).equalsIgnoreCase(p.name)).findFirst()).isPresent()) {
            return match;
        }
        if (modelId != null && (match = this.getDkuProperties().stream().filter(p -> AbstractLLMConnection.modelPropertyKey(keyPrefix, null, modelId).equalsIgnoreCase(p.name)).findFirst()).isPresent()) {
            return match;
        }
        if (queryType != null && (match = this.getDkuProperties().stream().filter(p -> AbstractLLMConnection.modelPropertyKey(keyPrefix, queryType, null).equalsIgnoreCase(p.name)).findFirst()).isPresent()) {
            return match;
        }
        return this.getDkuProperties().stream().filter(p -> keyPrefix.equalsIgnoreCase(p.name)).findFirst();
    }

    private static String modelPropertyKey(String keyPrefix, QueryType queryType, @Nullable String modelId) {
        if (queryType != null && modelId != null) {
            return String.join((CharSequence)".", keyPrefix, queryType.toString(), modelId);
        }
        if (modelId != null) {
            return String.join((CharSequence)".", keyPrefix, modelId);
        }
        if (queryType != null) {
            return String.join((CharSequence)".", keyPrefix, queryType.toString());
        }
        return keyPrefix;
    }

    @Override
    public List<AbstractSQLConnection.CustomDatabaseProperty> getDkuProperties() {
        return this.getLLMConnectionParams().dkuProperties;
    }

    public String getModelDetailedTypeForCRUAggregation(String llmId) {
        LLMStructuredRef ref = LLMStructuredRef.decodeId(llmId);
        return String.valueOf((Object)ref.type) + "_" + ref.getMinimallyLeakyModelNameForReporting();
    }

    public void fillModelsForGlobalSummaryReport(UsageSummaryModel.LLMConnectionSummary lcs) {
        for (BaseModel cm : this.listCustomModels()) {
            if (cm.canBeUsedForPurpose(LLMUsagePurpose.TEXT_EMBEDDING_EXTRACTION)) {
                ++lcs.enabledTextEmbeddingCustomModels;
                continue;
            }
            if (cm.canBeUsedForPurpose(LLMUsagePurpose.IMAGE_EMBEDDING_EXTRACTION)) {
                ++lcs.enabledImageEmbeddingCustomModels;
                continue;
            }
            ++lcs.enabledCompletionCustomModels;
        }
        for (BaseModel hardcodedModel : this.listHardcodedModels()) {
            if (!hardcodedModel.isEnabled()) continue;
            if (hardcodedModel.canBeUsedForPurpose(LLMUsagePurpose.TEXT_EMBEDDING_EXTRACTION)) {
                lcs.enabledTextEmbeddingStandardModels.add(hardcodedModel.getId());
                continue;
            }
            if (hardcodedModel.canBeUsedForPurpose(LLMUsagePurpose.IMAGE_EMBEDDING_EXTRACTION)) {
                lcs.enabledImageEmbeddingStandardModels.add(hardcodedModel.getId());
                continue;
            }
            lcs.enabledCompletionStandardModels.add(hardcodedModel.getId());
        }
    }

    @Override
    public boolean isADataStoringConnection() {
        return false;
    }

    public Map<String, Object> getConsistencyCheckables() {
        AbstractLLMConnectionParams params = this.getLLMConnectionParams();
        HashMap<String, Object> consistencyCheckables = new HashMap<String, Object>();
        consistencyCheckables.put(ENABLED_MODELS, this.listAllModels().stream().filter(model -> model.enabled).map(model -> model.id).collect(Collectors.toSet()));
        consistencyCheckables.put("Guardrails", params.guardrailsPipelineSettings);
        return consistencyCheckables;
    }

    public static enum LLMUsagePurpose {
        GENERIC_COMPLETION("Text generation"),
        CLASSIFICATION_WITH_USER_PROVIDED_CLASSES("Text classification: Custom classes (aka zero-shot)"),
        SENTIMENT_ANALYSIS("Text classification: Sentiment analysis"),
        EMOTION_ANALYSIS("Text classification: Emotion analysis"),
        CLASSIFICATION_WITH_OTHER_MODEL_PROVIDED_CLASSES("Text classification: Other use cases", false, false),
        TOXICITY_DETECTION("Toxicity detection", false, false),
        PROMPT_INJECTION_DETECTION("Prompt injection detection", false, false),
        SUMMARIZATION("Text summarization"),
        TEXT_EMBEDDING_EXTRACTION("Text embedding", false, false),
        IMAGE_EMBEDDING_EXTRACTION("Image embedding", false, false),
        FINE_TUNING("Fine-tunable", false, true),
        IMAGE_GENERATION("Image generation", false, false),
        IMAGE_INPUT("Image input", false, true);

        public final String displayName;
        public final boolean supportedByKbAugmentedModels;
        public final boolean supportedBySavedModelLLMs;

        private LLMUsagePurpose(String displayName, boolean supportedByKbAugmentedModels, boolean supportedBySavedModelLLMs) {
            this.displayName = displayName;
            this.supportedByKbAugmentedModels = supportedByKbAugmentedModels;
            this.supportedBySavedModelLLMs = supportedBySavedModelLLMs;
        }

        private LLMUsagePurpose(String displayName) {
            this(displayName, true, true);
        }
    }

    public static class ConnectionModelHandle
    implements LLMModelHandle<M> {
        private final M model;
        final /* synthetic */ AbstractLLMConnection this$0;

        public ConnectionModelHandle(M model) {
            this.this$0 = this$0;
            this.model = model;
        }

        @Override
        public LLMStructuredRef getRef() {
            return ((BaseModel)this.model).asStructuredRef(this.getConnectionName());
        }

        @Override
        public EnrichedLLMStructuredRef getEnrichedRef() {
            return ((BaseModel)this.model).asEnrichedRef(this.getConnectionName());
        }

        @Override
        public M getModel() {
            return this.model;
        }

        private final String getConnectionName() {
            return this.this$0.name;
        }
    }

    public static abstract class BaseModel
    implements LLMModelHandle.Model {
        public String id;
        public String refinerId;
        public String displayName;
        public Integer embeddingSize;
        public Integer maxTokensLimit;
        public boolean canBeFineTuned;
        public Double promptCost;
        public Double completionCost;
        public Double embeddingCost;
        public Double imageEmbeddingCost;
        public boolean enabled = true;
        public Integer batchSize;
        public Integer defaultHeight;
        public Integer defaultWidth;
        public Integer defaultNumInferenceSteps;
        public Float defaultGuidanceScale;
        public Float defaultStrength;
        public Integer maxSequenceLength;

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public Integer getEmbeddingSize() {
            return this.embeddingSize;
        }

        @Override
        public Integer getMaxTokensLimit() {
            return this.maxTokensLimit;
        }

        @Override
        public boolean canBeFineTuned() {
            return this.canBeFineTuned;
        }

        @Override
        public Double getPromptCost() {
            return this.promptCost;
        }

        @Override
        public Double getCompletionCost() {
            return this.completionCost;
        }

        @Override
        public Double getTextEmbeddingCost() {
            return this.embeddingCost;
        }

        @Override
        public Double getImageEmbeddingCost() {
            return this.imageEmbeddingCost;
        }

        @Override
        public boolean canBeUsedForPurpose(@Nonnull LLMUsagePurpose purpose) {
            return PROMPT_DRIVEN_PURPOSE_SET.contains((Object)purpose);
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public OptionalInt getBatchSize() {
            return this.batchSize == null ? OptionalInt.empty() : OptionalInt.of(this.batchSize);
        }

        protected void loadFromCustomModel(CustomModel customModel) {
            this.canBeFineTuned = customModel.canBeFineTuned;
            this.promptCost = customModel.promptCost;
            this.completionCost = customModel.completionCost;
            this.embeddingCost = customModel.embeddingCost;
            this.imageEmbeddingCost = customModel.imageEmbeddingCost;
            this.embeddingSize = customModel.embeddingSize;
            this.maxTokensLimit = customModel.maxTokensLimit;
            this.refinerId = customModel.refinerId;
            this.defaultHeight = customModel.defaultHeight;
            this.defaultWidth = customModel.defaultWidth;
            this.defaultNumInferenceSteps = customModel.defaultNumInferenceSteps;
            this.defaultGuidanceScale = customModel.defaultGuidanceScale;
            this.defaultStrength = customModel.defaultStrength;
        }

        abstract LLMStructuredRef asStructuredRef(String var1);

        protected EnrichedLLMStructuredRef asEnrichedRef(String connection) {
            LLMStructuredRef ref = this.asStructuredRef(connection);
            String friendlyNameShort = StringUtils.isNotBlank((CharSequence)this.getDisplayName()) ? this.getDisplayName() : this.getId();
            ModelCapabilities modelCapabilities = this.getModelCapabilities();
            String friendlyName = String.format("%s (connection: %s)", friendlyNameShort, connection);
            EnrichedLLMStructuredRef enrichedRef = new EnrichedLLMStructuredRef(ref, friendlyName, friendlyNameShort, this.getEmbeddingSize(), this.getMaxTokensLimit());
            enrichedRef.loadModelCapabilities(modelCapabilities);
            return enrichedRef;
        }
    }

    public static class AbstractLLMConnectionParams
    extends DSSConnection.DkuConnectionParams {
        public LLMQueriesAuditingMode auditingMode = LLMQueriesAuditingMode.METADATA_ONLY;
        public boolean auditCompletionTraces;
        public boolean auditImageGenerationTraces;
        public GuardrailsPipelineSettings guardrailsPipelineSettings = new GuardrailsPipelineSettings();
        public List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        public boolean cachingEnabled;
        public boolean embeddingsCachingEnabled = true;
        public boolean storeImages;
        public String imageAuditManagedFolderRef;
        public boolean allowFinetuning = false;

        public void encryptProperties(List<AbstractSQLConnection.CustomDatabaseProperty> properties, PasswordEncryptionService cryptoService) {
            for (AbstractSQLConnection.CustomDatabaseProperty customHeader : properties) {
                if (!customHeader.secret) continue;
                customHeader.value = cryptoService.encryptIfNotEncryptedOrEmpty(customHeader.value);
            }
        }

        public void decryptProperties(List<AbstractSQLConnection.CustomDatabaseProperty> properties, PasswordEncryptionService cryptoService) {
            for (AbstractSQLConnection.CustomDatabaseProperty customHeader : properties) {
                if (!customHeader.secret) continue;
                customHeader.value = cryptoService.decryptIfEncrypted(customHeader.value);
            }
        }
    }

    public static enum QueryType {
        completion,
        textEmbedding,
        imageEmbedding,
        imageGeneration;


        public static QueryType fromModel(LLMModelHandle.Model model) {
            if (model.canBeUsedForPurpose(LLMUsagePurpose.IMAGE_EMBEDDING_EXTRACTION)) {
                return imageEmbedding;
            }
            if (model.canBeUsedForPurpose(LLMUsagePurpose.TEXT_EMBEDDING_EXTRACTION)) {
                return textEmbedding;
            }
            if (model.canBeUsedForPurpose(LLMUsagePurpose.IMAGE_GENERATION)) {
                return imageGeneration;
            }
            return completion;
        }
    }

    public static interface IHardcodedConnectionModel<M> {
        public M toModel();
    }

    public static abstract class CustomModel<M> {
        protected boolean canBeFineTuned;
        public Double promptCost;
        public Double completionCost;
        public Double embeddingCost;
        public Double imageEmbeddingCost;
        public Integer embeddingSize;
        public Integer maxTokensLimit;
        public String refinerId;
        public Integer defaultHeight;
        public Integer defaultWidth;
        public Integer defaultNumInferenceSteps;
        public Float defaultGuidanceScale;
        public Float defaultStrength;
        public Integer maxSequenceLength;

        abstract M toModel();
    }

    @RoutinelyUsedInExtensionCode
    public static class HTTPBasedLLMNetworkSettings {
        public int queryTimeoutMS = 60000;
        public int maxRetries = 3;
        public long initialRetryDelayMS = 3000L;
        public double retryDelayScalingFactor = 2.0;

        public ClientOverrideConfiguration createRetryStrategy() {
            StandardRetryStrategy.Builder strategyBuilder = DefaultRetryStrategy.standardStrategyBuilder();
            if (this.initialRetryDelayMS > 0L) {
                Duration baseDelay = Duration.ofMillis(this.initialRetryDelayMS);
                Duration maxDelay = Duration.ofMillis(OnlineLLMUtils.backoffDelay(this, this.maxRetries + 1));
                strategyBuilder.backoffStrategy(BackoffStrategy.exponentialDelayHalfJitter((Duration)baseDelay, (Duration)maxDelay));
            }
            if (this.maxRetries >= 0) {
                strategyBuilder.maxAttempts(this.maxRetries + 1);
            }
            return (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().retryStrategy((RetryStrategy)strategyBuilder.build()).build();
        }

        public HTTPBasedLLMNetworkSettings copyWithoutRetry() {
            HTTPBasedLLMNetworkSettings newNetworkSettings = new HTTPBasedLLMNetworkSettings();
            newNetworkSettings.maxRetries = 0;
            newNetworkSettings.initialRetryDelayMS = 0L;
            newNetworkSettings.queryTimeoutMS = this.queryTimeoutMS;
            newNetworkSettings.retryDelayScalingFactor = this.retryDelayScalingFactor;
            return newNetworkSettings;
        }

        @RoutinelyUsedInExtensionCode
        public CustomLLMClient.RateLimitingRetrySettings toRateLimitingRetrySettings() {
            CustomLLMClient.RateLimitingRetrySettings retrySettings = new CustomLLMClient.RateLimitingRetrySettings();
            retrySettings.maxRetries = this.maxRetries;
            retrySettings.initialRetryDelayMS = this.initialRetryDelayMS;
            retrySettings.retryDelayScalingFactor = this.retryDelayScalingFactor;
            return retrySettings;
        }

        public static HTTPBasedLLMNetworkSettings of(CustomLLMClient.RateLimitingRetrySettings retrySettings) {
            HTTPBasedLLMNetworkSettings networkSettings = new HTTPBasedLLMNetworkSettings();
            networkSettings.maxRetries = retrySettings.maxRetries;
            networkSettings.initialRetryDelayMS = retrySettings.initialRetryDelayMS;
            networkSettings.retryDelayScalingFactor = retrySettings.retryDelayScalingFactor;
            return networkSettings;
        }
    }

    public static enum LLMQueriesAuditingMode {
        NONE,
        METADATA_ONLY,
        FULL_DATA;

    }

    public static class ModelCapabilities {
        public boolean promptDriven = true;
        public boolean customClassificationRequiresHypothesisTemplate;
        public boolean canDoNativeSentimentAnalysis;
        public boolean canDoNativeEmotionAnalysis;
        public boolean canGenerateCrossLanguageOutput;
        public boolean handlesSystemMessage;
        public boolean supportsImageInputs;
        @Nullable
        public EnrichedLLMStructuredRef.FieldRange temperatureRange;
        @Nullable
        public EnrichedLLMStructuredRef.FieldRange topKRange;
    }
}

