/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AbstractCloudStorageConnection;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.AutoFastPathConnection;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.ConnectionWithGoogleAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithPerUserOAuth2Credentials;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.GCSConnection;
import com.dataiku.dip.connections.GoogleUserAgentBuilder;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.BigQuerySQLDialect;
import com.dataiku.dip.sql.bigquery.BigQueryClient;
import com.dataiku.dip.sql.bigquery.BigQueryNativeClient;
import com.dataiku.dip.sql.bigquery.EncryptionConfiguration;
import com.dataiku.dip.sql.bigquery.TimeoutSettings;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class BigQueryConnection
extends AbstractSQLConnection
implements ConnectionWithEncryptedFields,
ConnectionWithPerUserOAuth2Credentials,
AutoFastPathConnection,
ConnectionWithGoogleAuthCredentials {
    public static final String DEFAULT_GOOGLE_BIGQUERY_SCOPE = "https://www.googleapis.com/auth/bigquery";
    private static final String PSC_ENDPOINT_URL_PATTERN = "https://bigquery-%s.p.googleapis.com";
    private static final String PSC_ENDPOINT_URL_WITH_PATH_PATTERN = "https://bigquery-%s.p.googleapis.com/bigquery/v2/";
    public static final String connectionType = "BigQuery";
    private static final BigQuerySQLDialect dialect = new BigQuerySQLDialect();
    public Params params = new Params();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.bigquery");

    @Override
    public boolean useAutoFastConnection() {
        return this.params.useAutoFastPath;
    }

    @Override
    public String getAutoFastPathConnection() {
        return this.params.autoFastPathConnection;
    }

    @Override
    public String getAutoFastPathConnectionPath() {
        return this.params.autoFastPathConnectionPath;
    }

    @Override
    public boolean isSupportedCloudStorage(AbstractCloudStorageConnection connection) {
        return connection instanceof GCSConnection;
    }

    @Override
    public boolean actuallyHasPerUserOAuth2Credential() {
        return this.credentialsMode == DSSConnection.CredentialsMode.PER_USER && this.params.authType == ConnectionWithGoogleAuthCredentials.AuthType.OAUTH;
    }

    @Override
    public SQLConnectionProvider.SQLConnectionData getConnectionData_NT(AuthCtx authCtx, String projectKey) throws DKUSecurityException, SQLException {
        SerializableBigQueryCredentials creds = this.getFullyResolvedCredentials_sqlLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null), SerializableBigQueryCredentials.class);
        SQLConnectionProvider.BigQuerySQLConnectionData cd = new SQLConnectionProvider.BigQuerySQLConnectionData(this.getType(), this.getDialect(), this, this.getDriver(), this.getJdbcUrl(), this.getJarsDirectory());
        this.fillConnectionData(cd);
        if (this.params.driverMode == BigQueryDriverMode.CUSTOM) {
            if (creds.authType == ConnectionWithGoogleAuthCredentials.AuthType.OAUTH) {
                cd.withPropertyIfNotBlank(new AbstractSQLConnection.CustomDatabaseProperty("OAuthClientId", creds.oauthAppId, false));
                cd.withPropertyIfNotBlank(new AbstractSQLConnection.CustomDatabaseProperty("OAuthClientSecret", creds.oauthAppSecret, true));
                cd.withPropertyIfNotBlank(new AbstractSQLConnection.CustomDatabaseProperty("OAuthAccessToken", creds.oauthAccessToken, true));
                cd.withPropertyIfNotBlank(new AbstractSQLConnection.CustomDatabaseProperty("OAuthRefreshToken", creds.oauthRefreshToken, true));
            } else if (StringUtils.isNotBlank((String)creds.keyPath) || StringUtils.isNotBlank((String)creds.keyJsonData)) {
                cd.withPropertyIfNotBlank(new AbstractSQLConnection.CustomDatabaseProperty("OAuthType", "0", false));
                if (StringUtils.isNotBlank((String)creds.keyEmail)) {
                    cd.withPropertyIfNotBlank(new AbstractSQLConnection.CustomDatabaseProperty("OAuthServiceAcctEmail", creds.keyEmail, false));
                }
                if (StringUtils.isNotBlank((String)creds.keyPath)) {
                    String localKeyPath = creds.getLocalKeyPath(this);
                    cd.withPropertyIfNotBlank(new AbstractSQLConnection.CustomDatabaseProperty("OAuthPvtKeyPath", localKeyPath, false));
                } else {
                    cd.withPropertyIfNotBlank(new AbstractSQLConnection.CustomDatabaseProperty("OAuthPvtKey", creds.keyJsonData, true));
                }
            } else {
                cd.withPropertyIfNotBlank(new AbstractSQLConnection.CustomDatabaseProperty("OAuthType", "3", false));
            }
        }
        if (this.getProxySettings().hasProxy() && StringUtils.isNotBlank((String)this.params.truststorePath)) {
            cd.withPropertyIfNotBlank(new AbstractSQLConnection.CustomDatabaseProperty("SSLTrustStore", this.params.truststorePath, false));
            cd.withPropertyIfNotBlank(new AbstractSQLConnection.CustomDatabaseProperty("SSLTrustStorePwd", creds.truststoreSecret, true));
        }
        return cd;
    }

    @Override
    public AbstractSQLConnection.AbstractSQLParams getParams() {
        return this.params;
    }

    @Override
    public ConnectionWithGoogleAuthCredentials.IGoogleAuth2Params getGoogleAuth2NonResolvedParams() {
        return this.params;
    }

    @Override
    public ProxySettings getProxySettingsFromConnection() {
        return this.getProxySettings();
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public BigQuerySQLDialect getDialect() {
        return dialect;
    }

    @Override
    public String getDefaultCatalog() {
        return this.params.projectId;
    }

    public BigQueryClient getRestClient(AuthCtx authCtx) throws DKUSecurityException, IOException, SQLException {
        ConnectionWithBasicCredential.CredentialResolutionContext ctx = new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null);
        ConnectionWithGoogleAuthCredentials.SerializableGoogleAuthCredentials creds = this.getFullyResolvedCredentials(ctx, ConnectionWithGoogleAuthCredentials.SerializableGoogleAuthCredentials.class);
        return new BigQueryClient(this.params.projectId, creds.toGoogleCredential(ctx, this), this.getEncryptionConfiguration(), this.getProxySettings(), this.getTimeoutSettings(), GoogleUserAgentBuilder.buildWithSpringContext(), this.buildPSCEndpointUrl(PSC_ENDPOINT_URL_WITH_PATH_PATTERN));
    }

    public BigQueryNativeClient getClient(AuthCtx authCtx, @Nullable String projectKey) throws IOException, URISyntaxException, DKUSecurityException, SQLException {
        ConnectionWithBasicCredential.CredentialResolutionContext ctx = new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null);
        ConnectionWithGoogleAuthCredentials.SerializableGoogleAuthCredentials creds = this.getFullyResolvedCredentials(ctx, ConnectionWithGoogleAuthCredentials.SerializableGoogleAuthCredentials.class);
        VariablesContext variablesContext = this.getVariablesContext(authCtx, projectKey);
        return new BigQueryNativeClient(this.params.projectId, creds.toGoogleCredentials(ctx, this), this.getEncryptionConfiguration(), this.getProxySettings(), this.getTimeoutSettings(), GoogleUserAgentBuilder.buildWithSpringContext(), this.getResolvedJobLabels(variablesContext), this.buildPSCEndpointUrl(PSC_ENDPOINT_URL_PATTERN), this.getResolvedTemporaryTableLocation(variablesContext));
    }

    @Nullable
    public EncryptionConfiguration getEncryptionConfiguration() {
        String kmsKeyName = this.params.properties.stream().filter(p -> p.name.equals("KMSKeyName")).findFirst().map(p -> p.value).orElse(null);
        if (StringUtils.isNotBlank((String)kmsKeyName)) {
            EncryptionConfiguration encryptionConfig = new EncryptionConfiguration();
            encryptionConfig.kmsKeyName = kmsKeyName;
            return encryptionConfig;
        }
        return null;
    }

    @Override
    String getDriver() {
        if (this.params.driverMode == BigQueryDriverMode.DRIVERLESS) {
            return null;
        }
        return "com.simba.googlebigquery.jdbc42.Driver";
    }

    @Override
    String getJdbcUrl() {
        if (this.params.driverMode == BigQueryDriverMode.DRIVERLESS) {
            return null;
        }
        ProxySettings proxySettings = this.getProxySettings();
        String base = this.params.authType == ConnectionWithGoogleAuthCredentials.AuthType.OAUTH ? String.format("jdbc:bigquery://https://www.googleapis.com/bigquery/v2;OAuthType=2;ProjectId=%s", this.params.projectId) : String.format("jdbc:bigquery://https://www.googleapis.com/bigquery/v2;ProjectId=%s", this.params.projectId);
        if (StringUtils.isNotBlank((String)this.params.pscEndpointId)) {
            return base + this.getJdbcPscParams();
        }
        if (proxySettings.hasProxy()) {
            return base + ProxyUtils.getJdbcUrlProxySettings((ProxySettings)proxySettings);
        }
        return base;
    }

    private String getJdbcPscParams() {
        StringBuilder paramsBuilder = new StringBuilder();
        paramsBuilder.append(";PrivateServiceConnectUris=BIGQUERY=https://bigquery-").append(this.params.pscEndpointId).append(".p.googleapis.com");
        paramsBuilder.append(",READ_API=bigquerystorage-").append(this.params.pscEndpointId).append(".p.googleapis.com:443");
        if (this.params.authType == ConnectionWithGoogleAuthCredentials.AuthType.OAUTH) {
            paramsBuilder.append(",OAUTH2=https://oauth2-").append(this.params.pscEndpointId).append(".p.googleapis.com");
        }
        return paramsBuilder.toString();
    }

    private TimeoutSettings getTimeoutSettings() {
        TimeoutSettings result = new TimeoutSettings();
        Optional<AbstractSQLConnection.CustomDatabaseProperty> timeout = this.getParams().properties.stream().filter(p -> p.name.equals("Timeout")).findFirst();
        timeout.ifPresent(p -> {
            result.readTimeoutInMs = Integer.parseInt(p.value) * 1000;
            result.connectionTimeoutInMs = Integer.parseInt(p.value) * 1000;
        });
        Optional<AbstractSQLConnection.CustomDatabaseProperty> readTimeout = this.getParams().properties.stream().filter(p -> p.name.equals("ReadTimeout")).findFirst();
        readTimeout.ifPresent(p -> {
            result.readTimeoutInMs = Integer.parseInt(p.value) * 1000;
        });
        Optional<AbstractSQLConnection.CustomDatabaseProperty> connectionTimeout = this.getParams().properties.stream().filter(p -> p.name.equals("ConnectionTimeout")).findFirst();
        connectionTimeout.ifPresent(p -> {
            result.connectionTimeoutInMs = Integer.parseInt(p.value) * 1000;
        });
        return result;
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.oauth2ClientSecret = cryptoService.decryptIfEncrypted(this.params.oauth2ClientSecret);
        this.params.truststoreSecret = cryptoService.decryptIfEncrypted(this.params.truststoreSecret);
        this.params.keyPath = cryptoService.decryptIfEncrypted(this.params.keyPath);
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings unused) {
        this.params.oauth2ClientSecret = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.oauth2ClientSecret);
        this.params.truststoreSecret = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.truststoreSecret);
        if (StringUtils.isNotBlank((String)this.params.keyPath) && ConnectionWithGoogleAuthCredentials.isJson(this.params.keyPath)) {
            this.params.keyPath = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.keyPath);
        }
    }

    @Override
    String getDisplayableJdbcUrl() {
        if (this.params.driverMode == BigQueryDriverMode.DRIVERLESS) {
            return "driver-less";
        }
        return this.getJdbcUrl();
    }

    @Override
    public boolean mustResolveOnDSSHost() {
        return this.mustResolveGoogleAuthOnDSSHost();
    }

    @Override
    public boolean mustResolveOnBackend() {
        return this.hasRefreshTokenRotation() || super.mustResolveOnBackend();
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(SerializableBigQueryCredentials.class));
        ConnectionWithGoogleAuthCredentials.SerializableGoogleAuthCredentials creds = this.getResolvedCredential(ctx.authCtx);
        SerializableBigQueryCredentials bqCreds = (SerializableBigQueryCredentials)JSON.parse((String)JSON.json((Object)creds), SerializableBigQueryCredentials.class);
        bqCreds.truststoreSecret = this.params.truststoreSecret;
        return clazz.cast(bqCreds);
    }

    private VariablesContext getVariablesContext(AuthCtx authCtx, @Nullable String projectKey) {
        VariablesService variablesService = (VariablesService)SpringUtils.getBean(VariablesService.class);
        return projectKey != null ? variablesService.getForConnectionAndProject(this, authCtx, projectKey) : variablesService.getForConnection(this, authCtx);
    }

    private BigQueryNativeClient.TableLocation getResolvedTemporaryTableLocation(VariablesContext variablesContext) {
        AbstractSQLConnection.SQLManagedDatasetNamingRule namingRule = this.params.namingRule == null ? new AbstractSQLConnection.SQLManagedDatasetNamingRule() : this.params.namingRule;
        String catalog = variablesContext.expand(namingRule.catalog);
        String schema = variablesContext.expand(namingRule.schemaName);
        if (StringUtils.isBlank((String)catalog) || StringUtils.isBlank((String)schema)) {
            return null;
        }
        return new BigQueryNativeClient.TableLocation(catalog, schema);
    }

    private Map<String, String> getResolvedJobLabels(VariablesContext variablesContext) {
        return this.params.jobLabels.stream().peek(l -> {
            String key = variablesContext.expandEmptyIfUnresolved(l.key);
            l.key = this.sanitizeJobLabelString(key);
            if (!l.key.equals(key)) {
                logger.warnV("Using job label key '%s' instead of '%s'", new Object[]{l.key, key});
            }
            String value = variablesContext.expandEmptyIfUnresolved(l.value);
            l.value = this.sanitizeJobLabelString(value);
            if (!l.value.equals(value)) {
                logger.warnV("Using job label value '%s' instead of '%s'", new Object[]{l.value, value});
            }
        }).collect(Collectors.toMap(l -> l.key, l -> l.value));
    }

    private String sanitizeJobLabelString(String string) {
        String sanitizedString = string.replace(' ', '_').toLowerCase().replaceAll("(?U)[^-0-9_\\p{Lower}]", "");
        return sanitizedString.substring(0, Math.min(sanitizedString.length(), 63));
    }

    private String buildPSCEndpointUrl(String pattern) {
        if (StringUtils.isBlank((String)this.params.pscEndpointId)) {
            return "";
        }
        return String.format(pattern, this.params.pscEndpointId.trim());
    }

    public static class Params
    extends AbstractSQLConnection.AbstractSQLParams
    implements ConnectionWithGoogleAuthCredentials.IGoogleAuth2Params {
        public ConnectionWithGoogleAuthCredentials.AuthType authType = ConnectionWithGoogleAuthCredentials.AuthType.KEYPAIR;
        public String projectId;
        public String keyPath;
        public String serviceAccountEmail;
        public BigQueryDriverMode driverMode = BigQueryDriverMode.DRIVERLESS;
        public String pscEndpointId;
        public boolean useAutoFastPath;
        public String autoFastPathConnection;
        public String autoFastPathConnectionPath;
        public boolean forbidPartitionsWriteToNonPartitionedTable = false;
        public List<SimpleKeyValue> jobLabels = new ArrayList<SimpleKeyValue>();
        public String truststorePath;
        public String truststoreSecret;
        public String oauth2ClientId;
        public String oauth2ClientSecret;
        public String oauth2AuthorizationEndpoint;
        public String oauth2tokenEndpoint;
        public String oauth2Scope;
        public boolean refreshTokenRotation;

        @Override
        public ConnectionWithGoogleAuthCredentials.AuthType getAuthType() {
            return this.authType;
        }

        @Override
        public String getOauth2ClientId() {
            return this.oauth2ClientId;
        }

        @Override
        public String getOauth2ClientSecret() {
            return this.oauth2ClientSecret;
        }

        @Override
        public String getOauth2Scope() {
            return this.oauth2Scope;
        }

        @Override
        public String getOauth2AuthorizationEndpoint() {
            return this.oauth2AuthorizationEndpoint;
        }

        @Override
        public String getOauth2TokenEndpoint() {
            if (StringUtils.isNotBlank((String)this.pscEndpointId) && StringUtils.isBlank((String)this.oauth2tokenEndpoint)) {
                return String.format("https://oauth2-%s.p.googleapis.com/token", this.pscEndpointId);
            }
            return this.oauth2tokenEndpoint;
        }

        @Override
        public String getAppSecretContent() {
            return this.keyPath;
        }

        @Override
        public String getServiceAccountEmail() {
            return this.serviceAccountEmail;
        }

        @Override
        public String getDefaultOauth2Scope() {
            return BigQueryConnection.DEFAULT_GOOGLE_BIGQUERY_SCOPE;
        }

        @Override
        public boolean getRefreshTokenRotation() {
            return this.refreshTokenRotation;
        }
    }

    public static class SerializableBigQueryCredentials
    extends ConnectionWithGoogleAuthCredentials.SerializableGoogleAuthCredentials {
        public String truststoreSecret;
    }

    public static enum BigQueryDriverMode {
        DRIVERLESS,
        CUSTOM;

    }
}

