/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.dataflow.exec.AbstractCodeBasedActivityRunner;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.remoterun.RemoteRunEnvHelper;
import com.dataiku.dip.remoterun.RemoteRunNetworkingUtils;
import com.dataiku.dip.rpc.LocalPrivilegedIntercomAPIClient;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.rpc.EncryptedRPC;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SharedSecretUtils;
import com.dataiku.dip.server.SpringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CredentialsRemoteFetchConfigurationProvider {
    public static final String EVENTSERVER_AUTHCTX_CLAIM_HEADER = "X-DKU-EventServerProxyUser";
    private static InheritableThreadLocal<AuthCtx> currentAuthCtx = new InheritableThreadLocal();
    private static InheritableThreadLocal<String> currentApiTicket = new InheritableThreadLocal();

    public static FetchAsAuthCtx fetchAs(AuthCtx authCtx) {
        final AuthCtx previous = (AuthCtx)currentAuthCtx.get();
        currentAuthCtx.set(authCtx);
        return new FetchAsAuthCtx(){

            @Override
            public void close() {
                if (previous == null) {
                    currentAuthCtx.remove();
                } else {
                    currentAuthCtx.set(previous);
                }
            }
        };
    }

    public static FetchAsApiTicket fetchAs(String apiTicket) {
        final String previous = (String)currentApiTicket.get();
        currentApiTicket.set(apiTicket);
        return new FetchAsApiTicket(){

            @Override
            public void close() {
                if (previous == null) {
                    currentApiTicket.remove();
                } else {
                    currentApiTicket.set(previous);
                }
            }
        };
    }

    public static MainLoggingConfigurator.ProcessType getCredentialsRemoteProvider(CredentialsRemoteFetcher configurationProvider) {
        if (configurationProvider.forceLocalResolution()) {
            return null;
        }
        switch (DKUApp.getProcessType()) {
            case UNKNOWN: {
                if (configurationProvider.mustResolveOnBackend()) {
                    return MainLoggingConfigurator.ProcessType.BACKEND;
                }
                String serverKind = RemoteRunEnvHelper.getEnv("DKU_SERVER_KIND");
                if (MainLoggingConfigurator.ProcessType.JEK.name().equals(serverKind) || MainLoggingConfigurator.ProcessType.CAK.name().equals(serverKind)) {
                    return MainLoggingConfigurator.ProcessType.valueOf((String)serverKind);
                }
                return MainLoggingConfigurator.ProcessType.BACKEND;
            }
            case JEK: 
            case FEK: 
            case CAK: 
            case EVENTSERVER: {
                return configurationProvider.mustResolveOnBackend() ? MainLoggingConfigurator.ProcessType.BACKEND : null;
            }
            case CDE: {
                if (configurationProvider.mustResolveOnBackend() || configurationProvider.mustResolveOnDSSHost()) {
                    return MainLoggingConfigurator.ProcessType.JEK;
                }
                return null;
            }
        }
        return null;
    }

    public static <X> X getFromRemote(CredentialsRemoteFetchInfo fetchInfo, String callPath, Class<X> clazz, Object ... formData) throws IOException {
        if (fetchInfo.privileged) {
            try (LocalPrivilegedIntercomAPIClient apiClient = new LocalPrivilegedIntercomAPIClient(Integer.parseInt(fetchInfo.apiPort), StringUtils.isNotBlank((String)fetchInfo.apiServerCert) && !"NA".equals(fetchInfo.apiServerCert), fetchInfo.apiTicket);){
                ArrayList<Object> fullFormData = new ArrayList<Object>();
                if (StringUtils.isNotBlank((String)fetchInfo.executionId)) {
                    fullFormData.add("executionId");
                    fullFormData.add(fetchInfo.executionId);
                }
                for (Object o : formData) {
                    fullFormData.add(o);
                }
                apiClient.addHeaders(fetchInfo.extraHeaders);
                Object object = apiClient.getForm(fetchInfo.apiPath + callPath, clazz, fullFormData.toArray(new Object[0]));
                return (X)object;
            }
        }
        try (TicketBasedIntercomAPIClient apiClient = new TicketBasedIntercomAPIClient(fetchInfo.apiURL, fetchInfo.apiServerCert, fetchInfo.apiTicket, fetchInfo.apiExecutionSecret);){
            ArrayList<Object> fullFormData = new ArrayList<Object>();
            if (StringUtils.isNotBlank((String)fetchInfo.executionId)) {
                fullFormData.add("executionId");
                fullFormData.add(fetchInfo.executionId);
            }
            for (Object o : formData) {
                fullFormData.add(o);
            }
            apiClient.addHeaders(fetchInfo.extraHeaders);
            Object object = apiClient.getForm(callPath, clazz, fullFormData.toArray(new Object[0]));
            return (X)object;
        }
    }

    public static interface CredentialsRemoteFetcher {
        public boolean forceLocalResolution();

        public boolean mustResolveOnDSSHost();

        public boolean mustResolveOnBackend();
    }

    public static class CredentialsRemoteFetchInfo {
        public String apiURL;
        public String apiPath;
        public String apiPort;
        public String apiServerCert;
        public String apiTicket;
        public String executionId;
        public String apiExecutionSecret;
        public String sharedSecret;
        public boolean privileged;
        public Map<String, String> extraHeaders = new HashMap<String, String>();

        public CredentialsRemoteFetchInfo(MainLoggingConfigurator.ProcessType rmiTo) {
            String apiProtocol;
            String apiHost;
            if (rmiTo == null) {
                apiHost = "127.0.0.1";
                this.apiPort = Integer.toString(RemoteRunNetworkingUtils.getServerPort());
                apiProtocol = RemoteRunNetworkingUtils.getBackendRPCProtocol();
                if (EncryptedRPC.enabled()) {
                    this.apiServerCert = EncryptedRPC.getPEMCertificateText();
                }
            } else {
                String prefix = rmiTo == MainLoggingConfigurator.ProcessType.BACKEND ? "DKU_BACKEND" : "DKU_SERVER";
                apiHost = StringUtils.defaultIfBlank((String)RemoteRunEnvHelper.getEnv(prefix + "_HOST"), (String)"127.0.0.1");
                this.apiPort = StringUtils.defaultIfBlank((String)RemoteRunEnvHelper.getEnv(prefix + "_PORT"), (String)"0");
                apiProtocol = StringUtils.defaultIfBlank((String)RemoteRunEnvHelper.getEnv(prefix + "_PROTOCOL"), (String)"http");
                this.apiServerCert = StringUtils.defaultIfBlank((String)RemoteRunEnvHelper.getEnv("DKU_SERVER_CERT"), (String)"NA");
                if ("NA".equals(this.apiServerCert)) {
                    this.apiServerCert = null;
                } else if (EncryptedRPC.isEncodedTextB64(this.apiServerCert)) {
                    this.apiServerCert = EncryptedRPC.decodePEMCertificateTextB64(this.apiServerCert);
                }
            }
            if (DKUApp.isConfigured()) {
                this.sharedSecret = SharedSecretUtils.getSharedSecretOrNull();
            }
            this.apiTicket = (String)currentApiTicket.get();
            if (StringUtils.isBlank((String)this.apiTicket)) {
                this.apiTicket = RemoteRunEnvHelper.getEnv("DKU_API_TICKET");
            }
            if (StringUtils.isBlank((String)this.apiTicket)) {
                if (DKUApp.getProcessType() == MainLoggingConfigurator.ProcessType.EVENTSERVER) {
                    AuthCtx authCtx = (AuthCtx)currentAuthCtx.get();
                    if (authCtx != null) {
                        this.extraHeaders.put(CredentialsRemoteFetchConfigurationProvider.EVENTSERVER_AUTHCTX_CLAIM_HEADER, authCtx.getIdentifier());
                    }
                } else {
                    APITicketService.Ticket ticket = ((APITicketService)SpringUtils.getBean(APITicketService.class)).getSingleTicket();
                    this.apiTicket = ticket == null ? "n/a" : ticket.getSecret();
                }
            }
            this.executionId = RemoteRunEnvHelper.getEnv("DKU_EXECUTION_ID");
            this.apiExecutionSecret = RemoteRunEnvHelper.getEnv("DKU_EXECUTION_SECRET_ID");
            if (rmiTo == null && DKUApp.getProcessType() == MainLoggingConfigurator.ProcessType.BACKEND || rmiTo == MainLoggingConfigurator.ProcessType.BACKEND) {
                if (StringUtils.isEmpty((String)this.sharedSecret)) {
                    this.apiPath = "dip/api/tintercom";
                    this.privileged = false;
                } else {
                    this.apiPath = "dip/api/pintercom";
                    this.privileged = true;
                }
            } else {
                AbstractCodeBasedActivityRunner.FlowSpec flowSpec = RemoteRunEnvHelper.getEnvDef().flowSpec;
                this.apiPath = flowSpec != null ? flowSpec.tintercomAPIBase : (rmiTo == MainLoggingConfigurator.ProcessType.CAK || rmiTo == null && DKUApp.getProcessType() == MainLoggingConfigurator.ProcessType.CAK ? "cak/tintercom" : (rmiTo == MainLoggingConfigurator.ProcessType.JEK || rmiTo == null && DKUApp.getProcessType() == MainLoggingConfigurator.ProcessType.JEK ? "kernel/tintercom" : "dip/api/tintercom"));
                this.privileged = false;
            }
            this.apiURL = String.format("%s://%s:%s/%s", apiProtocol, apiHost, this.apiPort, this.apiPath);
        }

        public static boolean canFindAuthCtx() {
            String apiTicket = RemoteRunEnvHelper.getEnv("DKU_API_TICKET");
            if (StringUtils.isNotBlank((String)apiTicket)) {
                return true;
            }
            if (DKUApp.getProcessType() == MainLoggingConfigurator.ProcessType.EVENTSERVER) {
                return true;
            }
            try {
                APITicketService.Ticket ticket = ((APITicketService)SpringUtils.getBean(APITicketService.class)).getSingleTicket();
                return ticket != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static interface FetchAsApiTicket
    extends AutoCloseable {
        @Override
        public void close();
    }

    public static interface FetchAsAuthCtx
    extends AutoCloseable {
        @Override
        public void close();
    }
}

