/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datacollections;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datacollections.AbstractDataCollectionItem;
import com.dataiku.dip.datacollections.AbstractDataCollectionItemRef;
import com.dataiku.dip.datacollections.DataCollectionColumnsCustomization;
import com.dataiku.dip.datacollections.UIDataCollection;
import com.dataiku.dip.security.BasePermissions;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class DataCollection
extends TaggableObjectsService.TaggableObject {
    @JSON.FileTransient
    public String id;
    public String displayName;
    public String color;
    public Set<AbstractDataCollectionItem> items = new HashSet<AbstractDataCollectionItem>();
    public List<BasePermissions.PermissionItem> permissions = new ArrayList<BasePermissions.PermissionItem>();
    public MetadataCompletenessChecks metadataCompletenessChecks = new MetadataCompletenessChecks();
    public DataCollectionColumnsCustomization columnsCustomizationSettings = new DataCollectionColumnsCustomization();

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return ITaggingService.TaggableType.DATA_COLLECTION;
    }

    @Override
    public String getProjectKey() {
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setProjectKey(String projectKey) {
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public String getColor() {
        return this.color;
    }

    public String getDescription() {
        return this.description;
    }

    public UIDataCollection.MetadataInfo getMetadata() {
        return new UIDataCollection.MetadataInfo(this.displayName, this.description, this.color, this.tags);
    }

    public UIDataCollection.MetadataCompletenessChecks getMetadataCompletenessChecks() {
        return new UIDataCollection.MetadataCompletenessChecks(this.metadataCompletenessChecks);
    }

    public DataCollection() {
    }

    public DataCollection(UIDataCollection.CreationInfo creationInfo) {
        this.id = SecretKeyGenerator.generate((int)8);
        this.displayName = creationInfo.displayName;
        this.description = creationInfo.description;
        this.color = creationInfo.color;
        this.metadataCompletenessChecks = creationInfo.metadataCompletenessChecks;
        this.permissions = creationInfo.permissions;
    }

    public DataCollection(DataCollectionSettings settings) {
        this.id = StringUtils.isNotBlank((String)settings.id) ? settings.id : SecretKeyGenerator.generate((int)8);
        this.displayName = settings.displayName;
        this.description = settings.description;
        this.tags = settings.tags;
        this.color = settings.color;
        List<Object> list = this.permissions = settings.permissions == null ? new ArrayList() : settings.permissions;
        if (settings.metadataCompletenessChecks != null) {
            this.metadataCompletenessChecks.columnsDescriptionCheck = settings.metadataCompletenessChecks.columnsDescriptionCheck;
            this.metadataCompletenessChecks.longDescriptionCheck = settings.metadataCompletenessChecks.longDescriptionCheck;
        } else {
            this.metadataCompletenessChecks.columnsDescriptionCheck = CompletenessCheckType.DISABLED;
            this.metadataCompletenessChecks.longDescriptionCheck = CompletenessCheckType.DISABLED;
        }
    }

    public boolean contains(AbstractDataCollectionItemRef itemRef) {
        return this.items.stream().anyMatch(itemRef::refersTo);
    }

    public boolean contains(SerializedDataset sd) {
        return this.contains(new AbstractDataCollectionItemRef.DatasetRef(sd.projectKey, sd.name));
    }

    public static class MetadataCompletenessChecks {
        public CompletenessCheckType longDescriptionCheck;
        public CompletenessCheckType columnsDescriptionCheck;

        public MetadataCompletenessChecks() {
            this.longDescriptionCheck = CompletenessCheckType.DISABLED;
            this.columnsDescriptionCheck = CompletenessCheckType.DISABLED;
        }

        public MetadataCompletenessChecks(UIDataCollection.MetadataCompletenessChecks other) {
            this.longDescriptionCheck = other.longDescriptionCheck;
            this.columnsDescriptionCheck = other.columnsDescriptionCheck;
        }
    }

    public static class DataCollectionSettings {
        @Nullable
        public String id;
        public String displayName;
        public String color;
        public String description;
        public List<String> tags;
        public List<BasePermissions.PermissionItem> permissions;
        public MetadataCompletenessChecks metadataCompletenessChecks;

        @VisibleForTesting
        public DataCollectionSettings(String id, String displayName, String color, String description, List<String> tags, List<BasePermissions.PermissionItem> permissions, MetadataCompletenessChecks metadataCompletenessChecks) {
            this.id = id;
            this.displayName = displayName;
            this.color = color;
            this.description = description;
            this.tags = tags;
            this.permissions = permissions;
            this.metadataCompletenessChecks = metadataCompletenessChecks;
        }

        @VisibleForTesting
        public DataCollectionSettings(String id, String displayName, String color, String description, List<String> tags, List<BasePermissions.PermissionItem> permissions) {
            this(id, displayName, color, description, tags, permissions, new MetadataCompletenessChecks());
        }

        public DataCollectionSettings(DataCollection dataCollection, boolean includePermissions) {
            this.id = dataCollection.id;
            this.displayName = dataCollection.displayName;
            this.color = dataCollection.color;
            this.description = dataCollection.description;
            this.tags = dataCollection.tags;
            this.permissions = includePermissions ? dataCollection.permissions : null;
            this.metadataCompletenessChecks = dataCollection.metadataCompletenessChecks;
        }
    }

    public static enum CompletenessCheckType {
        DISABLED,
        WARNING,
        ERROR;

    }
}

