/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.Job;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.kernel.slave.KernelSession;
import com.dataiku.dip.dataflow.streaming.DatasetWritingService;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import org.springframework.beans.factory.annotation.Autowired;

public class PreRunSchemaPropagationHandler {
    private final FlowRecipe fr;
    @Autowired
    private DatasetWritingService datasetWritingService;
    @Autowired
    private RecipesDAO recipesDAO;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.recipes.prerunpropagate");

    public PreRunSchemaPropagationHandler(JobActivity activity, FlowRecipe fr) {
        this.fr = fr;
        SpringUtils.getInstance().autowire((Object)this);
    }

    private RecipeSchemaService.RecipeSchemaAutoupdateResult getAutoupdateResultFromBackend(String projectKey, String recipeName) throws Exception {
        APITicketService ticketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
        try (APITicketService.TicketUsage tu = ticketService.getAndUseSingleTicket();){
            RecipeSchemaService.RecipeSchemaAutoupdateResult recipeSchemaAutoupdateResult;
            int backendPort = Integer.parseInt(System.getenv("DKU_BACKEND_PORT"));
            logger.info((Object)"Getting schema update result from backend");
            try (TicketBasedIntercomAPIClient apiClient = new TicketBasedIntercomAPIClient("http://127.0.0.1:" + backendPort, null, tu.getTicket().getSecret());){
                recipeSchemaAutoupdateResult = (RecipeSchemaService.RecipeSchemaAutoupdateResult)apiClient.postFormToJSON("/dip/api/tintercom/recipes/get-schema-update-result", RecipeSchemaService.RecipeSchemaAutoupdateResult.class, new Object[]{"projectKey", projectKey, "recipeName", recipeName, "autoUpdate", "true"});
            }
            return recipeSchemaAutoupdateResult;
        }
    }

    public void propagateRecipeUpdateToBackend(String projectKey, String recipeName, SerializedRecipe recipe, String payload) throws Exception {
        logger.info((Object)"Propagating update of recipe to backend");
        SerializedRecipe.SerializedRecipeAndPayload recipeAndPayload = new SerializedRecipe.SerializedRecipeAndPayload();
        recipeAndPayload.recipe = recipe;
        recipeAndPayload.payload = payload;
        APITicketService ticketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
        try (APITicketService.TicketUsage tu = ticketService.getAndUseSingleTicket();){
            int backendPort = Integer.parseInt(System.getenv("DKU_BACKEND_PORT"));
            logger.info((Object)"Propagating recipe update result to backend");
            try (TicketBasedIntercomAPIClient apiClient = new TicketBasedIntercomAPIClient("http://127.0.0.1:" + backendPort, null, tu.getTicket().getSecret());){
                apiClient.putObject("/dip/publicapi/projects/" + projectKey + "/recipes/" + recipeName, Void.class, recipeAndPayload);
            }
        }
    }

    public SerializedRecipe.SerializedRecipeAndPayload propagateIfNeeded() throws Exception {
        Job job = JobContext.getCurrentJobObj();
        if (job == null) {
            logger.warn((Object)"No job object in context, unexpected. Not propagating schema");
            return null;
        }
        if (!job.def.autoUpdateSchemaBeforeEachRecipeRun) {
            logger.debug((Object)"Pre-run schema propagation not enabled in this job");
            return null;
        }
        SerializedRecipe recipe = this.fr.getModel();
        logger.info((Object)("Propagating schema of recipe " + recipe.name + " of type " + recipe.type));
        RecipeSchemaService.RecipeSchemaAutoupdateResult updateResult = this.getAutoupdateResultFromBackend(recipe.projectKey, recipe.name);
        if (updateResult.totalIncompatibilities == 0 && updateResult.recipeChanges.size() == 0) {
            logger.info((Object)"No change to do");
            return null;
        }
        for (RecipeSchemaService.ComputableSchemaAutoupdateResult computableResult : updateResult.computables) {
            logger.infoV("Performing update of schema on computable %s: %s", new Object[]{computableResult.id, JSON.json((Object)computableResult)});
            if (computableResult.type != FlowComputable.FCType.DATASET) continue;
            DatasetLocUtils.DatasetLoc loc = new DatasetLocUtils.DatasetLoc(recipe.projectKey, computableResult.datasetName);
            logger.info((Object)"Writing new schema locally");
            this.datasetWritingService.writeDatasetSchema(TransactionContext.retrieveWrite().getUser(), loc, computableResult.newSchema, false, null);
            logger.info((Object)"Writing new schema to backend");
            KernelSession.propagateSchemaToJekOrBackend(loc.getFullName(), computableResult.newSchema);
        }
        if (updateResult.recipeChanges.size() > 0) {
            logger.infoV("Performing update of recipe too recipeChanges=%s, updatedRecipe=%s, updatedPayload=%s", new Object[]{JSON.json(updateResult.recipeChanges), JSON.json((Object)updateResult.updatedRecipe), JSON.json((Object)updateResult.updatedPayload)});
            this.recipesDAO.save(recipe.projectKey, recipe.name, updateResult.updatedRecipe, updateResult.updatedPayload);
            logger.info((Object)"Propagating new recipe to backend");
            this.propagateRecipeUpdateToBackend(recipe.projectKey, recipe.name, updateResult.updatedRecipe, updateResult.updatedPayload);
            this.fr.updateModel(updateResult.updatedRecipe);
            SerializedRecipe.SerializedRecipeAndPayload recipeAndPayload = new SerializedRecipe.SerializedRecipeAndPayload();
            recipeAndPayload.recipe = updateResult.updatedRecipe;
            recipeAndPayload.payload = updateResult.updatedPayload;
            return recipeAndPayload;
        }
        return null;
    }
}

