/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.autofeaturegeneration;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureJoinQueryGenerator;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.QueryVisitor;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.RelationshipGraph;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.NotImplementedException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class TimeWindowQueryVisitor
extends QueryVisitor {
    private static final String CUTOFF_TIME_COLUMN_NAME = "__dku_cutoff_time";
    private final SchemaColumn cutoffTimeColumn;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.autofeaturegeneration.timewindowquery");

    public TimeWindowQueryVisitor(AutoFeatureGenerationRecipePayloadParams params, SQLDialect dialect, Map<Integer, String> viewNameByDataset, Map<String, Dataset> datasetsMap, Map<String, SQLUtils.SQLTable> sqlTablesMap, SchemaColumn cutoffTimeColumn) {
        super(params, dialect, viewNameByDataset, datasetsMap, sqlTablesMap);
        this.cutoffTimeColumn = cutoffTimeColumn;
    }

    @Override
    protected String getSelectQuery() {
        throw new IllegalStateException("No main select query is generated by this visitor");
    }

    @Override
    public void visit(RelationshipGraph.Node node) {
        throw new NotImplementedException("Only edges are implemented");
    }

    @Override
    public void visit(RelationshipGraph.BackwardEdge edge) {
        this.visitEdge(edge);
    }

    @Override
    public void visit(RelationshipGraph.ForwardEdge edge) {
        this.visitEdge(edge);
    }

    private void visitEdge(RelationshipGraph.Edge edge) {
        if (this.params.cutoffTime.mode != AutoFeatureGenerationRecipePayloadParams.CutoffTime.CutoffTimeMode.COLUMN) {
            return;
        }
        if (StringUtils.isBlank((String)edge.getCurrentNode().getCutoffTimeColumn())) {
            logger.warn((Object)"Current node has no cutoff time column, doing nothing");
            return;
        }
        AutoFeatureJoinQueryGenerator queryGenerator = new AutoFeatureJoinQueryGenerator(this.datasetsMap, this.sqlTablesMap, this.dialect, this.viewNameByDataset);
        String joinQuery = queryGenerator.generateQuery(edge, CUTOFF_TIME_COLUMN_NAME, true);
        String joinViewName = SQLUtils.generateSqlViewName(edge.getRelatedNodeSanitizedLabel(), Partition.newNP(), this.dialect);
        this.generateSqlViewQueries(joinViewName, joinQuery);
        edge.getRelatedNode().setCutoffTimeColumn(new SchemaColumn(CUTOFF_TIME_COLUMN_NAME, this.cutoffTimeColumn.getType()));
        this.registerNewSQLView(edge.getRelatedNode(), joinViewName);
    }
}

