/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.io;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.io.IRowsDAO;
import com.dataiku.dip.dataflow.exec.h2.DatasetToH2Loader;
import com.dataiku.dip.dataflow.exec.h2.H2DB;
import com.dataiku.dip.dataflow.exec.h2.H2dbFactory;
import com.dataiku.dip.dataflow.exec.joinlike.InputDescBase;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.ServiceUtils;
import com.dataiku.dip.sql.H2SQLDialect;
import com.dataiku.dip.sql.H2V2SQLDialect;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.google.common.base.Joiner;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class RowsDAOH2Impl
implements IRowsDAO {
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    protected JobAuthCtxService jobAuthCtxService;
    @Autowired
    H2dbFactory h2dbFactory;
    private static final String TABLE_NAME_WITH_INDEX = "TABLE_%d";
    private H2DB database;
    private DatasetToH2Loader loader;
    private final H2SQLDialect h2SQLDialect = new H2V2SQLDialect();
    private final Map<Integer, Map<String, Type>> tableColumnTypesByTableId = new HashMap<Integer, Map<String, Type>>();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fuzzyjoin.RowsDAO");

    public RowsDAOH2Impl(JobActivity activity, FuzzyJoinRecipePayloadParams payload) throws Exception {
        SpringUtils.getInstance().autowire((Object)this);
        try {
            this.makeLoader(activity, this.jobAuthCtxService.getAuthCtx());
            this.initDatabase(activity, payload);
            this.createIndex();
            this.createMatchFlags();
        }
        catch (Exception e) {
            logger.error((Object)"Input datasets could not be loaded inside H2 database", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Map<String, String> getRow(int table, int indexRow) throws SQLException {
        HashMap<String, String> row = new HashMap<String, String>();
        String sql = String.format("SELECT * FROM TABLE_%d WHERE INDEX_ROW_%d = ?", table, table);
        try (PreparedStatement st2 = this.database.getConn().prepareStatement(sql);){
            st2.setInt(1, indexRow);
            try (ResultSet rs2 = st2.executeQuery();){
                ResultSetMetaData data = rs2.getMetaData();
                rs2.next();
                this.fillRow(table, rs2, data, row);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Row index does not exist", (Throwable)e);
            throw e;
        }
        return row;
    }

    @Override
    public int countRows(int table) throws SQLException {
        int count;
        String sql = String.format("SELECT COUNT(*) FROM TABLE_%d", table);
        try (Statement st2 = this.database.getConn().createStatement();
             ResultSet rs2 = st2.executeQuery(sql);){
            rs2.next();
            count = rs2.getInt(1);
        }
        return count;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.database.getConn().createStatement();
    }

    @Override
    public ResultSet selectAllRows(int table, Statement st2) throws SQLException {
        String sql = String.format("SELECT * FROM TABLE_%d ORDER BY INDEX_ROW_%d ASC", table, table);
        return st2.executeQuery(sql);
    }

    private void makeLoader(JobActivity activity, AuthCtx authCtx) throws Exception {
        FlowRecipe recipe = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe();
        this.loader = new DatasetToH2Loader(authCtx, activity.warnContext, recipe.getProjectKey(), this.h2dbFactory.createFor(recipe.getProjectKey()));
    }

    private void initDatabase(JobActivity activity, FuzzyJoinRecipePayloadParams params) throws Exception {
        List<FlowDataset> sources = activity.getSubgraph().getSourceDatasets();
        for (int i = 0; i < params.virtualInputs.size(); ++i) {
            InputDescBase vi = (InputDescBase)params.virtualInputs.get(i);
            logger.info((Object)String.format("Creating table %d", i));
            Dataset dataset = ServiceUtils.getDataset(activity, this.datasetsDAO, vi.name);
            String tableName = RowsDAOH2Impl.getH2TableName(i);
            List<String> columnNames = this.listColumnNames(dataset);
            HashMap<String, Type> columnTypes = new HashMap<String, Type>();
            for (SchemaColumn column : dataset.getSchema().columns) {
                if (column.getType().equals((Object)Type.GEOPOINT)) {
                    column.setType(Type.STRING);
                }
                columnTypes.put(column.getName(), column.getType());
            }
            this.tableColumnTypesByTableId.put(i, columnTypes);
            StreamableDatasetSelection full = StreamableDatasetSelection.full();
            if (dataset.getPartitioningSchema().isPartitioned()) {
                full.withSelectedPartitions(activity.getSubgraph().getSourcePartitions(sources.get(vi.index)));
            }
            this.loader.load(dataset, full, tableName, columnNames, null);
        }
        this.database = this.loader.h2db;
    }

    private void createIndex() throws SQLException {
        try (Statement st2 = this.database.getConn().createStatement();){
            for (int table = 0; table < 2; ++table) {
                logger.info((Object)String.format("Creating index for table %d", table));
                String tableName = RowsDAOH2Impl.getH2TableName(table);
                st2.execute(String.format("ALTER TABLE \"%s\" ADD INDEX_ROW_%d BIGINT", tableName, table));
                st2.execute(String.format("UPDATE \"%s\" SET INDEX_ROW_%d = ROWNUM()", tableName, table));
                st2.execute(String.format("CREATE UNIQUE HASH INDEX INDEX_ROW_%d ON \"%s\" (INDEX_ROW_%d)", table, tableName, table));
            }
        }
    }

    private static String getH2TableName(int index) {
        return String.format(TABLE_NAME_WITH_INDEX, index);
    }

    private List<String> listColumnNames(Dataset dataset) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (SchemaColumn column : dataset.getSchema().columns) {
            columnNames.add(column.getName());
        }
        return columnNames;
    }

    @Override
    public void close() {
        try {
            this.loader.close();
        }
        catch (Exception e) {
            logger.error((Object)"Could not close H2 database properly", (Throwable)e);
        }
    }

    @Override
    public List<Map<String, String>> getUnmatchedRows(int table) throws SQLException {
        ArrayList<Map<String, String>> rows = new ArrayList<Map<String, String>>();
        String sql = String.format("SELECT * FROM TABLE_%d WHERE MATCH_FLAG_%d = false", table, table);
        try (Statement st2 = this.database.getConn().createStatement();
             ResultSet rs2 = st2.executeQuery(sql);){
            ResultSetMetaData data = rs2.getMetaData();
            while (rs2.next()) {
                HashMap<String, String> row = new HashMap<String, String>();
                this.fillRow(table, rs2, data, row);
                rows.add(row);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Error when fetching unmatched rows", (Throwable)e);
            throw e;
        }
        return rows;
    }

    @Override
    public void fillRow(int table, ResultSet rs2, ResultSetMetaData data, Map<String, String> row) throws SQLException {
        Map<String, Type> columnTypes = this.tableColumnTypesByTableId.get(table);
        for (int i = 1; i <= data.getColumnCount(); ++i) {
            String value;
            String columnName = data.getColumnName(i);
            if (columnTypes.containsKey(columnName)) {
                SchemaColumn schemaColumn = new SchemaColumn(columnName, columnTypes.get(columnName));
                value = this.h2SQLDialect.getValueAsDSSString(rs2, data.getColumnType(i), i, schemaColumn, true, false, DateTimeZone.getDefault());
            } else {
                value = rs2.getString(i);
            }
            row.put(columnName, value);
        }
    }

    @Override
    public void setRowAsMatch(int table, Collection<Integer> indexRow) throws SQLException {
        String sql = String.format("UPDATE TABLE_%d SET MATCH_FLAG_%d = true WHERE INDEX_ROW_%d in (%s)", table, table, table, Joiner.on((String)",").join(indexRow));
        SQLConnectionProvider.SQLConnectionWrapper conn = this.database.getConn();
        try (Statement st2 = conn.createStatement();){
            st2.executeUpdate(sql);
        }
        catch (SQLException e) {
            logger.error((Object)"Row index does not exist", (Throwable)e);
            throw e;
        }
    }

    private void createMatchFlags() throws SQLException {
        try (Statement st2 = this.database.getConn().createStatement();){
            for (int table = 0; table < 2; ++table) {
                logger.info((Object)String.format("Creating match flag for table %d", table));
                String tableName = RowsDAOH2Impl.getH2TableName(table);
                st2.execute(String.format("ALTER TABLE \"%s\" ADD MATCH_FLAG_%d BOOLEAN", tableName, table));
                st2.execute(String.format("UPDATE \"%s\" SET MATCH_FLAG_%d = false", tableName, table));
            }
        }
    }
}

