/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.h2;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.ActivityAbortedException;
import com.dataiku.dip.dataflow.exec.h2.ColumnAdderFilteringProcessorOutput;
import com.dataiku.dip.dataflow.exec.h2.H2TemporarySQLConfig;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.FilteringProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.StorageTypeVerifier;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.output.OutputStreamOutputWriter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.H2SQLDialect;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class DatasetToH2ConnectionLoader
implements AutoCloseable {
    private volatile boolean abortNotified;
    private Statement runningStatement;
    public final SQLConnectionProvider.SQLConnectionWrapper connectionWrapper;
    final AuthCtx authCtx;
    final CSVFormatConfig csvConfig;
    final String csvOpts;
    final StreamColumnFactory cf;
    final H2SQLDialect dialect;
    final WarningsContext warningsContext;
    final String projectKey;
    File folder;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.h2loader");

    public DatasetToH2ConnectionLoader(AuthCtx authCtx, WarningsContext warningsContext, String projectKey, SQLConnectionProvider.SQLConnectionWrapper connectionWrapper, H2SQLDialect dialect, File folder) throws Exception {
        this.folder = folder;
        this.connectionWrapper = connectionWrapper;
        this.projectKey = projectKey;
        this.authCtx = authCtx;
        this.warningsContext = warningsContext;
        this.csvConfig = new CSVFormatConfig();
        this.csvConfig.style = CSVFormatConfig.CSVStyle.UNIX;
        this.csvConfig.charset = "utf8";
        this.csvConfig.setSeparatorStr(",");
        this.csvConfig.setQuoteStr("\"");
        this.csvConfig.setEscapeStr("\\");
        this.csvConfig.parseHeaderRow = false;
        this.csvConfig.arrayMapFormat = CSVFormatConfig.CSVComplexTypeSerialization.json;
        this.csvConfig.arrayItemSeparator = "\u0002";
        this.csvConfig.mapKeySeparator = "\u0003";
        this.csvConfig.dateSerializationFormat = CSVFormatConfig.DateSerializationFormat.ISO_STRICT;
        this.csvConfig.writeDataTypeMismatchBehavior = ApplicationConfigurator.getParams().getBoolParam("dku.recipes.visual.h2based.verifyInput", true) ? StorageTypeVerifier.DataTypeMismatchBehavior.ERROR : StorageTypeVerifier.DataTypeMismatchBehavior.IGNORE_SILENT;
        this.csvConfig.normalizeBooleans = true;
        this.csvConfig.normalizeDoubles = true;
        this.cf = new StreamColumnFactory();
        this.dialect = dialect;
        this.csvOpts = "charset=UTF-8 escape=\\\\ fieldSeparator=, fieldDelimiter=\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAbort() {
        Statement stmtToKill;
        DatasetToH2ConnectionLoader datasetToH2ConnectionLoader = this;
        synchronized (datasetToH2ConnectionLoader) {
            if (this.abortNotified) {
                return;
            }
            this.abortNotified = true;
            stmtToKill = this.runningStatement;
        }
        if (stmtToKill != null) {
            try {
                logger.info((Object)"Cancelling create table statement...");
                stmtToKill.cancel();
            }
            catch (SQLException e) {
                logger.error((Object)("Unable to cancel statement:" + e.getMessage()), (Throwable)e);
            }
        }
    }

    private Schema dumpToCSV(File file, Dataset dataset, StreamableDatasetSelection selection, List<String> requiredColumnNames, @Nullable ColumnAdderFilteringProcessorOutput filteringProcessor) throws Exception {
        AbortableProcessorOutput abortableOutput;
        long before = System.currentTimeMillis();
        Schema inputSchema = dataset.getSchema();
        OutputFormatter formatter = FormatFactory.buildFormatter(this.authCtx, this.projectKey, "csv", this.csvConfig);
        Schema csvFileSchema = new Schema();
        if (requiredColumnNames != null) {
            for (String string : requiredColumnNames) {
                csvFileSchema.addColumn(inputSchema.getColumn(string));
            }
        } else {
            for (SchemaColumn schemaColumn : inputSchema.getColumns()) {
                csvFileSchema.addColumn(schemaColumn);
            }
        }
        if (filteringProcessor != null) {
            for (SchemaColumn schemaColumn : filteringProcessor.addedColumns()) {
                csvFileSchema.addColumn(schemaColumn);
            }
        }
        formatter.setOutputSchema(csvFileSchema);
        formatter.setWarningsContext(new WarningsContext());
        FileOutputStream stdoutStream = new FileOutputStream(file);
        OutputStreamOutputWriter outputStreamOutputWriter = new OutputStreamOutputWriter((OutputStream)stdoutStream, formatter);
        outputStreamOutputWriter.init((ColumnFactory)this.cf);
        if (filteringProcessor != null) {
            filteringProcessor.withColumnFactory((ColumnFactory)this.cf);
            filteringProcessor.setDownstream((ProcessorOutput)outputStreamOutputWriter);
            abortableOutput = new AbortableProcessorOutput((ProcessorOutput)filteringProcessor);
        } else {
            abortableOutput = new AbortableProcessorOutput((ProcessorOutput)outputStreamOutputWriter);
        }
        UniversalSingleThreadPusher pusher = new UniversalSingleThreadPusher(this.authCtx, dataset, (ProcessorOutput)abortableOutput, (ColumnFactory)this.cf, (RowFactory)new StreamRowFactory());
        pusher.setDatasetSelection(selection);
        if (this.warningsContext != null) {
            pusher.setWarningsContext(this.warningsContext);
        }
        logger.info((Object)"Dumping dataset to CSV for H2...");
        pusher.push();
        outputStreamOutputWriter.lastRowEmitted();
        long after = System.currentTimeMillis();
        logger.info((Object)("Done: " + (after - before) + "ms"));
        return csvFileSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAbort() {
        DatasetToH2ConnectionLoader datasetToH2ConnectionLoader = this;
        synchronized (datasetToH2ConnectionLoader) {
            if (this.abortNotified) {
                throw new ActivityAbortedException();
            }
        }
    }

    private void failOnBadH2Identifier(String columnName) {
        if (StringUtils.isBlank((String)columnName)) {
            throw ErrorContext.iae((String)"Column name can not be empty");
        }
        if (columnName.contains(",") || columnName.contains("'") || columnName.trim().length() != columnName.length()) {
            throw ErrorContext.iae((String)"Column name can not contain comma, quotation mark, leading or trailing white spaces with DSS engine (when using H2).");
        }
    }

    public AutoDelete tableFile(String tableName) {
        return new AutoDelete(DKUFileUtils.getWithin((File)this.folder, (String[])new String[]{tableName + ".csv"}));
    }

    public void loadInDB(Dataset dataset, StreamableDatasetSelection selection, String targetTable, List<String> requiredColumnNames, ColumnAdderFilteringProcessorOutput filteringProcessor) throws Exception {
        this.loadInDB(dataset, selection, targetTable, requiredColumnNames, filteringProcessor, this.tableFile(targetTable), true);
    }

    public static Type downcastToSupportedTypeIfRequired(Type type) {
        if (!type.isPrimitive() || type.isGeo()) {
            return Type.STRING;
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Dataset loadInDB(Dataset dataset, StreamableDatasetSelection selection, String targetTable, List<String> requiredColumnNames, @Nullable ColumnAdderFilteringProcessorOutput columnsAdder, AutoDelete intermediateFile, boolean deleteH2TableBeforeLoad) throws Exception {
        try {
            Schema inputSchema = dataset.getSchema();
            if (inputSchema == null) {
                throw ErrorContext.iaef((String)"Dataset '%s' has no schema", (Object)dataset.getName(), (Object[])new Object[0]);
            }
            if (inputSchema.columns.size() == 0) {
                throw ErrorContext.iaef((String)"Dataset '%s' has an empty schema", (Object)dataset.getName(), (Object[])new Object[0]);
            }
            Schema csvFileSchema = this.dumpToCSV((File)intermediateFile, dataset, selection, requiredColumnNames, columnsAdder);
            this.checkAbort();
            Schema h2Schema = (Schema)JSON.deepCopy((Object)csvFileSchema);
            for (Object column : h2Schema.getColumns()) {
                column.setType(DatasetToH2ConnectionLoader.downcastToSupportedTypeIfRequired(column.getType()));
            }
            ArrayList<String> columnNamesQuoted = new ArrayList<String>();
            for (SchemaColumn column : h2Schema.columns) {
                this.failOnBadH2Identifier(column.getName());
                columnNamesQuoted.add(this.dialect.quoteIdentifier(column.getName()));
            }
            H2TemporarySQLConfig fakeConfig = new H2TemporarySQLConfig();
            fakeConfig.table = targetTable;
            Dataset h2Dataset = new Dataset();
            h2Dataset.setFullName(dataset.getFullName());
            h2Dataset.setParams(fakeConfig);
            h2Dataset.setSchema(h2Schema);
            this.dialect.setDefaultLengthForSchemaColumn(h2Dataset.getSchema(), Collections.emptyList(), new InfoMessage.InfoMessages());
            if (deleteH2TableBeforeLoad) {
                this.dialect.tryDeleteTable(this.connectionWrapper, null, null, targetTable);
            }
            String sql = this.dialect.createCreateTableFromCsvStatementSQL(h2Dataset, h2Schema.getColumns(), intermediateFile.getAbsolutePath(), this.csvConfig, this.csvOpts);
            try (Statement stmt = this.connectionWrapper.createStatement();){
                try {
                    this.checkAbort();
                    this.runningStatement = stmt;
                    logger.info((Object)"Creating H2 table from CSV. Statement:");
                    logger.info((Object)sql);
                    long before = System.currentTimeMillis();
                    stmt.execute(sql);
                    long after = System.currentTimeMillis();
                    logger.info((Object)("Done: " + (after - before) + "ms"));
                }
                finally {
                    DatasetToH2ConnectionLoader datasetToH2ConnectionLoader = this;
                    synchronized (datasetToH2ConnectionLoader) {
                        this.runningStatement = null;
                        this.checkAbort();
                    }
                }
            }
            Dataset dataset2 = h2Dataset;
            return dataset2;
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
        finally {
            logger.info((Object)"Deleting intermediate file");
            intermediateFile.close();
        }
    }

    @Override
    public void close() throws Exception {
    }

    private class AbortableProcessorOutput
    extends FilteringProcessorOutput {
        public AbortableProcessorOutput(ProcessorOutput wrapped) {
            super(wrapped);
        }

        public void emitRow(Row row) throws Exception {
            if (DatasetToH2ConnectionLoader.this.abortNotified) {
                throw new ActivityAbortedException();
            }
            this.downstream.emitRow(row);
        }
    }
}

