/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.pivot;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.pivot.CustomAggregateDefinition;
import com.dataiku.dip.dataflow.exec.pivot.PivotElement;
import com.dataiku.dip.dataflow.exec.pivot.PivotElementsModalitiesSnapshot;
import com.dataiku.dip.dataflow.exec.pivot.PivotedModality;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.recipes.ParamsWithContainerizable;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class PivotRecipePayloadParams
extends VisualSQLRecipePayloadParams
implements ParamsWithContainerizable {
    public SchemaComputation schemaComputation = SchemaComputation.ONLY_IF_NO_METADATA;
    public ModalitySlugification modalitySlugification = ModalitySlugification.NONE;
    public Integer modalityMaxLength;
    public boolean sortModalities = true;
    public FilterDesc preFilter = new FilterDesc();
    public List<ComputedColumn> computedColumns = Lists.newArrayList();
    public IdentifierColumnsSelection identifierColumnsSelection = IdentifierColumnsSelection.EXPLICIT;
    public List<String> explicitIdentifiers = Lists.newArrayList();
    public List<PivotElement> pivots = Lists.newArrayList();
    public List<GroupingRecipePayloadParams.GroupingValue> otherColumns = Lists.newArrayList();
    public List<CustomAggregateDefinition> customAggregates = Lists.newArrayList();

    @Override
    public ContainerExecSelection getContainerSelection() {
        return this.engineParams.containerSelection;
    }

    @Override
    public void setContainerSelection(ContainerExecSelection selection) {
        this.engineParams.containerSelection = selection;
    }

    public GroupingRecipePayloadParams generateGroupingRecipeParams(List<String> identifiers, List<PivotElementsModalitiesSnapshot.PivotElementsModalities> pivotElementsModalities, Schema filteredSchema) {
        GroupingRecipePayloadParams groupingParams = new GroupingRecipePayloadParams();
        groupingParams.globalCount = false;
        groupingParams.outputColumnNameOverrides = Maps.newHashMap();
        groupingParams.postFilter = new FilterDesc();
        groupingParams.postFilter.enabled = false;
        groupingParams.postFilter.distinct = false;
        groupingParams.preFilter = new FilterDesc();
        groupingParams.preFilter.enabled = false;
        groupingParams.preFilter.distinct = false;
        for (String key : identifiers) {
            GroupingRecipePayloadParams.GroupingKey groupingKey = new GroupingRecipePayloadParams.GroupingKey();
            groupingKey.column = key;
            groupingKey.type = filteredSchema.getColumn(groupingKey.column).getType();
            groupingParams.getRawGroupingKeys().add(groupingKey);
        }
        ArrayList groupingValues = Lists.newArrayList();
        for (PivotElementsModalitiesSnapshot.PivotElementsModalities pivotElementModalities : pivotElementsModalities) {
            this.generateForPivot(filteredSchema, groupingValues, pivotElementModalities);
        }
        for (GroupingRecipePayloadParams.GroupingValue otherColumn : this.otherColumns) {
            GroupingRecipePayloadParams.GroupingValue groupingValue = (GroupingRecipePayloadParams.GroupingValue)JSON.deepCopy((Object)otherColumn);
            groupingValues.add(groupingValue);
        }
        groupingParams.values.addAll(this.dedupGroupingValues(groupingValues));
        return groupingParams;
    }

    private CustomAggregateDefinition getCustomAggregateDefinition(String name) {
        for (CustomAggregateDefinition aggregate : this.customAggregates) {
            if (!name.equals(aggregate.name)) continue;
            return aggregate;
        }
        throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_PIVOT_INVALID_AGGREGATE, "Unknown custom aggregate : " + name);
    }

    private GroupingRecipePayloadParams.GroupingValue generatePivotGroupingValue(GroupingRecipePayloadParams.GroupingValue pivotGroupingValue, PivotedModality.PivotedColumn pivotedColumn, Schema filteredSchema, Expression modalityFilter) {
        GroupingRecipePayloadParams.GroupingValue groupingValue = (GroupingRecipePayloadParams.GroupingValue)JSON.deepCopy((Object)pivotGroupingValue);
        if (StringUtils.isNotBlank((String)groupingValue.customAggr)) {
            CustomAggregateDefinition aggregate = this.getCustomAggregateDefinition(groupingValue.customAggr);
            groupingValue.type = aggregate.type;
            groupingValue.arrayContent = aggregate.arrayContent;
            groupingValue.mapKeys = aggregate.mapKeys;
            groupingValue.mapValues = aggregate.mapValues;
            groupingValue.objectFields = aggregate.objectFields;
            groupingValue.customName = pivotedColumn.pivoted + aggregate.getSuffix();
            groupingValue.customExpr = aggregate.expression.replaceAll(Pattern.quote("${column}"), pivotedColumn.pivoted);
            groupingValue.column = null;
        } else {
            groupingValue.column = pivotedColumn.pivoted;
            groupingValue.setType(filteredSchema.getColumn(groupingValue.column).getType());
            if (groupingValue.first || groupingValue.last) {
                groupingValue.condition = modalityFilter;
            }
        }
        return groupingValue;
    }

    private void generateForPivot(Schema filteredSchema, List<GroupingRecipePayloadParams.GroupingValue> groupingValues, PivotElementsModalitiesSnapshot.PivotElementsModalities pivotElementModalities) {
        PivotElement pivotElement = pivotElementModalities.pivotElement;
        for (PivotedModality pivotElementModality : pivotElementModalities.pivotedModalities) {
            Expression modalityFilter = new Expression(pivotElementModality.asExpression(pivotElement.keyColumns, filteredSchema));
            for (GroupingRecipePayloadParams.GroupingValue pivotGroupingValue : pivotElement.valueColumns) {
                PivotedModality.PivotedColumn pivotedColumn = pivotElementModality.getPivotedColumn(pivotGroupingValue.column);
                GroupingRecipePayloadParams.GroupingValue groupingValue = this.generatePivotGroupingValue(pivotGroupingValue, pivotedColumn, filteredSchema, modalityFilter);
                groupingValues.add(groupingValue);
            }
            if (!StringUtils.isNotBlank((String)pivotElementModality.globalCountColumn)) continue;
            GroupingRecipePayloadParams.GroupingValue groupingValue = new GroupingRecipePayloadParams.GroupingValue();
            groupingValue.column = pivotElementModality.globalCountColumn;
            groupingValue.count = true;
            groupingValues.add(groupingValue);
        }
    }

    private List<GroupingRecipePayloadParams.GroupingValue> dedupGroupingValues(List<GroupingRecipePayloadParams.GroupingValue> groupingValues) {
        ArrayList custom = Lists.newArrayList();
        ArrayList groupingValuesByColumn = Lists.newArrayList();
        for (GroupingRecipePayloadParams.GroupingValue groupingValue : groupingValues) {
            if (StringUtils.isNotBlank((String)groupingValue.customAggr)) {
                custom.add(groupingValue);
                continue;
            }
            String key = Boolean.toString(groupingValue.firstLastNotNull) + StringUtils.defaultIfBlank((String)groupingValue.orderColumn, (String)"") + "_" + groupingValue.column;
            Pair found = null;
            for (Pair existing : groupingValuesByColumn) {
                if (!((String)existing.first).equals(key)) continue;
                found = existing;
                break;
            }
            if (found == null) {
                found = new Pair((Object)key, new ArrayList());
                groupingValuesByColumn.add(found);
            }
            ((List)found.second).add(groupingValue);
        }
        ArrayList dedupedGroupingValues = Lists.newArrayList();
        for (Pair groupingValuesForColumn : groupingValuesByColumn) {
            GroupingRecipePayloadParams.GroupingValue groupingValue = (GroupingRecipePayloadParams.GroupingValue)((List)groupingValuesForColumn.second).get(0);
            if (((List)groupingValuesForColumn.second).size() > 1) {
                for (GroupingRecipePayloadParams.GroupingValue otherGroupingValue : (List)groupingValuesForColumn.second) {
                    groupingValue.avg |= otherGroupingValue.avg;
                    groupingValue.stddev |= otherGroupingValue.stddev;
                    groupingValue.sum |= otherGroupingValue.sum;
                    groupingValue.sum2 |= otherGroupingValue.sum2;
                    groupingValue.count |= otherGroupingValue.count;
                    groupingValue.countDistinct |= otherGroupingValue.countDistinct;
                    groupingValue.min |= otherGroupingValue.min;
                    groupingValue.max |= otherGroupingValue.max;
                    groupingValue.first |= otherGroupingValue.first;
                    groupingValue.last |= otherGroupingValue.last;
                    groupingValue.firstLastNotNull |= otherGroupingValue.firstLastNotNull;
                    groupingValue.concat |= otherGroupingValue.concat;
                    if (StringUtils.isBlank((String)groupingValue.orderColumn) && !StringUtils.isBlank((String)otherGroupingValue.orderColumn)) {
                        groupingValue.orderColumn = otherGroupingValue.orderColumn;
                    }
                    if (groupingValue.concatSeparator == null && otherGroupingValue.concatSeparator != null) {
                        groupingValue.concatSeparator = otherGroupingValue.concatSeparator;
                    }
                    groupingValue.concatDistinct |= otherGroupingValue.concatDistinct;
                    if (groupingValue.condition != null || otherGroupingValue.condition == null) continue;
                    groupingValue.condition = otherGroupingValue.condition;
                }
            }
            dedupedGroupingValues.add(groupingValue);
        }
        dedupedGroupingValues.addAll(custom);
        return dedupedGroupingValues;
    }

    public List<String> buildIdentifierList(Schema schema) {
        if (this.identifierColumnsSelection == IdentifierColumnsSelection.EXPLICIT) {
            return this.explicitIdentifiers;
        }
        if (this.identifierColumnsSelection == IdentifierColumnsSelection.ALL_BUT_USED) {
            ArrayList allTheRestIdentifiers = Lists.newArrayList();
            HashSet used = Sets.newHashSet();
            for (PivotElement pivotElement : this.pivots) {
                used.addAll(pivotElement.keyColumns);
                for (GroupingRecipePayloadParams.GroupingValue valueColumn : pivotElement.valueColumns) {
                    used.add(valueColumn.column);
                    if (!StringUtils.isNotBlank((String)valueColumn.orderColumn) || !valueColumn.first && !valueColumn.last) continue;
                    used.add(valueColumn.orderColumn);
                }
            }
            for (GroupingRecipePayloadParams.GroupingValue groupingValue : this.otherColumns) {
                used.add(groupingValue.column);
                if (!StringUtils.isNotBlank((String)groupingValue.orderColumn) || !groupingValue.first && !groupingValue.last) continue;
                used.add(groupingValue.orderColumn);
            }
            for (SchemaColumn schemaColumn : schema.getColumns()) {
                if (used.contains(schemaColumn.getName())) continue;
                allTheRestIdentifiers.add(schemaColumn.getName());
            }
            for (ComputedColumn computedColumn : this.computedColumns) {
                if (!StringUtils.isNotBlank((String)computedColumn.name) || used.contains(computedColumn.name)) continue;
                allTheRestIdentifiers.add(computedColumn.name);
            }
            return allTheRestIdentifiers;
        }
        throw new IllegalArgumentException("Unknown identifiers selection mode " + String.valueOf((Object)this.identifierColumnsSelection));
    }

    public Integer getModalityMaxLength(SQLDialect dialect) {
        if (this.modalityMaxLength != null) {
            return this.modalityMaxLength;
        }
        if (dialect != null) {
            return dialect.getIdentifiersMaxLength();
        }
        return null;
    }

    public static enum SchemaComputation {
        ALWAYS,
        ONLY_IF_NO_METADATA;

    }

    public static enum ModalitySlugification {
        NONE,
        SOFT_SLUGIFY,
        HARD_SLUGIFY,
        NUMBER;

    }

    public static enum IdentifierColumnsSelection {
        EXPLICIT,
        ALL_BUT_USED;

    }
}

