/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.split;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbstractInitializedRunner;
import com.dataiku.dip.dataflow.exec.AbstractStagedThreadedBuiltinRunner;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.filter.GrelExpression;
import com.dataiku.dip.dataflow.exec.split.SplitRecipePayloadParams;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutputToSIP;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.datalayer.sort.RowAndSortMark;
import com.dataiku.dip.datalayer.sort.SortedRowsIterator;
import com.dataiku.dip.datalayer.sort.Sorter;
import com.dataiku.dip.datalayer.sort.SpilledRowsStorage;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.UniversalSingleThreadPuller;
import com.dataiku.dip.utils.DKULogger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class SplitRecipeCentileBuiltinRunner
extends AbstractStagedThreadedBuiltinRunner {
    private SplitRecipePayloadParams params;
    private ColumnFactory lastCf;
    private RowFactory lastRf;
    private RowInputStream lastInput;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.split");

    public SplitRecipeCentileBuiltinRunner(JobActivity activity, SplitRecipePayloadParams params) {
        super(activity, false);
        this.params = params;
    }

    @Override
    protected List<AbstractInitializedRunner.Output> prepareStages(File tempDirectory) throws Exception {
        assert (this.inputs.containsKey("main"));
        assert (!((List)this.inputs.get("main")).isEmpty());
        assert (this.outputs.containsKey("main"));
        assert (!((List)this.outputs.get("main")).isEmpty());
        AbstractInitializedRunner.Input mainInput = (AbstractInitializedRunner.Input)((List)this.inputs.get("main")).get(0);
        List outputsMain = (List)this.outputs.get("main");
        this.lastCf = mainInput.cf;
        this.lastRf = null;
        this.lastInput = mainInput.is;
        if (this.params.preFilter != null && this.params.preFilter.distinct) {
            AbstractStagedThreadedBuiltinRunner.KeepDistinctRowsThread distinctStage = new AbstractStagedThreadedBuiltinRunner.KeepDistinctRowsThread(mainInput.schema, new File(tempDirectory, "prefilter"));
            ((AbstractStagedThreadedBuiltinRunner.ComputationStage)distinctStage).setInputFactories(this.lastCf, this.lastRf, this.lastInput);
            this.pipeOutputWithNewVariables(distinctStage);
            this.stages.add(distinctStage);
        }
        if (FilterDescUtils.willFilter(this.params.preFilter)) {
            GrelExpression preFilterExpression = FilterDescUtils.getGrelFilterExpression(this.params.preFilter);
            AbstractStagedThreadedBuiltinRunner.FilteringThread preFilterStage = new AbstractStagedThreadedBuiltinRunner.FilteringThread(preFilterExpression);
            ((AbstractStagedThreadedBuiltinRunner.ComputationStage)preFilterStage).setInputFactories(this.lastCf, this.lastRf, this.lastInput);
            this.pipeOutputWithNewVariables(preFilterStage);
            this.stages.add(preFilterStage);
        }
        Schema schemaAfterComputedCols = new Schema(mainInput.schema);
        if (this.params.hasComputedColumns()) {
            AbstractStagedThreadedBuiltinRunner.ComputedColumnsThread computedColumnsStage = new AbstractStagedThreadedBuiltinRunner.ComputedColumnsThread(this.params.computedColumns);
            ((AbstractStagedThreadedBuiltinRunner.ComputationStage)computedColumnsStage).setInputFactories(this.lastCf, this.lastRf, this.lastInput);
            this.pipeOutputWithNewVariables(computedColumnsStage);
            this.stages.add(computedColumnsStage);
            for (ComputedColumn cc : this.params.computedColumns) {
                schemaAfterComputedCols.addColumn(cc.name, Type.forName((String)cc.type));
            }
        }
        SorterAndCentileThread sorterAndCentileThread = new SorterAndCentileThread(new File(tempDirectory, "sorter"), schemaAfterComputedCols, this.mergeSortParams, this.params.centileOrders, this.params.centileSplits, this.params.defaultOutputDataset, outputsMain);
        sorterAndCentileThread.setInputFactories(this.lastCf, this.lastRf, this.lastInput);
        sorterAndCentileThread.setComputedColumns(this.params.computedColumns, this.params.writeComputedColumnsInOutput);
        sorterAndCentileThread.setOutputFactories((ColumnFactory)((AbstractInitializedRunner.Output)outputsMain.get((int)0)).cf, (RowFactory)((AbstractInitializedRunner.Output)outputsMain.get((int)0)).rf, null);
        this.stages.add(sorterAndCentileThread);
        return outputsMain;
    }

    private void pipeOutputWithNewVariables(AbstractStagedThreadedBuiltinRunner.ComputationStage stage) {
        StreamColumnFactory nextCf = new StreamColumnFactory();
        StreamRowFactory nextRf = new StreamRowFactory();
        UniversalSingleThreadPuller.Stream nextStream = new UniversalSingleThreadPuller.Stream();
        stage.setOutputFactories((ColumnFactory)nextCf, (RowFactory)nextRf, nextStream);
        this.lastCf = nextCf;
        this.lastRf = nextRf;
        this.lastInput = nextStream;
        stage.setEmitLastRow(true);
    }

    private class SorterAndCentileThread
    extends AbstractStagedThreadedBuiltinRunner.ComputationStage {
        private ColumnFactory inputCf;
        private RowInputStream input;
        private ColumnFactory outputCf;
        private RowFactory outputRf;
        private Throwable exception;
        private List<Sorter.SortSpec> specs;
        private List<ComputedColumn> computedColums;
        private boolean writeComputedColumnsInOuptut;
        private final List<CentileOutput> centileOutputs;
        private final ProcessorOutput defaultProcessorOutput;
        private long rowCount = 0L;
        private final Schema inputSchema;
        private final File folder;
        private final Sorter.MergeSortParams mergeSortParams;

        AbstractInitializedRunner.Output findOutput(String outputName, List<AbstractInitializedRunner.Output> outputs) {
            for (AbstractInitializedRunner.Output output : outputs) {
                if (!output.name.equals(outputName)) continue;
                return output;
            }
            return null;
        }

        ProcessorOutput buildProcessorOutput(AbstractInitializedRunner.Output output) {
            if (output == null) {
                return null;
            }
            return new ProcessorOutputToSIP(output.out);
        }

        @Override
        public void setInputFactories(ColumnFactory cf, RowFactory rf, RowInputStream input) {
            this.inputCf = cf;
            this.input = input;
        }

        @Override
        public void setOutputFactories(ColumnFactory cf, RowFactory rf, ProcessorOutput output) {
            this.outputCf = cf;
            this.outputRf = rf;
        }

        public void setSpecs(List<SplitRecipePayloadParams.Order> orders) {
            this.specs = new ArrayList<Sorter.SortSpec>();
            for (SplitRecipePayloadParams.Order order : orders) {
                this.specs.add(new Sorter.SortSpec(order.column, !order.desc));
            }
        }

        void setComputedColumns(List<ComputedColumn> computedColumns, boolean writeComputedColumnsInOutput) {
            this.computedColums = computedColumns;
            this.writeComputedColumnsInOuptut = writeComputedColumnsInOutput;
        }

        Row getOutputRow(Row intermediateRow) {
            if (!this.writeComputedColumnsInOuptut && this.computedColums != null && !this.computedColums.isEmpty()) {
                for (ComputedColumn cc : this.computedColums) {
                    intermediateRow.delete(this.inputCf.column(cc.name));
                }
            }
            return intermediateRow;
        }

        public SorterAndCentileThread(File folder, Schema inputSchema, Sorter.MergeSortParams mergeSortParams, List<SplitRecipePayloadParams.Order> orders, List<SplitRecipePayloadParams.ShareSplitDesc> centileSplits, String defaultOutputName, List<AbstractInitializedRunner.Output> outputsMain) {
            this.inputSchema = inputSchema;
            this.folder = folder;
            this.mergeSortParams = mergeSortParams;
            this.centileOutputs = new ArrayList<CentileOutput>(centileSplits.size());
            for (SplitRecipePayloadParams.ShareSplitDesc split : centileSplits) {
                this.centileOutputs.add(new CentileOutput(split, outputsMain));
            }
            this.defaultProcessorOutput = this.buildProcessorOutput(this.findOutput(defaultOutputName, outputsMain));
            this.setSpecs(orders);
        }

        @Override
        public void run() {
            Sorter sorter = null;
            try (SpilledRowsStorage storage = new SpilledRowsStorage(this.folder, SpilledRowsStorage.factoryColumnsOfSchema(this.inputCf, this.inputSchema), this.mergeSortParams);){
                sorter = new Sorter(this.specs, this.inputSchema, this.inputCf, storage, this.outputRf, this.outputCf, this.mergeSortParams);
                long totalRowCount = 0L;
                Object row = this.input.next();
                while (row != null) {
                    sorter.emitRow((Row)row);
                    ++totalRowCount;
                    row = this.input.next();
                }
                sorter.lastRowEmitted();
                storage.doneWriting();
                logger.info((Object)"Sorting phase done, now iterating");
                if (totalRowCount == 0L) {
                    return;
                }
                for (CentileOutput output : this.centileOutputs) {
                    output.setTargetRecords(totalRowCount);
                }
                SortedRowsIterator sortedInput = sorter.read();
                int currentOutputIndex = 0;
                CentileOutput currentOutput = this.centileOutputs.get(currentOutputIndex);
                boolean finishedTreatingOutputs = false;
                long offset = currentOutput.targetRecords;
                RowAndSortMark rowAndMark = sortedInput.next();
                while (rowAndMark != null) {
                    ++this.rowCount;
                    if (!finishedTreatingOutputs && this.rowCount > offset) {
                        if (currentOutputIndex < this.centileOutputs.size() - 1) {
                            currentOutput = this.centileOutputs.get(++currentOutputIndex);
                            offset += currentOutput.targetRecords;
                        } else {
                            finishedTreatingOutputs = true;
                        }
                    }
                    if (!finishedTreatingOutputs) {
                        if (currentOutput.processorOutput != null) {
                            currentOutput.processorOutput.emitRow(this.getOutputRow(rowAndMark.row.row));
                        }
                    } else if (this.defaultProcessorOutput != null) {
                        this.defaultProcessorOutput.emitRow(this.getOutputRow(rowAndMark.row.row));
                    }
                    rowAndMark = sortedInput.next();
                }
            }
            catch (InterruptedException e) {
                try {
                    if (sorter != null) {
                        sorter.cancel();
                    }
                    for (CentileOutput fo : this.centileOutputs) {
                        if (fo.processorOutput == null) continue;
                        fo.processorOutput.cancel();
                    }
                    if (this.defaultProcessorOutput != null) {
                        this.defaultProcessorOutput.cancel();
                    }
                }
                catch (Exception e1) {
                    this.exception = e1;
                }
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                logger.error((Object)"Sort stage failed", (Throwable)e);
                SplitRecipeCentileBuiltinRunner.this.interruptStages();
                for (CentileOutput fo : this.centileOutputs) {
                    if (fo.processorOutput == null) continue;
                    try {
                        fo.processorOutput.cancel();
                    }
                    catch (Exception e2) {
                        logger.warn((Object)"Failed to cleanup outputs", (Throwable)e2);
                    }
                }
                if (this.defaultProcessorOutput != null) {
                    try {
                        this.defaultProcessorOutput.cancel();
                    }
                    catch (Exception e2) {
                        logger.warn((Object)"Failed to cleanup outputs", (Throwable)e2);
                    }
                }
                this.exception = e;
            }
        }

        @Override
        public Throwable getException() {
            return this.exception;
        }

        private class CentileOutput {
            ProcessorOutput processorOutput;
            float share;
            long targetRecords;

            CentileOutput(SplitRecipePayloadParams.ShareSplitDesc split, List<AbstractInitializedRunner.Output> outputs) {
                this.processorOutput = SorterAndCentileThread.this.buildProcessorOutput(SorterAndCentileThread.this.findOutput(split.outputDatasetFullName, outputs));
                this.share = split.share.floatValue();
            }

            public void setTargetRecords(long totalRecords) {
                this.targetRecords = (long)Math.ceil(this.share * (float)totalRecords / 100.0f);
            }
        }
    }
}

