/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.exec.sync.CloudToSnowflake;
import com.dataiku.dip.dataflow.exec.sync.FastPathDatasetTypeStraightener;
import com.dataiku.dip.dataflow.exec.sync.SnowflakeToCloud;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.S3DatasetHandler;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.sql.SnowflakeSQLDialect;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class S3ToSnowflake
extends CloudToSnowflake<S3DatasetHandler> {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.s3tosnowflake");

    public static void setCompatible(Dataset inputDS, Dataset outputDS, RecipeEngineStatus status) {
        DatasetHandler.DatasetMeta<?, ?> outputMeta = DatasetHandlerFactory.getMeta(outputDS);
        status.isSelectable = true;
        if (!new FastPathDatasetTypeStraightener().isEquivalentTo(inputDS, "S3")) {
            status.markAsNonSelectable("Input dataset is not in S3", RecipeEngineStatus.WarningLevel.ERROR);
            return;
        }
        if (outputMeta != BuiltinSQLDatasets.SNOWFLAKE_META) {
            status.markAsNonSelectable("Output dataset is not in Snowflake", RecipeEngineStatus.WarningLevel.ERROR);
            return;
        }
        try {
            SnowflakeToCloud.getCopyMode(inputDS, true);
        }
        catch (SnowflakeToCloud.SnowflakeCloudFastpathImpossibleException e) {
            status.markAsNonSelectable(e.getMessage(), RecipeEngineStatus.WarningLevel.ERROR);
        }
    }

    @Override
    protected String getRootPath(S3DatasetHandler blobDShandler) throws DKUSecurityException, CodedException, IOException {
        return blobDShandler.getRootPathForSnowflakeFastPath();
    }

    @Override
    protected String generateCopyStatementFromCloud(String outputTableFullName, String inputFullPath, String specifiedFilePaths, CloudToSnowflake.CopyMode mode, S3DatasetHandler blobDShandler, boolean append, StringBuilder displayableSql) throws IOException, DKUSecurityException {
        String displayCreds;
        String creds;
        EC2Connection inputConnection = blobDShandler.getConnection();
        EC2Connection.S3FastPathCredentials s3Credentials = inputConnection.getS3CredentialsForFastPath(this.authCtx);
        if (inputFullPath.startsWith("@")) {
            creds = "";
            displayCreds = "";
        } else if (StringUtils.isNotBlank((String)inputConnection.params.snowflakeStorageIntegration)) {
            SnowflakeSQLDialect dialect = new SnowflakeSQLDialect();
            displayCreds = creds = String.format("   STORAGE_INTEGRATION=%s", dialect.quoteIdentifier(inputConnection.params.snowflakeStorageIntegration));
        } else {
            logger.info((Object)("Using access key: " + s3Credentials.getAccessKey()));
            creds = String.format("   CREDENTIALS=(%s)", s3Credentials.getCredentialStringForSnowflake());
            displayCreds = "   CREDENTIALS=(****)";
        }
        Object copyStatement = String.format("COPY INTO %s FROM '%s'  %s  %s   FILE_FORMAT = (%s " + mode.generateSnowflakeParquetLogicalTypes() + " )   FORCE=%s", outputTableFullName, inputFullPath, mode.generateToSnowflakeCommonOptions(), creds, mode.generateFormatOptions(), append ? "true" : "false");
        Object displaySql = String.format("COPY INTO %s FROM '%s'   %s   %s   FILE_FORMAT = (%s)   FORCE=%s", outputTableFullName, inputFullPath, mode.generateToSnowflakeCommonOptions(), displayCreds, mode.generateFormatOptions(), append ? "true" : "false");
        if (StringUtils.isNotBlank((String)specifiedFilePaths)) {
            copyStatement = (String)copyStatement + "   FILES = (" + specifiedFilePaths + ")";
            displaySql = (String)displaySql + "   FILES = (" + specifiedFilePaths + ")";
        }
        displayableSql.append((String)displaySql);
        return copyStatement;
    }
}

