/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.utils;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.partitioning.Partition;
import java.util.ArrayList;
import java.util.List;

public class DatasetPartition {
    public String dataset;
    public String partition;

    public DatasetPartition(String dataset, String partition) {
        this.dataset = dataset;
        this.partition = partition;
    }

    public DatasetPartition(Dataset dataset, Partition partition) {
        this.dataset = dataset.getName();
        this.partition = partition.id();
    }

    public DatasetPartition(FlowDataset dataset, Partition partition) {
        this.dataset = dataset.getFullName();
        this.partition = partition.id();
    }

    public static List<DatasetPartition> subgraphSources(RunnableSubgraph subgraph) {
        ArrayList<DatasetPartition> ret = new ArrayList<DatasetPartition>();
        for (FlowDataset source : subgraph.getSourceDatasets()) {
            for (Partition p : subgraph.getSourcePartitions(source)) {
                ret.add(new DatasetPartition(source.getFullName(), p.id()));
            }
        }
        return ret;
    }

    public static List<DatasetPartition> subgraphTargets(RunnableSubgraph subgraph) {
        ArrayList<DatasetPartition> ret = new ArrayList<DatasetPartition>();
        for (FlowDataset target : subgraph.getTargetsDatasets()) {
            Partition p = subgraph.getTargetPartition(target);
            ret.add(new DatasetPartition(target.getFullName(), p.id()));
        }
        return ret;
    }
}

