/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.sort;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.sort.BufferFiller;
import com.dataiku.dip.datalayer.sort.NumberedRow;
import com.dataiku.dip.datalayer.sort.SimpleRowsFileReader;
import com.dataiku.dip.datalayer.sort.SimpleRowsFileWriter;
import com.dataiku.dip.datalayer.sort.Sorter;
import com.dataiku.dip.datalayer.sort.SortingRow;
import com.dataiku.dip.datalayer.sort.SpilledRows;
import com.dataiku.dip.datalayer.utils.SpilledRowsWithPositions;
import com.dataiku.dip.utils.DKUFileUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SpilledRowsStorage
implements AutoCloseable {
    private final File folder;
    private final SimpleRowsFileWriter spills;
    private final Path spillsPath;
    private final List<AutoCloseable> mess = Lists.newArrayList();
    private final BufferFiller bufferFiller;
    private final Sorter.MergeSortParams mergeSortParams;
    private final List<Column> columns;
    private final Map<String, Integer> columnIndices;
    private long spilledCount = 0L;
    private static Logger logger = Logger.getLogger((String)"dku.sorter.storage");

    public static List<Column> factoryColumnsOfSchema(ColumnFactory cf, Schema schema) {
        ArrayList columns = Lists.newArrayList();
        for (SchemaColumn column : schema.getColumns()) {
            columns.add(cf.column(column.getName()));
        }
        return columns;
    }

    public SpilledRowsStorage(File folder, List<Column> spilledColumns, Sorter.MergeSortParams mergeSortParams) throws IOException {
        this.folder = folder;
        this.mergeSortParams = mergeSortParams;
        this.columns = Lists.newArrayList();
        this.columnIndices = Maps.newHashMap();
        for (Column column : spilledColumns) {
            this.columnIndices.put(column.getName(), this.columns.size());
            this.columns.add(column);
        }
        if (!folder.exists()) {
            DKUFileUtils.mkdirs((File)folder);
        }
        this.spillsPath = new File(folder, "spills").toPath();
        FileChannel fc = FileChannel.open(this.spillsPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        this.spills = new SimpleRowsFileWriter(fc, this.columns);
        this.mess.add(this.spills);
        this.bufferFiller = new BufferFiller(FileChannel.open(this.spillsPath, StandardOpenOption.READ));
        this.mess.add(this.bufferFiller);
    }

    public SortingRow handle(Row row) {
        return new SortingRow(row, this.columns, this.columnIndices);
    }

    public SpilledRows spill(List<NumberedRow> rows) throws Exception {
        return this.spill(rows, (boolean)false).spilledRows;
    }

    public SpilledRowsWithPositions spillWithPositions(List<NumberedRow> rows) throws Exception {
        return this.spill(rows, true);
    }

    private SpilledRowsWithPositions spill(List<NumberedRow> rows, boolean saveRowsPositions) throws Exception {
        SpilledRows spilledRows = new SpilledRows();
        Map<Long, Long> rowsPositions = spilledRows.spill(this.spills, rows, this.spilledCount, saveRowsPositions);
        this.spilledCount += (long)rows.size();
        return new SpilledRowsWithPositions(spilledRows, rowsPositions);
    }

    public SimpleRowsFileReader newReader(RowFactory rf, ColumnFactory cf) throws IOException {
        SimpleRowsFileReader reader = new SimpleRowsFileReader(this.bufferFiller, this.columns, cf, rf, this.mergeSortParams);
        this.mess.add(reader);
        return reader;
    }

    public void doneWriting() throws IOException {
        this.spills.close();
    }

    @Override
    public void close() throws IOException {
        for (AutoCloseable item : this.mess) {
            try {
                item.close();
            }
            catch (Exception e) {
                logger.error((Object)"Failed to cleanup", (Throwable)e);
            }
        }
        if (this.folder.exists()) {
            DKUFileUtils.forceDelete((File)this.folder);
        }
    }
}

