/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataquality;

import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.Set;

public interface UIComputeRuleSelection {

    @UIModel
    @PolyJSON(value={@Mapping(type="SingleRule", value=SingleRule.class), @Mapping(type="MultipleRules", value=MultipleRules.class), @Mapping(type="AllRules", value=AllRules.class)})
    public static abstract class RuleSelectionSpec {
        public abstract boolean matches(DataQualityRule var1);

        public boolean excludeAutoRun() {
            return false;
        }

        public static class AllRules
        extends RuleSelectionSpec {
            public boolean excludeAutoRun = false;

            @Override
            public boolean matches(DataQualityRule r) {
                return true;
            }

            @Override
            public boolean excludeAutoRun() {
                return this.excludeAutoRun;
            }
        }

        public static class MultipleRules
        extends RuleSelectionSpec {
            Set<String> ruleIds;

            @Override
            public boolean matches(DataQualityRule r) {
                return this.ruleIds.contains(r.getId());
            }
        }

        public static class SingleRule
        extends RuleSelectionSpec {
            public String ruleId;

            @Override
            public boolean matches(DataQualityRule r) {
                return r.getId().equals(this.ruleId);
            }
        }
    }

    @UIModel
    @PolyJSON(value={@Mapping(type="PartitionsSpec", value=PartitionsSpec.class), @Mapping(type="AllPartitions", value=AllPartitions.class)})
    public static abstract class MultiPartitionSelectionSpec {
        public boolean fullDataset;

        public static class AllPartitions
        extends MultiPartitionSelectionSpec {
        }

        public static class PartitionsSpec
        extends MultiPartitionSelectionSpec {
            public String partitionsSpec;
        }
    }
}

