/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningUtils;
import com.dataiku.dip.security.AuthCtx;
import java.util.List;

public class LatestPartitionsSelector {
    public static List<Partition> select(AuthCtx authCtx, Dataset dataset, int n) throws Exception {
        try (DatasetHandler handler = DatasetHandlerFactory.build(authCtx, dataset);){
            List<Partition> partitions = handler.listPartitions();
            if (partitions.isEmpty()) {
                throw new IllegalArgumentException("Cannot evaluate latest partition of " + dataset.getName() + ": no partition is available");
            }
            List<Partition> sorted = PartitioningUtils.sort(partitions, true);
            if (sorted.size() <= n) {
                List<Partition> list = sorted;
                return list;
            }
            List<Partition> list = sorted.subList(0, n);
            return list;
        }
    }

    public static List<Partition> select(AuthCtx authCtx, ManagedFolder folder, int n) throws Exception {
        try (ManagedFolderHandler handler = (ManagedFolderHandler)folder.buildHandler(authCtx);){
            List<Partition> partitions = handler.listPartitions();
            if (partitions.isEmpty()) {
                throw new IllegalArgumentException("Cannot evaluate latest partition of " + folder.getName() + ": no partition is available");
            }
            List<Partition> sorted = PartitioningUtils.sort(partitions, true);
            if (sorted.size() <= n) {
                List<Partition> list = sorted;
                return list;
            }
            List<Partition> list = sorted.subList(0, n);
            return list;
        }
    }
}

