/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.core.sync.RequestBody;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.S3Client;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.CompletedPart;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.UploadPartRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.UploadPartResponse;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class AmazonS3OutputStream
extends OutputStream {
    public static final int MINIMAL_PART_SIZE = 0x500000;
    private final S3Client s3;
    private final String bucket;
    private final String path;
    private final int partSize;
    private ByteArrayInputOutputStream buffer = new ByteArrayInputOutputStream();
    private final List<CompletedPart> completedParts = new ArrayList<CompletedPart>();
    private final String uploadId;
    private boolean closed;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fs.s3.upload");

    public AmazonS3OutputStream(S3Client s3, String bucket, String path, ServerSideEncryption sseAlgorithm, String sseKeyId) {
        this(s3, bucket, path, 0x500000, false, sseAlgorithm, sseKeyId);
    }

    public AmazonS3OutputStream(S3Client s3, String bucket, String path, int partSize, boolean addCannedACL, ServerSideEncryption sseAlgorithm, String sseKeyId) {
        Preconditions.checkArgument((partSize >= 0x500000 ? 1 : 0) != 0, (Object)"partSize must be greater or equal to 5 MB");
        this.bucket = bucket;
        this.path = path;
        this.s3 = s3;
        this.partSize = partSize;
        logger.info((Object)String.format("Initiate multipart upload [bucket=%s, path=%s, encrypt=%s].", bucket, path, sseAlgorithm != null ? "yes" : "no"));
        this.uploadId = s3.createMultipartUpload(this.buildCreateMultipartUploadRequest(bucket, path, addCannedACL, sseAlgorithm, sseKeyId)).uploadId();
    }

    @Override
    public synchronized void write(int arg) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write into an AmazonS3OutputStream that has been closed.");
        }
        this.buffer.write(arg);
        if (this.buffer.size() >= this.partSize) {
            this.flushToS3(false);
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write into an AmazonS3OutputStream that has been closed.");
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int bytesToWrite = len;
        int currentOffset = off;
        while (bytesToWrite > 0) {
            int bytesCopied = Math.min(bytesToWrite, this.partSize - this.buffer.size());
            this.buffer.write(b, currentOffset, bytesCopied);
            if (this.buffer.size() >= this.partSize) {
                this.flushToS3(false);
            }
            bytesToWrite -= bytesCopied;
            currentOffset += bytesCopied;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.flushToS3(true);
            this.closed = true;
        }
    }

    private CreateMultipartUploadRequest buildCreateMultipartUploadRequest(String bucket, String path, boolean addCannedACL, ServerSideEncryption sseAlgorithm, String sseKeyId) {
        CreateMultipartUploadRequest.Builder builder = CreateMultipartUploadRequest.builder().bucket(bucket).key(path);
        if (addCannedACL) {
            builder.acl(ObjectCannedACL.BUCKET_OWNER_FULL_CONTROL);
        }
        if (sseAlgorithm != null) {
            builder.serverSideEncryption(sseAlgorithm.toString());
            if (StringUtils.isNotEmpty((String)sseKeyId) && sseAlgorithm == ServerSideEncryption.AWS_KMS) {
                builder.ssekmsKeyId(sseKeyId);
            }
        }
        return (CreateMultipartUploadRequest)builder.build();
    }

    private void flushToS3(boolean isLast) throws IOException {
        try {
            int buffSize = this.buffer.size();
            if (buffSize > 0 || isLast && this.completedParts.isEmpty()) {
                UploadPartRequest partRequest = (UploadPartRequest)UploadPartRequest.builder().bucket(this.bucket).key(this.path).uploadId(this.uploadId).partNumber(Integer.valueOf(1 + this.completedParts.size())).contentLength(Long.valueOf(buffSize)).build();
                logger.info((Object)String.format("Upload part [bucket=%s, path=%s, partNumber=%d, contentLength=%d].", partRequest.bucket(), partRequest.key(), partRequest.partNumber(), partRequest.contentLength()));
                UploadPartResponse uploadPartResponse = this.s3.uploadPart(partRequest, RequestBody.fromInputStream((InputStream)this.buffer.asInputStream(), (long)buffSize));
                CompletedPart part = (CompletedPart)CompletedPart.builder().partNumber(partRequest.partNumber()).eTag(uploadPartResponse.eTag()).build();
                this.completedParts.add(part);
                this.buffer = new ByteArrayInputOutputStream();
            }
            if (isLast) {
                logger.info((Object)String.format("Complete multipart upload [bucket=%s, path=%s].", this.bucket, this.path));
                this.s3.completeMultipartUpload((CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().bucket(this.bucket).key(this.path).uploadId(this.uploadId).multipartUpload((CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(this.completedParts).build()).build());
            }
        }
        catch (Exception e) {
            logger.error((Object)String.format("Abort multipart upload [bucket=%s, path=%s].", this.bucket, this.path), (Throwable)e);
            AbortMultipartUploadRequest abortMultipartUploadRequest = (AbortMultipartUploadRequest)AbortMultipartUploadRequest.builder().bucket(this.bucket).key(this.path).uploadId(this.uploadId).build();
            this.s3.abortMultipartUpload(abortMultipartUploadRequest);
            throw new IOException(e);
        }
    }

    private static final class ByteArrayInputOutputStream
    extends ByteArrayOutputStream {
        private ByteArrayInputOutputStream() {
        }

        ByteArrayInputStream asInputStream() {
            return new ByteArrayInputStream(this.buf, 0, this.count);
        }
    }
}

