/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.PluginEntryPoint;
import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.DatabricksConnection;
import com.dataiku.dip.connections.DatabricksVolumeConnection;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.connections.FSProviderizableConnection;
import com.dataiku.dip.connections.FTPConnection;
import com.dataiku.dip.connections.FsConnection;
import com.dataiku.dip.connections.GCSConnection;
import com.dataiku.dip.connections.HDFSConnection;
import com.dataiku.dip.connections.SSHConnection;
import com.dataiku.dip.connections.SharePointOnlineConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.custom.IPluginifiedHolderMeta;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.ManagedDatasetsHelper;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.AzureBlobDatasetHandler;
import com.dataiku.dip.datasets.fs.DatabricksVolumeDatasetHandler;
import com.dataiku.dip.datasets.fs.FTPDatasetHandler;
import com.dataiku.dip.datasets.fs.FilesInFolderDatasetHandler;
import com.dataiku.dip.datasets.fs.FilesystemDatasetConfig;
import com.dataiku.dip.datasets.fs.FilesystemDatasetHandler;
import com.dataiku.dip.datasets.fs.FolderProvidedFilesConfig;
import com.dataiku.dip.datasets.fs.GCSDatasetHandler;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.datasets.fs.HTTPDatasetHandler;
import com.dataiku.dip.datasets.fs.S3DatasetHandler;
import com.dataiku.dip.datasets.fs.SCPDatasetHandler;
import com.dataiku.dip.datasets.fs.SFTPDatasetHandler;
import com.dataiku.dip.datasets.fs.SharePointOnlineDatasetHandler;
import com.dataiku.dip.datasets.fs.UploadableDatasetConfig;
import com.dataiku.dip.datasets.fs.UploadedFilesDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.ConfValidators;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class BuiltinFSDatasets
extends PluginEntryPoint {
    public static final String FS_TYPE = "Filesystem";
    public static final FSDatasetMeta<FilesystemDatasetHandler, FilesystemDatasetConfig> FS_META = new FSDatasetMeta<FilesystemDatasetHandler, FilesystemDatasetConfig>(){

        @Override
        public String getType() {
            return BuiltinFSDatasets.FS_TYPE;
        }

        @Override
        public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
            return FilesystemDatasetConfig.class;
        }

        @Override
        public DatasetHandler build(AuthCtx authCtx, Dataset dataset) {
            return new FilesystemDatasetHandler(authCtx, dataset);
        }

        @Override
        public boolean isFSLike() {
            return true;
        }

        @Override
        public boolean isFS() {
            return true;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public boolean isParallelWritable() {
            return true;
        }

        @Override
        public AbstractFSDatasetHandler.AbstractFSConfig createUploadedDatasetParams(String projectKey, String datasetName, DSSConnection targetConnection) {
            FilesystemDatasetConfig config = new FilesystemDatasetConfig();
            config.connection = targetConnection.name;
            config.path = PathUtils.concatLNT((String[])new String[]{"uploads", BuiltinFSDatasets.makePathFromNamingRule(((FsConnection)targetConnection).params.namingRule, datasetName)});
            return config;
        }

        @Override
        public void fillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings specificSettings, boolean useExistingParams) {
            ManagedDatasetsCreationService.FormatOptionId formatOptionId = specificSettings == null ? null : specificSettings.formatOptionId;
            FilesystemDatasetConfig config = (FilesystemDatasetConfig)this.baseFillManagedDatasetParams(dataset, targetConnection, formatOptionId, useExistingParams);
            config.path = BuiltinFSDatasets.makePathFromNamingRule(((FsConnection)targetConnection).params.namingRule, dataset.getName());
        }

        @Override
        public void fillManagedFolderParams(ManagedFolder folder, DSSConnection targetConnection, boolean useExistingParams) {
            FilesystemDatasetConfig config = (FilesystemDatasetConfig)this.baseFillManagedFolderParams(folder, targetConnection, useExistingParams);
            config.path = BuiltinFSDatasets.makePathFromNamingRule(((FsConnection)targetConnection).params.namingRule, "${odbId}");
        }
    };
    public static final String HDFS_TYPE = "HDFS";
    public static final FSDatasetMeta<HDFSDatasetHandler, HDFSDatasetHandler.Config> HDFS_META = new FSDatasetMeta<HDFSDatasetHandler, HDFSDatasetHandler.Config>(){

        @Override
        public String getType() {
            return BuiltinFSDatasets.HDFS_TYPE;
        }

        @Override
        public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
            return HDFSDatasetHandler.Config.class;
        }

        @Override
        public HDFSDatasetHandler build(AuthCtx authCtx, Dataset dataset) {
            return new HDFSDatasetHandler(authCtx, dataset, false);
        }

        @Override
        public boolean isFSLike() {
            return true;
        }

        @Override
        public boolean isFS() {
            return true;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public boolean isParallelWritable() {
            return true;
        }

        @Override
        public AbstractFSDatasetHandler.AbstractFSConfig createUploadedDatasetParams(String projectKey, String datasetName, DSSConnection targetConnection) {
            HDFSDatasetHandler.Config config = new HDFSDatasetHandler.Config();
            HDFSConnection hdfsConnection = (HDFSConnection)targetConnection;
            config.connection = targetConnection.name;
            config.path = PathUtils.concatLNT((String[])new String[]{hdfsConnection.params.namingRule.uploadsPathPrefix, this.createPath(hdfsConnection, datasetName)});
            config.hiveDatabase = hdfsConnection.params.namingRule.hiveDatabaseName;
            config.hiveTableName = this.createHiveTableName(datasetName, (HDFSConnection)targetConnection);
            return config;
        }

        @Override
        public void fillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings specificSettings, boolean useExistingParams) {
            ManagedDatasetsCreationService.FormatOptionId formatOptionId = specificSettings == null ? null : specificSettings.formatOptionId;
            HDFSDatasetHandler.Config config = (HDFSDatasetHandler.Config)this.baseFillManagedDatasetParams(dataset, targetConnection, formatOptionId, useExistingParams);
            config.path = this.createPath((HDFSConnection)targetConnection, dataset.getName());
            config.hiveDatabase = ((HDFSConnection)targetConnection).params.namingRule.hiveDatabaseName;
            config.hiveTableName = this.createHiveTableName(dataset.getName(), (HDFSConnection)targetConnection);
        }

        @Override
        public void fillManagedFolderParams(ManagedFolder folder, DSSConnection targetConnection, boolean useExistingParams) {
            HDFSDatasetHandler.Config config = (HDFSDatasetHandler.Config)this.baseFillManagedFolderParams(folder, targetConnection, useExistingParams);
            config.path = this.createPath((HDFSConnection)targetConnection, "${odbId}");
        }

        private String createPath(HDFSConnection hdfsConn, String objectName) {
            Object path = "";
            if (StringUtils.isNotBlank((String)hdfsConn.params.namingRule.hdfsPathDatasetNamePrefix)) {
                path = (String)path + hdfsConn.params.namingRule.hdfsPathDatasetNamePrefix;
            }
            path = (String)path + objectName;
            if (StringUtils.isNotBlank((String)hdfsConn.params.namingRule.hdfsPathDatasetNameSuffix)) {
                path = (String)path + hdfsConn.params.namingRule.hdfsPathDatasetNameSuffix;
            }
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            return path;
        }

        private String createHiveTableName(String objectName, HDFSConnection hdfsConn) {
            Object hiveTableName = "";
            if (StringUtils.isNotBlank((String)hdfsConn.params.namingRule.tableNameDatasetNamePrefix)) {
                hiveTableName = (String)hiveTableName + hdfsConn.params.namingRule.tableNameDatasetNamePrefix;
            }
            hiveTableName = (String)hiveTableName + objectName;
            if (StringUtils.isNotBlank((String)hdfsConn.params.namingRule.tableNameDatasetNameSuffix)) {
                hiveTableName = (String)hiveTableName + hdfsConn.params.namingRule.tableNameDatasetNameSuffix;
            }
            return hiveTableName;
        }
    };
    public static final String S3_TYPE = "S3";
    public static final FSDatasetMeta<S3DatasetHandler, S3DatasetConfig> S3_META = new FSDatasetMeta<S3DatasetHandler, S3DatasetConfig>(){

        @Override
        public String getType() {
            return BuiltinFSDatasets.S3_TYPE;
        }

        @Override
        public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
            return S3DatasetConfig.class;
        }

        @Override
        public DatasetHandler build(AuthCtx authCtx, Dataset dataset) {
            return new S3DatasetHandler(authCtx, dataset);
        }

        @Override
        public boolean isFSLike() {
            return true;
        }

        @Override
        public boolean isFS() {
            return true;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public boolean isParallelWritable() {
            return true;
        }

        @Override
        public AbstractFSDatasetHandler.AbstractFSConfig createUploadedDatasetParams(String projectKey, String datasetName, DSSConnection targetConnection) throws CodedException {
            S3DatasetConfig config = new S3DatasetConfig();
            config.connection = targetConnection.name;
            this.setBucketAndPath(config, datasetName, targetConnection, true);
            return config;
        }

        @Override
        public void fillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings specificSettings, boolean useExistingParams) throws CodedException {
            ManagedDatasetsCreationService.FormatOptionId formatOptionId = specificSettings == null ? null : specificSettings.formatOptionId;
            S3DatasetConfig config = (S3DatasetConfig)this.baseFillManagedDatasetParams(dataset, targetConnection, formatOptionId, useExistingParams);
            this.setBucketAndPath(config, dataset.getName(), targetConnection, false);
        }

        @Override
        public void fillManagedFolderParams(ManagedFolder folder, DSSConnection targetConnection, boolean useExistingParams) throws CodedException {
            S3DatasetConfig config = (S3DatasetConfig)this.baseFillManagedFolderParams(folder, targetConnection, useExistingParams);
            this.setBucketAndPath(config, "${odbId}", targetConnection, false);
        }

        private void setBucketAndPath(S3DatasetConfig config, String objectName, DSSConnection targetConnection, boolean isUpload) throws CodedException {
            EC2Connection connection = (EC2Connection)targetConnection;
            String defaultManagedBucket = connection.params.getDefaultManagedBucket();
            ConfValidators.checkNotBlank(defaultManagedBucket, ConnectionCodes.ERR_CONNECTION_S3_INVALID_CONFIG, "default bucket");
            ConfValidators.checkNotBlank(connection.params.defaultManagedPath, ConnectionCodes.ERR_CONNECTION_S3_INVALID_CONFIG, "default path");
            config.bucket = defaultManagedBucket;
            config.path = isUpload ? PathUtils.concatLNT((String[])new String[]{connection.params.defaultManagedPath, "uploads", BuiltinFSDatasets.makePathFromNamingRule(connection.params.namingRule, objectName)}) : PathUtils.concatLNT((String[])new String[]{connection.params.defaultManagedPath, BuiltinFSDatasets.makePathFromNamingRule(connection.params.namingRule, objectName)});
            EC2Connection ec2Conn = (EC2Connection)targetConnection;
            config.metastoreDatabaseName = ec2Conn.params.namingRule.metastoreDatabaseName;
            config.metastoreTableName = "";
            if (StringUtils.isNotBlank((String)ec2Conn.params.namingRule.metastoreTableNameDatasetNamePrefix)) {
                config.metastoreTableName = config.metastoreTableName + ec2Conn.params.namingRule.metastoreTableNameDatasetNamePrefix;
            }
            config.metastoreTableName = config.metastoreTableName + objectName;
            if (StringUtils.isNotBlank((String)ec2Conn.params.namingRule.metastoreTableNameDatasetNameSuffix)) {
                config.metastoreTableName = config.metastoreTableName + ec2Conn.params.namingRule.metastoreTableNameDatasetNameSuffix;
            }
        }
    };
    public static final String GCS_TYPE = "GCS";
    public static final FSDatasetMeta<GCSDatasetHandler, GCSDatasetConfig> GCS_META = new FSDatasetMeta<GCSDatasetHandler, GCSDatasetConfig>(){

        @Override
        public String getType() {
            return BuiltinFSDatasets.GCS_TYPE;
        }

        @Override
        public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
            return GCSDatasetConfig.class;
        }

        @Override
        public DatasetHandler build(AuthCtx authCtx, Dataset dataset) {
            return new GCSDatasetHandler(authCtx, dataset);
        }

        @Override
        public boolean isFSLike() {
            return true;
        }

        @Override
        public boolean isFS() {
            return true;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public boolean isParallelWritable() {
            return true;
        }

        @Override
        public AbstractFSDatasetHandler.AbstractFSConfig createUploadedDatasetParams(String projectKey, String datasetName, DSSConnection targetConnection) throws CodedException {
            GCSDatasetConfig config = new GCSDatasetConfig();
            config.connection = targetConnection.name;
            this.setBucketAndPath(config, (GCSConnection)targetConnection, datasetName, true);
            return config;
        }

        @Override
        public void fillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings specificSettings, boolean useExistingParams) throws CodedException {
            ManagedDatasetsCreationService.FormatOptionId formatOptionId = specificSettings == null ? null : specificSettings.formatOptionId;
            GCSDatasetConfig config = (GCSDatasetConfig)this.baseFillManagedDatasetParams(dataset, targetConnection, formatOptionId, useExistingParams);
            this.setBucketAndPath(config, (GCSConnection)targetConnection, dataset.getName(), false);
        }

        @Override
        public void fillManagedFolderParams(ManagedFolder folder, DSSConnection targetConnection, boolean useExistingParams) throws CodedException {
            GCSDatasetConfig config = (GCSDatasetConfig)this.baseFillManagedFolderParams(folder, targetConnection, useExistingParams);
            this.setBucketAndPath(config, (GCSConnection)targetConnection, "${odbId}", false);
        }

        private void setBucketAndPath(GCSDatasetConfig config, GCSConnection connection, String objectName, boolean isUpload) throws CodedException {
            ConfValidators.checkNotBlank(connection.params.getDefaultManagedBucket(), ConnectionCodes.ERR_CONNECTION_GCS_INVALID_CONFIG, "default bucket");
            ConfValidators.checkNotBlank(connection.params.defaultManagedPath, ConnectionCodes.ERR_CONNECTION_GCS_INVALID_CONFIG, "default path");
            config.bucket = connection.params.getDefaultManagedBucket();
            config.path = isUpload ? PathUtils.concatLNT((String[])new String[]{connection.params.defaultManagedPath, "uploads", BuiltinFSDatasets.makePathFromNamingRule(connection.params.namingRule, objectName)}) : PathUtils.concatLNT((String[])new String[]{connection.params.defaultManagedPath, BuiltinFSDatasets.makePathFromNamingRule(connection.params.namingRule, objectName)});
            config.metastoreDatabaseName = connection.params.namingRule.metastoreDatabaseName;
            config.metastoreTableName = "";
            if (StringUtils.isNotBlank((String)connection.params.namingRule.metastoreTableNameDatasetNamePrefix)) {
                config.metastoreTableName = config.metastoreTableName + connection.params.namingRule.metastoreTableNameDatasetNamePrefix;
            }
            config.metastoreTableName = config.metastoreTableName + objectName;
            if (StringUtils.isNotBlank((String)connection.params.namingRule.metastoreTableNameDatasetNameSuffix)) {
                config.metastoreTableName = config.metastoreTableName + connection.params.namingRule.metastoreTableNameDatasetNameSuffix;
            }
        }
    };
    public static final String FTP_TYPE = "FTP";
    public static final FSDatasetMeta<FTPDatasetHandler, FTPDatasetConfig> FTP_META = new FSDatasetMeta<FTPDatasetHandler, FTPDatasetConfig>(){

        @Override
        public String getType() {
            return BuiltinFSDatasets.FTP_TYPE;
        }

        @Override
        public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
            return FTPDatasetConfig.class;
        }

        @Override
        public DatasetHandler build(AuthCtx authCtx, Dataset dataset) {
            return new FTPDatasetHandler(authCtx, dataset);
        }

        @Override
        public boolean isFSLike() {
            return true;
        }

        @Override
        public boolean isFS() {
            return true;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public boolean isParallelWritable() {
            return false;
        }

        @Override
        public AbstractFSDatasetHandler.AbstractFSConfig createUploadedDatasetParams(String projectKey, String datasetName, DSSConnection targetConnection) {
            FTPDatasetConfig config = new FTPDatasetConfig();
            config.connection = targetConnection.name;
            config.path = PathUtils.concatLNT((String[])new String[]{"uploads", BuiltinFSDatasets.makePathFromNamingRule(((FTPConnection)targetConnection).params.namingRule, datasetName)});
            return config;
        }

        @Override
        public void fillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings specificSettings, boolean useExistingParams) {
            ManagedDatasetsCreationService.FormatOptionId formatOptionId = specificSettings == null ? null : specificSettings.formatOptionId;
            FTPDatasetConfig config = (FTPDatasetConfig)this.baseFillManagedDatasetParams(dataset, targetConnection, formatOptionId, useExistingParams);
            config.path = BuiltinFSDatasets.makePathFromNamingRule(((FTPConnection)targetConnection).params.namingRule, dataset.getName());
        }

        @Override
        public void fillManagedFolderParams(ManagedFolder folder, DSSConnection targetConnection, boolean useExistingParams) {
            FTPDatasetConfig config = (FTPDatasetConfig)this.baseFillManagedFolderParams(folder, targetConnection, useExistingParams);
            config.path = BuiltinFSDatasets.makePathFromNamingRule(((FTPConnection)targetConnection).params.namingRule, "${odbId}");
        }
    };
    public static final String SFTP_TYPE = "SFTP";
    public static final FSDatasetMeta<SFTPDatasetHandler, SFTPDatasetConfig> SFTP_META = new FSDatasetMeta<SFTPDatasetHandler, SFTPDatasetConfig>(){

        @Override
        public String getType() {
            return BuiltinFSDatasets.SFTP_TYPE;
        }

        @Override
        public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
            return SFTPDatasetConfig.class;
        }

        @Override
        public DatasetHandler build(AuthCtx authCtx, Dataset dataset) {
            return new SFTPDatasetHandler(authCtx, dataset);
        }

        @Override
        public boolean isFSLike() {
            return true;
        }

        @Override
        public boolean isFS() {
            return true;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public boolean isParallelWritable() {
            return false;
        }

        @Override
        public AbstractFSDatasetHandler.AbstractFSConfig createUploadedDatasetParams(String projectKey, String datasetName, DSSConnection targetConnection) {
            SFTPDatasetConfig config = new SFTPDatasetConfig();
            config.connection = targetConnection.name;
            config.path = PathUtils.concatLNT((String[])new String[]{"uploads", BuiltinFSDatasets.makePathFromNamingRule(((SSHConnection)targetConnection).params.namingRule, datasetName)});
            return config;
        }

        @Override
        public void fillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings specificSettings, boolean useExistingParams) {
            ManagedDatasetsCreationService.FormatOptionId formatOptionId = specificSettings == null ? null : specificSettings.formatOptionId;
            SFTPDatasetConfig config = (SFTPDatasetConfig)this.baseFillManagedDatasetParams(dataset, targetConnection, formatOptionId, useExistingParams);
            config.path = BuiltinFSDatasets.makePathFromNamingRule(((SSHConnection)targetConnection).params.namingRule, dataset.getName());
        }

        @Override
        public void fillManagedFolderParams(ManagedFolder folder, DSSConnection targetConnection, boolean useExistingParams) {
            SFTPDatasetConfig config = (SFTPDatasetConfig)this.baseFillManagedFolderParams(folder, targetConnection, useExistingParams);
            config.path = BuiltinFSDatasets.makePathFromNamingRule(((SSHConnection)targetConnection).params.namingRule, "${odbId}");
        }
    };
    public static final String SCP_TYPE = "SCP";
    public static final FSDatasetMeta<SCPDatasetHandler, SCPDatasetConfig> SCP_META = new FSDatasetMeta<SCPDatasetHandler, SCPDatasetConfig>(){

        @Override
        public String getType() {
            return BuiltinFSDatasets.SCP_TYPE;
        }

        @Override
        public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
            return SCPDatasetConfig.class;
        }

        @Override
        public DatasetHandler build(AuthCtx authCtx, Dataset dataset) {
            return new SCPDatasetHandler(authCtx, dataset);
        }

        @Override
        public boolean isFSLike() {
            return true;
        }

        @Override
        public boolean isFS() {
            return true;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public boolean isParallelWritable() {
            return false;
        }

        @Override
        public AbstractFSDatasetHandler.AbstractFSConfig createUploadedDatasetParams(String projectKey, String datasetName, DSSConnection targetConnection) {
            SCPDatasetConfig config = new SCPDatasetConfig();
            config.connection = targetConnection.name;
            config.path = PathUtils.concatLNT((String[])new String[]{"uploads", BuiltinFSDatasets.makePathFromNamingRule(((SSHConnection)targetConnection).params.namingRule, datasetName)});
            return config;
        }

        @Override
        public void fillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings specificSettings, boolean useExistingParams) {
            ManagedDatasetsCreationService.FormatOptionId formatOptionId = specificSettings == null ? null : specificSettings.formatOptionId;
            SCPDatasetConfig config = (SCPDatasetConfig)this.baseFillManagedDatasetParams(dataset, targetConnection, formatOptionId, useExistingParams);
            config.path = BuiltinFSDatasets.makePathFromNamingRule(((SSHConnection)targetConnection).params.namingRule, dataset.getName());
        }

        @Override
        public void fillManagedFolderParams(ManagedFolder folder, DSSConnection targetConnection, boolean useExistingParams) {
            SCPDatasetConfig config = (SCPDatasetConfig)this.baseFillManagedFolderParams(folder, targetConnection, useExistingParams);
            config.path = BuiltinFSDatasets.makePathFromNamingRule(((SSHConnection)targetConnection).params.namingRule, "${odbId}");
        }
    };
    public static final String HTTP_TYPE = "HTTP";
    public static final DatasetHandler.DatasetMeta<HTTPDatasetHandler, HTTPDatasetConfig> HTTP_META = new DatasetHandler.DatasetMeta<HTTPDatasetHandler, HTTPDatasetConfig>(){

        @Override
        public String getType() {
            return BuiltinFSDatasets.HTTP_TYPE;
        }

        @Override
        public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
            return HTTPDatasetConfig.class;
        }

        @Override
        public DatasetHandler build(AuthCtx authCtx, Dataset dataset) {
            return new HTTPDatasetHandler(authCtx, dataset);
        }

        @Override
        public boolean isFSLike() {
            return true;
        }

        @Override
        public boolean isFS() {
            return false;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        public boolean isParallelWritable() {
            return false;
        }

        @Override
        public boolean supportsOrderPreservation() {
            return false;
        }

        @Override
        public void fillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings specificSettings, boolean useExistingParams) {
        }

        @Override
        public void fillManagedFolderParams(ManagedFolder folder, DSSConnection targetConnection, boolean useExistingParams) {
        }
    };
    public static final String UPLOADED_FILES_TYPE = "UploadedFiles";
    public static final DatasetHandler.DatasetMeta<UploadedFilesDatasetHandler, UploadedFilesConfig> UPLOADED_FILES_META = new DatasetHandler.DatasetMeta<UploadedFilesDatasetHandler, UploadedFilesConfig>(){

        @Override
        public String getType() {
            return BuiltinFSDatasets.UPLOADED_FILES_TYPE;
        }

        @Override
        public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
            return UploadedFilesConfig.class;
        }

        @Override
        public DatasetHandler build(AuthCtx authCtx, Dataset dataset) {
            return new UploadedFilesDatasetHandler(authCtx, dataset);
        }

        @Override
        public boolean isFSLike() {
            return true;
        }

        @Override
        public boolean isFS() {
            return true;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        public boolean isParallelWritable() {
            return false;
        }

        @Override
        public void fillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings unused, boolean useExistingParams) {
            throw new Error("unreachable");
        }

        @Override
        public void fillManagedFolderParams(ManagedFolder folder, DSSConnection targetConnection, boolean useExistingParams) {
            throw new Error("unreachable");
        }
    };
    public static final String SHAREPOINTONLINE_TYPE = "SharePointOnline";
    public static final FSDatasetMeta<SharePointOnlineDatasetHandler, SharePointOnlineDatasetConfig> SHAREPOINTONLINE_META = new FSDatasetMeta<SharePointOnlineDatasetHandler, SharePointOnlineDatasetConfig>(){

        @Override
        public AbstractFSDatasetHandler.AbstractFSConfig createUploadedDatasetParams(String projectKey, String datasetName, DSSConnection targetConnection) throws CodedException {
            SharePointOnlineDatasetConfig config = new SharePointOnlineDatasetConfig();
            config.connection = targetConnection.name;
            SharePointOnlineConnection connection = (SharePointOnlineConnection)targetConnection;
            ConfValidators.checkNotBlank(connection.params.defaultManagedSite, ConnectionCodes.ERR_CONNECTION_SHAREPOINT_INVALID_CONFIG, "default site");
            ConfValidators.checkNotBlank(connection.params.defaultManagedDrive, ConnectionCodes.ERR_CONNECTION_SHAREPOINT_INVALID_CONFIG, "default drive");
            ConfValidators.checkNotBlank(connection.params.defaultManagedPath, ConnectionCodes.ERR_CONNECTION_SHAREPOINT_INVALID_CONFIG, "default path");
            config.path = PathUtils.concatLNT((String[])new String[]{connection.params.defaultManagedPath, "uploads", BuiltinFSDatasets.makePathFromNamingRule(connection.params.namingRule, datasetName)});
            config.site = connection.params.defaultManagedSite;
            config.drive = connection.params.defaultManagedDrive;
            return config;
        }

        @Override
        public String getType() {
            return BuiltinFSDatasets.SHAREPOINTONLINE_TYPE;
        }

        @Override
        public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
            return SharePointOnlineDatasetConfig.class;
        }

        @Override
        public DatasetHandler build(AuthCtx authCtx, Dataset dataset) {
            return new SharePointOnlineDatasetHandler(authCtx, dataset);
        }

        @Override
        public boolean isFSLike() {
            return true;
        }

        @Override
        public boolean isFS() {
            return true;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public boolean isParallelWritable() {
            return true;
        }

        @Override
        public void fillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings specificSettings, boolean useExistingParams) throws CodedException {
            ManagedDatasetsCreationService.FormatOptionId formatOptionId = specificSettings == null ? null : specificSettings.formatOptionId;
            SharePointOnlineDatasetConfig config = (SharePointOnlineDatasetConfig)this.baseFillManagedDatasetParams(dataset, targetConnection, formatOptionId, useExistingParams);
            SharePointOnlineConnection connection = (SharePointOnlineConnection)targetConnection;
            ConfValidators.checkNotBlank(connection.params.defaultManagedPath, ConnectionCodes.ERR_CONNECTION_SHAREPOINT_INVALID_CONFIG, "default path");
            ConfValidators.checkNotBlank(connection.params.defaultManagedSite, ConnectionCodes.ERR_CONNECTION_SHAREPOINT_INVALID_CONFIG, "default site");
            ConfValidators.checkNotBlank(connection.params.defaultManagedDrive, ConnectionCodes.ERR_CONNECTION_SHAREPOINT_INVALID_CONFIG, "default drive");
            config.path = PathUtils.concatLNT((String[])new String[]{connection.params.defaultManagedPath, "${projectKey}/", dataset.getName()});
            config.site = connection.params.defaultManagedSite;
            config.drive = connection.params.defaultManagedDrive;
        }

        @Override
        public void fillManagedFolderParams(ManagedFolder folder, DSSConnection targetConnection, boolean useExistingParams) throws CodedException {
            SharePointOnlineDatasetConfig config = (SharePointOnlineDatasetConfig)this.baseFillManagedFolderParams(folder, targetConnection, useExistingParams);
            SharePointOnlineConnection connection = (SharePointOnlineConnection)targetConnection;
            ConfValidators.checkNotBlank(connection.params.defaultManagedPath, ConnectionCodes.ERR_CONNECTION_SHAREPOINT_INVALID_CONFIG, "default path");
            ConfValidators.checkNotBlank(connection.params.defaultManagedSite, ConnectionCodes.ERR_CONNECTION_SHAREPOINT_INVALID_CONFIG, "default site");
            ConfValidators.checkNotBlank(connection.params.defaultManagedDrive, ConnectionCodes.ERR_CONNECTION_SHAREPOINT_INVALID_CONFIG, "default drive");
            config.path = PathUtils.concatLNT((String[])new String[]{connection.params.defaultManagedPath, "${projectKey}/${odbId}"});
            config.site = connection.params.defaultManagedSite;
            config.drive = connection.params.defaultManagedDrive;
        }
    };
    public static final String AZURE_TYPE = "Azure";
    public static final FSDatasetMeta<AzureBlobDatasetHandler, AzureBlobDatasetConfig> AZURE_META = new FSDatasetMeta<AzureBlobDatasetHandler, AzureBlobDatasetConfig>(){

        @Override
        public String getType() {
            return BuiltinFSDatasets.AZURE_TYPE;
        }

        @Override
        public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
            return AzureBlobDatasetConfig.class;
        }

        @Override
        public boolean isFSLike() {
            return true;
        }

        @Override
        public boolean isFS() {
            return true;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public boolean isParallelWritable() {
            return true;
        }

        @Override
        public AbstractFSDatasetHandler.AbstractFSConfig createUploadedDatasetParams(String projectKey, String datasetName, DSSConnection targetConnection) throws CodedException {
            AzureBlobDatasetConfig config = new AzureBlobDatasetConfig();
            config.connection = targetConnection.name;
            this.setContainerAndPath(config, datasetName, targetConnection, true);
            return config;
        }

        @Override
        public void fillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings specificSettings, boolean useExistingParams) throws CodedException {
            ManagedDatasetsCreationService.FormatOptionId formatOptionId = specificSettings == null ? null : specificSettings.formatOptionId;
            AzureBlobDatasetConfig config = (AzureBlobDatasetConfig)this.baseFillManagedDatasetParams(dataset, targetConnection, formatOptionId, useExistingParams);
            this.setContainerAndPath(config, dataset.getName(), targetConnection, false);
        }

        @Override
        public void fillManagedFolderParams(ManagedFolder folder, DSSConnection targetConnection, boolean useExistingParams) throws CodedException {
            AzureBlobDatasetConfig config = (AzureBlobDatasetConfig)this.baseFillManagedFolderParams(folder, targetConnection, useExistingParams);
            this.setContainerAndPath(config, "${odbId}", targetConnection, false);
        }

        private void setContainerAndPath(AzureBlobDatasetConfig config, String objectName, DSSConnection targetConnection, boolean isUpload) throws CodedException {
            AzureConnection connection = (AzureConnection)targetConnection;
            String container = connection.params.getDefaultManagedContainer();
            ConfValidators.checkNotBlank(container, ConnectionCodes.ERR_CONNECTION_AZURE_INVALID_CONFIG, "container");
            ConfValidators.checkNotBlank(connection.params.defaultManagedPath, ConnectionCodes.ERR_CONNECTION_AZURE_INVALID_CONFIG, "default path");
            config.container = container;
            String defaultManagedPath = connection.params.defaultManagedPath;
            config.path = isUpload ? PathUtils.concatLNT((String[])new String[]{defaultManagedPath, "uploads", BuiltinFSDatasets.makePathFromNamingRule(connection.params.namingRule, objectName)}) : PathUtils.concatLNT((String[])new String[]{defaultManagedPath, BuiltinFSDatasets.makePathFromNamingRule(connection.params.namingRule, objectName)});
            config.metastoreDatabaseName = connection.params.namingRule.metastoreDatabaseName;
            config.metastoreTableName = "";
            if (StringUtils.isNotBlank((String)connection.params.namingRule.metastoreTableNameDatasetNamePrefix)) {
                config.metastoreTableName = config.metastoreTableName + connection.params.namingRule.metastoreTableNameDatasetNamePrefix;
            }
            config.metastoreTableName = config.metastoreTableName + objectName;
            if (StringUtils.isNotBlank((String)connection.params.namingRule.metastoreTableNameDatasetNameSuffix)) {
                config.metastoreTableName = config.metastoreTableName + connection.params.namingRule.metastoreTableNameDatasetNameSuffix;
            }
        }

        @Override
        public DatasetHandler build(AuthCtx authCtx, Dataset dataset) {
            return new AzureBlobDatasetHandler(authCtx, dataset);
        }
    };
    public static final String FILES_IN_FOLDER_TYPE = "FilesInFolder";
    public static final DatasetHandler.DatasetMeta<FilesInFolderDatasetHandler, FilesInFolderConfig> FILES_IN_FOLDER_META = new DatasetHandler.DatasetMeta<FilesInFolderDatasetHandler, FilesInFolderConfig>(){

        @Override
        public String getType() {
            return BuiltinFSDatasets.FILES_IN_FOLDER_TYPE;
        }

        @Override
        public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
            return FilesInFolderConfig.class;
        }

        @Override
        public DatasetHandler build(AuthCtx authCtx, Dataset dataset) {
            return new FilesInFolderDatasetHandler(authCtx, dataset);
        }

        @Override
        public boolean isFSLike() {
            return true;
        }

        @Override
        public boolean isFS() {
            return true;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        public boolean isParallelWritable() {
            return false;
        }

        @Override
        public void fillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings unused, boolean useExistingParams) {
            throw new Error("unreachable");
        }

        @Override
        public void fillManagedFolderParams(ManagedFolder folder, DSSConnection targetConnection, boolean useExistingParams) {
            throw new Error("unreachable");
        }
    };
    public static final String DATABRICKS_VOLUME_TYPE = "DatabricksVolume";
    public static final FSDatasetMeta<DatabricksVolumeDatasetHandler, DatabricksVolumeDatasetConfig> DATABRICKS_VOLUME_META = new FSDatasetMeta<DatabricksVolumeDatasetHandler, DatabricksVolumeDatasetConfig>(){

        @Override
        public String getType() {
            return BuiltinFSDatasets.DATABRICKS_VOLUME_TYPE;
        }

        @Override
        public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
            return DatabricksVolumeDatasetConfig.class;
        }

        @Override
        public DatasetHandler build(AuthCtx authCtx, Dataset dataset) {
            return new DatabricksVolumeDatasetHandler(authCtx, dataset);
        }

        @Override
        public boolean isFSLike() {
            return true;
        }

        @Override
        public boolean isFS() {
            return true;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public boolean isParallelWritable() {
            return true;
        }

        @Override
        public AbstractFSDatasetHandler.AbstractFSConfig createUploadedDatasetParams(String projectKey, String datasetName, DSSConnection targetConnection) throws CodedException {
            DatabricksVolumeDatasetConfig config = new DatabricksVolumeDatasetConfig();
            config.connection = targetConnection.name;
            this.setBucketAndPath(config, datasetName, targetConnection, true);
            return config;
        }

        @Override
        public void fillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings specificSettings, boolean useExistingParams) throws CodedException {
            if (targetConnection instanceof DatabricksConnection) {
                targetConnection = ((DatabricksConnection)targetConnection).asDatabricksVolumeConnection();
            }
            ManagedDatasetsCreationService.FormatOptionId formatOptionId = specificSettings == null ? null : specificSettings.formatOptionId;
            DatabricksVolumeDatasetConfig config = (DatabricksVolumeDatasetConfig)this.baseFillManagedDatasetParams(dataset, targetConnection, formatOptionId, useExistingParams);
            this.setBucketAndPath(config, dataset.getName(), targetConnection, false);
        }

        @Override
        public void fillManagedFolderParams(ManagedFolder folder, DSSConnection targetConnection, boolean useExistingParams) throws CodedException {
            if (targetConnection instanceof DatabricksConnection) {
                targetConnection = ((DatabricksConnection)targetConnection).asDatabricksVolumeConnection();
            }
            DatabricksVolumeDatasetConfig config = (DatabricksVolumeDatasetConfig)this.baseFillManagedFolderParams(folder, targetConnection, useExistingParams);
            this.setBucketAndPath(config, "${odbId}", targetConnection, false);
        }

        private void setBucketAndPath(DatabricksVolumeDatasetConfig config, String objectName, DSSConnection targetConnection, boolean isUpload) throws CodedException {
            if (targetConnection instanceof DatabricksConnection) {
                targetConnection = ((DatabricksConnection)targetConnection).asDatabricksVolumeConnection();
            }
            DatabricksVolumeConnection connection = (DatabricksVolumeConnection)targetConnection;
            String defaultManagedVolume = connection.params.getDefaultManagedVolume();
            ConfValidators.checkNotBlank(defaultManagedVolume, ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "default volume");
            ConfValidators.checkNotBlank(connection.params.defaultManagedPath, ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "default path");
            config.volume = defaultManagedVolume;
            config.path = isUpload ? PathUtils.concatLNT((String[])new String[]{connection.params.defaultManagedPath, "uploads", BuiltinFSDatasets.makePathFromNamingRule(connection.params.namingRule, objectName)}) : PathUtils.concatLNT((String[])new String[]{connection.params.defaultManagedPath, BuiltinFSDatasets.makePathFromNamingRule(connection.params.namingRule, objectName)});
            config.metastoreDatabaseName = connection.params.namingRule.metastoreDatabaseName;
            config.metastoreTableName = "";
            if (StringUtils.isNotBlank((String)connection.params.namingRule.metastoreTableNameDatasetNamePrefix)) {
                config.metastoreTableName = config.metastoreTableName + connection.params.namingRule.metastoreTableNameDatasetNamePrefix;
            }
            config.metastoreTableName = config.metastoreTableName + objectName;
            if (StringUtils.isNotBlank((String)connection.params.namingRule.metastoreTableNameDatasetNameSuffix)) {
                config.metastoreTableName = config.metastoreTableName + connection.params.namingRule.metastoreTableNameDatasetNameSuffix;
            }
        }
    };

    private static String makePathFromNamingRule(FSProviderizableConnection.FilesBasedDatasetNamingRule namingRule, String objectName) {
        if (StringUtils.isBlank((String)namingRule.pathDatasetNamePrefix) && StringUtils.isBlank((String)namingRule.pathDatasetNameSuffix)) {
            return "${projectKey}/" + objectName;
        }
        Object ret = "";
        if (StringUtils.isNotBlank((String)namingRule.pathDatasetNamePrefix)) {
            ret = (String)ret + namingRule.pathDatasetNamePrefix;
        }
        ret = (String)ret + objectName;
        if (StringUtils.isNotBlank((String)namingRule.pathDatasetNameSuffix)) {
            ret = (String)ret + namingRule.pathDatasetNameSuffix;
        }
        return PathUtils.canonical((String)ret);
    }

    private static String getFormatOptionIdOrDefault(ManagedDatasetsCreationService.FormatOptionId formatOptionId, DSSConnection targetConnection) {
        if (formatOptionId == null) {
            ManagedDatasetsCreationService cs2 = (ManagedDatasetsCreationService)SpringUtils.getBean(ManagedDatasetsCreationService.class);
            ManagedDatasetsCreationService.FormatOptionId ret = cs2.getDefaultFormatOption(targetConnection);
            if (ret == null) {
                return null;
            }
            return ret.toString();
        }
        return formatOptionId.toString();
    }

    @Override
    public void load() {
        DatasetHandlerFactory.registerDatasetType(FS_META);
        DatasetHandlerFactory.registerDatasetType(HDFS_META);
        DatasetHandlerFactory.registerDatasetType(S3_META);
        DatasetHandlerFactory.registerDatasetType(FTP_META);
        DatasetHandlerFactory.registerDatasetType(SFTP_META);
        DatasetHandlerFactory.registerDatasetType(SCP_META);
        DatasetHandlerFactory.registerDatasetType(HTTP_META);
        DatasetHandlerFactory.registerDatasetType(UPLOADED_FILES_META);
        DatasetHandlerFactory.registerDatasetType(FILES_IN_FOLDER_META);
        DatasetHandlerFactory.registerDatasetType(AZURE_META);
        DatasetHandlerFactory.registerDatasetType(SHAREPOINTONLINE_META);
        DatasetHandlerFactory.registerDatasetType(GCS_META);
        DatasetHandlerFactory.registerDatasetType(DATABRICKS_VOLUME_META);
    }

    public static abstract class FSDatasetMeta<TDataset extends DatasetHandler, TDatasetParams extends DatasetHandler.DatasetParams>
    extends DatasetHandler.DatasetMeta<TDataset, TDatasetParams>
    implements IPluginifiedHolderMeta {
        public abstract AbstractFSDatasetHandler.AbstractFSConfig createUploadedDatasetParams(String var1, String var2, DSSConnection var3) throws CodedException;

        protected TDatasetParams baseFillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.FormatOptionId formatOptionId, boolean useExistingParams) {
            dataset.setManaged(true);
            dataset.setType(this.getType());
            AbstractFSDatasetHandler.AbstractFSConfig config = this.prepareFSLikeConfig(dataset.getType(), dataset.getName(), dataset.getParams(), targetConnection, useExistingParams);
            dataset.setParams(config);
            if (!useExistingParams || dataset.getFormatType() == null) {
                ManagedDatasetsHelper.setFormat(dataset, BuiltinFSDatasets.getFormatOptionIdOrDefault(formatOptionId, targetConnection));
            }
            return (TDatasetParams)config;
        }

        protected TDatasetParams baseFillManagedFolderParams(ManagedFolder folder, DSSConnection targetConnection, boolean useExistingParams) {
            folder.type = this.getType();
            folder.params = this.prepareFSLikeConfig(folder.getType(), folder.getName(), folder.getParams(), targetConnection, useExistingParams);
            return (TDatasetParams)folder.params;
        }

        private AbstractFSDatasetHandler.AbstractFSConfig prepareFSLikeConfig(String objectSubType, String objectName, DatasetHandler.DatasetParams existingConfig, DSSConnection targetConnection, boolean useExistingParams) {
            AbstractFSDatasetHandler.AbstractFSConfig config;
            DatasetHandler.DatasetMeta<?, ?> realMeta = DatasetHandlerFactory.getMeta(objectSubType);
            try {
                config = (AbstractFSDatasetHandler.AbstractFSConfig)realMeta.paramsClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e1) {
                throw new Error("Failed to instantiate config", e1);
            }
            if (useExistingParams && existingConfig instanceof AbstractFSDatasetHandler.AbstractFSConfig) {
                AbstractFSDatasetHandler.AbstractFSConfig currentParams = (AbstractFSDatasetHandler.AbstractFSConfig)existingConfig;
                if (existingConfig.getClass().equals(realMeta.paramsClass())) {
                    config = (AbstractFSDatasetHandler.AbstractFSConfig)JSON.deepCopy((Object)currentParams);
                } else if (AbstractFSDatasetHandler.AbstractFSConfig.class.isAssignableFrom(realMeta.paramsClass())) {
                    config.markerFile = currentParams.markerFile;
                    config.previewFile = currentParams.previewFile;
                    config.filesSelectionRules = currentParams.filesSelectionRules;
                }
            }
            config.connection = targetConnection.name;
            return config;
        }

        @Override
        public List<IPluginifiedHolderMeta.Pluginifiable> getPluginifiables(Object object, String payload) {
            List<IPluginifiedHolderMeta.Pluginifiable> components = super.getPluginifiables(object, payload);
            if (object instanceof SerializedDataset) {
                SerializedDataset dataset = (SerializedDataset)object;
                components.add(new IPluginifiedHolderMeta.Pluginifiable("format", dataset.formatType, dataset.getFormatParams()));
            }
            return components;
        }
    }

    public static class DatabricksVolumeDatasetConfig
    extends AbstractFSDatasetHandler.AbstractMetastoreAwareFSConfig {
        private static final long serialVersionUID = -1L;
        public String volume;
    }

    public static class FilesInFolderConfig
    extends FilesystemDatasetConfig
    implements FolderProvidedFilesConfig,
    DatasetHandler.SoftLinkGeneratingDatasetParams {
        private static final long serialVersionUID = -1L;
        public String folderSmartId;

        @Override
        public String getFolderSmartId() {
            return this.folderSmartId;
        }

        @Override
        public boolean linksChanged(SerializedDataset preExisting) {
            FilesInFolderConfig preExistingParams = (FilesInFolderConfig)preExisting.getParamsAs(this.getClass());
            return !StringUtils.equals((String)this.folderSmartId, (String)preExistingParams.folderSmartId);
        }
    }

    public static class AzureBlobDatasetConfig
    extends AbstractFSDatasetHandler.AbstractMetastoreAwareFSConfig {
        private static final long serialVersionUID = -1L;
        public String container;
        public long baseBlockID;
    }

    public static class SharePointOnlineDatasetConfig
    extends AbstractFSDatasetHandler.AbstractFSConfig {
        private static final long serialVersionUID = -1L;
        public String container;
        public String site;
        public String siteId;
        public String siteSearch;
        public String drive;
        public String driveId;
    }

    public static class UploadedFilesConfig
    extends AbstractFSDatasetHandler.AbstractFSConfig
    implements UploadableDatasetConfig {
        private static final long serialVersionUID = -1L;
        public String uploadBoxId;
        public List<String> files;
        public String uploadConnection;
        public String uploadFSProviderType;
        public JsonObject uploadedConfig;

        @Override
        public String getUploadBoxId() {
            return this.uploadBoxId;
        }
    }

    public static class HTTPDatasetConfig
    implements DatasetHandler.DatasetParams {
        private static final long serialVersionUID = -1L;
        public List<HTTPSource> sources = new ArrayList<HTTPSource>();
        public boolean consider404AsEmpty = true;
        public boolean fallbackHeadToGet = true;
        public boolean notReadyIfEmpty;
        public boolean useGlobalProxy = true;
        public boolean trustAnySSLCertificate = false;
        public String previewPartition;
        public List<String> partitions = new LinkedList<String>();

        @Override
        public String getConnection() {
            return null;
        }

        @Override
        public boolean isNotReadyIfEmpty() {
            return this.notReadyIfEmpty;
        }
    }

    public static class HTTPSource {
        public String url;
    }

    public static class SCPDatasetConfig
    extends AbstractFSDatasetHandler.AbstractFSConfig {
        private static final long serialVersionUID = -1L;
        public int timeout = 10000;
    }

    public static class SFTPDatasetConfig
    extends AbstractFSDatasetHandler.AbstractFSConfig {
        private static final long serialVersionUID = -1L;
        public int timeout = 10000;
    }

    public static class FTPDatasetConfig
    extends AbstractFSDatasetHandler.AbstractFSConfig {
        private static final long serialVersionUID = -1L;
        public int timeout = 30000;
        public boolean urlMode = false;
        public boolean urlModeUseGlobalProxy;
    }

    public static class GCSDatasetConfig
    extends AbstractFSDatasetHandler.AbstractMetastoreAwareFSConfig {
        private static final long serialVersionUID = -1L;
        public String bucket;
    }

    public static class S3DatasetConfig
    extends AbstractFSDatasetHandler.AbstractMetastoreAwareFSConfig {
        private static final long serialVersionUID = -1L;
        public String bucket;
    }
}

