/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithDatabricksCredentials;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.DatabricksVolumeConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.FSProviderCodes;
import com.dataiku.dip.datasets.fs.AbstractFSEnumerationResult;
import com.dataiku.dip.datasets.fs.BlobLikeFSProvider;
import com.dataiku.dip.datasets.fs.ChrootUtils;
import com.dataiku.dip.datasets.fs.FsToFsProviderTransferer;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSBrowsePath;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.fs.PathToURIConverter;
import com.dataiku.dip.input.stream.AutoEnrichedInputStream;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dss.shadelib.com.databricks.sdk.core.error.platform.NotFound;
import com.dataiku.dss.shadelib.com.databricks.sdk.service.files.DirectoryEntry;
import com.dataiku.dss.shadelib.com.databricks.sdk.service.files.FilesAPI;
import com.dataiku.dss.shadelib.com.databricks.sdk.service.files.GetMetadataResponse;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.client.utils.DateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DatabricksVolumeFSProvider
implements BlobLikeFSProvider,
PathToURIConverter {
    private final DatabricksVolumeConnection conn;
    private final String pathInVolume;
    private final String pathInDBFS;
    private final String volume;
    private final String volumeRoot;
    private final AuthCtx authCtx;
    private final int enumerationLimit = DKUApp.getParams().getIntParam("dku.fsproviders.enumerationLimit", Integer.valueOf(1000000));
    private FilesAPI client;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fs.databricksVolume");

    public DatabricksVolumeFSProvider(AuthCtx authCtx, DSSConnection conn, String pathInVolume, String volume) throws CodedIOException, DKUSecurityException {
        this.authCtx = authCtx;
        assert (conn instanceof DatabricksVolumeConnection);
        this.conn = (DatabricksVolumeConnection)conn;
        this.volume = volume;
        this.volumeRoot = String.format("/Volumes/%s/%s/%s", this.conn.params.catalog, this.conn.params.schema, volume);
        if (StringUtils.isBlank((String)volume)) {
            throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_INVALID_CONFIG, "Volume to read is not defined");
        }
        if ((pathInVolume = StringUtils.trimToEmpty((String)pathInVolume)).equals("..") || pathInVolume.contains("../") || pathInVolume.contains("/..")) {
            logger.error((Object)("Forbidden '..' segment in Databricks volume filesystem path, path='" + pathInVolume + "'"));
            throw new DKUSecurityException("Forbidden '..' segment in Databricks volume filesystem path").withCode((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_FSLIKE_REACH_OUT_OF_ROOT);
        }
        this.pathInVolume = PathUtils.makeLeadingNoTrailing((String)PathUtils.canonical((String)ChrootUtils.getChrootedPath(this.conn.params.chroot, pathInVolume, false)));
        this.pathInDBFS = PathUtils.makeLeadingNoTrailing((String)(this.volumeRoot + this.pathInVolume));
        logger.info((Object)("Created Databricks volume FS provider bucket=" + volume + " effectivePath=" + this.pathInVolume + " from '" + this.conn.params.chroot + "' and '" + pathInVolume + "'"));
    }

    private void checkConnectionWritability() {
        if (!this.conn.allowWrite) {
            throw new IllegalArgumentException("Cannot write on connection " + this.conn.name);
        }
    }

    public void close() throws IOException {
    }

    private String makePath(String path, boolean isDir) {
        String cleanPath = PathUtils.concatLNT((String[])new String[]{this.pathInDBFS, path});
        if (!cleanPath.startsWith(this.pathInDBFS)) {
            throw ErrorContext.iae((String)("Cannot reach outside " + this.pathInDBFS));
        }
        return PathUtils.slashes((String)cleanPath, (Boolean)true, (Boolean)(isDir ? Boolean.valueOf(true) : null), (boolean)true, (String)"");
    }

    private synchronized FilesAPI initClientIfNeeded() throws IOException, DKUSecurityException {
        if (this.client == null) {
            this.client = new FilesAPI(this.conn.getApiClient(this.authCtx));
        }
        return this.client;
    }

    public FSBrowsePath browse(String path, FSProvider.FSBrowseStrategy strategy) throws IOException, DKUSecurityException, CodedException {
        FilesAPI client = this.initClientIfNeeded();
        FSBrowsePath ret = FSBrowsePath.makeRoot((String)path, (boolean)false);
        FSPathOrDirectory p = this.stat(path);
        if (p == null) {
            ret.exists = false;
            return ret;
        }
        ret.exists = true;
        if (!(strategy != FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY && strategy != FSProvider.FSBrowseStrategy.FILE || p.isDirectory)) {
            ret.directory = false;
            ret.size = p.getSize();
            ret.directory = false;
            ret.lastModified = p.getLastModified();
            return ret;
        }
        ret.directory = true;
        String dirPath = this.makePath(path, true);
        for (DirectoryEntry f : client.listDirectoryContents(dirPath)) {
            String relPath = PathUtils.makeNotLeadingNoTrailing((String)f.getPath().substring(dirPath.length()));
            if (ret.children.size() + 1 > this.enumerationLimit) {
                throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_TOO_MANY_FILES, String.format("There are too many files in this Databricks Volume location (> %d). Enumeration aborted.", this.enumerationLimit));
            }
            if (f.getIsDirectory() != null && f.getIsDirectory().booleanValue()) {
                ret.children.add(FSBrowsePath.makeChild((FSBrowsePath)ret, (String)relPath, (boolean)true, (long)0L, (long)-1L));
                continue;
            }
            ret.children.add(FSBrowsePath.makeChild((FSBrowsePath)ret, (String)relPath, (boolean)false, (long)f.getFileSize(), (long)f.getLastModified()));
        }
        return ret;
    }

    public DatabricksVolumeFSEnumerationResult enumerateRecursive(String prefix, FSEnumerationSettings enumerationSettings) throws IOException, CodedException, DKUSecurityException {
        FSPathOrDirectory p = this.stat(prefix);
        if (p == null) {
            return DatabricksVolumeFSEnumerationResult.fromNonExistingPrefix();
        }
        if (!p.isDirectory) {
            return DatabricksVolumeFSEnumerationResult.fromPaths(Lists.newArrayList((Object[])new FSPath[]{p}));
        }
        try {
            prefix = PathUtils.makeLeadingNoTrailing((String)prefix);
            ArrayList<FSPath> list = new ArrayList<FSPath>();
            this.enumerateRec(prefix, prefix, list);
            return DatabricksVolumeFSEnumerationResult.fromPaths(list);
        }
        catch (Exception e) {
            return DatabricksVolumeFSEnumerationResult.fromError(e);
        }
    }

    private void enumerateRec(String dirPath, String prefix, List<FSPath> paths) throws IOException, DKUSecurityException {
        FilesAPI client = this.initClientIfNeeded();
        String fullPath = this.makePath(dirPath, true);
        String fullBase = this.makePath("/", true);
        for (DirectoryEntry f : client.listDirectoryContents(fullPath)) {
            String relPath = PathUtils.makeLeadingNoTrailing((String)f.getPath().substring(fullBase.length()));
            logger.info((Object)("Got " + f.getPath() + " relPath=" + relPath));
            FSPathOrDirectory child = f.getIsDirectory() != null && f.getIsDirectory() != false ? new FSPathOrDirectory(relPath, 0L, -1L, true) : new FSPathOrDirectory(relPath, f.getFileSize().longValue(), f.getLastModified().longValue(), false);
            if (child.isDirectory) {
                String path = PathUtils.makeLeadingNoTrailing((String)relPath);
                logger.info((Object)("  recurse into " + path));
                this.enumerateRec(path, prefix, paths);
                continue;
            }
            if (paths.size() + 1 > this.enumerationLimit) {
                throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_TOO_MANY_FILES, String.format("There are too many files in this Databricks Volume location (> %d). Enumeration aborted.", this.enumerationLimit));
            }
            paths.add((FSPath)child);
        }
    }

    public FSPathOrDirectory stat(String path) throws IOException, CodedException, DKUSecurityException {
        FilesAPI client = this.initClientIfNeeded();
        String fullPath = this.makePath(path, false);
        try {
            GetMetadataResponse metadata = client.getMetadata(fullPath);
            return new FSPathOrDirectory(PathUtils.makeLeadingNoTrailing((String)path), metadata.getContentLength().longValue(), DateUtils.parseDate((String)metadata.getLastModified()).getTime(), false);
        }
        catch (NotFound e) {
            try {
                client.getDirectoryMetadata(fullPath);
                return new FSPathOrDirectory(PathUtils.makeLeadingNoTrailing((String)path), 0L, -1L, true);
            }
            catch (Exception ee) {
                return null;
            }
        }
    }

    @Override
    public boolean fileExists(String path) throws IOException, CodedException, DKUSecurityException {
        FilesAPI client = this.initClientIfNeeded();
        String fullPath = this.makePath(path, false);
        try {
            GetMetadataResponse metadata = client.getMetadata(fullPath);
            return true;
        }
        catch (NotFound e) {
            try {
                client.getDirectoryMetadata(fullPath);
                return true;
            }
            catch (Exception ee) {
                return false;
            }
        }
    }

    public boolean directoryExists(String path) throws IOException, CodedException, DKUSecurityException {
        FilesAPI client = this.initClientIfNeeded();
        String fullPath = this.makePath(path, false);
        try {
            client.getDirectoryMetadata(fullPath);
            return true;
        }
        catch (Exception ee) {
            return false;
        }
    }

    public EnrichedInputStream read(String path) throws IOException, CodedException, DKUSecurityException {
        FilesAPI client = this.initClientIfNeeded();
        logger.info((Object)("Getting Databricks volume stream on " + path));
        FSPathOrDirectory object = this.stat(path);
        if (object == null) {
            throw new IOException("No file at " + path);
        }
        return new DatabricksVolumeEnrichedInputStream(client, path, (FSPath)object);
    }

    public OutputStream write(String path) throws IOException, CodedException, DKUSecurityException {
        this.checkConnectionWritability();
        FilesAPI client = new FilesAPI(this.conn.getApiClient(this.authCtx));
        String writePath = this.makePath(path, false);
        String fileName = PathUtils.getLastPathSegment((String)writePath);
        logger.info((Object)("Pushing Databricks volume stream on " + path));
        DatabricksVolumeWriteThread writerThread = new DatabricksVolumeWriteThread(client, writePath, fileName);
        writerThread.start();
        return writerThread.getOutputStream();
    }

    public void setLastModified(String path, long lastModified) throws IOException, CodedException, DKUSecurityException {
    }

    public void deleteRecursive(String path) throws IOException, CodedException, DKUSecurityException {
        this.checkConnectionWritability();
        logger.infoV("Deleting recursively %s", new Object[]{path});
        this.deleteDirectory(path);
    }

    public boolean deleteFile(String path) throws IOException, CodedException, DKUSecurityException {
        this.checkConnectionWritability();
        PathUtils.ensurePathStaysWithinRoot((String)path);
        String fullPath = this.makePath(path, false);
        FilesAPI client = new FilesAPI(this.conn.getApiClient(this.authCtx));
        logger.infoV("Deleting file %s", new Object[]{fullPath});
        try {
            client.delete(fullPath);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("Unable to delete " + fullPath), (Throwable)e);
            return false;
        }
    }

    public boolean deleteDirectory(String path) throws IOException, CodedException, DKUSecurityException {
        this.checkConnectionWritability();
        PathUtils.ensurePathStaysWithinRoot((String)path);
        if (!this.directoryExists(path)) {
            return false;
        }
        String fullPath = this.makePath(path, true);
        return this.deleteRec(fullPath);
    }

    private boolean deleteRec(String dirPath) throws IOException, DKUSecurityException {
        FilesAPI client = this.initClientIfNeeded();
        for (DirectoryEntry f : client.listDirectoryContents(dirPath)) {
            String childPath = dirPath + "/" + f.getName();
            if (f.getIsDirectory() != null && f.getIsDirectory().booleanValue()) {
                this.deleteRec(childPath);
                continue;
            }
            try {
                client.delete(childPath);
            }
            catch (Exception e) {
                logger.error((Object)("Unable to delete " + childPath), (Throwable)e);
            }
        }
        try {
            client.deleteDirectory(dirPath);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("Unable to delete " + dirPath), (Throwable)e);
            return false;
        }
    }

    public void moveDirectory(String from, String to) throws IOException, CodedException, DKUSecurityException {
        this.checkConnectionWritability();
        if (StringUtils.equals((String)from, (String)to)) {
            return;
        }
        PathUtils.ensurePathStaysWithinRoot((String)from);
        PathUtils.ensurePathStaysWithinRoot((String)to);
        FsToFsProviderTransferer transferer = new FsToFsProviderTransferer(this, this);
        transferer.transfer(from, to);
    }

    public void moveFile(String from, String to) throws IOException, CodedException, DKUSecurityException {
        this.checkConnectionWritability();
        if (StringUtils.equals((String)from, (String)to)) {
            return;
        }
        EnrichedInputStream eis = this.read(from);
        try (OutputStream os = this.write(to);){
            try (InputStream is = eis.rawStream();){
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted while transferring", e);
            }
        }
        this.deleteFile(from);
    }

    public Map<String, String> getAccessInfo(boolean withSensitiveInfo) throws IOException, CodedException, DKUSecurityException {
        HashMap ret = Maps.newHashMap();
        ret.put("volume", this.volume);
        ret.put("root", this.pathInDBFS);
        if (withSensitiveInfo && this.conn.detailsReadableBy(this.authCtx)) {
            ConnectionWithDatabricksCredentials.SerializableDatabricksCredentials cred = this.conn.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(this.authCtx, null), ConnectionWithDatabricksCredentials.SerializableDatabricksCredentials.class);
            ret.put("personalToken", cred.personalToken);
            ret.put("oauth2AccessToken", cred.oauth2AccessToken);
            ret.put("authType", cred.authType.name());
            ProxyUtils.applyProxySettings((ProxySettings)this.conn.getProxySettings(), (Map)ret);
        }
        return ret;
    }

    public String convertPathToURI(String path) {
        return "dbfs:/" + PathUtils.slashes((String)(this.pathInDBFS + "/" + path), (Boolean)true, (Boolean)false, (boolean)true, (String)"/");
    }

    @Override
    public String getRootWithinBucket() throws IOException, DKUSecurityException {
        return this.pathInVolume;
    }

    @Override
    public void waitUntilReadable(String path) throws IOException, CodedException {
    }

    static class DatabricksVolumeFSEnumerationResult
    extends AbstractFSEnumerationResult {
        public DatabricksVolumeFSEnumerationResult() {
        }

        public DatabricksVolumeFSEnumerationResult(List<FSPath> paths) {
            super(paths);
        }

        public DatabricksVolumeFSEnumerationResult(Throwable error) {
            super(error);
        }

        private static DatabricksVolumeFSEnumerationResult fromError(Throwable error) {
            return new DatabricksVolumeFSEnumerationResult(error);
        }

        private static DatabricksVolumeFSEnumerationResult fromPaths(List<FSPath> paths) {
            return new DatabricksVolumeFSEnumerationResult(paths);
        }

        private static DatabricksVolumeFSEnumerationResult fromNonExistingPrefix() {
            return new DatabricksVolumeFSEnumerationResult();
        }
    }

    class DatabricksVolumeEnrichedInputStream
    extends AutoEnrichedInputStream {
        private final String fullPath;
        private final FilesAPI client;

        public DatabricksVolumeEnrichedInputStream(FilesAPI client, String pathWithinProvider, FSPath path) throws IOException {
            super(path.getSize(), pathWithinProvider, FilenameUtils.getName((String)path.path()), path.path(), () -> ((FSPath)path).getLastModified());
            this.client = client;
            this.fullPath = DatabricksVolumeFSProvider.this.makePath(path.path(), false);
        }

        protected InputStream getBasicInputStream() throws IOException, CodedException, DKUSecurityException {
            logger.info((Object)"Getting full stream");
            return this.getBasicHeadInputStream(this.size());
        }

        protected InputStream getBasicHeadInputStream(long size) throws IOException, CodedException, DKUSecurityException {
            logger.info((Object)("Getting range on " + size));
            return this.client.download(this.fullPath).getContents();
        }
    }

    public class DatabricksVolumeWriteThread
    extends Thread {
        private final FilesAPI writeClient;
        private final String path;
        private final String fileName;
        private final PipedInputStream pin;
        private final PipedOutputStream pos;
        private Throwable thrown;

        public DatabricksVolumeWriteThread(FilesAPI writeClient, String path, String fileName) throws IOException, DKUSecurityException {
            this.writeClient = writeClient;
            this.path = path;
            this.fileName = fileName;
            this.pin = new PipedInputStream();
            this.pos = new PipedOutputStream();
            this.pos.connect(this.pin);
        }

        public OutputStream getOutputStream() {
            return new FilterOutputStream(this.pos){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        try {
                            DatabricksVolumeWriteThread.this.join();
                        }
                        catch (Exception e) {
                            throw new IOException("Error while waiting for writer thread", e);
                        }
                    }
                    if (DatabricksVolumeWriteThread.this.thrown != null) {
                        throw new IOException("Error in writer thread", DatabricksVolumeWriteThread.this.thrown);
                    }
                }
            };
        }

        @Override
        public void run() {
            try {
                this.writeClient.upload(this.path, (InputStream)this.pin);
            }
            catch (Throwable e) {
                logger.error((Object)"Failed to write data", e);
                this.thrown = e;
            }
        }
    }
}

