/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.GCSConnection;
import com.dataiku.dip.connections.GoogleUserAgentBuilder;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.FSTestProvider;
import com.dataiku.dip.datasets.fs.GCSclient;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class GoogleCloudStorageFSTestProvider
implements FSTestProvider {
    private static final String TEST_USER_AGENT = GoogleUserAgentBuilder.buildForTest();
    private final GCSConnection connection;
    private final BuiltinFSDatasets.GCSDatasetConfig config;
    private final AuthCtx authCtx;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fstestproviders.google");

    public GoogleCloudStorageFSTestProvider(AuthCtx authCtx, DSSConnection connection, AbstractFSDatasetHandler.AbstractFSConfig config) {
        this.config = (BuiltinFSDatasets.GCSDatasetConfig)config;
        this.connection = (GCSConnection)connection;
        this.authCtx = authCtx;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Map<String, String> test(boolean listBuckets) throws IOException, CodedException {
        String bucketName;
        GCSclient client;
        HashMap connectionMetadata = Maps.newHashMap();
        try {
            client = this.connection.getClient(this.authCtx, TEST_USER_AGENT);
        }
        catch (Exception e) {
            logger.warn((Object)"Error connecting to GCS", (Throwable)e);
            connectionMetadata.put("couldListBuckets", "false");
            connectionMetadata.put("bucketsListError", e.getMessage());
            return connectionMetadata;
        }
        if (StringUtils.isBlank((String)this.connection.params.chbucket) && listBuckets) {
            logger.info((Object)"Listing GCS buckets");
            try {
                List<GCSclient.GCSBucket> buckets = client.listBuckets();
                if (!buckets.isEmpty()) {
                    logger.info((Object)"Could list GCS buckets ");
                    ArrayList<String> bucketlist = new ArrayList<String>();
                    for (GCSclient.GCSBucket bucket : buckets) {
                        bucketlist.add(bucket.getName());
                    }
                    connectionMetadata.put("couldListBuckets", "true");
                    connectionMetadata.put("buckets", StringUtils.join(bucketlist, (String)","));
                } else {
                    connectionMetadata.put("couldListBuckets", "false");
                    connectionMetadata.put("bucketsListError", "No buckets accessible");
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Error while listing the GCS buckets", (Throwable)e);
                connectionMetadata.put("couldListBuckets", "false");
                connectionMetadata.put("bucketsListError", e.getMessage());
            }
        }
        connectionMetadata.put("constrainedBucket", this.connection.params.chbucket);
        String chbucket = this.connection.params.chbucket;
        String string = bucketName = StringUtils.isNotBlank((String)chbucket) ? chbucket : this.config.bucket;
        if (StringUtils.isNotBlank((String)bucketName)) {
            boolean bucketExists = false;
            try {
                client.getBucket(bucketName);
                logger.info((Object)("found managed bucket " + bucketName));
                bucketExists = true;
            }
            catch (Exception e) {
                logger.error((Object)"Bucket not found", (Throwable)e);
            }
            connectionMetadata.put("bucketExists", Boolean.toString(bucketExists));
        }
        return connectionMetadata;
    }
}

