/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.streamwrite;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.CanShareSQLConnection;
import com.dataiku.dip.datasets.streamwrite.StreamWriter;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.Splitter;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SQLBasedStreamWriter
extends StreamWriter {
    protected final AbstractSQLTableDatasetHandler outputSQLDH;
    protected final String streamStateReadQuery;
    protected final String[] streamStateWriteQueries;
    protected final List<String> streamStateReadQueryParameters;
    protected final List<List<String>> streamStateWriteQueryParameters;
    protected final SQLDialect dialect;
    @Autowired
    protected VariablesService variablesService;
    protected CanShareSQLConnection.SQLConnectionShare connectionShare;
    private static Logger logger = Logger.getLogger((String)"dip.stream.writer.sql");

    public static boolean hasStreamStateWriteQuery(AbstractSQLTableDatasetHandler dh) throws DKUSecurityException {
        ArrayList properties = Lists.newArrayList();
        properties.addAll(dh.getDSSConnection().getDkuProperties());
        properties.addAll(dh.getDataset().getModel().dkuProperties);
        return AbstractSQLConnection.CustomDatabaseProperty.hasNotBlankDkuProperty(properties, "streamstate.read.query") && AbstractSQLConnection.CustomDatabaseProperty.hasNotBlankDkuProperty(properties, "streamstate.write.query");
    }

    public SQLBasedStreamWriter(AuthCtx authCtx, AbstractSQLTableDatasetHandler outputSQLDH, String sourceId, int splitId) throws DKUSecurityException {
        super(authCtx, outputSQLDH, sourceId, splitId);
        this.outputSQLDH = outputSQLDH;
        ArrayList properties = Lists.newArrayList();
        properties.addAll(outputSQLDH.getDSSConnection().getDkuProperties());
        properties.addAll(outputSQLDH.getDataset().getModel().dkuProperties);
        SpringUtils.getInstance().autowire((Object)this);
        VariablesContext vc = this.variablesService.getContext(outputSQLDH.getDataset().getProjectKey());
        vc.add("datasetName", outputSQLDH.getDataset().getName());
        vc.add("sourceId", sourceId);
        vc.add("splitId", Integer.toString(splitId));
        this.streamStateReadQuery = vc.expandAllowUnresolved(AbstractSQLConnection.CustomDatabaseProperty.getDkuPropertyOrNull(properties, "streamstate.read.query"));
        String streamStateWriteQuery = vc.expandAllowUnresolved(AbstractSQLConnection.CustomDatabaseProperty.getDkuPropertyOrNull(properties, "streamstate.write.query"));
        this.dialect = outputSQLDH.getConnectionData().getDialect();
        Splitter splitter = new Splitter(this.dialect.getSemicolonExclusionPortionFinders());
        this.streamStateWriteQueries = splitter.split(streamStateWriteQuery);
        String streamStatreReadQueryParametersRaw = AbstractSQLConnection.CustomDatabaseProperty.getDkuPropertyOrNull(properties, "streamstate.read.query.params");
        this.streamStateReadQueryParameters = StringUtils.isBlank((String)streamStatreReadQueryParametersRaw) ? (this.streamStateReadQuery.contains("?") ? Lists.newArrayList((Object[])new String[]{"sourceId"}) : new ArrayList()) : (List)JSON.parse((String)streamStatreReadQueryParametersRaw, (TypeToken)new TypeToken<List<String>>(){});
        String streamStatreWriteQueryParametersRaw = AbstractSQLConnection.CustomDatabaseProperty.getDkuPropertyOrNull(properties, "streamstate.write.query.params");
        if (StringUtils.isBlank((String)streamStatreWriteQueryParametersRaw)) {
            this.streamStateWriteQueryParameters = Lists.newArrayList();
            for (String q : this.streamStateWriteQueries) {
                this.streamStateWriteQueryParameters.add(q.contains("?") ? Lists.newArrayList((Object[])new String[]{"state"}) : new ArrayList());
            }
        } else {
            this.streamStateWriteQueryParameters = (List)JSON.parse((String)streamStatreWriteQueryParametersRaw, (TypeToken)new TypeToken<List<List<String>>>(){});
        }
        this.connectionShare = new CanShareSQLConnection.SQLConnectionShare(this.outputSQLDH.getConnectionData());
    }

    @Override
    public void checkpoint(String newState) throws Exception {
        SQLConnectionProvider.SQLConnectionWrapper connForState = this.connectionShare.take(this.authCtx, this.outputSQLDH.getDataset().getProjectKey());
        try {
            this.closeOpenPartitions();
            this.writeStateToConnection(newState, connForState);
            this.connectionShare.give(false);
        }
        finally {
            this.connectionShare.close();
        }
        this.connectionShare = new CanShareSQLConnection.SQLConnectionShare(this.outputSQLDH.getConnectionData());
    }

    private void writeStateToConnection(String newState, SQLConnectionProvider.SQLConnectionWrapper conn) throws SQLException {
        logger.info((Object)("Store stream state with " + JSON.json((Object)this.streamStateWriteQueries)));
        int queryIndex = 0;
        for (String q : this.streamStateWriteQueries) {
            try (PreparedStatement stmt = conn.prepareStatement(q);){
                List<String> queryParameters = this.streamStateWriteQueryParameters.get(queryIndex);
                for (int i = 0; i < queryParameters.size(); ++i) {
                    String param = queryParameters.get(i);
                    if ("sourceId".equals(param)) {
                        this.dialect.fill(stmt, Type.STRING, i + 1, this.sourceId);
                        continue;
                    }
                    if ("splitId".equals(param)) {
                        this.dialect.fill(stmt, Type.BIGINT, i + 1, Integer.toString(this.splitId));
                        continue;
                    }
                    if ("state".equals(param)) {
                        this.dialect.fill(stmt, Type.STRING, i + 1, newState);
                        continue;
                    }
                    throw new SQLException("Can't handle param '" + param + "' in write state query");
                }
                stmt.execute();
            }
            ++queryIndex;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getRecordedState() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected class SQLBasedOpenOutputPartition
    extends StreamWriter.OpenOutputPartition {
        protected SQLBasedOpenOutputPartition() {
            super(SQLBasedStreamWriter.this);
        }

        @Override
        public void setupNewOpenOutputPartition(String partitionId) throws Exception, IOException, DKUSecurityException, InterruptedException, CodedException {
            this.partition = PartitionFactory.fromIdentifier(SQLBasedStreamWriter.this.outputDH.getDataset().getPartitioningSchema(), partitionId);
            this.output = SQLBasedStreamWriter.this.outputDH.buildOutput(this.partition, SQLBasedStreamWriter.this.splitId, 1, new WarningsContext());
            if (this.output instanceof CanShareSQLConnection) {
                ((CanShareSQLConnection)this.output).shareSQLConnection(SQLBasedStreamWriter.this.connectionShare);
            }
            this.writer = this.output.getWriter(Output.WriteMode.APPEND);
            this.writer.init(SQLBasedStreamWriter.this.cf);
        }
    }
}

