/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.project;

import com.dataiku.dip.dataflow.export.FlowExportService;
import com.dataiku.dip.dataflow.export.model.FlowExport;
import com.dataiku.dip.dataflow.export.model.FlowExportFormat;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;
import com.dataiku.dip.graphicsexport.model.ExportFormat;
import com.dataiku.dip.server.SpringUtils;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;

public class FlowExportPlaceholder
implements FlowPlaceholder.RootExportPlaceholder<FlowExport> {
    private final ExportFormat.Orientation orientation;
    private final boolean fullFlowOnOnePng;
    @Autowired
    private FlowExportService flowExportService;

    public FlowExportPlaceholder(ExportFormat.Orientation orientation, boolean fullFlowOnOnePng) {
        this.orientation = orientation;
        this.fullFlowOnOnePng = fullFlowOnOnePng;
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public PlaceholderOutput.Export<FlowExport> resolve(FlowDocumentContext flowDocumentContext, Void resolvedVariable) throws PlaceholderExpectedException {
        return new FlowPictureOutput(flowDocumentContext.projectKey);
    }

    private class FlowPictureOutput
    extends PlaceholderOutput.Export<FlowExport> {
        private final String projectKey;

        public FlowPictureOutput(String projectKey) {
            this.projectKey = projectKey;
        }

        public FlowExportService getExportService() {
            return FlowExportPlaceholder.this.flowExportService;
        }

        @Override
        protected FlowExport prepareExport() {
            int BASE_PAGE_PIXEL_WIDTH = 1920;
            double LANDSCAPE_RATIO = 1.6400000000000001;
            double PORTRAIT_RATIO = 0.8418367346938775;
            FlowExportFormat format = new FlowExportFormat();
            format.tileScale = FlowExportPlaceholder.this.fullFlowOnOnePng ? 1.0 : 0.0;
            format.paperSize = ExportFormat.PaperSize.CUSTOM;
            format.width = (int)Math.round(FlowExportPlaceholder.this.orientation == ExportFormat.Orientation.LANDSCAPE ? 3148.8 : 1920.0);
            format.height = (int)Math.round(FlowExportPlaceholder.this.orientation == ExportFormat.Orientation.LANDSCAPE ? 1920.0 : 2280.727272727273);
            format.fileType = ExportFormat.FileType.PNG;
            format.drawZones = true;
            format.collapsedZones = new HashSet<String>();
            return new FlowExport(this.projectKey, format);
        }
    }
}

