/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute.caching;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.GuavaCacheMetrics;
import com.dataiku.dip.utils.ImmutableValueObject;
import com.dataiku.dip.utils.Params;
import com.google.common.cache.AbstractCache;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.Weigher;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ComputeResultCachingService {
    public static final String CACHE_NAME = "eda.results";
    public static final String MAX_WEIGHT_BYTES_CONFIG_KEY = "dku.caches.eda.results.maxWeightBytes";
    public static final String EXPIRATION_AFTER_ACCESS_MINUTES_CONFIG_KEY = "dku.caches.eda.results.expireAfterAccessMn";
    private static final int RESULT_CACHE_DEFAULT_EXPIRATION_TIME_IN_MINUTES = 60;
    private static final int RESULT_CACHE_DEFAULT_MAX_WEIGHT_IN_BYTES = 200000000;
    public final Cache<Key, ComputationResult> resultCache;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.eda.compute.cache");

    public ComputeResultCachingService() {
        Params p = DKUApp.getParams();
        long maxWeightBytes = p.getLongParam(MAX_WEIGHT_BYTES_CONFIG_KEY, 200000000L);
        long expireAfterAccessMn = p.getLongParam(EXPIRATION_AFTER_ACCESS_MINUTES_CONFIG_KEY, 60L);
        logger.infoV("Init computation results cache with maxWeightBytes %d and expireAfterAccessMn %d", new Object[]{maxWeightBytes, expireAfterAccessMn});
        this.resultCache = CacheBuilder.newBuilder().recordStats().weigher((Weigher)new CacheWeigher()).maximumWeight(maxWeightBytes).expireAfterAccess(expireAfterAccessMn, TimeUnit.MINUTES).build();
        DSSMetrics.registry().registerAll(GuavaCacheMetrics.cacheMetricsSet((String)CACHE_NAME, this.resultCache));
    }

    public synchronized void removeForSampleId(String sampleId) {
        ArrayList<Key> toClear = new ArrayList<Key>();
        for (Map.Entry entry : this.resultCache.asMap().entrySet()) {
            Key key = (Key)((Object)entry.getKey());
            if (!StringUtils.equals((CharSequence)key.sampleId, (CharSequence)sampleId)) continue;
            toClear.add(key);
        }
        this.resultCache.invalidateAll(toClear);
    }

    public SampleIdWrappedCache get(String sampleId) {
        return new SampleIdWrappedCache(sampleId);
    }

    public void invalidateAll() {
        this.resultCache.invalidateAll();
    }

    public void cleanUp() {
        this.resultCache.cleanUp();
    }

    private static class CacheWeigher
    implements Weigher<Key, ComputationResult> {
        private CacheWeigher() {
        }

        public int weigh(Key key, ComputationResult result) {
            return result.getEstimatedMemoryUsageBytes();
        }
    }

    public static final class Key
    extends ImmutableValueObject {
        final String sampleId;
        final Computation computation;

        public Key(String sampleId, Computation computation) {
            this.sampleId = sampleId;
            this.computation = computation;
        }
    }

    public class SampleIdWrappedCache
    extends AbstractCache<Computation, ComputationResult> {
        final String sampleId;

        public SampleIdWrappedCache(String sampleId) {
            this.sampleId = sampleId;
        }

        @Nullable
        public ComputationResult getIfPresent(Object o) {
            return (ComputationResult)((Object)ComputeResultCachingService.this.resultCache.getIfPresent((Object)new Key(this.sampleId, (Computation)((Object)o))));
        }

        public void put(Computation computation, ComputationResult computationResult) {
            ComputeResultCachingService.this.resultCache.put((Object)new Key(this.sampleId, computation), (Object)computationResult);
        }
    }
}

