/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.suggester;

import com.dataiku.dip.eda.compute.computations.bivariate.Chi2IndTest;
import com.dataiku.dip.eda.compute.computations.bivariate.Spearman;
import com.dataiku.dip.eda.compute.computations.univariate.FitDistribution;
import com.dataiku.dip.eda.compute.computations.univariate.GuessTimeStep;
import com.dataiku.dip.eda.compute.computations.univariate.MatchTimeStep;
import com.dataiku.dip.eda.compute.computations.univariate.OneWayAnova;
import com.dataiku.dip.eda.compute.computations.univariate.Shapiro;
import com.dataiku.dip.eda.compute.distributions.Distribution;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class SniffedVariable {
    public final String name;
    public long totalCount;
    public Long cardinality;
    @Nullable
    public Long nbMissing;
    public Long nbEmpty;
    @Nullable
    public Double min;
    @Nullable
    public Double max;
    @Nullable
    public Double mean;
    @Nullable
    public Double stdDev;
    @Nullable
    public Double entropy;
    public Map<String, Long> top5values = new LinkedHashMap<String, Long>();
    public Map<String, Chi2IndTest.Chi2IndTestResult> chi2tests = new LinkedHashMap<String, Chi2IndTest.Chi2IndTestResult>();
    public Map<String, Spearman.SpearmanResult> spearmanTests = new LinkedHashMap<String, Spearman.SpearmanResult>();
    public Map<String, OneWayAnova.OneWayAnovaResult> oneWayAnovaTests = new LinkedHashMap<String, OneWayAnova.OneWayAnovaResult>();
    public Map<Distribution, FitDistribution.FitDistributionResult> fitDistributionResults = new LinkedHashMap<Distribution, FitDistribution.FitDistributionResult>();
    public Shapiro.ShapiroResult shapiroResult;
    public GuessTimeStep.GuessTimeStepResult guessTimeStepResult;
    public MatchTimeStep.MatchTimeStepResult matchTimeStepResult;
    private final Set<SniffedVariable> seriesIdentifiers = new HashSet<SniffedVariable>();
    private boolean holdsNumericalValues = false;
    private boolean holdsTemporalValues = false;
    private final boolean isSelected;
    public double individualScore;
    public double correlationScore;
    public double timeSeriesScore;
    public List<String> scoreExplanations = new ArrayList<String>();

    public SniffedVariable(String name, boolean isSelected, long totalCount) {
        this.name = name;
        this.isSelected = isSelected;
        this.totalCount = totalCount;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void markAsNumerical() {
        this.holdsNumericalValues = true;
    }

    public boolean holdsNumericalValues() {
        return this.holdsNumericalValues;
    }

    public void markAsTemporal() {
        this.holdsTemporalValues = true;
    }

    public void unMarkAsTemporal() {
        this.holdsTemporalValues = false;
    }

    public boolean holdsTemporalValues() {
        return this.holdsTemporalValues;
    }

    public boolean isLikelyNumerical() {
        return this.holdsNumericalValues && !this.hasLowCardinality();
    }

    public boolean isLikelyCategorical() {
        return !this.holdsNumericalValues && !this.holdsTemporalValues || this.hasLowCardinality();
    }

    public boolean isSeriesIdCandidate() {
        return !this.holdsTemporalValues && this.cardinality > 1L && this.hasLowCardinality();
    }

    public boolean hasEmptyValues() {
        return this.nbEmpty > 0L;
    }

    public double getUnavailableDataRatio() {
        Long nbUnavailable;
        Long l = nbUnavailable = this.nbMissing == null ? this.nbEmpty : this.nbMissing;
        if (nbUnavailable < 0L || this.totalCount <= 0L) {
            return Double.NaN;
        }
        return (double)nbUnavailable.longValue() / (double)this.totalCount;
    }

    public boolean isLikelyIndicator() {
        if (!this.holdsNumericalValues || this.isConstant()) {
            return false;
        }
        Set indicatorValues = Stream.of(0.0, 1.0).collect(Collectors.toSet());
        return this.top5values.keySet().stream().filter(value -> !StringUtils.isBlank((String)value)).map(Double::parseDouble).allMatch(indicatorValues::contains);
    }

    public void setShapiroResult(Shapiro.ShapiroResult shapiroResult) {
        this.shapiroResult = shapiroResult;
    }

    public boolean hasSignificantShapiroStatistic() {
        if (this.shapiroResult == null) {
            return false;
        }
        return this.shapiroResult.statistic >= 0.99;
    }

    public boolean isConstant() {
        return this.cardinality == 1L;
    }

    public boolean isLikelyAnIdentifier() {
        String lowerCaseName = this.name.toLowerCase(Locale.ENGLISH);
        return this.hasHighCardinality() && (lowerCaseName.startsWith("id") || lowerCaseName.endsWith("id"));
    }

    public boolean hasLowCardinality() {
        return this.cardinality <= 50L;
    }

    public boolean hasVeryLowCardinality() {
        return this.cardinality <= 5L;
    }

    public boolean hasHighCardinality() {
        return this.totalCount > 100L && (double)this.cardinality.longValue() >= 0.95 * (double)this.totalCount;
    }

    public boolean hasSignificantStandardDeviation() {
        if (this.stdDev == null || this.min == null || this.max == null) {
            return false;
        }
        return this.stdDev > 0.05 * Math.abs(this.max - this.min);
    }

    public boolean looksCenteredAround(double targetMean) {
        if (this.mean == null || this.stdDev == null) {
            return false;
        }
        return Math.abs(this.mean - targetMean) <= 3.0 * this.stdDev;
    }

    public double getInterestScore() {
        return 2.0 * (this.correlationScore + this.timeSeriesScore) + this.individualScore;
    }

    public List<Distribution> getGoodDistributionFits() {
        return this.fitDistributionResults.entrySet().stream().filter(it -> this.isAGoodFit((FitDistribution.FitDistributionResult)((Object)((Object)it.getValue())))).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private boolean isAGoodFit(FitDistribution.FitDistributionResult result) {
        if (result.test == null || result.test.test.ks == null) {
            return false;
        }
        return result.test.test.ks.pvalue > 5.0E-4;
    }

    public void addSeriesIdentifier(SniffedVariable variable) {
        this.seriesIdentifiers.add(variable);
    }

    public boolean hasSeriesIdentifier(SniffedVariable variable) {
        return this.seriesIdentifiers.contains(variable);
    }

    public List<SniffedVariable> getSeriesIdentifiers() {
        return new ArrayList<SniffedVariable>(this.seriesIdentifiers);
    }

    public List<String> getSeriesIdentifierNames() {
        return this.seriesIdentifiers.stream().map(v -> v.name).collect(Collectors.toList());
    }
}

