/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.externalinfras.azureml.datamodel;

import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLResource;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLResourceIdentifier;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class AzureMLOnlineDeployment
extends AzureMLResource {
    private static final String CONFIG_YAML_ENDPOINT_NAME = "__AZ_ONLINE_DEPLOYMENT_ENDPOINT_NAME__";
    private static final String CONFIG_YAML_MODEL_REF = "__AZ_ONLINE_DEPLOYMENT_MODEL_REF__";
    private static final String CONFIG_YAML_ENVIRONMENT_REF = "__AZ_ONLINE_DEPLOYMENT_ENVIRONMENT_REF__";
    private static final String CONFIG_YAML_INSTANCE_TYPE = "__AZ_ONLINE_DEPLOYMENT_INSTANCE_TYPE__";
    private static final String CONFIG_YAML_INSTANCE_COUNT = "__AZ_ONLINE_DEPLOYMENT_INSTANCE_COUNT__";
    private static final String CONFIG_YAML_INSIGHTS_ENABLED = "__AZ_ONLINE_DEPLOYMENT_INSIGHTS_ENABLED__";
    private static final String CONFIG_YAML_PUBLIC_NETWORK_ACCESS = "__AZ_ONLINE_DEPLOYMENT_PUBLIC_NETWORK_ACCESS__";
    private static final String CONFIG_YAML_LIVENESS_PROBE = "__AZ_ONLINE_DEPLOYMENT_LIVENESS_PROBE__";
    private static final String CONFIG_YAML_READINESS_PROBE = "__AZ_ONLINE_DEPLOYMENT_READINESS_PROBE__";
    private static final String CONFIG_YAML_ENV_VARS = "__AZ_ONLINE_DEPLOYMENT_ENV_VARS__";
    public static final String AZUREML_ONLINE_DEPLOYMENT_RESOURCE = "online-deployment";
    public static final String AZUREML_ONLINE_DEPLOYMENT_RESOURCE_LABEL = "Online Deployment";
    public static final int ONLINE_DEPLOYMENT_NAME_MAX_LENGTH = 16;
    @SerializedName(value="model")
    public String modelURI;
    public String environment;
    @SerializedName(value="endpointName", alternate={"endpoint_name"})
    public String endpointName;
    @SerializedName(value="instanceType", alternate={"instance_type"})
    public String instanceType;
    @SerializedName(value="instanceCount", alternate={"instance_count"})
    public int instanceCount;
    @SerializedName(value="appInsightsEnabled", alternate={"app_insights_enabled"})
    public boolean appInsightsEnabled;
    @SerializedName(value="egressPublicNetworkAccess", alternate={"egress_public_network_access"})
    public String egressPublicNetworkAccess;
    @SerializedName(value="environmentVariables", alternate={"environment_variables"})
    public Map<String, String> environmentVariables = new HashMap<String, String>();
    @SerializedName(value="livenessProbe", alternate={"liveness_probe"})
    public ProbeSettings livenessProbe;
    @SerializedName(value="readinessProbe", alternate={"readiness_probe"})
    public ProbeSettings readinessProbe;
    @SerializedName(value="provisioningState", alternate={"provisioning_state"})
    public DeploymentProvisioningState provisioningState;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.externalinfras.azureml.datamodel.azureml-online-deployment");

    public AzureMLOnlineDeployment() {
    }

    public AzureMLOnlineDeployment(AzureMLResourceIdentifier resourceId) {
        super(resourceId);
        if (StringUtils.isNotBlank((CharSequence)resourceId.parentResourceName)) {
            this.endpointName = resourceId.parentResourceName;
        }
    }

    @Override
    public String getResourceType() {
        return AZUREML_ONLINE_DEPLOYMENT_RESOURCE;
    }

    @Override
    public String getResourceTypeLabel() {
        return AZUREML_ONLINE_DEPLOYMENT_RESOURCE_LABEL;
    }

    @Override
    public AzureMLResourceIdentifier getResourceIdentifier() {
        AzureMLResourceIdentifier onlineDeploymentId = super.getResourceIdentifier();
        onlineDeploymentId.parentResourceName = this.endpointName;
        return onlineDeploymentId;
    }

    private String replaceEnvVarsYamlField(String yaml) {
        StringBuilder envVarsSection = new StringBuilder();
        if (!this.environmentVariables.isEmpty()) {
            envVarsSection = new StringBuilder("environment_variables:\n");
            for (Map.Entry<String, String> entry : this.environmentVariables.entrySet()) {
                envVarsSection.append(String.format("  %s: \"%s\"%n", entry.getKey(), entry.getValue()));
            }
        }
        return yaml.replace(CONFIG_YAML_ENV_VARS, envVarsSection.toString());
    }

    private String getProbeSettingsAsYaml(@Nonnull ProbeSettings probeSettings) {
        return String.format("  initial_delay: \"%s\"%n", probeSettings.initialDelay) + String.format("  period: \"%s\"%n", probeSettings.period) + String.format("  timeout: \"%s\"%n", probeSettings.timeout) + String.format("  success_threshold: \"%s\"%n", probeSettings.successThreshold) + String.format("  failure_threshold: \"%s\"%n", probeSettings.failureThreshold);
    }

    private String replaceLivenessProbeYamlField(String yaml) {
        StringBuilder probeSection = new StringBuilder();
        if (Objects.nonNull(this.livenessProbe) && this.livenessProbe.overrideProbeSettings) {
            probeSection = new StringBuilder("liveness_probe:\n");
            probeSection.append(this.getProbeSettingsAsYaml(this.livenessProbe));
        }
        return yaml.replace(CONFIG_YAML_LIVENESS_PROBE, probeSection.toString());
    }

    private String replaceReadinessProbeYamlField(String yaml) {
        StringBuilder probeSection = new StringBuilder();
        if (Objects.nonNull(this.readinessProbe) && this.readinessProbe.overrideProbeSettings) {
            probeSection = new StringBuilder("readiness_probe:\n");
            probeSection.append(this.getProbeSettingsAsYaml(this.readinessProbe));
        }
        return yaml.replace(CONFIG_YAML_READINESS_PROBE, probeSection);
    }

    @Override
    public String toYamlConfig() throws IOException {
        String yaml = super.replaceBaseYamlFields().replace(CONFIG_YAML_ENDPOINT_NAME, this.endpointName).replace(CONFIG_YAML_MODEL_REF, this.modelURI).replace(CONFIG_YAML_ENVIRONMENT_REF, this.environment).replace(CONFIG_YAML_INSTANCE_TYPE, this.instanceType).replace(CONFIG_YAML_INSTANCE_COUNT, Integer.toString(this.instanceCount)).replace(CONFIG_YAML_INSIGHTS_ENABLED, Boolean.toString(this.appInsightsEnabled)).replace(CONFIG_YAML_PUBLIC_NETWORK_ACCESS, this.egressPublicNetworkAccess);
        yaml = this.replaceLivenessProbeYamlField(yaml);
        yaml = this.replaceReadinessProbeYamlField(yaml);
        return this.replaceEnvVarsYamlField(yaml);
    }

    private String extractRelatedResourceName(String resourceURI) {
        if (StringUtils.isEmpty((CharSequence)resourceURI)) {
            return null;
        }
        String[] resourceURIParts = resourceURI.split("/");
        if (resourceURIParts.length < 4) {
            return null;
        }
        return resourceURIParts[resourceURIParts.length - 3];
    }

    public String extractRelatedResourceVersion(String resourceURI) {
        if (StringUtils.isEmpty((CharSequence)resourceURI)) {
            return null;
        }
        String[] resourceURIParts = resourceURI.split("/");
        if (resourceURIParts.length < 4) {
            return null;
        }
        return resourceURIParts[resourceURIParts.length - 1];
    }

    public String getModelName() {
        return this.extractRelatedResourceName(this.modelURI);
    }

    public String getModelVersion() {
        return this.extractRelatedResourceVersion(this.modelURI);
    }

    public String getEnvironmentName() {
        return this.extractRelatedResourceName(this.environment);
    }

    public String getEnvironmentVersion() {
        return this.extractRelatedResourceVersion(this.environment);
    }

    public static class ProbeSettings {
        public boolean overrideProbeSettings = false;
        @SerializedName(value="initialDelay", alternate={"initial_delay"})
        public int initialDelay = 10;
        public int period = 10;
        public int timeout = 2;
        @SerializedName(value="successThreshold", alternate={"success_threshold"})
        public int successThreshold = 1;
        @SerializedName(value="failureThreshold", alternate={"failure_threshold"})
        public int failureThreshold = 30;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProbeSettings that = (ProbeSettings)o;
            return this.initialDelay == that.initialDelay && this.period == that.period && this.timeout == that.timeout && this.successThreshold == that.successThreshold && this.failureThreshold == that.failureThreshold;
        }

        public int hashCode() {
            return Objects.hash(this.initialDelay, this.period, this.timeout, this.successThreshold, this.failureThreshold);
        }
    }

    @JsonAdapter(value=DeploymentProvisioningStateAdapter.class)
    public static enum DeploymentProvisioningState {
        CREATING("Creating"),
        DELETING("Deleting"),
        SCALING("Scaling"),
        UPDATING("Updating"),
        SUCCEEDED("Succeeded"),
        FAILED("Failed"),
        CANCELED("Canceled");

        private final String name;

        private DeploymentProvisioningState(String name) {
            this.name = name;
        }

        static DeploymentProvisioningState getProvisioningStateByName(String name) {
            for (DeploymentProvisioningState provisioningState : DeploymentProvisioningState.values()) {
                if (!provisioningState.name.equals(name)) continue;
                return provisioningState;
            }
            logger.errorV("AzureML Deployment Provisioning State '%s' cannot be mapped.", new Object[]{name});
            return null;
        }

        public String getName() {
            return this.name;
        }

        public static void registerAdapter() {
            JSON.registerAdapter(DeploymentProvisioningState.class, (Object)new DeploymentProvisioningStateAdapter());
        }

        static class DeploymentProvisioningStateAdapter
        implements JSON.Adapter<DeploymentProvisioningState> {
            DeploymentProvisioningStateAdapter() {
            }

            public JsonElement serialize(DeploymentProvisioningState src, Type typeOfSrc, JsonSerializationContext context) {
                return context.serialize((Object)src.name);
            }

            public DeploymentProvisioningState deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
                return DeploymentProvisioningState.getProvisioningStateByName(json.getAsString());
            }
        }
    }
}

