/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.externalinfras.azureml.datamodel;

import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLResource;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLResourceIdentifier;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class AzureMLOnlineEndpoint
extends AzureMLResource {
    private static final String CONFIG_YAML_AUTH_MODE_FIELD = "__AZ_ONLINE_ENDPOINT_AUTH_MODE__";
    private static final String CONFIG_YAML_PUBLIC_NETWORK_ACCESS_FIELD = "__AZ_ONLINE_ENDPOINT_PUBLIC_NETWORK_ACCESS__";
    private static final String CONFIG_YAML_TRAFFIC_FIELD = "__AZ_ONLINE_ENDPOINT_TRAFFIC__";
    public static final String AZUREML_ONLINE_ENDPOINT_RESOURCE = "online-endpoint";
    public static final String AZUREML_ONLINE_ENDPOINT_RESOURCE_LABEL = "Online Endpoint";
    public static final int ONLINE_ENDPOINT_NAME_MAX_LENGTH = 32;
    public static final int ONLINE_ENDPOINT_NAME_MIN_LENGTH = 3;
    @SerializedName(value="authMode", alternate={"auth_mode"})
    public String authMode;
    @SerializedName(value="publicNetworkAccess", alternate={"public_network_access"})
    public String publicNetworkAccess;
    public Map<String, Integer> traffic = new HashMap<String, Integer>();
    @SerializedName(value="provisioningState", alternate={"provisioning_state"})
    public AzureMLResource.ResourceProvisioningState provisioningState;
    @SerializedName(value="openapiURI", alternate={"openapi_uri"})
    public String openapiURI;
    @SerializedName(value="scoringURI", alternate={"scoring_uri"})
    public String scoringURI;
    public String location;
    public String kind;

    public AzureMLOnlineEndpoint() {
    }

    public AzureMLOnlineEndpoint(AzureMLResourceIdentifier resourceId) {
        super(resourceId);
    }

    @Override
    public String getResourceType() {
        return AZUREML_ONLINE_ENDPOINT_RESOURCE;
    }

    @Override
    public String getResourceTypeLabel() {
        return AZUREML_ONLINE_ENDPOINT_RESOURCE_LABEL;
    }

    private String replaceTrafficYamlField(String yaml) {
        StringBuilder trafficSection = new StringBuilder();
        if (!this.traffic.isEmpty()) {
            trafficSection = new StringBuilder("traffic:\n");
            for (Map.Entry<String, Integer> entry : this.traffic.entrySet()) {
                trafficSection.append(String.format("  %s: \"%s\"%n", entry.getKey(), entry.getValue()));
            }
        }
        return yaml.replace(CONFIG_YAML_TRAFFIC_FIELD, trafficSection.toString());
    }

    private String mapAuthMode(String authMode) {
        if ("Key".equals(authMode)) {
            return "key";
        }
        if ("AMLToken".equals(authMode)) {
            return "aml_token";
        }
        return authMode;
    }

    @Override
    public String toYamlConfig() throws IOException {
        String yaml = super.replaceBaseYamlFields().replace(CONFIG_YAML_AUTH_MODE_FIELD, this.mapAuthMode(this.authMode)).replace(CONFIG_YAML_PUBLIC_NETWORK_ACCESS_FIELD, this.publicNetworkAccess.toLowerCase());
        return this.replaceTrafficYamlField(yaml);
    }
}

