/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.externalml.mlflow;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.CodeBasedRecipeDatasetInfoHelper;
import com.dataiku.dip.engine.SmoothlyClosableRunner;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksRegisteredModel;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksRegisteredModelVersion;
import com.dataiku.dip.externalml.mlflow.DatabricksUtilsKernelProtocol;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DatabricksUtilsRunner
extends SmoothlyClosableRunner<DatabricksUtilsKernelProtocol> {
    Lock lock = new ReentrantLock();

    public DatabricksUtilsRunner(DatabricksUtilsKernelProtocol databricksUtilsKernelProtocol) {
        super(databricksUtilsKernelProtocol);
    }

    public File downloadModelFromDatabricks(@Nonnull CodeBasedRecipeDatasetInfoHelper.ConnectionLocationInfo connectionInfo, boolean useUnityCatalog, @Nonnull String modelName, @Nonnull String modelVersion, @Nonnull File targetDirectory) throws IOException, InterruptedException, CodedException {
        try {
            this.lock.lockInterruptibly();
            if (this.isDeadKernel()) {
                ((DatabricksUtilsKernelProtocol)this.runner).getKernel().start();
            }
            File file = ((DatabricksUtilsKernelProtocol)this.runner).downloadModelFromDatabricks(connectionInfo, useUnityCatalog, modelName, modelVersion, targetDirectory.getAbsolutePath());
            return file;
        }
        catch (Exception e) {
            ((DatabricksUtilsKernelProtocol)this.runner).close();
            throw e;
        }
        finally {
            this.lock.unlock();
        }
    }

    public DatabricksUtilsKernelProtocol.RequestModelRegistrationResponse registerModelInDatabricks(@Nonnull File modelDirectory, @Nonnull CodeBasedRecipeDatasetInfoHelper.ConnectionLocationInfo connectionInfo, boolean useUnityCatalog, @Nonnull String modelName, @Nonnull String experimentName, @Nullable List<SchemaColumn> inputColumns, @Nonnull String targetName) throws IOException, InterruptedException, CodedException {
        try {
            this.lock.lockInterruptibly();
            if (this.isDeadKernel()) {
                ((DatabricksUtilsKernelProtocol)this.runner).getKernel().start();
            }
            DatabricksUtilsKernelProtocol.RequestModelRegistrationResponse requestModelRegistrationResponse = ((DatabricksUtilsKernelProtocol)this.runner).registerModelInDatabricks(connectionInfo, useUnityCatalog, modelName, modelDirectory.getAbsolutePath(), experimentName, inputColumns, targetName);
            return requestModelRegistrationResponse;
        }
        catch (Exception e) {
            ((DatabricksUtilsKernelProtocol)this.runner).close();
            throw e;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<DatabricksRegisteredModel> listRegisteredModels(CodeBasedRecipeDatasetInfoHelper.ConnectionLocationInfo connectionInfo, boolean useUnityCatalog) throws CodedException, IOException, InterruptedException {
        try {
            this.lock.lockInterruptibly();
            this.incRefCount();
            if (this.isDeadKernel()) {
                ((DatabricksUtilsKernelProtocol)this.runner).getKernel().start();
            }
            List<DatabricksRegisteredModel> list = ((DatabricksUtilsKernelProtocol)this.runner).listRegisteredModels(connectionInfo, useUnityCatalog);
            return list;
        }
        catch (Exception e) {
            ((DatabricksUtilsKernelProtocol)this.runner).close();
            throw e;
        }
        finally {
            this.decRefCount();
            this.lock.unlock();
        }
    }

    public List<DatabricksRegisteredModelVersion> listRegisteredModelVersions(CodeBasedRecipeDatasetInfoHelper.ConnectionLocationInfo connectionInfo, String modelName, boolean useUnityCatalog) throws CodedException, IOException, InterruptedException {
        try {
            this.lock.lockInterruptibly();
            this.incRefCount();
            if (this.isDeadKernel()) {
                ((DatabricksUtilsKernelProtocol)this.runner).getKernel().start();
            }
            List<DatabricksRegisteredModelVersion> list = ((DatabricksUtilsKernelProtocol)this.runner).listRegisteredModelVersions(connectionInfo, modelName, useUnityCatalog);
            return list;
        }
        catch (Exception e) {
            ((DatabricksUtilsKernelProtocol)this.runner).close();
            throw e;
        }
        finally {
            this.decRefCount();
            this.lock.unlock();
        }
    }

    public boolean isDeadKernel() {
        return ((DatabricksUtilsKernelProtocol)this.runner).getKernel().getLink() == null || !((DatabricksUtilsKernelProtocol)this.runner).getKernel().isAlive();
    }
}

