/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.geo;

import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.formats.geo.ShapefileFormatExtractor;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.shaker.types.GeometryMeaning;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ShapefileOutputFormatter
implements OutputFormatter {
    private Schema outputSchema;
    protected WarningsContext warningsContext = new WarningsContext();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.shp");
    private String stringCRS;
    private String previousGeometryType = null;
    private List<Column> propertyCDs = new ArrayList<Column>();
    private Column geoCD = null;
    private GeometryMeaning geometryMeaning = new GeometryMeaning();
    private Transaction transaction;
    private Map<String, Serializable> dataStoreOption = new HashMap<String, Serializable>();
    private SimpleFeatureTypeBuilder builder;
    private SimpleFeatureType type;
    private SimpleFeatureBuilder featureBuilder;
    private DataStore datastore;
    private FeatureWriter<SimpleFeatureType, SimpleFeature> writer;
    private File tmpDir;

    public ShapefileOutputFormatter() {
        this.stringCRS = "EPSG:4326";
    }

    public ShapefileOutputFormatter(ShapefileFormatExtractor.Config config) {
        this.stringCRS = config.stringCRS;
    }

    public void header(ColumnFactory cf, OutputStream os) throws Exception {
        this.transaction = new DefaultTransaction("create");
        for (SchemaColumn schemaCol : this.outputSchema.getColumns()) {
            if (schemaCol.getType() == Type.GEOMETRY || schemaCol.getType() == Type.GEOPOINT) {
                this.geoCD = cf.column(schemaCol.getName());
                continue;
            }
            this.propertyCDs.add(cf.column(schemaCol.getName()));
        }
        if (this.geoCD == null) {
            throw ErrorContext.iae((String)"No geometry column found in the dataset");
        }
        this.tmpDir = DSSTempUtils.getTempFolder((String)"tmp_shapefile_dl");
        this.dataStoreOption.put("url", new File(String.valueOf(this.tmpDir) + File.separator + "geodata.shp").toURI().toURL());
        this.dataStoreOption.put("create spatial index", Boolean.TRUE);
    }

    public void format(Row row, ColumnFactory cf, OutputStream os) throws Exception {
        String geoVal = row.get(this.geoCD);
        if (StringUtils.isBlank((String)geoVal)) {
            return;
        }
        Geometry geom = this.geometryMeaning.toGeometry(geoVal);
        if (geom == null) {
            this.warningsContext.addWarning(WarningsContext.WarningType.OUTPUT_DATA_BAD_TYPE, "Unable to write row (invalid geometry or geopoint:" + geoVal + ")", logger);
            return;
        }
        String geometryType = geom.getGeometryType();
        if (this.previousGeometryType == null) {
            this.previousGeometryType = geometryType;
            Object exportCRS = null;
            exportCRS = this.stringCRS != null && !this.stringCRS.isEmpty() ? CRS.decode((String)this.stringCRS, (boolean)true) : DefaultGeographicCRS.WGS84;
            this.builder = new SimpleFeatureTypeBuilder();
            this.builder.setName("geodata");
            this.builder.setCRS((CoordinateReferenceSystem)exportCRS);
            this.builder.setDefaultGeometry("the_geom");
            this.builder.add("the_geom", GeometryMeaning.strToClass(geometryType));
            for (SchemaColumn schemaCol : this.outputSchema.getColumns()) {
                if (schemaCol.getType() == Type.GEOMETRY || schemaCol.getType() == Type.GEOPOINT || Objects.equals(schemaCol.getName(), "shp_srs")) continue;
                this.builder.add(schemaCol.getName(), schemaCol.getType().getClass());
            }
            ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
            this.type = this.builder.buildFeatureType();
            this.featureBuilder = new SimpleFeatureBuilder(this.type);
            this.datastore = factory.createNewDataStore(this.dataStoreOption);
            this.datastore.createSchema((FeatureType)this.type);
            this.writer = this.datastore.getFeatureWriterAppend(this.type.getTypeName(), this.transaction);
        } else if (!this.previousGeometryType.equals(geometryType)) {
            throw new IllegalArgumentException("All row geometry features must be of same type - dataset has both : " + geometryType + " and " + this.previousGeometryType + ".");
        }
        this.featureBuilder.add((Object)geom);
        for (Column column : this.propertyCDs) {
            Object castValue;
            if (column.getName().equals("shp_srs")) continue;
            Type colType = this.outputSchema.getColumn(column.getName()).getType();
            String value = row.get(column);
            if (StringUtils.isBlank((String)value)) continue;
            try {
                castValue = colType.isInteger() ? Integer.valueOf(Integer.parseInt(value)) : (colType.isFloatingPoint() ? Double.valueOf(Double.parseDouble(value)) : (colType == Type.BOOLEAN ? Boolean.valueOf(Boolean.parseBoolean(value)) : (!colType.isPrimitive() ? (colType == Type.ARRAY ? new JSONArray(value) : new JSONObject(value)) : value)));
            }
            catch (NumberFormatException | JSONException ignored) {
                castValue = value;
            }
            this.featureBuilder.add(castValue);
        }
        SimpleFeature copy = (SimpleFeature)this.writer.next();
        SimpleFeature feat = this.featureBuilder.buildFeature(null);
        copy.setAttributes(feat.getAttributes());
        copy.setDefaultGeometry((Object)geom);
        this.writer.write();
    }

    public void footer(ColumnFactory cf, OutputStream os) throws Exception {
        this.transaction.commit();
        ZipUnzipDir.zipDirectoryToStream(this.tmpDir, os);
        DKUFileUtils.forceDelete((File)this.tmpDir);
    }

    public void cancel(OutputStream os) throws Exception {
        this.transaction.commit();
        DKUFileUtils.forceDelete((File)this.tmpDir);
    }

    public void setOutputSchema(Schema schema) {
        this.outputSchema = schema;
    }

    public void setWarningsContext(WarningsContext warningsContext) {
        this.warningsContext = warningsContext;
    }
}

