/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hadoop;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Logger;

public class HadoopLoader {
    private static boolean hadoopEnabled = "true".equals(System.getenv("DKU_HADOOP_ENABLED"));
    private static boolean kerberosLoginEnabled;
    private static boolean securityConfigLoaded;
    private static String principal;
    private static String keytab;
    private static long ticketRenewPeriod;
    private static long ticketRetryPeriod;
    private static String ticketCacheFilename;
    private static boolean passTicketCacheToChildren;
    private static Thread ticketRenewerThread;
    private static Logger logger;

    public static boolean hadoopEnabled() {
        return hadoopEnabled;
    }

    public static FileSystem getFS(String rootPathURI, List<SimpleKeyValue> fsExtraConf) throws IOException {
        FileSystem fs;
        try (DSSMetrics.TimeCtx gtctx = DSSMetrics.timeCtx((String)"dku.services.hadoop.fsloader.getFS");){
            Configuration hadoopConfig;
            block30: {
                DSSMetrics.TimeCtx tctx;
                logger.debug((Object)("Initializing Hadoop FS with context UGI: " + String.valueOf(UserGroupInformation.getCurrentUser()) + " (login: " + String.valueOf(UserGroupInformation.getLoginUser()) + ") rootPathURI=" + rootPathURI));
                hadoopConfig = new Configuration();
                for (SimpleKeyValue extra : fsExtraConf) {
                    hadoopConfig.set(extra.key, extra.value);
                }
                if (new File("/databricks/driver").isDirectory()) {
                    hadoopConfig.set("fs.wasb.impl", "shaded.databricks.org.apache.hadoop.fs.azure.NativeAzureFileSystem");
                    hadoopConfig.set("fs.wasbs.impl", "shaded.databricks.org.apache.hadoop.fs.azure.NativeAzureFileSystem");
                    hadoopConfig.set("fs.adl.impl", "com.databricks.adl.AdlFileSystem");
                    hadoopConfig.set("fs.abfs.impl", "shaded.databricks.org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem");
                    hadoopConfig.set("fs.abfss.impl", "shaded.databricks.org.apache.hadoop.fs.azurebfs.SecureAzureBlobFileSystem");
                }
                if (StringUtils.isNotBlank((String)rootPathURI) && !"/".equals(rootPathURI)) {
                    try {
                        try {
                            String scheme = new URI(rootPathURI).getScheme();
                            if (StringUtils.isNotBlank((String)scheme)) {
                                logger.info((Object)"Forcing fs.<scheme>.impl.disable.cache because the config might not be taken into account");
                                hadoopConfig.set("fs." + scheme + ".impl.disable.cache", "true");
                            } else {
                                logger.warn((Object)("Scheme not found in URI '" + rootPathURI + "', not disabling cache"));
                            }
                        }
                        catch (Exception e) {
                            logger.warn((Object)("Invalid URI '" + rootPathURI + "', not disabling cache"), (Throwable)e);
                        }
                        tctx = DSSMetrics.timeCtx((String)"dku.services.hadoop.fsloader.getFS.fsget.withURI");
                        try {
                            fs = FileSystem.get((URI)new URI(rootPathURI), (Configuration)hadoopConfig);
                            break block30;
                        }
                        finally {
                            if (tctx != null) {
                                tctx.close();
                            }
                        }
                    }
                    catch (URISyntaxException e) {
                        throw new IOException("Invalid path to build HDFS filesystem", e);
                    }
                }
                try {
                    String defaultScheme = FileSystem.getDefaultUri((Configuration)hadoopConfig).getScheme();
                    logger.info((Object)("Forcing disable of defaultScheme cache (#8388): " + defaultScheme));
                    hadoopConfig.set("fs." + defaultScheme + ".impl.disable.cache", "true");
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to disable cache on default scheme", (Throwable)e);
                }
                tctx = DSSMetrics.timeCtx((String)"dku.services.hadoop.fsloader.getFS.fsget.default");
                try {
                    fs = FileSystem.get((Configuration)hadoopConfig);
                }
                finally {
                    if (tctx != null) {
                        tctx.close();
                    }
                }
            }
            if (fs instanceof RawLocalFileSystem || fs instanceof LocalFileSystem) {
                logger.info((Object)("Wrong configuration, was created with " + String.valueOf(hadoopConfig)));
                logger.info((Object)("fs.defaultFS = " + hadoopConfig.get("fs.defaultFS")));
            }
        }
        return fs;
    }

    public static FileSystem getFSForUGI(final String rootPathURI, final List<SimpleKeyValue> extraConf, UserGroupInformation ugi) throws IOException, InterruptedException {
        logger.debug((Object)("Initializing Hadoop FS with explicit UGI: " + String.valueOf(ugi) + " (login: " + String.valueOf(UserGroupInformation.getLoginUser()) + ")"));
        return (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws IOException {
                return HadoopLoader.getFS(rootPathURI, extraConf);
            }
        });
    }

    public static void initializeSecurity(HadoopSettings settings, boolean passTicketCacheToChildren, final boolean maintainTicketCache) throws IOException {
        HadoopLoader.loadSecurityConfig(settings);
        if (kerberosLoginEnabled) {
            logger.info((Object)("Logging user " + principal + " from keytab file " + keytab));
            UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab);
            if (maintainTicketCache) {
                try {
                    HadoopLoader.saveTicketCache();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Kerberos ticket acquisition interrupted", e);
                }
            }
            HadoopLoader.passTicketCacheToChildren = passTicketCacheToChildren;
            logger.info((Object)"Starting Kerberos ticket renewer thread");
            assert (ticketRenewerThread == null);
            ticketRenewerThread = new Thread("KerberosTicketRenewer"){

                @Override
                public void run() {
                    try {
                        2.sleep(ticketRenewPeriod * 1000L);
                        while (true) {
                            try {
                                while (true) {
                                    logger.info((Object)("Re-logging user " + principal + " from keytab file if needed"));
                                    UserGroupInformation.getLoginUser().checkTGTAndReloginFromKeytab();
                                    if (maintainTicketCache) {
                                        HadoopLoader.saveTicketCache();
                                    }
                                    2.sleep(ticketRenewPeriod * 1000L);
                                }
                            }
                            catch (IOException e) {
                                logger.warn((Object)"Error acquiring Kerberos ticket", (Throwable)e);
                                2.sleep(ticketRetryPeriod * 1000L);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        logger.warn((Object)"Kerberos ticket renewer thread interrupted", (Throwable)e);
                        return;
                    }
                }
            };
            ticketRenewerThread.setDaemon(true);
            ticketRenewerThread.start();
        }
    }

    private static void saveTicketCache() throws IOException, InterruptedException {
        String tmpFilename = ticketCacheFilename + ".tmp";
        String[] cmd = new String[]{"kinit", "-k", "-t", keytab, "-c", tmpFilename, principal};
        logger.info((Object)("Updating Kerberos ticket cache for " + principal));
        DKUtils.execAndLogThrows((String[])cmd, null, (File)null);
        if (!new File(tmpFilename).renameTo(new File(ticketCacheFilename))) {
            throw new IOException("Error renaming " + tmpFilename + " to " + ticketCacheFilename);
        }
    }

    public static void addTicketCacheEnvVar(Map<String, String> env) {
        if (passTicketCacheToChildren) {
            env.put("KRB5CCNAME", ticketCacheFilename);
        }
    }

    public static String getTicketCacheEnvVar() {
        if (passTicketCacheToChildren) {
            return ticketCacheFilename;
        }
        return System.getenv("KRB5CCNAME");
    }

    public static boolean isSecurityEnabled() {
        return UserGroupInformation.isSecurityEnabled();
    }

    public static boolean isKerberosLoginEnabled() {
        assert (securityConfigLoaded);
        return kerberosLoginEnabled;
    }

    private static synchronized void loadSecurityConfig(HadoopSettings settings) throws IOException {
        if (securityConfigLoaded) {
            return;
        }
        kerberosLoginEnabled = settings.kerberosLoginEnabled;
        if (settings.kerberosLoginEnabled) {
            logger.info((Object)"Hadoop Kerberos login enabled");
            principal = settings.dssPrincipal;
            if (StringUtils.isBlank((String)principal)) {
                throw new Error("DSS principal is mandatory in general settings");
            }
            keytab = settings.dssKeytabPath;
            if (keytab == null) {
                throw new Error("DSS keytab path is mandatory in general settings");
            }
            ticketRenewPeriod = ApplicationConfigurator.getParams().getLongParam("hadoop.kerberos.ticketRenewPeriod", 3600L);
            ticketRetryPeriod = ApplicationConfigurator.getParams().getLongParam("hadoop.kerberos.ticketRetryPeriod", 300L);
            File krb5CCFile = ApplicationConfigurator.getFile((String)"privtmp/krb5cc");
            DKUFileUtils.mkdirsParent((File)krb5CCFile);
            ticketCacheFilename = krb5CCFile.getAbsolutePath();
        }
        securityConfigLoaded = true;
    }

    static {
        logger = Logger.getLogger((String)"dku.hadoop");
    }
}

