/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.csv;

import com.dataiku.dip.input.formats.CSVParserUtils;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.csv.CSVParser;
import com.dataiku.dip.input.stream.LineReader;
import java.io.IOException;
import java.util.List;

public class EscapingOnlyCSVParser
implements CSVParser {
    private StringBuilder currentField = new StringBuilder();
    private boolean escapeAtEndOfLine;
    private LineReader br;
    private char delimiter;
    private char escapeChar;
    protected Integer maxRowChars;
    private int currentLine = 1;

    public EscapingOnlyCSVParser(LineReader reader, char delimiter, char escapeChar) {
        this(reader, delimiter, escapeChar, null);
    }

    public EscapingOnlyCSVParser(LineReader reader, CSVFormatConfig conf) {
        this(reader, conf.getSeparatorChar(), conf.getEscapeChar(), conf.getMaxRowChars());
    }

    public EscapingOnlyCSVParser(LineReader reader, char delimiter, char escapeChar, Integer maxRowChars) {
        this.delimiter = delimiter;
        this.escapeChar = escapeChar;
        this.br = reader;
        this.maxRowChars = maxRowChars;
    }

    @Override
    public boolean next(List<String> out) throws IOException {
        out.clear();
        int currentRowLength = 0;
        do {
            String line;
            if ((line = this.br.readLine()) == null) {
                if (!this.escapeAtEndOfLine) {
                    return false;
                }
                throw new IOException("Unterminated multi-line record at the end of the file");
            }
            this.escapeAtEndOfLine = false;
            for (int i = 0; i < line.length(); ++i) {
                char c2 = line.charAt(i);
                if (c2 == this.escapeChar) {
                    if (line.length() > i + 1 && line.charAt(i + 1) == this.delimiter) {
                        this.currentField.append(this.delimiter);
                        ++i;
                        continue;
                    }
                    if (line.length() > i + 1 && line.charAt(i + 1) == this.escapeChar) {
                        this.currentField.append(this.escapeChar);
                        ++i;
                        continue;
                    }
                    if (line.length() > i + 1 && (byte)line.charAt(i + 1) <= 8) {
                        this.currentField.append(line.charAt(i + 1));
                        ++i;
                        continue;
                    }
                    if (line.length() > i + 1 && line.charAt(i + 1) == 'N') {
                        this.currentField.setLength(0);
                        ++i;
                        continue;
                    }
                    if (line.length() == i + 1) {
                        this.escapeAtEndOfLine = true;
                        continue;
                    }
                    throw new IOException("Invalid escape sequence : " + line + ": escape followed by '" + line.charAt(i + 1) + "' (char " + line.charAt(i + 1) + ")");
                }
                if (c2 == this.delimiter) {
                    out.add(this.currentField.toString());
                    this.currentField.setLength(0);
                    continue;
                }
                this.currentField.append(c2);
            }
            currentRowLength += line.length();
            if (this.escapeAtEndOfLine) {
                this.currentField.append('\n');
                ++currentRowLength;
            } else {
                out.add(this.currentField.toString());
                this.currentField.setLength(0);
            }
            CSVParserUtils.checkRowLength((int)currentRowLength, (Integer)this.maxRowChars, (int)this.currentLine);
        } while (this.escapeAtEndOfLine);
        ++this.currentLine;
        return true;
    }
}

