/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.parquet;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.input.formats.parquet.RowTupleConverter;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;

public class ParquetSchemaConverter {
    private static boolean hasLoggedReflectionError = false;
    static Set<String> TIMESTAMP_ORIGINAL_TYPES = Sets.newHashSet((Object[])new String[]{"TIMESTAMP_MILLIS", "TIMESTAMP_MICROS"});

    public static Schema convert(MessageType messageType, Schema currentSchema, ParquetFormatConfig.ReadTemporalMode readTemporalMode, ParquetFormatConfig.Flavor datasetDefaultFlavor) {
        Schema schema = new Schema();
        for (int i = 0; i < messageType.getFieldCount(); ++i) {
            schema.addColumn(ParquetSchemaConverter.convertTypeToSchemaColumn(messageType, messageType.getType(i), currentSchema, readTemporalMode, datasetDefaultFlavor));
        }
        return schema;
    }

    private static SchemaColumn convertTypeToSchemaColumn(MessageType rootType, org.apache.parquet.schema.Type parquetType, Schema currentSchema, ParquetFormatConfig.ReadTemporalMode readTemporalMode, ParquetFormatConfig.Flavor datasetDefaultFlavor) {
        SchemaColumn currentColumn;
        SchemaColumn sc = new SchemaColumn();
        sc.setName(parquetType.getName());
        SchemaColumn schemaColumn = currentColumn = currentSchema != null ? currentSchema.getColumn(parquetType.getName()) : null;
        if (parquetType.isPrimitive()) {
            ParquetSchemaConverter.convertPrimitiveToSchemaColumn(parquetType, sc, currentColumn, readTemporalMode);
        } else {
            GroupType groupType = parquetType.asGroupType();
            if (groupType.getOriginalType() == OriginalType.LIST) {
                ParquetSchemaConverter.convertList(sc, rootType, groupType, currentSchema, readTemporalMode, datasetDefaultFlavor);
            } else if (groupType.getOriginalType() == OriginalType.MAP) {
                org.apache.parquet.schema.Type keyType = groupType.getType(0).asGroupType().getType(0);
                org.apache.parquet.schema.Type valueType = groupType.getType(0).asGroupType().getType(1);
                sc.mapKeys = ParquetSchemaConverter.convertTypeToSchemaColumn(rootType, keyType, currentSchema, readTemporalMode, datasetDefaultFlavor);
                sc.mapValues = ParquetSchemaConverter.convertTypeToSchemaColumn(rootType, valueType, currentSchema, readTemporalMode, datasetDefaultFlavor);
                sc.setType(Type.MAP);
            } else {
                sc.objectFields = new ArrayList();
                for (int i = 0; i < groupType.getFieldCount(); ++i) {
                    sc.objectFields.add(ParquetSchemaConverter.convertTypeToSchemaColumn(rootType, groupType.getType(i), currentSchema, readTemporalMode, datasetDefaultFlavor));
                }
                sc.setType(Type.OBJECT);
            }
        }
        return sc;
    }

    private static void convertPrimitiveToSchemaColumn(org.apache.parquet.schema.Type parquetType, SchemaColumn sc, SchemaColumn currentColumn, ParquetFormatConfig.ReadTemporalMode readTemporalMode) {
        PrimitiveType pt = parquetType.asPrimitiveType();
        PrimitiveType.PrimitiveTypeName ptn = pt.getPrimitiveTypeName();
        String originalTypeStr = pt.getOriginalType() != null ? pt.getOriginalType().toString() : "";
        switch (ptn) {
            case BINARY: {
                if (parquetType.getOriginalType() == OriginalType.DECIMAL && pt.getDecimalMetadata() != null) {
                    sc.setType(Type.DOUBLE);
                    sc.withOriginalType("decimal(" + pt.getDecimalMetadata().getPrecision() + "," + pt.getDecimalMetadata().getScale() + ")");
                    break;
                }
                sc.setType(Type.STRING);
                break;
            }
            case BOOLEAN: {
                sc.setType(Type.BOOLEAN);
                break;
            }
            case DOUBLE: {
                sc.setType(Type.DOUBLE);
                break;
            }
            case FIXED_LEN_BYTE_ARRAY: {
                if (parquetType.getOriginalType() == OriginalType.DECIMAL && pt.getDecimalMetadata() != null) {
                    sc.setType(Type.DOUBLE);
                    sc.withOriginalType("decimal(" + pt.getDecimalMetadata().getPrecision() + "," + pt.getDecimalMetadata().getScale() + ")");
                    break;
                }
                sc.setType(Type.STRING);
                break;
            }
            case FLOAT: {
                sc.setType(Type.FLOAT);
                break;
            }
            case INT32: {
                ParquetSchemaConverter.convertInt32ToSchemaColumn(parquetType, pt, sc, currentColumn, readTemporalMode);
                break;
            }
            case INT64: {
                ParquetSchemaConverter.convertInt64ToSchemaColumn(parquetType, pt, sc, originalTypeStr, currentColumn, readTemporalMode);
                break;
            }
            case INT96: {
                sc.setType(Type.DATE);
                break;
            }
            default: {
                throw new NotImplementedException("DSS doesn't support Parquet/" + String.valueOf(ptn));
            }
        }
    }

    private static void convertInt64ToSchemaColumn(org.apache.parquet.schema.Type parquetType, PrimitiveType pt, SchemaColumn sc, String originalTypeStr, SchemaColumn currentColumn, ParquetFormatConfig.ReadTemporalMode readTemporalMode) {
        if (parquetType.getOriginalType() == OriginalType.DECIMAL && pt.getDecimalMetadata() != null) {
            sc.setType(Type.DOUBLE);
            sc.withOriginalType("decimal(" + pt.getDecimalMetadata().getPrecision() + "," + pt.getDecimalMetadata().getScale() + ")");
        } else if (TIMESTAMP_ORIGINAL_TYPES.contains(originalTypeStr)) {
            boolean isAdjustedToUTC;
            boolean isMicros;
            block14: {
                isMicros = originalTypeStr.equals("TIMESTAMP_MICROS");
                isAdjustedToUTC = true;
                if (!hasLoggedReflectionError) {
                    try {
                        Method getAnnotationMethod = parquetType.getClass().getMethod("getLogicalTypeAnnotation", new Class[0]);
                        Object annotation = getAnnotationMethod.invoke((Object)parquetType, new Object[0]);
                        if (annotation != null && annotation.getClass().getSimpleName().equals("TimestampLogicalTypeAnnotation")) {
                            Method isAdjustedToUTCMethod = annotation.getClass().getMethod("isAdjustedToUTC", new Class[0]);
                            isAdjustedToUTC = (Boolean)isAdjustedToUTCMethod.invoke(annotation, new Object[0]);
                        }
                    }
                    catch (Exception e) {
                        if (hasLoggedReflectionError) break block14;
                        Logger.getLogger((String)"dip.parquet").info((Object)"Unable to get logicaltype annotation", (Throwable)e);
                        hasLoggedReflectionError = true;
                    }
                }
            }
            if (currentColumn != null && currentColumn.getType() == Type.DATE) {
                sc.withOriginalType(isMicros ? "date_micro" : "date_milli");
                sc.setType(Type.DATE);
            } else if (readTemporalMode == ParquetFormatConfig.ReadTemporalMode.AS_TEMPORAL) {
                if (isAdjustedToUTC) {
                    sc.setType(Type.DATE);
                } else {
                    sc.setType(Type.DATETIMENOTZ);
                }
            } else {
                sc.setType(Type.BIGINT);
            }
        } else {
            sc.setType(Type.BIGINT);
        }
    }

    private static void convertInt32ToSchemaColumn(org.apache.parquet.schema.Type parquetType, PrimitiveType pt, SchemaColumn sc, SchemaColumn currentColumn, ParquetFormatConfig.ReadTemporalMode readTemporalMode) {
        if (parquetType.getOriginalType() == OriginalType.DECIMAL && pt.getDecimalMetadata() != null) {
            sc.setType(Type.DOUBLE);
            sc.withOriginalType("decimal(" + pt.getDecimalMetadata().getPrecision() + "," + pt.getDecimalMetadata().getScale() + ")");
        } else if (parquetType.getOriginalType() == OriginalType.DATE) {
            sc.setType(Type.DATEONLY);
            if (currentColumn != null && currentColumn.getType() == Type.DATE) {
                sc.withOriginalType("date_day");
                sc.setType(Type.DATE);
            } else if (readTemporalMode == ParquetFormatConfig.ReadTemporalMode.AS_TEMPORAL) {
                sc.setType(Type.DATEONLY);
            } else {
                sc.setType(Type.INT);
            }
        } else {
            sc.setType(Type.INT);
        }
    }

    private static void convertList(SchemaColumn sc, MessageType rootType, GroupType groupType, Schema currentSchema, ParquetFormatConfig.ReadTemporalMode readTemporalMode, ParquetFormatConfig.Flavor datasetDefaultFlavor) {
        ParquetFormatConfig.Flavor flavor = RowTupleConverter.messageTypeNameToFlavor(rootType.getName(), datasetDefaultFlavor);
        switch (flavor) {
            case SPARK: 
            case HIVE: {
                org.apache.parquet.schema.Type elementType = groupType.getType(0).asGroupType().getType(0);
                sc.setType(Type.ARRAY);
                sc.arrayContent = ParquetSchemaConverter.convertTypeToSchemaColumn(rootType, elementType, currentSchema, readTemporalMode, datasetDefaultFlavor);
                break;
            }
            case PIG: {
                org.apache.parquet.schema.Type elementType = groupType.getType(0);
                sc.setType(Type.ARRAY);
                sc.arrayContent = ParquetSchemaConverter.convertTypeToSchemaColumn(rootType, elementType, currentSchema, readTemporalMode, datasetDefaultFlavor);
                break;
            }
        }
    }
}

