/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.parquet;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.input.formats.parquet.DSSParquetInputFormat;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.input.formats.parquet.RowMaterializer;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;

public class RowConverter
extends ReadSupport<Row> {
    private final ColumnFactory columnFactory;
    private final RowFactory rowFactory;
    private final DSSParquetInputFormat dssParquetInputFormat;
    private final boolean representsNullFields;
    private final ParquetFormatConfig.Flavor datasetDefaultFlavor;

    public RowConverter() {
        this.columnFactory = null;
        this.rowFactory = null;
        this.dssParquetInputFormat = null;
        this.representsNullFields = false;
        this.datasetDefaultFlavor = ParquetFormatConfig.Flavor.HIVE;
    }

    public RowConverter(DSSParquetInputFormat dssParquetInputFormat, ColumnFactory cf, RowFactory rf, boolean representsNullFields, ParquetFormatConfig.Flavor datasetDefaultFlavor) {
        this.columnFactory = cf;
        this.representsNullFields = representsNullFields;
        this.dssParquetInputFormat = dssParquetInputFormat;
        this.rowFactory = rf;
        this.datasetDefaultFlavor = datasetDefaultFlavor;
    }

    public ReadSupport.ReadContext init(InitContext ic) {
        return new ReadSupport.ReadContext(ic.getFileSchema());
    }

    public RecordMaterializer<Row> prepareForRead(Configuration conf, Map<String, String> metadata, MessageType schema, ReadSupport.ReadContext readContext) {
        assert (this.dssParquetInputFormat != null);
        return new RowMaterializer(this.dssParquetInputFormat, schema, this.columnFactory, this.rowFactory, this.representsNullFields, this.datasetDefaultFlavor);
    }
}

