/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.io;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.containers.exec.ContainerExecImagesHelper;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.containers.exec.DockerExecUtils;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.io.JavaBlockLink;
import com.dataiku.dip.io.KernelErrorCodes;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.io.ResponderKernelLink;
import com.dataiku.dip.io.SimplePythonKernel;
import com.dataiku.dip.kernels.DSSKernelBase;
import com.dataiku.dip.remoterun.RemoteRunEnvDef;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.RegularProcess;
import com.dataiku.dip.security.rpc.EncryptedRPC;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Level;

public class DockerSimplePythonKernel
extends DSSKernelBase
implements SimplePythonKernel {
    private final ContainerExecRuntimeConfig containerConfig;
    private ResponderKernelLink link;
    private final String identifier;
    private final String executionId;
    private final String projectKey;
    private final AuthCtx authCtx;
    private final File workDir;
    private final String containerName;
    private final String pythonModule;
    private final String prefix;
    private final List<CodeEnvModel.EnvFullRef> codeEnvs;
    private String imageTag;
    private final Boolean loadInstanceLibs;
    private final Boolean loadProjectLibs;
    private final DKULogger logger;
    private final Map<String, String> extraEnv = new HashMap<String, String>();
    private final List<String> readablePaths = new ArrayList<String>();
    private String executionPath;
    private APITicketService.Ticket ticket;
    private static final DKULogger loggerAdditive = DKULogger.getLogger((String)"com.dataiku.dip.io");
    public static final DKULogger loggerNotAdditive = DKULogger.getLogger((String)"notadditive.com.dataiku.dip.io");

    DockerSimplePythonKernel(String id, AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, CodeEnvModel.UsedCodeEnvRef codeEnvRef, String pythonModule, String prefix, boolean loadInstanceLibs, boolean loadProjectLibs, boolean additiveLogging) throws IOException {
        super(id);
        this.projectKey = projectKey;
        this.authCtx = authCtx;
        this.identifier = SecretKeyGenerator.generateSmall();
        this.executionId = KubernetesExecUtils.getNormalizedExecutionId(prefix + this.identifier);
        this.containerName = "dku_exec-" + this.executionId;
        this.containerConfig = containerConfig;
        this.workDir = DSSTempUtils.getTempFolder((String)this.containerName);
        this.pythonModule = pythonModule;
        this.prefix = prefix;
        this.loadInstanceLibs = loadInstanceLibs;
        this.loadProjectLibs = loadProjectLibs;
        if (codeEnvRef == null) {
            this.codeEnvs = Collections.emptyList();
            this.imageTag = ContainerExecImagesHelper.getBaseImageTag(containerConfig.baseImage, ContainerExecUtils.BaseImageType.EXEC);
        } else {
            String envVersion = ((CodeEnvResolutionService)SpringUtils.getBean(CodeEnvResolutionService.class)).getEnvVersionToUseForContainerImageLookup(codeEnvRef.envName, codeEnvRef.envLang, projectKey);
            CodeEnvModel.EnvFullRef envRef = new CodeEnvModel.EnvFullRef(CodeEnvModel.EnvLang.PYTHON, codeEnvRef.envName, envVersion);
            this.codeEnvs = Collections.singletonList(envRef);
            this.imageTag = ContainerExecImagesHelper.getImageTagToUse(containerConfig.dockerHost, containerConfig.baseImage, ContainerExecUtils.BaseImageType.EXEC, codeEnvRef.envLang, codeEnvRef.envName, envVersion);
            this.imageTag = ContainerExecImagesHelper.withRepositoryURL(containerConfig.repositoryURL, this.imageTag);
        }
        this.logger = additiveLogging ? loggerAdditive : loggerNotAdditive;
    }

    @Override
    public DockerSimplePythonKernel withExtraEnv(Map<String, String> extraEnv) {
        this.extraEnv.putAll(extraEnv);
        return this;
    }

    @Override
    public DockerSimplePythonKernel withReadablePaths(List<String> readablePaths) {
        this.readablePaths.addAll(readablePaths);
        return this;
    }

    @Override
    public DockerSimplePythonKernel withExecutionPath(String executionPath) {
        this.executionPath = executionPath;
        return this;
    }

    @Override
    public void start() throws IOException, InterruptedException, CodedException {
        if (this.link != null) {
            throw new IllegalStateException("Kernel already started");
        }
        ComputeResourceUsage computeResourceUsage = new ComputeResourceUsage();
        try (FutureProgress.AutocloseableFutureProgressState fp = FutureProgress.pushAutoCloseableState((String)"Initializing docker kernel", (double)1.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            FutureProgress.updateState((double)0.0);
            PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
            this.link = new ResponderKernelLink(dssPortRange, EncryptedRPC.getSSLContext());
            final APITicketService ticketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
            this.ticket = ticketService.createTicket(this.authCtx, this.prefix + this.projectKey + "-" + this.identifier, null);
            this.addOnShutdown(new Runnable(){

                @Override
                public void run() {
                    ticketService.expireTicket(DockerSimplePythonKernel.this.ticket);
                }
            });
            JsonObject definition = new JsonObject();
            definition.addProperty("port", (Number)this.link.getPort());
            definition.addProperty("secret", this.link.getSecret());
            definition.addProperty("server_cert", EncryptedRPC.getPEMCertificateTextB64orNA());
            definition.addProperty("module", this.pythonModule);
            definition.addProperty("load_instance_libs", this.loadInstanceLibs);
            definition.addProperty("load_project_libs", this.loadProjectLibs);
            RemoteRunsRegistry.add(this.executionId, this.authCtx, this.projectKey, null, this.executionPath, RemoteRunsRegistry.ExecutionType.SIMPLE_PYTHON, definition.toString(), null, this.readablePaths, Collections.emptyList(), this.codeEnvs);
            EnvironmentStash environmentStash = new EnvironmentStash();
            environmentStash.fillDefaultForRemote().fillCommunicationVars();
            RemoteRunEnvDef envResource = new RemoteRunEnvDef();
            environmentStash.copyToRemoteRunEnvDef(envResource, false, false, false);
            envResource.runsRemotely = true;
            envResource.jobId = this.executionId;
            RemoteRunsRegistry.get((String)this.executionId).envResource = envResource;
            Map<String, String> env = environmentStash.getAsEnvVariables(false, false, false);
            Pattern excludedEnvVarsPattern = this.containerConfig.getExcludedEnvVarsPattern();
            env.putAll(this.extraEnv);
            env.entrySet().removeIf(envEntry -> excludedEnvVarsPattern.matcher((CharSequence)envEntry.getKey()).matches());
            ArrayList<String> dockerArgs = new ArrayList<String>();
            dockerArgs.add("--name");
            dockerArgs.add(this.containerName);
            dockerArgs.add("-e");
            dockerArgs.add("DKU_API_TICKET");
            dockerArgs.add("-e");
            dockerArgs.add("DKU_CURRENT_PROJECT_KEY");
            env.keySet().stream().forEach(k -> {
                dockerArgs.add("-e");
                dockerArgs.add((String)k);
            });
            List<String> dockerRunCommand = DockerExecUtils.getDockerRunCommand(this.authCtx, RemoteRunsRegistry.ExecutionType.SIMPLE_PYTHON, this.projectKey, null, null, this.containerConfig, dockerArgs.toArray(new String[0]));
            dockerRunCommand.addAll(DockerExecUtils.getEnvironmentCommandFlags(this.containerConfig));
            dockerRunCommand.addAll(Lists.newArrayList((Object[])new String[]{this.imageTag, this.executionId}));
            final ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.directory(this.workDir);
            pb.command(dockerRunCommand);
            ContainerExecUtils.enrichDockerEnv(this.containerConfig, pb.environment());
            pb.environment().put("DKU_API_TICKET", this.ticket.getSecret());
            pb.environment().put("DKU_CURRENT_PROJECT_KEY", this.projectKey);
            pb.environment().putAll(this.extraEnv);
            this.process = new RegularProcess(pb, this.workDir){

                public void niceKill() {
                    ContainerExecUtils.killDockerContainer(DockerSimplePythonKernel.this.containerName, false, pb.environment(), DockerSimplePythonKernel.this.logger);
                }

                public void evilKill() throws IOException {
                    ContainerExecUtils.killDockerContainer(DockerSimplePythonKernel.this.containerName, true, pb.environment(), DockerSimplePythonKernel.this.logger);
                    super.evilKill();
                }
            };
            this.process.start();
            computeResourceUsage.reportStartNoFail();
            this.startStandardTailers();
            this.monitorThread = new DSSKernelBase.KernelMonitorThread((DSSKernelBase)this);
            this.monitorThread.setCloseOnFailure((Closeable)this);
            this.monitorThread.start();
            this.link.waitForProcess();
            FutureProgress.updateState((double)1.0);
            computeResourceUsage.reportCompleteNoFail();
        }
        catch (Exception e) {
            computeResourceUsage.markComplete();
            this.close();
            throw new CodedException((InfoMessage.MessageCode)KernelErrorCodes.ERR_COMPUTE_KERNEL_FAILURE, "Docker kernel failed to start", (Throwable)e);
        }
        finally {
            if (this.monitorThread != null) {
                this.monitorThread.setCloseOnFailure(null);
            }
        }
    }

    protected void startStandardTailers() throws IOException {
        this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(this.logger, Level.INFO));
        this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder));
        this.outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(this.logger, Level.INFO));
        this.outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder));
    }

    @Override
    public APITicketService.Ticket getTicket() {
        return this.ticket;
    }

    @Override
    public String getType() {
        return "docker";
    }

    @Override
    public JavaBlockLink getLink() {
        return this.link != null ? this.link.getBlockLink() : null;
    }

    @Override
    public boolean isAlive() {
        return !this.killed && this.link.isAlive() && !this.isFinished();
    }

    @Override
    public AuthCtx getAuthCtx() {
        return this.authCtx;
    }

    @Override
    public void close() throws IOException {
        this.logger.info((Object)"Killing docker kernel");
        try {
            try {
                this.link.close();
            }
            catch (IOException e) {
                this.logger.error((Object)"Could not close Javalink", (Throwable)e);
            }
            try {
                if (!this.killed) {
                    this.killWithoutMercy();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted while killing docker kernel", e);
            }
        }
        finally {
            RemoteRunsRegistry.remove(this.executionId);
            boolean keepTempFolder = DKUApp.getParams().getBoolParam("dku.pythonKernel.keepTempFolder", false);
            if (!keepTempFolder) {
                ((AutoDelete)this.workDir).close();
            }
        }
    }

    @Override
    public void appendKernelLogsToLogFile(File deploymentLogFile) throws FileNotFoundException {
        PrintWriter writer = new PrintWriter(new FileOutputStream(deploymentLogFile, true), true);
        this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.OutputWriterSubscription((Writer)writer, true));
        this.outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.OutputWriterSubscription((Writer)writer, true));
    }

    @Override
    public void appendKernelLogsToSubscription(DKUtils.LineSubscription subscription) {
        this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)subscription);
        this.outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)subscription);
    }

    @Override
    public DKUtils.SmartLogTailBuilder getSmartLogTailBuilder() {
        return this.smartLogTailBuilder;
    }

    static {
        loggerNotAdditive.setAdditivity(false);
    }
}

