/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.audit;

import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.PathUtils;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.util.Base64;
import java.util.UUID;
import org.springframework.stereotype.Service;

@Service
public class ImageAuditManagedFolderService {
    public static final DKULogger logger = DKULogger.getLogger((String)"dip.llm.audit.images");

    public String saveImage(String imageData, ImageAuditSource auditSource, ManagedFolderHandler folderHandler) throws IOException, CodedException, DKUSecurityException, InterruptedException {
        String imgId = UUID.randomUUID().toString();
        String imagePath = ImageAuditManagedFolderService.getImagePath(imgId, auditSource);
        byte[] data = Base64.getDecoder().decode(imageData);
        try (ByteArrayInputStream in = new ByteArrayInputStream(data);
             OutputStream out = folderHandler.getOutputStream(imagePath);){
            logger.info((Object)String.format("Writing image '%s' in managed folder '%s'.", imagePath, folderHandler.getFolder().name));
            ByteStreams.copy((InputStream)in, (OutputStream)out);
        }
        return imagePath;
    }

    private static String getImagePath(String imgId, ImageAuditSource imageAuditSource) {
        return PathUtils.concatLNT((String[])new String[]{imageAuditSource.auditRootDirectory, LocalDate.now().toString(), imgId + ".png"});
    }

    public static enum ImageAuditSource {
        IMAGE_GENERATION_INPUT("image-generation-inputs"),
        IMAGE_GENERATION_OUTPUT("image-generation-outputs"),
        TEXT_GENERATION_INPUT("text-generation-inputs");

        public final String auditRootDirectory;

        private ImageAuditSource(String auditRootFolder) {
            this.auditRootDirectory = auditRootFolder;
        }
    }
}

