/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.utils;

import com.dataiku.common.rpc.ExternalJSONAPIClient;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dss.shadelib.org.apache.http.ConnectionClosedException;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.NoHttpResponseException;
import com.dataiku.dss.shadelib.org.apache.http.client.HttpRequestRetryHandler;
import com.dataiku.dss.shadelib.org.apache.http.client.ServiceUnavailableRetryStrategy;
import com.dataiku.dss.shadelib.org.apache.http.conn.ConnectTimeoutException;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.HttpClientBuilder;
import com.dataiku.dss.shadelib.org.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.function.Consumer;

public class OnlineLLMUtils {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.llm.online.utils");

    public static long backoffDelay(AbstractLLMConnection.HTTPBasedLLMNetworkSettings networkSettings, int executionCount) {
        return (long)((double)networkSettings.initialRetryDelayMS * Math.pow(networkSettings.retryDelayScalingFactor, executionCount - 1));
    }

    public static boolean retryRequired(int statusCode) {
        return statusCode == 429 || statusCode == 502 || statusCode == 503;
    }

    private static void backoffSleep(AbstractLLMConnection.HTTPBasedLLMNetworkSettings networkSettings, int executionCount) {
        long backoffDelay = OnlineLLMUtils.backoffDelay(networkSettings, executionCount);
        logger.infoV("Backing-off retry, executionCount=%d, will retry after delay=%d", new Object[]{executionCount, backoffDelay});
        try {
            Thread.sleep(backoffDelay);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.info((Object)"Interrupted while sleeping");
        }
    }

    public static void add429RetryStrategy(HttpClientBuilder builder, final AbstractLLMConnection.HTTPBasedLLMNetworkSettings networkSettings) {
        ServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy = new ServiceUnavailableRetryStrategy(){

            public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
                if (response.getStatusLine().getStatusCode() > 299 && executionCount <= networkSettings.maxRetries) {
                    logger.infoV("Request to the LLM failed with status %d. Considering retry. Count=%d/%d", new Object[]{response.getStatusLine().getStatusCode(), executionCount, networkSettings.maxRetries});
                    if (OnlineLLMUtils.retryRequired(response.getStatusLine().getStatusCode())) {
                        OnlineLLMUtils.backoffSleep(networkSettings, executionCount);
                        return true;
                    }
                }
                return false;
            }

            public long getRetryInterval() {
                return 1000L;
            }
        };
        builder.setServiceUnavailableRetryStrategy(serviceUnavailableRetryStrategy);
        if (builder instanceof ExternalJSONAPIClient.CustomHttpClientBuilder) {
            builder.setRetryHandler((HttpRequestRetryHandler)new SafeRetryHandler(((ExternalJSONAPIClient.CustomHttpClientBuilder)builder).getCloseCallback(), networkSettings));
        } else {
            builder.setRetryHandler((HttpRequestRetryHandler)new SafeRetryHandler(null, networkSettings));
        }
    }

    public static ExternalJSONAPIClient getExternalJSONClientWithRetryStrategy(String baseURI, String serverCertPEM, boolean trustAllSSLCertificates, ProxySettings proxySettings, AbstractLLMConnection.HTTPBasedLLMNetworkSettings networkSettings) {
        Consumer<HttpClientBuilder> customizeBuilderCallback = builder -> OnlineLLMUtils.add429RetryStrategy(builder, networkSettings);
        return new ExternalJSONAPIClient(baseURI, serverCertPEM, trustAllSSLCertificates, proxySettings, OnlineLLMUtils.getLLMResponseRetryStrategy(networkSettings), customizeBuilderCallback);
    }

    public static boolean isRequestSuccessful(HttpResponse response) {
        int status = response.getStatusLine().getStatusCode();
        return status / 100 == 2;
    }

    public static ExternalJSONAPIClient.ResponseRetryStrategy getLLMResponseRetryStrategy(final AbstractLLMConnection.HTTPBasedLLMNetworkSettings networkSettings) {
        return new ExternalJSONAPIClient.ResponseRetryStrategy(){

            public boolean canRetry(IOException e, HttpResponse response, int executionCount) {
                if (executionCount <= networkSettings.maxRetries) {
                    logger.infoV("Response parsing failed with exception %s. Considering retry. Count=%d/%d", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e), executionCount, networkSettings.maxRetries});
                    if (OnlineLLMUtils.isRequestSuccessful(response) && (e instanceof ConnectionClosedException || e.getCause() instanceof ConnectionClosedException)) {
                        OnlineLLMUtils.backoffSleep(networkSettings, executionCount);
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static ExternalJSONAPIClient getExternalJSONClientWithBuilderCallback(String baseURI, String serverCertPEM, boolean trustAllSSLCertificates, ProxySettings proxySettings, AbstractLLMConnection.HTTPBasedLLMNetworkSettings networkSettings, Consumer<HttpClientBuilder> customizeBuilderCallback) {
        return new ExternalJSONAPIClient(baseURI, serverCertPEM, trustAllSSLCertificates, proxySettings, customizeBuilderCallback);
    }

    public static boolean isRetryableException(Throwable t) {
        return OnlineLLMUtils.isRetryableJSONAPIClientException(t) || t instanceof ConnectionClosedException || t instanceof NoHttpResponseException || t instanceof SocketTimeoutException || t instanceof ConnectTimeoutException || t instanceof SocketException;
    }

    private static boolean isRetryableJSONAPIClientException(Throwable t) {
        if (t instanceof ExternalJSONAPIClient.JSONAPIClientException) {
            ExternalJSONAPIClient.JSONAPIClientException exception = (ExternalJSONAPIClient.JSONAPIClientException)t;
            return OnlineLLMUtils.retryRequired(exception.httpCode);
        }
        return false;
    }

    static class SafeRetryHandler
    implements HttpRequestRetryHandler {
        private ExternalJSONAPIClient.CloseCallback cb;
        private AbstractLLMConnection.HTTPBasedLLMNetworkSettings networkSettings;

        public SafeRetryHandler(ExternalJSONAPIClient.CloseCallback closeCallback, AbstractLLMConnection.HTTPBasedLLMNetworkSettings settings) {
            this.cb = closeCallback;
            this.networkSettings = settings;
        }

        public boolean isClosed() {
            if (this.cb != null) {
                return this.cb.isClosed();
            }
            return false;
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            if (this.isClosed()) {
                logger.info((Object)"LLM connection has been closed or interrupted. Not retrying");
                return false;
            }
            if (executionCount <= this.networkSettings.maxRetries) {
                logger.infoV("Request to the LLM failed with exception %s. Retrying. Count=%d/%d", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)exception), executionCount, this.networkSettings.maxRetries});
                OnlineLLMUtils.backoffSleep(this.networkSettings, executionCount);
                return true;
            }
            return false;
        }
    }
}

