/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.utils;

import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.LLMTracingUtils;
import com.dataiku.dip.llm.utils.StreamingChunkEmitter;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.mutable.MutableBoolean;

public class StreamingConsumer
implements LLMClient.StreamedCompletionResponseConsumer {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.utils.StreamingConsumer");
    final StringBuilder completeText = new StringBuilder();
    final List<LLMClient.AbstractToolCall> completeToolCalls = new ArrayList<LLMClient.AbstractToolCall>();
    final List<LLMClient.DetailedLogProb> allLogProbs = new ArrayList<LLMClient.DetailedLogProb>();
    final List<LLMClient.Artifact> completeArtifacts = new ArrayList<LLMClient.Artifact>();
    final MutableBoolean firstChunkReceived = new MutableBoolean(false);
    final StreamingChunkEmitter emitter;
    LLMClient.LLMMeshTraceSpan callSpan;
    LLMClient.LLMMeshTraceSpan trace;
    LLMClient.StreamedCompletionResponseFooter footer;

    public StreamingConsumer(StreamingChunkEmitter streamingChunkEmitter) {
        this.emitter = streamingChunkEmitter;
    }

    public LLMClient.SimpleCompletionResponseOrError buildSimpleCompletionResponseOrErrorFromStreamingInterrupted() {
        this.callSpan.withChildEvent("DKU_LLM_MESH_LLM_CALL_STREAM_INTERRUPTED");
        LLMClient.SimpleCompletionResponseOrError scre = LLMClient.SimpleCompletionResponseOrError.blank();
        scre.ok = true;
        scre.text = this.completeText.toString();
        scre.logProbs = this.allLogProbs;
        scre.toolCalls = this.completeToolCalls;
        scre.artifacts = this.completeArtifacts;
        LLMTracingUtils.setCompletionOutput(this.callSpan, scre);
        LLMTracingUtils.setCompletionOutput(this.trace, scre);
        this.callSpan.close();
        this.trace.close();
        scre.trace = this.trace;
        return scre;
    }

    public LLMClient.SimpleCompletionResponseOrError buildSimpleCompletionResponseOrErrorFromSuccess() {
        LLMClient.SimpleCompletionResponseOrError scre = LLMClient.SimpleCompletionResponseOrError.blank();
        scre.ok = true;
        if (this.footer.finishReason != null) {
            scre.finishReason = this.footer.finishReason;
        } else {
            logger.debug((Object)String.format("The streamed answer does not include a finish reason, defaulting to '%s'", new Object[]{scre.finishReason}));
        }
        scre.promptTokens = this.footer.promptTokens;
        scre.completionTokens = this.footer.completionTokens;
        if (this.footer.promptTokens != null || this.footer.completionTokens != null) {
            scre.totalTokens = (this.footer.promptTokens != null ? this.footer.promptTokens : 0) + (this.footer.completionTokens != null ? this.footer.completionTokens : 0);
        }
        scre.tokenCountsAreEstimated = this.footer.tokenCountsAreEstimated;
        scre.estimatedCost = this.footer.estimatedCost;
        scre.additionalInformation = this.footer.additionalInformation;
        scre.artifacts = this.completeArtifacts;
        scre.trace = this.footer.trace;
        scre.text = this.completeText.toString();
        scre.logProbs = this.allLogProbs;
        scre.toolCalls = this.completeToolCalls;
        logger.info((Object)("Done streaming answer from LLM: " + JSON.json((Object)scre)));
        return scre;
    }

    @Override
    public void onStreamStarted() throws Exception {
        logger.debug((Object)"Stream started");
        this.emitter.initSuccess();
    }

    @Override
    public void onStreamChunk(LLMClient.StreamedCompletionResponseChunk chunk) throws Exception {
        if (!this.firstChunkReceived.booleanValue()) {
            logger.debug((Object)"First chunk received");
            this.callSpan.withChildEvent("DKU_LLM_MESH_LLM_CALL_STREAMED_FIRST_CHUNK");
            this.firstChunkReceived.setValue(true);
        }
        if (chunk.toolCalls != null) {
            this.completeToolCalls.addAll(chunk.toolCalls);
        }
        if (chunk.text != null) {
            this.completeText.append(chunk.text);
        }
        if (chunk.logProbs != null && !chunk.logProbs.isEmpty()) {
            this.allLogProbs.addAll(chunk.logProbs);
        }
        if (chunk.artifacts != null) {
            this.completeArtifacts.addAll(chunk.artifacts);
        }
        this.emitter.emitCompletionChunk(chunk);
    }

    @Override
    public void onStreamComplete(LLMClient.StreamedCompletionResponseFooter streamedCompletionResponseFooter) throws Exception {
        logger.info((Object)("onStreamComplete: " + JSON.json((Object)streamedCompletionResponseFooter)));
        this.callSpan.withChildEvent("DKU_LLM_MESH_LLM_CALL_STREAMED_STREAM_COMPLETE");
        LLMClient.SimpleCompletionResponseOrError screForTrace = LLMClient.SimpleCompletionResponseOrError.blank();
        screForTrace.text = this.completeText.toString();
        screForTrace.toolCalls = this.completeToolCalls;
        screForTrace.ok = true;
        LLMTracingUtils.setCompletionOutput(this.callSpan, screForTrace);
        LLMTracingUtils.setCompletionOutput(this.trace, screForTrace);
        this.callSpan.usageMetadata = new LLMClient.UsageMetadata(streamedCompletionResponseFooter);
        this.callSpan.close();
        this.trace.close();
        if (streamedCompletionResponseFooter.trace != null) {
            this.callSpan.addObservation(streamedCompletionResponseFooter.trace);
        }
        this.footer = streamedCompletionResponseFooter;
        this.footer.trace = this.trace;
        this.emitter.emitCompletionFooter(this.footer);
    }

    public void setCallSpan(LLMClient.LLMMeshTraceSpan callSpan) {
        this.callSpan = callSpan;
    }

    public void setTraceSpan(LLMClient.LLMMeshTraceSpan trace) {
        this.trace = trace;
    }
}

