/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.probes;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.filter.GrelExpression;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.streamimpl.StreamColumn;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.input.formats.csv.CSVDeserializer;
import com.dataiku.dip.meanings.IBasicMeaningsService;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricMetadata;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.engines.DSSMetricsEngine;
import com.dataiku.dip.metrics.engines.HiveMetricsEngine;
import com.dataiku.dip.metrics.engines.ImpalaMetricsEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.engines.MetricsQueryBuilder;
import com.dataiku.dip.metrics.engines.SQLMetricsEngine;
import com.dataiku.dip.metrics.engines.SparkMetricsEngine;
import com.dataiku.dip.metrics.probes.MetricBuilder;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeConfiguration;
import com.dataiku.dip.metrics.probes.ProbeMetadata;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.HiveSQLDialect;
import com.dataiku.dip.sql.ImpalaSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CellProbeType
extends ProbeType
implements MetricBuilder {
    public static final String TYPE = "cell";
    private static Logger logger = Logger.getLogger((String)"dku.datasets.metrics.cell");

    private static String applyMode(CellValueRetrievalMode mode, List<String> values) throws Exception {
        switch (mode) {
            case MULTI_CELL: {
                return JSON.json(values);
            }
            case FIRST_CELL_OR_NONE: {
                return values.size() > 0 ? values.get(0) : null;
            }
            case SINGLE_CELL_STRICT: {
                if (values.size() != 1) {
                    throw new Exception("Expected 1 value, got " + values.size());
                }
                return values.get(0);
            }
            case SINGLE_CELL_OR_NONE: {
                if (values.size() > 1) {
                    throw new Exception("Expected at most 1 value, got " + values.size());
                }
                return values.size() > 0 ? values.get(0) : null;
            }
        }
        return null;
    }

    @Override
    public List<MetricComputer> getComputers(IBasicMeaningsService basicMeaningsService) {
        ArrayList computers = Lists.newArrayList();
        computers.add(new StreamCellValueComputer());
        computers.add(new CellSQLMetricsEngineComputer(new CellSQLLikeEngineComputer()));
        computers.add(new CellImpalaMetricsEngineComputer(new CellSQLLikeEngineComputer()));
        computers.add(new CellHiveMetricsEngineComputer(new CellSQLLikeEngineComputer()));
        computers.add(new CellSparkMetricsEngineComputer(new CellSQLLikeEngineComputer()));
        return computers;
    }

    public CellProbeType() {
        this.type = TYPE;
    }

    private String getProbeName(Probe probe) {
        if (StringUtils.isNotBlank((String)probe.getMeta().getName())) {
            return probe.getMeta().getName();
        }
        CellProbeConfiguration configuration = probe.getConfigurationAs(CellProbeConfiguration.class);
        return FilterDescUtils.getFilterRepr(configuration.filter);
    }

    @Override
    public Object listSelectableMetrics(Probe probe, Object object, MetricTargetType objectType) {
        if (objectType == MetricTargetType.DATASET) {
            CellProbeConfiguration configuration = probe.getConfigurationAs(CellProbeConfiguration.class);
            CellProbeHint probeHint = new CellProbeHint();
            Dataset dataset = (Dataset)object;
            for (SchemaColumn column : dataset.getSchema().getColumns()) {
                CellColumnProbeHint columnHint = new CellColumnProbeHint(column.getName(), configuration.columns.contains(column.getName()));
                probeHint.columns.add(columnHint);
            }
            return probeHint;
        }
        return null;
    }

    @Override
    public List<Metric> getMetricsToCompute(Probe probe, Object object, MetricTargetType objectType, boolean forDisplay) {
        ArrayList metrics = Lists.newArrayList();
        HashSet metricIds = Sets.newHashSet();
        if (objectType == MetricTargetType.DATASET) {
            Dataset dataset = (Dataset)object;
            CellProbeConfiguration configuration = probe.getConfigurationAs(CellProbeConfiguration.class);
            for (String configured : configuration.columns) {
                SchemaColumn column = dataset.getSchema().getColumn(configured);
                if (column != null) {
                    CellMetric metric = new CellMetric(column.getName(), column.getType(), this.getProbeName(probe), probe.getConfigurationAs(CellProbeConfiguration.class).mode);
                    metrics.add(metric);
                    metricIds.add(metric.getId());
                    continue;
                }
                logger.warn((Object)("Configured a metric on '" + configured + "' which has disappeared since. Skipping."));
            }
        }
        return metrics;
    }

    @Override
    public ProbeConfiguration buildFullConfiguration(List<SchemaColumn> columns, Probe probe) {
        CellProbeConfiguration probeConfiguration = probe.getConfigurationAs(CellProbeConfiguration.class);
        CellProbeConfiguration configuration = new CellProbeConfiguration();
        configuration.filter = probeConfiguration.filter;
        for (SchemaColumn column : columns) {
            configuration.columns.add(column.getName());
        }
        return configuration;
    }

    @Override
    public ProbeType trimForSave() {
        return new CellProbeType();
    }

    @Override
    public Class<? extends ProbeConfiguration> getParamsClazz() {
        return CellProbeConfiguration.class;
    }

    @Override
    public ProbeMetadata getMeta() {
        return new ProbeMetadata().withLevel(9).withName("Cell value");
    }

    @Override
    public boolean isUserSelectedProbe() {
        return true;
    }

    @Override
    public Metric build(String name, Type dataType, Probe probe) {
        return new CellMetric(name, dataType, this.getProbeName(probe), probe.getConfigurationAs(CellProbeConfiguration.class).mode);
    }

    public static enum CellValueRetrievalMode {
        SINGLE_CELL_STRICT,
        SINGLE_CELL_OR_NONE,
        FIRST_CELL_OR_NONE,
        MULTI_CELL;

    }

    public static class StreamCellValueComputer
    extends DSSMetricsEngine.DSSMetricsEngineComputer {
        private FilterDesc filter;
        private CellValueRetrievalMode mode;

        public StreamCellValueComputer() {
        }

        public StreamCellValueComputer(CellProbeConfiguration configuration) {
            this.filter = configuration.filter;
            this.mode = configuration.mode;
        }

        @Override
        public String getProbeType() {
            return CellProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (metric instanceof CellMetric && objectType == MetricTargetType.DATASET) {
                CellProbeConfiguration configuration = probe.getConfigurationAs(CellProbeConfiguration.class);
                return new DSSMetricsEngine.DSSMetricsEngineRun().with(new MetricComputation(probe, new StreamCellValueComputer(configuration), metric, 10.0));
            }
            return null;
        }

        @Override
        public DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession start(DSSMetricsEngine.DSSMetricsEngineCallbacks engine, List<MetricComputation> computations, Map<String, String> alreadyComputed) throws Exception {
            StreamCellValueComputerSession session = new StreamCellValueComputerSession();
            computations.forEach(computation -> {
                computation.session = session;
            });
            VariablesContext vc = engine.getVariablesContext();
            FilterDescUtils.expand(this.filter, vc);
            session.computations = computations;
            session.filter = GrelExpression.build(FilterDescUtils.getGrelFilterExpression(this.filter), engine.getDataset().getSchema());
            session.filter.setColumnFactory((ColumnFactory)engine.getColumnFactory());
            session.engine = engine;
            session.columns = computations.stream().map(computation -> computation.metric).map(Metric::getColumn).map(column -> engine.getColumnFactory().column(column)).collect(Collectors.toSet());
            return session;
        }

        @Override
        public boolean accumulate(Row row, DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession dssComputerSession) throws Exception {
            StreamCellValueComputerSession session = (StreamCellValueComputerSession)dssComputerSession;
            if (!this.filter.enabled || session.filter.isTrueish(row)) {
                for (StreamColumn column : session.columns) {
                    session.values.computeIfAbsent(column, c2 -> new ArrayList());
                    session.values.get(column).add(row.get((Column)column));
                }
            }
            return true;
        }

        @Override
        public Map<Metric, String> getAggregates(DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession dssComputerSession) throws Exception {
            StreamCellValueComputerSession session = (StreamCellValueComputerSession)dssComputerSession;
            HashMap<Metric, String> aggregates = new HashMap<Metric, String>();
            for (MetricComputation computation : session.computations) {
                StreamColumn column = session.engine.getColumnFactory().column(computation.metric.getColumn());
                aggregates.put(computation.metric, CellProbeType.applyMode(this.mode, session.values.get(column)));
            }
            return aggregates;
        }

        @Override
        public JsonObject writeJson(JsonSerializationContext ctx) {
            JsonObject obj = new JsonObject();
            obj.add("filter", ctx.serialize((Object)this.filter, FilterDesc.class));
            obj.add("mode", ctx.serialize((Object)this.mode, CellValueRetrievalMode.class));
            return obj;
        }

        @Override
        public void readJson(JsonObject jsonObj, JsonDeserializationContext ctx) {
            this.filter = (FilterDesc)ctx.deserialize(jsonObj.get("filter"), FilterDesc.class);
            this.mode = (CellValueRetrievalMode)((Object)ctx.deserialize(jsonObj.get("mode"), CellValueRetrievalMode.class));
        }

        @Override
        public void cleanup(DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession dssComputerSession) throws Exception {
        }

        public static class StreamCellValueComputerSession
        implements DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession {
            public Set<StreamColumn> columns;
            public DSSMetricsEngine.DSSMetricsEngineCallbacks engine;
            public List<MetricComputation> computations;
            Map<StreamColumn, List<String>> values = new HashMap<StreamColumn, List<String>>();
            Expression filter;
        }
    }

    public static class CellSQLMetricsEngineComputer
    extends MetricComputer.SQLMetricsEngineComputer {
        private final CellSQLLikeEngineComputer subComputer;

        public CellSQLMetricsEngineComputer(CellSQLLikeEngineComputer subComputer) {
            this.subComputer = subComputer;
        }

        @Override
        public String getProbeType() {
            return CellProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (objectType == MetricTargetType.DATASET && DatasetInspector.isSQLAble(authCtx, (Dataset)object)) {
                Dataset dataset = (Dataset)object;
                try {
                    CellProbeConfiguration configuration = probe.getConfigurationAs(CellProbeConfiguration.class);
                    AbstractSQLConnection connection = DatasetInspector.getDSSConnectionForSQLAbleDatasetOrHive(authCtx, dataset);
                    SQLDialect dialect = connection.getDialect();
                    String filterSql = FilterDescUtils.getSQLExpression(configuration.filter, dialect, dataset, true);
                    filterSql = StringUtils.defaultIfBlank((String)filterSql, (String)"");
                    return new SQLMetricsEngine.SQLMetricsEngineRun().withFilter(filterSql).with(new MetricComputation(probe, this, metric, 1.0));
                }
                catch (Exception e) {
                    logger.info((Object)"Could not prepare the filter for the SQL engine, skipping this engine", (Throwable)e);
                    return null;
                }
            }
            return null;
        }

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            this.subComputer.addAggregations(engine.getDataset(), computation, dialect, queryBuilder);
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return this.subComputer.getAggregate(rs2, computation);
        }
    }

    public static class CellSQLLikeEngineComputer {
        public void addAggregations(Dataset dataset, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder) throws Exception {
            CellSQLLikeEngineComputerSession session = new CellSQLLikeEngineComputerSession();
            computation.session = session;
            session.dialect = dialect;
            CellMetric metric = (CellMetric)computation.metric;
            String columnName = metric.getColumn();
            SchemaColumn column = dataset.getSchema().getColumn(columnName);
            session.column = columnName;
            session.type = column.getType();
            ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
            SelectQueryBuilder.SelectRefBuilder ref = queryBuilder.select(ef.col(column.getName()), "cell_" + queryBuilder.getSelectedItemsCount());
            session.offset = ref.getIndex();
        }

        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            CellSQLLikeEngineComputerSession session = (CellSQLLikeEngineComputerSession)computation.session;
            CellProbeConfiguration configuration = computation.probe.getConfigurationAs(CellProbeConfiguration.class);
            Type dssType = session.type;
            ArrayList values = Lists.newArrayList();
            for (String[] row : rs2.rows) {
                String v = row[session.offset - 1];
                try {
                    if (dssType == Type.DATE) {
                        v = DKUtils.isoFormatReadableByDateFormat((long)CSVDeserializer.hiveDateParser.parseDateTime(v).getMillis());
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Failure while trying to harmonize hive date to ISO format");
                }
                values.add(v);
            }
            return CellProbeType.applyMode(configuration.mode, values);
        }

        public static class CellSQLLikeEngineComputerSession {
            public String column;
            public Type type;
            public SQLDialect dialect;
            public int offset;
        }
    }

    public static class CellImpalaMetricsEngineComputer
    extends MetricComputer.ImpalaMetricsEngineComputer {
        private final CellSQLLikeEngineComputer subComputer;

        public CellImpalaMetricsEngineComputer(CellSQLLikeEngineComputer subComputer) {
            this.subComputer = subComputer;
        }

        @Override
        public String getProbeType() {
            return CellProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (objectType == MetricTargetType.DATASET && DatasetInspector.isHDFSDatasetOrHiveTableDataset((Dataset)object)) {
                Dataset dataset = (Dataset)object;
                try {
                    CellProbeConfiguration configuration = probe.getConfigurationAs(CellProbeConfiguration.class);
                    ImpalaSQLDialect dialect = new ImpalaSQLDialect();
                    String filterSql = FilterDescUtils.getSQLExpression(configuration.filter, dialect, dataset, true);
                    filterSql = StringUtils.defaultIfBlank((String)filterSql, (String)"");
                    return new ImpalaMetricsEngine.ImpalaMetricsEngineRun(null).withFilter(filterSql).with(new MetricComputation(probe, this, metric, 1.0));
                }
                catch (Exception e) {
                    logger.info((Object)"Could not prepare the filter for the SQL engine, skipping this engine", (Throwable)e);
                    return null;
                }
            }
            return null;
        }

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            this.subComputer.addAggregations(engine.getDataset(), computation, dialect, queryBuilder);
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return this.subComputer.getAggregate(rs2, computation);
        }
    }

    public static class CellHiveMetricsEngineComputer
    extends MetricComputer.HiveMetricsEngineComputer {
        private final CellSQLLikeEngineComputer subComputer;

        public CellHiveMetricsEngineComputer(CellSQLLikeEngineComputer subComputer) {
            this.subComputer = subComputer;
        }

        @Override
        public String getProbeType() {
            return CellProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (objectType == MetricTargetType.DATASET && DatasetInspector.isHDFSDatasetOrHiveTableDataset((Dataset)object)) {
                Dataset dataset = (Dataset)object;
                try {
                    CellProbeConfiguration configuration = probe.getConfigurationAs(CellProbeConfiguration.class);
                    HiveSQLDialect dialect = new HiveSQLDialect();
                    String filterSql = FilterDescUtils.getSQLExpression(configuration.filter, dialect, dataset, true);
                    filterSql = StringUtils.defaultIfBlank((String)filterSql, (String)"");
                    return new HiveMetricsEngine.HiveMetricsEngineRun().withFilter(filterSql).with(new MetricComputation(probe, this, metric, 2.0));
                }
                catch (Exception e) {
                    logger.info((Object)"Could not prepare the filter for the SQL engine, skipping this engine", (Throwable)e);
                    return null;
                }
            }
            return null;
        }

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            this.subComputer.addAggregations(engine.getDataset(), computation, dialect, queryBuilder);
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return this.subComputer.getAggregate(rs2, computation);
        }
    }

    public static class CellSparkMetricsEngineComputer
    extends MetricComputer.SparkMetricsEngineComputer {
        private final CellSQLLikeEngineComputer subComputer;

        public CellSparkMetricsEngineComputer(CellSQLLikeEngineComputer subComputer) {
            this.subComputer = subComputer;
        }

        @Override
        public String getProbeType() {
            return CellProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (objectType == MetricTargetType.DATASET) {
                Dataset dataset = (Dataset)object;
                try {
                    CellProbeConfiguration configuration = probe.getConfigurationAs(CellProbeConfiguration.class);
                    SparkSQLDialect dialect = new SparkSQLDialect();
                    String filterSql = FilterDescUtils.getSQLExpression(configuration.filter, dialect, dataset, true);
                    filterSql = StringUtils.defaultIfBlank((String)filterSql, (String)"");
                    return new SparkMetricsEngine.SparkMetricsEngineRun().withFilter(filterSql).with(new MetricComputation(probe, this, metric, 3.0));
                }
                catch (Exception e) {
                    logger.info((Object)"Could not prepare the filter for the SQL engine, skipping this engine", (Throwable)e);
                    return null;
                }
            }
            return null;
        }

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            this.subComputer.addAggregations(engine.getDataset(), computation, dialect, queryBuilder);
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return this.subComputer.getAggregate(rs2, computation);
        }
    }

    public static class CellProbeConfiguration
    implements ProbeConfiguration {
        public CellValueRetrievalMode mode = CellValueRetrievalMode.SINGLE_CELL_STRICT;
        public FilterDesc filter = new FilterDesc();
        public List<String> columns = Lists.newArrayList();

        public CellValueRetrievalMode getMode() {
            return this.mode;
        }
    }

    public static class CellProbeHint {
        public List<CellColumnProbeHint> columns = Lists.newArrayList();
    }

    public static class CellColumnProbeHint {
        public String column;
        public boolean active;

        public CellColumnProbeHint(String column, boolean active) {
            this.column = column;
            this.active = active;
        }
    }

    public static class CellMetric
    extends Metric {
        public String column;
        public String probeName;

        public CellMetric(String column, Type columnType, String probeName, CellValueRetrievalMode mode) {
            super(CellProbeType.TYPE, mode == CellValueRetrievalMode.MULTI_CELL ? Type.ARRAY : columnType);
            this.probeName = probeName;
            this.column = column;
            this.id = Metric.serializeMetric(this);
        }

        public String getProbeName() {
            return this.probeName;
        }

        @Override
        public String getColumn() {
            return this.column;
        }

        @Override
        public MetricMetadata getMeta() {
            return new MetricMetadata().withName("Cell value").withFullName(this.column + " of " + this.probeName);
        }

        @Override
        public String getColumnInvariantId(String placeholder) {
            return new CellMetric(placeholder, this.dataType, this.probeName, null).getId();
        }

        @Override
        public Probe getMatchingProbe(List<Probe> probes) {
            return CellMetric.getProbeFromName(probes, this.getProbeName());
        }
    }

    public static class CellMetricSerializer
    implements Metric.MetricIdSerializer {
        @Override
        public String serializeMetric(Metric metric) {
            if (!(metric instanceof CellMetric)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metric.getClass().getSimpleName());
            }
            CellMetric cellMetric = (CellMetric)metric;
            return Metric.buildMetricIdFromParts(CellProbeType.TYPE, cellMetric.getColumn(), cellMetric.getProbeName());
        }

        @Override
        public Metric deserializeMetric(String metricId) {
            List<String> parts = Metric.buildPartsFromMetricId(metricId);
            if (parts.size() != 3 || !parts.get(0).equals(CellProbeType.TYPE)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metricId);
            }
            return new CellMetric(parts.get(1), Type.STRING, parts.get(2), null);
        }
    }
}

