/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.aggregators;

import com.dataiku.dip.pivot.UnsupportedOperation;
import com.dataiku.dip.pivot.backend.dss.aggregators.FlushableAggregatorImpl;
import com.dataiku.dip.pivot.backend.dss.aggregators.FlushableAggregatorWrapper;
import com.dataiku.dip.pivot.backend.dss.aggregators.MergeVisitor;
import com.dataiku.dip.pivot.backend.dss.aggregators.PercentilesAggregatorImpl;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import gnu.trove.list.array.TDoubleArrayList;
import java.io.IOException;
import java.util.ArrayList;

public class PercentilesAggregator
extends FlushableAggregatorWrapper<TDoubleArrayList, ArrayList<String>> {
    public PercentilesAggregator(Aggregation req) {
        super(req);
    }

    public PercentilesAggregator(Aggregation req, int[] numBins) {
        super(req, numBins);
    }

    public PercentilesAggregator(Aggregation aggregation, int bins) {
        super(aggregation, bins);
    }

    @Override
    public FlushableAggregatorImpl<TDoubleArrayList, ArrayList<String>> newFlushableInstance(double[] data, long[] nonNullCounts, String column) {
        return new PercentilesAggregatorImpl(this.req, data, nonNullCounts, column);
    }

    @Override
    public FlushableAggregatorImpl<TDoubleArrayList, ArrayList<String>>[] newFlushableArrayInstance(int size) {
        if (size == 0) {
            return new PercentilesAggregatorImpl[0];
        }
        return new PercentilesAggregatorImpl[size];
    }

    @Override
    public MergeVisitor<TDoubleArrayList, ArrayList<String>> getMergeVisitor(FlushableAggregatorImpl<TDoubleArrayList, ArrayList<String>> aggregator, int destination) {
        return new PercentilesMergeVisitor(aggregator, destination);
    }

    public static void percentileValueCheck(double percentile) {
        if (!(percentile > 0.0) || !(percentile <= 100.0)) {
            throw new UnsupportedOperation(String.format("Percentile value %s is not valid, must be between 0 (excluded) and 100 (included)", percentile));
        }
    }

    public static class PercentilesMergeVisitor
    extends MergeVisitor<TDoubleArrayList, ArrayList<String>> {
        public PercentilesMergeVisitor(FlushableAggregatorImpl<TDoubleArrayList, ArrayList<String>> aggregator, int destination) {
            super(aggregator, destination);
        }

        @Override
        public void handleString(String value) throws IOException {
            this.aggregator.handle(value, this.destination, false);
        }

        @Override
        public void handleDouble(double value) throws IOException {
            this.aggregator.handle(value, this.destination, false);
        }

        @Override
        public void beginRead(int location, int length) {
            this.aggregator.beginRead(location, length);
        }

        @Override
        public void endRead(int location) {
            this.aggregator.endRead(this.destination);
        }
    }
}

