/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.density;

import com.dataiku.dip.classpathfix.DKUDoubles;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.density.NaiveStreaming1DKDE;
import com.dataiku.dip.pivot.backend.density.NaiveStreaming2DKDE;
import com.dataiku.dip.pivot.backend.dss.PivotTableBuilder;
import com.dataiku.dip.pivot.backend.model.density.PT2DDensityRequest;
import com.dataiku.dip.pivot.backend.model.density.PT2DDensityResponse;
import com.dataiku.dip.shaker.filter.FilteringExecutor;
import com.dataiku.dip.utils.DKULogger;

public class Density2DBuilder
extends PivotTableBuilder {
    private PT2DDensityRequest request;
    private boolean filtered;
    private NaiveStreaming2DKDE kde;
    private long beforeFilterRecords = 0L;
    private long afterFilterRecords = 0L;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.shaker.pivot");

    public Density2DBuilder(PT2DDensityRequest request) {
        this.request = request;
        this.filtered = request.isFiltered();
    }

    public PT2DDensityResponse buildFromLino(LinoReader linoReader) throws Exception {
        this.buildLinoFilters(this.request, linoReader);
        double xMin = Double.MAX_VALUE;
        double xMax = -1.7976931348623157E308;
        double yMin = Double.MAX_VALUE;
        double yMax = -1.7976931348623157E308;
        for (int blockIdx = 0; blockIdx < linoReader.nblocks(); ++blockIdx) {
            int i;
            ColumnBlock xBlock = linoReader.readColumnBlock(this.request.xColumn, blockIdx);
            ColumnBlock yBlock = linoReader.readColumnBlock(this.request.yColumn, blockIdx);
            boolean[] filters = new boolean[xBlock.nbRecords()];
            this.filterLinoBlock(this.request, linoReader, blockIdx, filters);
            for (i = 0; i < xBlock.doubles.length; ++i) {
                if (!filters[i] || Double.isNaN(xBlock.doubles[i])) continue;
                xMin = Math.min(xMin, xBlock.doubles[i]);
                xMax = Math.max(xMax, xBlock.doubles[i]);
            }
            for (i = 0; i < yBlock.doubles.length; ++i) {
                if (!filters[i] || Double.isNaN(yBlock.doubles[i])) continue;
                yMin = Math.min(yMin, yBlock.doubles[i]);
                yMax = Math.max(yMax, yBlock.doubles[i]);
            }
        }
        int xsteps = 50;
        int ysteps = 20;
        double lambdaX = (xMax - xMin) / (double)xsteps / 2.0;
        double lambdaY = (yMax - yMin) / (double)ysteps / 2.0;
        this.kde = new NaiveStreaming2DKDE(new double[]{lambdaX, lambdaY}, xMin, xMax, yMin, yMax, xsteps, ysteps);
        NaiveStreaming1DKDE xKde = new NaiveStreaming1DKDE(lambdaX, xMin, xMax, xsteps);
        int doneRecords = 0;
        for (int blockIdx = 0; blockIdx < linoReader.nblocks(); ++blockIdx) {
            ColumnBlock xBlock = linoReader.readColumnBlock(this.request.xColumn, blockIdx);
            ColumnBlock yBlock = linoReader.readColumnBlock(this.request.yColumn, blockIdx);
            boolean[] filters = new boolean[xBlock.nbRecords()];
            this.filterLinoBlock(this.request, linoReader, blockIdx, filters);
            this.beforeFilterRecords += (long)xBlock.nbRecords();
            this.afterFilterRecords += (long)FilteringExecutor.countTrue(filters);
            for (int i = 0; i < xBlock.nbRecords(); ++i) {
                if (!filters[i]) continue;
                double x = xBlock.doubles[i];
                double y = yBlock.doubles[i];
                if (!Double.isNaN(x) && !Double.isNaN(y)) {
                    this.kde.add(xBlock.doubles[i], yBlock.doubles[i]);
                    xKde.add(xBlock.doubles[i]);
                    ++doneRecords;
                }
                if (doneRecords % 100 != 0) continue;
                logger.info((Object)("Done " + doneRecords + " records"));
            }
            this.updateLinoFilterFacets(this.request, linoReader, blockIdx);
        }
        PT2DDensityResponse resp = new PT2DDensityResponse();
        this.computeFilterFacets(this.request, resp);
        resp.xSteps = xsteps;
        resp.ySteps = ysteps;
        resp.xMin = xMin;
        resp.xMax = xMax;
        resp.yMin = yMin;
        resp.yMax = yMax;
        resp.density = this.kde.getData();
        resp.xDensity = xKde.getData();
        resp.minDensity = DKUDoubles.min((double[])resp.density);
        resp.maxDensity = DKUDoubles.max((double[])resp.density);
        resp.setRecordCounts(this.beforeFilterRecords, this.afterFilterRecords);
        return resp;
    }
}

