/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.maps;

import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.dss.LongDataList;
import com.dataiku.dip.pivot.backend.dss.PivotTableBuilder;
import com.dataiku.dip.pivot.backend.dss.PivotUtils;
import com.dataiku.dip.pivot.backend.dss.aggregators.AbstractAggregator;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.pivot.backend.model.PivotTableAggregatedRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableRequest;
import com.dataiku.dip.shaker.filter.FilteringExecutor;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.VariablesContext;
import com.google.refine.udaf.UdafUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PivotMapAggrBuilderBase
extends PivotTableBuilder {
    protected long beforeFilterRecords = 0L;
    protected long afterFilterRecords = 0L;
    protected LongDataList countList;
    public List<AbstractAggregator<?>> aggregators = new ArrayList();
    protected static final DKULogger logger = DKULogger.getLogger((String)"dku.shaker.pivot");

    protected void buildAggregationStructures(int nbBins, PivotTableAggregatedRequest request, VariablesContext variablesContext, LinoReader linoReader) {
        this.countList = new LongDataList(nbBins);
        for (Aggregation aggregation : request.aggregations) {
            this.aggregators.add(PivotUtils.buildAggregator(variablesContext, linoReader, aggregation, nbBins));
        }
    }

    protected boolean[] handleFiltersAndCounts(PivotTableRequest request, ColumnBlock block, LinoReader linoReader, int blockIdx) throws IOException {
        boolean[] filters = null;
        this.beforeFilterRecords += (long)block.nbRecords();
        if (this.filtered) {
            logger.info((Object)"Doing filter");
            filters = new boolean[block.nbRecords()];
            this.filterLinoBlock(request, linoReader, blockIdx, filters);
            this.afterFilterRecords += (long)FilteringExecutor.countTrue(filters);
        } else {
            this.afterFilterRecords += (long)block.nbRecords();
        }
        return filters;
    }

    protected void updateAggregations(PivotTableAggregatedRequest request, int[] bins, boolean[] filters, List<ColumnBlock> columnBlocks, LinoReader linoReader, int blockIdx) throws IOException {
        for (int row = 0; row < bins.length; ++row) {
            if (filters != null && !filters[row]) continue;
            if (bins[row] != -1) {
                int n = bins[row];
                this.countList.data[n] = this.countList.data[n] + 1L;
                continue;
            }
            --this.afterFilterRecords;
        }
        for (int i = 0; i < request.aggregations.size(); ++i) {
            AbstractAggregator<?> aggregator = this.aggregators.get(i);
            UdafUtils.setBlocksIfCustomAggregation(aggregator, linoReader, blockIdx);
            aggregator.handleBlock(columnBlocks.get(i), bins.length, bins, filters);
            UdafUtils.mergeOtherAggregators(aggregator, this.countList);
        }
    }
}

