/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.pivot.backend.PivotTablesService;
import com.dataiku.dip.pivot.backend.dss.LinoUtils;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.ColumnSummary;
import com.dataiku.dip.pivot.backend.model.PivotTableAggregatedRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableResponse;
import com.dataiku.dip.pivot.backend.sql.SQLPivotExecutor;
import com.dataiku.dip.pivot.backend.sql.SQLPivotListener;
import com.dataiku.dip.pivot.backend.sql.SQLPivotTypeDetector;
import com.dataiku.dip.pivot.backend.sql.cache.PerDatasetCache;
import com.dataiku.dip.pivot.backend.sql.queries.ColumnMapper;
import com.dataiku.dip.pivot.backend.sql.queries.InputTable;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.model.ShakerSamplingUtils;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SQLPivotTablesService {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.reports.sql");
    @Autowired
    private FutureService futureService;
    @Autowired
    private DataService shakerDataService;
    private PerDatasetCache sqlCache = new PerDatasetCache();

    public void invalidateDataset(String fullDatasetName) {
        this.sqlCache.invalidateDataset(fullDatasetName);
    }

    public void invalidateProject(String projectKey) {
        this.sqlCache.invalidateProject(projectKey);
    }

    public ColumnSummary getColumnSummary_NT(AuthCtx authCtx, Dataset dataset, SerializedShakerScript scriptForTypes, SerializedShakerScript.RefreshableStreamableSelection sampleSettings, List<ScriptStep> steps, SerializedShakerScript.ChartsEngine engineType) throws Exception {
        ComputeResourceUsageContext cruContext = ComputeResourceUsageContext.forDatasetCharts((AuthCtx)authCtx, (String)dataset.getProjectKey(), (String)dataset.getName());
        CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)cruContext);
        TransactionContext.assertNoAttachedTransaction();
        MemTable typeHandlingMT = this.shakerDataService.get_NOTRANSACTION((Dataset)dataset, (SerializedShakerScript)scriptForTypes, null, null, (boolean)true, (AuthCtx)authCtx).table;
        ColumnSummary ret = new ColumnSummary();
        ret.requiredSampleId = ShakerSamplingUtils.computeSampleId(authCtx, dataset, sampleSettings, steps, typeHandlingMT);
        InputTable table = InputTable.fromDataset(dataset, authCtx, engineType == SerializedShakerScript.ChartsEngine.SPARKSQL);
        SQLPivotTypeDetector detector = new SQLPivotTypeDetector(this.sqlCache.getFor(ret.requiredSampleId, dataset.getFullName()));
        for (Pair<String, ColumnMapper.ExprType> type : detector.detectTypes(table, authCtx)) {
            ColumnSummary.UsableColumn ucol = new ColumnSummary.UsableColumn();
            ucol.cacheable = true;
            ucol.column = (String)type.first;
            ucol.type = ((ColumnMapper.ExprType)((Object)type.second)).type == ColumnMapper.BaseType.DATE ? AxisDef.Type.DATE.toString() : (((ColumnMapper.ExprType)((Object)type.second)).type == ColumnMapper.BaseType.NUMBER ? AxisDef.Type.NUMERICAL.toString() : AxisDef.Type.ALPHANUM.toString());
            ret.usableColumns.add(ucol);
        }
        return ret;
    }

    public FutureResponse<PivotTablesService.Response> getResponse_NT(PivotTableRequest request, String requestedSampleId, Dataset ds, SerializedShakerScript scriptForTypes, List<ScriptStep> steps, SerializedShakerScript.RefreshableStreamableSelection sampleSettings, AuthCtx user, SerializedShakerScript.ChartsEngine engineType) throws Exception {
        FutureSQLThread ft = new FutureSQLThread((DSSAuthCtx)user, ds, scriptForTypes, steps, sampleSettings, requestedSampleId, (PivotTableAggregatedRequest)request, engineType);
        ft.executor = new SQLPivotExecutor(this.sqlCache.getFor(requestedSampleId, ds.getFullName()));
        return this.futureService.runFuture(ft, 2000L, new TypeToken<FutureResponse<PivotTablesService.Response>>(){});
    }

    public static FuturePayload buildFuturePayload(Dataset dataset) {
        FuturePayload fp = new FuturePayload();
        fp.action = "refresh_chart_sql";
        fp.targets.add(DSSFuturePayloadUtils.forDataset(dataset).withPart("charts"));
        fp.displayName = "Refreshing values";
        return fp;
    }

    private static class FutureSQLThread
    extends FutureThread<PivotTablesService.Response>
    implements SQLPivotListener {
        public SQLPivotExecutor executor;
        public final String sampleId;
        public final PivotTableAggregatedRequest pivotRequest;
        private final SerializedShakerScript scriptForTypes;
        public PivotTableResponse pivotResponse;
        public final Dataset dataset;
        private int nbTotalFacets = 0;
        private int nbRunningFacets = 0;
        private SQLPivotListener.PivotStatus pivotStatus;
        public final SerializedShakerScript.RefreshableStreamableSelection sampleSettings;
        private final SerializedShakerScript.ChartsEngine engineType;
        private final FuturePayload futurePayload;

        public FutureSQLThread(DSSAuthCtx owner, Dataset ds, SerializedShakerScript scriptForTypes, List<ScriptStep> steps, SerializedShakerScript.RefreshableStreamableSelection sampleSettings, String sampleId, PivotTableAggregatedRequest request, SerializedShakerScript.ChartsEngine engineType) {
            super(owner);
            this.sampleId = sampleId;
            this.dataset = ds;
            this.pivotRequest = request;
            this.scriptForTypes = scriptForTypes;
            this.sampleSettings = sampleSettings;
            this.engineType = engineType;
            this.futurePayload = SQLPivotTablesService.buildFuturePayload(this.dataset);
            logger.info((Object)("New FutureSQLThread engineType=" + String.valueOf((Object)engineType)));
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public PivotTablesService.Response getResult() {
            PivotTablesService.Response resp = new PivotTablesService.Response();
            resp.pivotResponse = this.pivotResponse;
            resp.updatedSampleId = this.sampleId;
            return resp;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public void execute() throws Exception {
            InputTable table;
            ComputeResourceUsageContext cruContext = ComputeResourceUsageContext.forDatasetCharts((AuthCtx)this.owner, (String)this.dataset.getProjectKey(), (String)this.dataset.getName());
            CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)cruContext);
            try (FutureProgress.AutocloseableFutureProgressState state = FutureProgress.pushAutoCloseableState((String)"Preparing...");){
                table = InputTable.fromDataset(this.dataset, this.sampleSettings.selection, this.owner, this.engineType == SerializedShakerScript.ChartsEngine.SPARKSQL);
            }
            state = FutureProgress.pushAutoCloseableState((String)"Pivoting...");
            try {
                this.pivotResponse = this.executor.computePivotTableResponse(table, this.pivotRequest, this, this.owner);
            }
            finally {
                if (state != null) {
                    state.close();
                }
            }
            if (this.pivotRequest.computeUsableColumns) {
                logger.debug((Object)"Computing usable columns, opening Shaker MemTable first");
                DataService shakerDataService = (DataService)SpringUtils.getBean(DataService.class);
                LinoUtils linoUtils = (LinoUtils)SpringUtils.getBean(LinoUtils.class);
                MemTable mt = shakerDataService.get_NOTRANSACTION((Dataset)this.dataset, (SerializedShakerScript)this.scriptForTypes, null, null, (boolean)true, (AuthCtx)this.owner).table;
                this.pivotResponse.columnsSummary = new ColumnSummary();
                linoUtils.fillUsableColumns(mt, this.pivotResponse.columnsSummary);
            }
        }

        private void notifyStatusChanged() throws InterruptedException {
            double total = 0.0;
            double finished = 0.0;
            Object str = "";
            if (this.pivotStatus != null) {
                if (this.pivotStatus == SQLPivotListener.PivotStatus.RUNNING_AXES) {
                    total = 1.0;
                    finished = 0.0;
                    str = "Creating axes...";
                } else if (this.pivotStatus == SQLPivotListener.PivotStatus.RUNNING_PIVOT) {
                    total = 2.0;
                    finished = 1.0;
                    str = "Creating chart...";
                }
            } else {
                str = "Preparing...";
            }
            total += (double)this.nbTotalFacets;
            finished += (double)(this.nbTotalFacets - this.nbRunningFacets);
            if (this.nbTotalFacets > 0 && ((String)str).isEmpty()) {
                str = (String)str + "Building facet(s)...";
            }
        }

        @Override
        public void facetProgress(int facetId, SQLPivotListener.FacetStatus status) throws InterruptedException {
            if (status == SQLPivotListener.FacetStatus.DONE) {
                --this.nbRunningFacets;
            } else if (status == SQLPivotListener.FacetStatus.RUNNING) {
                ++this.nbRunningFacets;
                ++this.nbTotalFacets;
            }
            this.notifyStatusChanged();
        }

        @Override
        public void pivotProgress(SQLPivotListener.PivotStatus status) throws InterruptedException {
            this.pivotStatus = status;
            this.notifyStatusChanged();
        }
    }
}

