/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.binners;

import com.dataiku.dip.pivot.backend.model.AxisElt;
import com.dataiku.dip.pivot.backend.sql.binners.StringAxisBinner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AlphanumAxisBinner
implements StringAxisBinner {
    private HashMap<String, Integer> map = new HashMap();
    private List<AxisElt> elts = new ArrayList<AxisElt>();
    private AxisElt otherBin;
    private AxisElt allBin;

    public AlphanumAxisBinner(List<String> values, boolean createOthers, boolean generateTotalBin) {
        int currentBinIndex = 0;
        for (String val : values) {
            if (val == null) continue;
            this.map.put(val, currentBinIndex);
            AxisElt elt = new AxisElt();
            elt.binIndex = currentBinIndex;
            elt.label = val.isEmpty() ? "___dku_no_value___" : val;
            this.elts.add(elt);
            ++currentBinIndex;
        }
        if (createOthers) {
            this.otherBin = new AxisElt();
            this.otherBin.binIndex = this.elts.size();
            this.otherBin.label = "___dku_others_value___";
            this.map.put(null, this.elts.size());
            this.elts.add(this.otherBin);
        }
        if (generateTotalBin) {
            this.allBin = new AxisElt();
            this.allBin.binIndex = this.elts.size();
            this.allBin.label = "___dku_total_value___";
            this.map.put("___dku_total_value___", this.elts.size());
            this.elts.add(this.allBin);
        }
    }

    @Override
    public int assign(String val) {
        Integer s = this.map.get(val);
        if (s == null) {
            throw new RuntimeException("\"" + val + "\" is out of axis");
        }
        return s;
    }

    @Override
    public AxisElt getOtherBin() {
        return this.otherBin;
    }

    @Override
    public List<AxisElt> getAxisElts() {
        return this.elts;
    }
}

