/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.frontend.model;

import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.shaker.text.StringMatchingMode;
import com.dataiku.dip.shaker.text.StringNormalizationMode;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@UIModel
public class ChartFilter {
    public FilterType filterType;
    @UINullable
    public FilterSelectionType filterSelectionType;
    @UINullable
    public FilterSortingOptions facetSorting;
    public String id;
    public String column;
    @UINullable
    public String label;
    @UINullable
    public AxisDef.Type columnType;
    @UINullable
    public DateFilterType dateFilterType;
    @UINullable
    public DateFilterPart dateFilterPart;
    @UINullable
    public DateRelativeOption dateFilterOption;
    @UINullable
    public DateFilterRelativePreset dateFilterRelativePreset;
    @UINullable
    public Double minValue;
    @UINullable
    public Double maxValue;
    @UINullable
    public String timezone;
    public String isA;
    @UINullable
    public Map<String, Boolean> excludedValues;
    @UINullable
    public Map<String, Boolean> selectedValues;
    public boolean isAGlobalFilter;
    @UINullable
    public boolean useMinimalUi;
    @UINullable
    public boolean excludeOtherValues;
    public boolean allValuesInSample;
    public boolean active = true;
    @UINullable
    public Boolean explicitExclude;
    @UINullable
    public CustomOptions customOptions;
    @UINullable
    public Boolean includeEmptyValues = true;
    @UINullable
    public List<ExplicitCondition> explicitConditions;

    public static enum DateFilterPart {
        HOUR_OF_DAY,
        DAY_OF_WEEK,
        DAY_OF_MONTH,
        MONTH_OF_YEAR,
        WEEK_OF_YEAR,
        QUARTER_OF_YEAR,
        YEAR,
        INDIVIDUAL;

    }

    public static enum DateFilterType {
        RANGE,
        RELATIVE,
        PART;

    }

    public static enum DateFilterRelativePreset {
        TODAY,
        YESTERDAY,
        THIS_WEEK,
        PREVIOUS_WEEK,
        LAST_7_DAYS,
        THIS_MONTH,
        PREVIOUS_MONTH,
        LAST_30_DAYS,
        LAST_3_MONTH,
        LAST_90_DAYS,
        LAST_6_MONTH,
        LAST_180_DAYS,
        THIS_YEAR,
        LAST_365_DAYS;

    }

    public static class CustomOptions
    implements Serializable {
        public StringMatchingMode matchingMode;
        public StringNormalizationMode normalizationMode;
        @UINullable
        public Integer decimalPlaces;

        public CustomOptions() {
            this(StringMatchingMode.FULL_STRING, StringNormalizationMode.EXACT);
        }

        public CustomOptions(StringMatchingMode matchingMode, StringNormalizationMode normalizationMode) {
            this.matchingMode = matchingMode;
            this.normalizationMode = normalizationMode;
        }

        public String toString() {
            return "CustomOptions{matchingMode=" + String.valueOf(this.matchingMode) + ", normalizationMode=" + String.valueOf(this.normalizationMode) + ", decimalPlaces=" + this.decimalPlaces + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CustomOptions that = (CustomOptions)o;
            return Objects.equals(this.decimalPlaces, that.decimalPlaces) && this.matchingMode == that.matchingMode && this.normalizationMode == that.normalizationMode;
        }

        public int hashCode() {
            return Objects.hash(this.matchingMode, this.normalizationMode, this.decimalPlaces);
        }
    }

    public static class DateRelativeOption
    implements Serializable {
        public int last;
        public int next;
        public boolean isUntilNow;
        public boolean containsCurrentDatePart;

        public DateRelativeOption() {
            new DateRelativeOption(false, false, 0, 0);
        }

        public DateRelativeOption(boolean containsCurrentDatePart, boolean isUntilNow, int last, int next) {
            this.last = last;
            this.next = next;
            this.isUntilNow = isUntilNow;
            this.containsCurrentDatePart = containsCurrentDatePart;
        }

        public String toString() {
            return "DateRelativeOption{last=" + this.last + ", next=" + this.next + ", isUntilNow=" + this.isUntilNow + ", containsCurrentDatePart=" + this.containsCurrentDatePart + "}";
        }

        public boolean isEffective() {
            return this.last > 0 || this.next > 0 || this.containsCurrentDatePart;
        }
    }

    public static class ExplicitCondition
    implements Serializable {
        public String column;
        public AxisDef.Type columnType;
        public DateFilterType dateFilterType;
        public DateFilterPart dateFilterPart;
        public String singleValue;
        public Double minValue;
        public Double maxValue;

        public String toString() {
            return "ExplicitCondition{column=" + this.column + ", columnType=" + String.valueOf((Object)this.columnType) + ", dateFilterType=" + String.valueOf((Object)this.dateFilterType) + ", dateFilterPart=" + String.valueOf((Object)this.dateFilterPart) + ", singleValue=" + this.singleValue + ", minValue=" + this.minValue + ", maxValue=" + this.maxValue + "}";
        }
    }

    public static enum FilterSortingOptions {
        NATURAL_ORDER_ASC(FilterSortingType.NATURAL_ORDER, true),
        NATURAL_ORDER_DESC(FilterSortingType.NATURAL_ORDER, false),
        COUNT_ASC(FilterSortingType.COUNT, true),
        COUNT_DESC(FilterSortingType.COUNT, false);

        private final FilterSortingType type;
        private final boolean ascending;

        private FilterSortingOptions(FilterSortingType type, boolean ascending) {
            this.type = type;
            this.ascending = ascending;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public FilterSortingType getType() {
            return this.type;
        }
    }

    public static enum FilterSortingType {
        NATURAL_ORDER,
        COUNT;

    }

    public static enum FilterSelectionType {
        RANGE_OF_VALUES,
        SINGLE_SELECT,
        MULTI_SELECT,
        CUSTOM;

    }

    public static enum FilterType {
        NUMERICAL_FACET,
        DATE_FACET,
        INTERACTIVE_DATE_FACET,
        ALPHANUM_FACET,
        EXPLICIT,
        ALPHANUM;

    }
}

