/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projects;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.coremodel.DkuComponentMetadata;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.PluginStoreService;
import com.dataiku.dip.plugins.PluginVersionUtils;
import com.dataiku.dip.plugins.model.ComputedPluginContent;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.plugins.model.StorePluginsList;
import com.dataiku.dip.projects.Desc;
import com.dataiku.dip.projects.DescList;
import com.dataiku.dip.projects.importexport.ExportedProject;
import com.dataiku.dip.projects.importexport.ProjectImporter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.DSSUpdateServiceUtils;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.HTTPClientUtils;
import com.dataiku.dip.util.RepeatingListFetcher;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dss.shadelib.com.google.api.client.util.Strings;
import com.dataiku.dss.shadelib.com.google.common.io.Files;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;
import org.apache.tools.ant.util.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TutorialsService
extends RepeatingListFetcher<DescList> {
    @Autowired
    private UsersService usersService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private FlowGraphService flowGraphService;
    @Autowired
    private IPluginsRegistryService pluginsService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private FutureService futureService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private PluginStoreService pluginStoreService;
    @Autowired
    private DesignNodeCodeEnvsService designNodeCodeEnvsService;
    private static Logger logger = Logger.getLogger((String)"dku.tutorials");

    public TutorialsService() {
        super(DSSUpdateServiceUtils.getTutorialsListURL(), logger, DescList.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalList getList() throws Exception {
        DescList localFetchList;
        GlobalList ret = new GlobalList();
        File builtinListFile = DKUApp.getInstallFile((String[])new String[]{"resources/tutorials/list.json"});
        DescList builtinList = (DescList)JSON.parseFile((File)builtinListFile, DescList.class);
        ret.items.addAll(builtinList.items);
        TutorialsService tutorialsService = this;
        synchronized (tutorialsService) {
            ret.couldFetch = this.fetchedList != null;
            localFetchList = (DescList)this.fetchedList;
            ret.fetchError = this.fetchException;
        }
        if (localFetchList != null) {
            this.addOrReplaceItemsInList(ret.items, localFetchList.items);
        }
        for (InstalledPluginDesc pd : this.pluginsService.getLoadedPlugins()) {
            File pluginListFile = DKUFileUtils.getWithin((File)this.pluginsService.getPluginResourceFolder(pd.desc.id), (String[])new String[]{"tutorials/list.json"});
            if (!pluginListFile.exists()) continue;
            this.addOrReplaceItemsInList(ret.items, ((DescList)JSON.parseFile((File)pluginListFile, DescList.class)).items);
        }
        return ret;
    }

    private void addOrReplaceItemsInList(List<Desc> list, List<Desc> newItems) {
        for (Desc newItem : newItems) {
            list.removeIf(item -> item.id.equals(newItem.id));
            list.add(newItem);
        }
    }

    public static List<ComputedPluginContent.ContributionWithId> getPluginContent(IPluginsRegistryService pluginsService, InstalledPluginDesc ipd, Desc.Type type) throws IOException {
        ArrayList<ComputedPluginContent.ContributionWithId> ret = new ArrayList<ComputedPluginContent.ContributionWithId>();
        File pluginListFile = DKUFileUtils.getWithin((File)pluginsService.getPluginResourceFolder(ipd.desc.id), (String[])new String[]{"tutorials/list.json"});
        if (pluginListFile.exists()) {
            DescList list = (DescList)JSON.parseFile((File)pluginListFile, DescList.class);
            for (Desc item : list.items) {
                if (item.type != type) continue;
                ComputedPluginContent.ContributionWithId cid = new ComputedPluginContent.ContributionWithId(item.id, new DkuComponentMetadata(), null);
                cid.meta.label = item.name;
                cid.meta.description = item.description;
                ret.add(cid);
            }
        }
        return ret;
    }

    private Desc getDesc(String id) throws Exception {
        for (Desc d : this.getList().items) {
            if (!d.id.equals(id)) continue;
            return d;
        }
        throw new IllegalArgumentException("Unknown tutorial " + id);
    }

    private File getArchive(Desc desc, AuthCtx user, ProxySettings proxySettings) throws IOException {
        switch (desc.archiveType) {
            case BUILTIN: {
                File f = DKUApp.getInstallFile((String[])new String[]{"resources/tutorials", desc.id, "archive.zip"});
                if (!f.exists()) {
                    throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_COMPONENT_NOT_INSTALLED, "Archive for " + desc.id + " not found : " + String.valueOf(f));
                }
                return f;
            }
            case FETCH: {
                AutoDelete f = DSSTempUtils.getTempFile((String)"tutorial-download", (String)desc.id, (String)"zip");
                HTTPClientUtils.downloadToFile((String)desc.downloadURL, (File)f, this.settingsService.getCustomHeadersForTracking(user), (ProxySettings)proxySettings);
                return f;
            }
            case PLUGIN: {
                File f = DKUFileUtils.getWithin((File)this.pluginsService.getPluginResourceFolder(desc.pluginId), (String[])new String[]{"tutorials/" + desc.id + "/archive.zip"});
                if (!f.exists()) {
                    throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_COMPONENT_NOT_INSTALLED, "Archive for " + desc.id + " not found : " + String.valueOf(f));
                }
                return f;
            }
        }
        throw new Error("unreachable");
    }

    public URL getThumbnailURL(String id) throws Exception {
        Desc desc = this.getDesc(id);
        switch (desc.archiveType) {
            case BUILTIN: {
                File f = DKUApp.getInstallFile((String[])new String[]{"resources/tutorials/", desc.id, "archive.zip"});
                if (!f.exists()) {
                    throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_COMPONENT_NOT_INSTALLED, "Archive for " + desc.id + " not found : " + String.valueOf(f));
                }
                try (ZipFile archive = new ZipFile(f);){
                    ZipEntry image = archive.getEntry("project_config/pictures/project-original.png");
                    if (image == null) {
                        URL uRL = null;
                        return uRL;
                    }
                }
                URL zipUrl = f.toURI().toURL();
                URL entryUrl = new URL("jar:" + String.valueOf(zipUrl) + "!/project_config/pictures/project-original.png");
                return entryUrl;
            }
            case FETCH: {
                if (desc.imageURL != null) {
                    return new URL(desc.imageURL);
                }
                return null;
            }
            case PLUGIN: {
                File f = DKUFileUtils.getWithin((File)this.pluginsService.getPluginResourceFolder(desc.pluginId), (String[])new String[]{"tutorials/" + desc.id + "/archive.zip"});
                if (!f.exists()) {
                    throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_COMPONENT_NOT_INSTALLED, "Archive for " + desc.id + " not found : " + String.valueOf(f));
                }
                try (ZipFile archive = new ZipFile(f);){
                    URL entryUrl;
                    ZipEntry image = archive.getEntry("project_config/pictures/project-original.png");
                    if (image == null) {
                        URL uRL = null;
                        return uRL;
                    }
                    URL zipUrl = f.toURI().toURL();
                    URL uRL = entryUrl = new URL("jar:" + String.valueOf(zipUrl) + "!/project_config/pictures/project-original.png");
                    return uRL;
                }
            }
        }
        throw new Error("unreachable");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PrepareImportResponse prepareImport(DSSAuthCtx user, String importId) throws Exception {
        PrepareImportResponse prepareImportResponse = new PrepareImportResponse();
        File file = null;
        if (!Strings.isNullOrEmpty((String)importId)) {
            try {
                file = DKUApp.getFile((String[])new String[]{"tmp", "tutorial-download", importId + ".zip"});
            }
            catch (Exception e) {
                prepareImportResponse.prepareError = new SerializedError((Throwable)e, !DKUApp.hideErrorStacks(), !DKUApp.hideErrorStacks(), !DKUApp.hideLogTails());
            }
        }
        if (file == null || !file.exists()) {
            prepareImportResponse.success = false;
            prepareImportResponse.errorMessage = "Unable to read downloaded tutorial. Missing archive file.";
            return prepareImportResponse;
        }
        GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettings();
        if (!generalSettings.pluginInstallRequestsEnabled && !generalSettings.codeEnvInstallRequestsEnabled) {
            prepareImportResponse.success = true;
            return prepareImportResponse;
        }
        try {
            AutoDelete tempFile = DSSTempUtils.getTempFolder((String)"tutorial-download", (String)importId);
            try {
                ExportedProject ep;
                logger.info((Object)("Unarchiving to " + tempFile.getPath()));
                ZipUnzipDir.extractFolder(file, (File)tempFile, false);
                try {
                    ep = (ExportedProject)JSON.parseFile((File)DKUFileUtils.getWithin((File)tempFile, (String[])new String[]{"export-manifest.json"}), ExportedProject.class);
                }
                catch (Exception e) {
                    logger.error((Object)"Error while reading tutorial archive file");
                    prepareImportResponse.success = false;
                    prepareImportResponse.prepareError = new SerializedError((Throwable)e, !DKUApp.hideErrorStacks(), !DKUApp.hideErrorStacks(), !DKUApp.hideLogTails());
                    prepareImportResponse.errorMessage = "Error while reading tutorial archive file";
                    PrepareImportResponse prepareImportResponse2 = prepareImportResponse;
                    if (tempFile != null) {
                        tempFile.close();
                    }
                    return prepareImportResponse2;
                }
                this.checkPluginRequirements(prepareImportResponse, generalSettings, ep);
                this.checkCodeEnvRequirements(prepareImportResponse, generalSettings, (File)tempFile, ep);
            }
            finally {
                if (tempFile != null) {
                    try {
                        tempFile.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while reading tutorial archive file");
            prepareImportResponse.success = false;
            prepareImportResponse.prepareError = new SerializedError((Throwable)e, !DKUApp.hideErrorStacks(), !DKUApp.hideErrorStacks(), !DKUApp.hideLogTails());
            prepareImportResponse.errorMessage = "Error while reading tutorial archive file";
            return prepareImportResponse;
        }
        prepareImportResponse.success = prepareImportResponse.notInstalledPlugins.isEmpty() && prepareImportResponse.notUpToDatePlugins.isEmpty() && prepareImportResponse.notExistingPlugins.isEmpty() && prepareImportResponse.nonConventionalPluginVersions.isEmpty() && prepareImportResponse.missingCodeEnvs.isEmpty();
        return prepareImportResponse;
    }

    private void checkCodeEnvRequirements(PrepareImportResponse prepareImportResponse, GeneralSettingsDAO.GeneralSettings generalSettings, File codeEnvFolder, ExportedProject ep) throws IOException {
        if (!generalSettings.codeEnvInstallRequestsEnabled || ApplicationConfigurator.getNodeType() != ApplicationConfigurator.DSSNodeType.DESIGN || ep.usedCodeEnvRefs == null) {
            return;
        }
        List existingCodeEnvs = this.designNodeCodeEnvsService.listCodeEnvs().stream().map(codeEnv -> codeEnv.envName).collect(Collectors.toList());
        for (CodeEnvModel.UsedCodeEnvRef ref : ep.usedCodeEnvRefs) {
            CodeEnvModel.AbstractDesignUIEnv designUIEnv;
            if (existingCodeEnvs.contains(ref.envName) || !DKUFileUtils.exists((File)codeEnvFolder, (String[])new String[]{"project_config", "lib", "code-envs", ref.envName})) continue;
            if (ref.envLang == null) {
                throw new IllegalArgumentException("Not valid language in code env : " + ref.envName);
            }
            File codeEnvDirectory = DKUFileUtils.getWithin((File)codeEnvFolder, (String[])new String[]{"project_config", "lib", "code-envs", ref.envName});
            File desc = DKUFileUtils.getWithin((File)codeEnvDirectory, (String[])new String[]{"desc.json"});
            File condaSpecFile = DKUFileUtils.getWithin((File)codeEnvDirectory, (String[])new String[]{"spec", "environment.spec"});
            File packagesSpecFile = DKUFileUtils.getWithin((File)codeEnvDirectory, (String[])new String[]{"spec", ref.envLang.getPackageFileName()});
            switch (ref.envLang) {
                case PYTHON: {
                    designUIEnv = new CodeEnvModel.DesignUIPythonEnv();
                    designUIEnv.envName = ref.envName;
                    designUIEnv.desc = (CodeEnvModel.AbstractEnvDesc)JSON.parseFile((File)desc, CodeEnvModel.DesignNewPythonEnvSpec.class);
                    designUIEnv.envLang = ref.envLang;
                    if (packagesSpecFile.exists()) {
                        designUIEnv.specPackageList = DKUFileUtils.readFileToStringUTF8OrEmpty((File)packagesSpecFile);
                    }
                    if (!((CodeEnvModel.PythonEnvDesc)designUIEnv.desc).conda || !condaSpecFile.exists()) break;
                    designUIEnv.specCondaEnvironment = DKUFileUtils.readFileToStringUTF8OrEmpty((File)condaSpecFile);
                    break;
                }
                case R: {
                    designUIEnv = new CodeEnvModel.DesignUIREnv();
                    designUIEnv.envName = ref.envName;
                    ((CodeEnvModel.DesignUIREnv)designUIEnv).desc = (CodeEnvModel.AbstractEnvDesc)JSON.parseFile((File)desc, CodeEnvModel.DesignNewREnvSpec.class);
                    designUIEnv.envLang = ref.envLang;
                    if (packagesSpecFile.exists()) {
                        designUIEnv.specPackageList = DKUFileUtils.readFileToStringUTF8OrEmpty((File)packagesSpecFile);
                    }
                    if (!((CodeEnvModel.REnvDesc)((CodeEnvModel.DesignUIREnv)designUIEnv).desc).conda || !condaSpecFile.exists()) break;
                    designUIEnv.specCondaEnvironment = DKUFileUtils.readFileToStringUTF8OrEmpty((File)condaSpecFile);
                    break;
                }
                default: {
                    throw new NotImplementedException("Code env language not supported : " + String.valueOf((Object)ref.envLang));
                }
            }
            prepareImportResponse.missingCodeEnvs.add(designUIEnv);
        }
    }

    private void checkPluginRequirements(PrepareImportResponse prepareImportResponse, GeneralSettingsDAO.GeneralSettings generalSettings, ExportedProject ep) throws Exception {
        if (!generalSettings.pluginInstallRequestsEnabled || !ep.exportedWithOptions.useManualPluginsInfo || ep.exportedWithOptions.manualPluginsInfo == null) {
            return;
        }
        ArrayList<ExportedProject.InstalledPluginRef> pluginRequirementList = new ArrayList<ExportedProject.InstalledPluginRef>(ep.exportedWithOptions.manualPluginsInfo);
        for (ExportedProject.InstalledPluginRef pluginRequirement : pluginRequirementList) {
            Optional<StorePluginsList.StorePlugin> storePlugin = this.pluginStoreService.getStorePluginDesc(pluginRequirement.pluginId);
            if (!storePlugin.isPresent()) {
                prepareImportResponse.notExistingPlugins.add(new PluginRequirement(pluginRequirement.pluginId, null, pluginRequirement.version, null));
                continue;
            }
            try {
                PluginStoreService.PluginStateInfo pluginStateInfo = this.pluginStoreService.getMandatory(pluginRequirement.pluginId);
                try {
                    if (!pluginStateInfo.installed || PluginVersionUtils.comparePluginVersion(pluginStateInfo.installedDesc.desc.version, pluginRequirement.version) >= 0 || PluginVersionUtils.comparePluginVersion(pluginRequirement.version, storePlugin.get().storeVersion) > 0) continue;
                    prepareImportResponse.notUpToDatePlugins.add(new PluginRequirement(pluginRequirement.pluginId, pluginStateInfo.storeDesc.meta.label, pluginRequirement.version, pluginStateInfo.installedDesc.desc.version));
                }
                catch (NumberFormatException nfe) {
                    prepareImportResponse.nonConventionalPluginVersions.add(new PluginRequirement(pluginRequirement.pluginId, storePlugin.get().meta.label, pluginRequirement.version, pluginStateInfo.installedDesc.desc.version));
                }
            }
            catch (CodedRuntimeException cre) {
                prepareImportResponse.notInstalledPlugins.add(new PluginRequirement(pluginRequirement.pluginId, storePlugin.get().meta.label, pluginRequirement.version, null));
            }
        }
    }

    public static FuturePayload buildFuturePayload(String tutorialId, String tutorialType, String action, String displayName) {
        FuturePayload fp = new FuturePayload();
        fp.action = action;
        fp.targets.add(new FuturePayload.FuturePayloadTarget(tutorialId, tutorialId, tutorialId, tutorialType, "TUTORIAL"));
        fp.displayName = displayName;
        return fp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processImport(InstallationResult ret, File archive, Desc desc, ProjectImporter pi, DSSAuthCtx owner, String targetProjectKey, String tutorialId) {
        try {
            ProjectImporter.ProjectImportResult result = pi.importProject(owner);
            if (result.success) {
                try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)owner);){
                    SerializedProject sp = this.projectsService.getMandatory(targetProjectKey);
                    sp.name = desc.name + " for " + this.usersService.getUserOrNull_NoLeak((String)owner.getAssociatedDSSUserMand()).displayName;
                    sp.tutorialProject = true;
                    sp.tutorialId = tutorialId;
                    GeneralSettingsDAO.ProjectStatus sandboxStatus = this.generalSettingsService.getProjectStatusWithName(GeneralSettingsDAO.DEFAULT_PROJECT_STATUS.SANDBOX.projectStatus.name);
                    if (sandboxStatus != null) {
                        sp.projectStatus = sandboxStatus.name;
                    }
                    this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.UNKNOWN);
                    this.flowGraphService.invalidateCache();
                    this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.PROJECT, targetProjectKey, targetProjectKey, owner, TaggableObjectChangedEvent.ActionType.PROJECT_CREATE));
                    t.commit("Set project as tutorial: " + tutorialId);
                }
            } else {
                throw new Exception("Tutorial project import failed:\n " + JSON.json((Object)((Object)result)));
            }
            ret.projectKey = targetProjectKey;
            ret.success = true;
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to create the tutorial", (Throwable)ex);
            ret.success = false;
            ret.installationError = new SerializedError((Throwable)ex, !DKUApp.hideErrorStacks(), !DKUApp.hideErrorStacks(), !DKUApp.hideLogTails());
            ret.errorMessage = "Could not create the tutorial";
        }
        finally {
            if (desc.archiveType == Desc.ArchiveType.FETCH) {
                logger.info((Object)("Deleting downloaded archive: " + String.valueOf(archive)));
                FileUtils.delete((File)archive);
            }
        }
    }

    private static FuturePayload buildImportFuturePayload(String projectKey, String importId) {
        FuturePayload fp = new FuturePayload();
        fp.action = "import_tutorial";
        fp.targets.add(new FuturePayload.FuturePayloadTarget(projectKey, importId, ITaggingService.TaggableType.PROJECT.name(), null));
        fp.displayName = "Import tutorial " + importId;
        return fp;
    }

    public FutureResponse<InstallationResult> createProject(AuthCtx user, String id, String type, String projectFolderId) throws Exception {
        CreateTutorialFutureThread ft = new CreateTutorialFutureThread(id, type, projectFolderId, (DSSAuthCtx)user);
        return this.futureService.runFuture(ft, 50L, new TypeToken<FutureResponse<InstallationResult>>(){});
    }

    public FutureResponse<DownloadResult> downloadProject(AuthCtx user, String id, String type) throws Exception {
        DownloadTutorialFutureThread ft = new DownloadTutorialFutureThread(id, type, (DSSAuthCtx)user);
        return this.futureService.runFuture(ft, 50L, new TypeToken<FutureResponse<DownloadResult>>(){});
    }

    public FutureResponse<InstallationResult> processImport(AuthCtx user, String importId, String tutorialId, String targetProjectKey, String targetProjectFolderId) throws Exception {
        TutorialImportFutureThread ft = new TutorialImportFutureThread(importId, tutorialId, targetProjectKey, targetProjectFolderId, user);
        return this.futureService.runFuture(ft, 50L, new TypeToken<FutureResponse<InstallationResult>>(){});
    }

    public static class GlobalList {
        public List<Desc> items = new ArrayList<Desc>();
        public boolean couldFetch;
        public SerializedError fetchError;
    }

    public class PrepareImportResponse {
        public boolean success;
        public String errorMessage;
        public SerializedError prepareError;
        public List<PluginRequirement> notInstalledPlugins = new ArrayList<PluginRequirement>();
        public List<PluginRequirement> notExistingPlugins = new ArrayList<PluginRequirement>();
        public List<PluginRequirement> notUpToDatePlugins = new ArrayList<PluginRequirement>();
        public List<PluginRequirement> nonConventionalPluginVersions = new ArrayList<PluginRequirement>();
        public List<CodeEnvModel.AbstractDesignUIEnv<?>> missingCodeEnvs = new ArrayList();
    }

    public static class PluginRequirement {
        public String id;
        public String name;
        public String version;
        public String installedVersion;

        public PluginRequirement(String id, String name, String version, String installedVersion) {
            this.id = id;
            this.name = name;
            this.version = version;
            this.installedVersion = installedVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PluginRequirement that = (PluginRequirement)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version) && Objects.equals(this.installedVersion, that.installedVersion);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.version, this.installedVersion);
        }
    }

    public static class InstallationResult {
        public boolean success;
        public String projectKey;
        public SerializedError installationError;
        public String errorMessage;
    }

    private class CreateTutorialFutureThread
    extends FutureThread<InstallationResult> {
        private final InstallationResult result;
        private final String tutorialId;
        private final String tutorialType;
        private final String projectFolderId;
        private final ProxySettings proxySettings;
        private final FuturePayload futurePayload;

        public CreateTutorialFutureThread(String tutorialId, String tutorialType, String projectFolderId, DSSAuthCtx authCtx) {
            super(authCtx);
            this.result = new InstallationResult();
            this.tutorialId = tutorialId;
            this.tutorialType = tutorialType;
            this.projectFolderId = projectFolderId;
            this.proxySettings = ApplicationConfigurator.getProxySettings();
            this.futurePayload = TutorialsService.buildFuturePayload(tutorialId, tutorialType, "create_tutorial", "Installing tutorial");
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public InstallationResult getResult() {
            return this.result;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public void execute() {
            File archive;
            String projectKey;
            Desc desc;
            InstallationResult ret = this.result;
            try {
                desc = TutorialsService.this.getDesc(this.tutorialId);
                StringTransmogrifier st2 = new StringTransmogrifier();
                try (Transaction t = TutorialsService.this.transactionService.beginRead();){
                    for (String s : TutorialsService.this.projectsService.listProjectKeys()) {
                        st2.addAlreadyTransmogrified(s);
                    }
                }
                projectKey = st2.transmogrify(this.tutorialId);
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to setup the tutorial's creation", (Throwable)ex);
                ret.success = false;
                ret.installationError = new SerializedError((Throwable)ex, !DKUApp.hideErrorStacks(), !DKUApp.hideErrorStacks(), !DKUApp.hideLogTails());
                ret.errorMessage = "Could not setup the tutorial creation";
                return;
            }
            try {
                archive = TutorialsService.this.getArchive(desc, this.owner, this.proxySettings);
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to retrieve the tutorial's archive", (Throwable)ex);
                ret.success = false;
                ret.installationError = new SerializedError((Throwable)ex, !DKUApp.hideErrorStacks(), !DKUApp.hideErrorStacks(), !DKUApp.hideLogTails());
                ret.errorMessage = "Could not retrieve the tutorial's files";
                return;
            }
            ProjectImporter.ProjectImportSettings importSettings = new ProjectImporter.ProjectImportSettings();
            importSettings.targetProjectKey = projectKey;
            importSettings.importType = this.tutorialType;
            importSettings.targetProjectFolderId = this.projectFolderId;
            ProjectImporter pi = new ProjectImporter(this.owner, archive, importSettings, true);
            TutorialsService.this.processImport(ret, archive, desc, pi, this.owner, projectKey, this.tutorialId);
        }
    }

    private class DownloadTutorialFutureThread
    extends FutureThread<DownloadResult> {
        private final DownloadResult result;
        private final String tutorialId;
        private final ProxySettings proxySettings;
        private final FuturePayload futurePayload;

        public DownloadTutorialFutureThread(String tutorialId, String tutorialType, DSSAuthCtx authCtx) {
            super(authCtx);
            this.result = new DownloadResult();
            this.tutorialId = tutorialId;
            this.proxySettings = ApplicationConfigurator.getProxySettings();
            this.futurePayload = TutorialsService.buildFuturePayload(tutorialId, tutorialType, "download_tutorial", "Downloading tutorial");
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public DownloadResult getResult() {
            return this.result;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public void execute() {
            Desc desc;
            DownloadResult ret = this.result;
            try {
                desc = TutorialsService.this.getDesc(this.tutorialId);
                StringTransmogrifier st2 = new StringTransmogrifier();
                try (Transaction t = TutorialsService.this.transactionService.beginRead();){
                    for (String s : TutorialsService.this.projectsService.listProjectKeys()) {
                        st2.addAlreadyTransmogrified(s);
                    }
                }
                ret.projectKey = st2.transmogrify(this.tutorialId);
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to setup the tutorial's creation", (Throwable)ex);
                ret.success = false;
                ret.downloadError = new SerializedError((Throwable)ex, !DKUApp.hideErrorStacks(), !DKUApp.hideErrorStacks(), !DKUApp.hideLogTails());
                ret.errorMessage = "Could not setup the tutorial creation";
                return;
            }
            if (desc.archiveType != Desc.ArchiveType.FETCH) {
                logger.error((Object)"Failed to setup the tutorial's creation. The archive cannot be downloaded.");
                ret.success = false;
                ret.errorMessage = "Could not setup the tutorial creation. It is not a downloadable content.";
                return;
            }
            try {
                AutoDelete archive = DSSTempUtils.getTempFile((String)"tutorial-download", (String)desc.id, (String)"zip");
                HTTPClientUtils.downloadToFile((String)desc.downloadURL, (File)archive, TutorialsService.this.settingsService.getCustomHeadersForTracking(this.owner), (ProxySettings)this.proxySettings);
                ret.importId = Files.getNameWithoutExtension((String)archive.getName());
                ret.success = true;
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to retrieve the tutorial's archive", (Throwable)ex);
                ret.success = false;
                ret.downloadError = new SerializedError((Throwable)ex, !DKUApp.hideErrorStacks(), !DKUApp.hideErrorStacks(), !DKUApp.hideLogTails());
                ret.errorMessage = "Could not retrieve the tutorial's files";
                return;
            }
        }
    }

    private class TutorialImportFutureThread
    extends SimpleFutureThread<InstallationResult> {
        private String importId;
        private String tutorialId;
        private String targetProjectKey;
        private String targetProjectFolderId;
        private final FuturePayload futurePayload;

        private TutorialImportFutureThread(String importId, String tutorialId, String targetProjectKey, String targetProjectFolderId, AuthCtx user) {
            super(user);
            this.importId = importId;
            this.tutorialId = tutorialId;
            this.targetProjectKey = targetProjectKey;
            this.targetProjectFolderId = targetProjectFolderId;
            this.futurePayload = TutorialsService.buildImportFuturePayload(targetProjectKey, importId);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InstallationResult compute() throws Exception {
            InstallationResult ret = new InstallationResult();
            File archive = null;
            try {
                File file = archive = Strings.isNullOrEmpty((String)this.importId) ? null : DKUApp.getFile((String[])new String[]{"tmp", "tutorial-download", this.importId + ".zip"});
                if (archive == null) {
                    logger.error((Object)"Failed to retrieve the tutorial's archive");
                    ret.success = false;
                    ret.errorMessage = "Could not retrieve the tutorial's files";
                    InstallationResult installationResult = ret;
                    return installationResult;
                }
                Desc desc = TutorialsService.this.getDesc(this.tutorialId);
                ProjectImporter.ProjectImportSettings projectImportSettings = new ProjectImporter.ProjectImportSettings();
                projectImportSettings.importType = desc.type.name();
                projectImportSettings.targetProjectKey = this.targetProjectKey;
                projectImportSettings.targetProjectFolderId = this.targetProjectFolderId;
                TutorialsService.this.processImport(ret, archive, desc, new ProjectImporter(this.owner, archive, projectImportSettings, true), this.owner, this.targetProjectKey, this.tutorialId);
                InstallationResult installationResult = ret;
                return installationResult;
            }
            catch (Exception e) {
                logger.error((Object)"Failed to create the tutorial");
                ret.success = false;
                ret.installationError = new SerializedError((Throwable)e, !DKUApp.hideErrorStacks(), !DKUApp.hideErrorStacks(), !DKUApp.hideLogTails());
                ret.errorMessage = "Could not create the tutorial";
                InstallationResult installationResult = ret;
                return installationResult;
            }
            finally {
                if (archive != null && archive.exists()) {
                    logger.info((Object)("Deleting downloaded archive: " + String.valueOf(archive)));
                    FileUtils.delete((File)archive);
                }
            }
        }
    }

    public static class DownloadResult {
        public boolean success;
        public String importId;
        public String projectKey;
        public SerializedError downloadError;
        public String errorMessage;
    }
}

