/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projects.importexport;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.analysis.ml.prediction.flow.AbstractPredictionTrainingRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionSMMgmtService;
import com.dataiku.dip.analysis.ml.prediction.flow.TabularPredictionTrainingRecipePayloadParams;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.code.AutomationNodeCodeEnvsService;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvUsagesService;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.containers.exec.ContainerExecUsagesService;
import com.dataiku.dip.containers.exec.UsedContainerExec;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.CodeStudioObjectsDAO;
import com.dataiku.dip.dao.CodeStudioTemplatesDAO;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SQLNotebooksDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.datasets.DatasetConnectionUtils;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.inline.InlineDatasetHandler;
import com.dataiku.dip.datasets.jobsdb.JobsdbDatasetHandler;
import com.dataiku.dip.datasets.statsdb.StatsDBDatasetHandler;
import com.dataiku.dip.discussions.Discussion;
import com.dataiku.dip.discussions.DiscussionList;
import com.dataiku.dip.discussions.DiscussionsInternalDB;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.experimenttracking.ExperimentTrackingExportData;
import com.dataiku.dip.experimenttracking.ExperimentTrackingService;
import com.dataiku.dip.export.ExportCodes;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.labeling.AnswerList;
import com.dataiku.dip.labeling.LabelingAnswer;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.LabelingTasksDAO;
import com.dataiku.dip.labeling.LocalLabelingAnswerCRUDService;
import com.dataiku.dip.labeling.VerifiedLabelingAnswer;
import com.dataiku.dip.lambda.mgmt.LambdaServicesDAO;
import com.dataiku.dip.llm.promptstudio.PromptStudio;
import com.dataiku.dip.llm.promptstudio.PromptStudioDAO;
import com.dataiku.dip.llm.promptstudio.PromptStudiosCRUDService;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.projects.importexport.BundleCodes;
import com.dataiku.dip.projects.importexport.DataExportFailedException;
import com.dataiku.dip.projects.importexport.ExportedProject;
import com.dataiku.dip.projects.importexport.ProjectImportExportCodes;
import com.dataiku.dip.projects.importexport.ProjectImportExportUtils;
import com.dataiku.dip.projects.importexport.model.BundleContentSummary;
import com.dataiku.dip.projects.importexport.model.ProjectExportOptions;
import com.dataiku.dip.projects.importexport.timeline.TimelineItemToJSONConverter;
import com.dataiku.dip.scheduler.ScenariosDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.ConnectionUsagesService;
import com.dataiku.dip.server.services.JupyterService;
import com.dataiku.dip.server.services.JupyterUtils;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.timelines.ProjectTimeline;
import com.dataiku.dip.timelines.TimelineItem;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.NativeFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ZipWriteFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.fs.imfs.InMemoryDiff;
import com.dataiku.dip.transactions.fs.utils.AcceptAllFilter;
import com.dataiku.dip.transactions.fs.utils.FSUtils;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DatasetFileTransferer;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppsDAO;
import com.dataiku.dip.webapps.codestudio.CodeStudioWebAppMeta;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ProjectExporterBase {
    protected String projectKey = null;
    protected final AuthCtx authCtx;
    protected final NativeFS dataDirFS;
    protected ZipWriteFS targetZipFS;
    @Autowired
    protected FlowGraphService graphService;
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    protected RecipesDAO recipesDAO;
    @Autowired
    protected ScenariosDAO scenariosDAO;
    @Autowired
    protected DatasetAccessService datasetAccessService;
    @Autowired
    protected SQLNotebooksDAO sqlNotebooksDAO;
    @Autowired
    protected ConnectionsDAO connectionsDAO;
    @Autowired
    protected IPluginsRegistryService pluginsService;
    @Autowired
    protected TransactionService transactionService;
    @Autowired
    protected SavedModelsDAO savedModelsDAO;
    @Autowired
    protected ModelEvaluationStoresDAO modelEvaluationStoresDAO;
    @Autowired
    protected LabelingTasksDAO labelingTasksDAO;
    @Autowired
    protected ManagedFolderDAO managedFolderDAO;
    @Autowired
    protected CodeStudioObjectsDAO codeStudioObjectsDAO;
    @Autowired
    protected RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    protected PromptStudioDAO promptStudioDAO;
    @Autowired
    protected WebAppsDAO webAppsDAO;
    @Autowired
    protected CodeStudioTemplatesDAO codeStudioTemplatesDAO;
    @Autowired
    protected LambdaServicesDAO lambdaServicesDAO;
    @Autowired
    protected DiscussionsInternalDB discussionsDAO;
    @Autowired
    protected LocalLabelingAnswerCRUDService labelingAnswerCRUDService;
    @Autowired
    private DesignNodeCodeEnvsService designNodeCodeEnvsService;
    @Autowired
    private AutomationNodeCodeEnvsService automationNodeCodeEnvsService;
    @Autowired
    private CodeEnvUsagesService codeEnvUsagesService;
    @Autowired
    private ContainerExecUsagesService containerExecUsagesService;
    @Autowired
    private ConnectionUsagesService connectionUsagesService;
    @Autowired
    private TimelinesService timelinesService;
    @Autowired
    private ExperimentTrackingService experimentTrackingService;
    @Autowired
    private JupyterService jupyterService;
    @Autowired
    private PredictionSMMgmtService psmmService;
    @Autowired
    private PromptStudiosCRUDService promptStudiosCRUDService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.projects.export");

    ProjectExporterBase(AuthCtx authCtx) throws IOException {
        this.authCtx = authCtx;
        this.dataDirFS = NativeFS.from((File)ApplicationConfigurator.getBaseFolderF()).build();
    }

    protected void zipDirectory(RelFile from, String to) throws IOException {
        this.zipDirectory(from, RelFile.fromPath((String)to));
    }

    protected void zipDirectoryMaybeWithoutSymlinks(RelFile from, String to) throws IOException {
        this.zipDirectoryMaybeWithoutSymlinks(from, RelFile.fromPath((String)to));
    }

    protected void zipDirectory(RelFile from, RelFile to) throws IOException {
        FSUtils.newRecursiveCopy().from((ReadOnlyFS)this.dataDirFS, from).to((ReadWriteFS)this.targetZipFS, to).run();
    }

    protected void zipDirectoryMaybeWithoutSymlinks(RelFile from, RelFile to) throws IOException {
        NativeFS noSymlinkFS = NativeFS.from((File)this.dataDirFS.resolve(from)).skipFileTypeCheck(false).atomicWrite(false).rejectSymlinks(DKUApp.getParams().getBoolParam("dku.exports.rejectSymlinks", true)).build();
        FSUtils.newRecursiveCopy().from((ReadOnlyFS)noSymlinkFS).to((ReadWriteFS)this.targetZipFS, to).run();
    }

    protected void exportAllAnalysisData() throws IOException {
        RelFile analysisData = new RelFile(new String[]{"analysis-data", this.projectKey});
        if (this.dataDirFS.isDirectory(analysisData)) {
            this.zipDirectoryMaybeWithoutSymlinks(analysisData, "analysis-data");
        }
    }

    protected void exportInsightsData() throws IOException {
        logger.info((Object)"Exporting static insights data ...");
        RelFile insightsData = new RelFile(new String[]{"insights-data", this.projectKey});
        if (this.dataDirFS.isDirectory(insightsData)) {
            this.zipDirectory(insightsData, "insights-data");
        }
    }

    protected void exportProjectResources() throws IOException {
        RelFile projectResources = new RelFile(new String[]{"lib", "projects", this.projectKey});
        if (this.dataDirFS.isDirectory(projectResources)) {
            this.zipDirectory(projectResources, "project-resources");
        }
    }

    private void stripNotebooksCellsOutputsFromConfig(ReadWriteFS projectConfig) throws IOException {
        for (JupyterUtils.JupyterNotebookListEntry nb : this.jupyterService.listUnsafe(this.authCtx, this.projectKey)) {
            RelFile notebookFile = this.jupyterService.getNotebookFile(RelFile.root(), nb.name);
            RelFile checkpointFile = this.jupyterService.getCheckpointFile(RelFile.root(), nb.name);
            this.jupyterService.stripCellOutputsFromNotebookFile(projectConfig, notebookFile);
            this.jupyterService.stripCellOutputsFromNotebookFile(projectConfig, checkpointFile);
        }
    }

    protected void exportNotebooksWithOutputs() throws IOException {
        RelFile jupyterDir = new RelFile(new String[]{"notebook_results", "jupyter", this.projectKey});
        if (this.dataDirFS.isDirectory(jupyterDir)) {
            this.zipDirectory(jupyterDir, new RelFile(new String[]{"notebook_results", "jupyter"}));
        }
    }

    protected void exportWikiData() throws IOException {
        RelFile dir = new RelFile(new String[]{"wiki-attachments", this.projectKey});
        if (this.dataDirFS.isDirectory(dir)) {
            this.zipDirectory(dir, "wiki-attachments");
        }
    }

    protected void exportDiscussionsData() throws Exception {
        List<Discussion> discussions = this.discussionsDAO.getDiscussionsForProject(this.projectKey);
        for (Discussion discu : discussions) {
            discu.projectKey = null;
        }
        this.targetZipFS.writeObject(new RelFile(new String[]{"discussions", "discussions.json"}), (Object)new DiscussionList(discussions));
    }

    protected void exportExperimentTrackingData() throws Exception {
        ExperimentTrackingExportData exportData = this.experimentTrackingService.getExportData(this.projectKey);
        this.targetZipFS.writeObject(new RelFile(new String[]{"experiment-tracking", "experiment-tracking.json"}), (Object)exportData);
    }

    protected void exportReportsData() throws IOException {
        RelFile reports = new RelFile(new String[]{"code-reports", this.projectKey});
        if (this.dataDirFS.isDirectory(reports)) {
            this.zipDirectory(reports, "code-reports");
        }
    }

    protected void exportReportExportsData() throws IOException {
        RelFile reports = new RelFile(new String[]{"reports_exports", this.projectKey});
        if (this.dataDirFS.isDirectory(reports)) {
            this.zipDirectory(reports, new RelFile(new String[]{"reports_exports"}));
        }
    }

    protected void exportConfig(RelFileFilter filter, boolean stripNotebooksCellsOutputsFromConfig, boolean exportGitRepository, boolean exportForNewBranch) throws Exception {
        InMemoryDiff inMemoryConfigDiff = new InMemoryDiff((ReadOnlyFS)TransactionContext.retrieveRead());
        ReadWriteFS projectConfig = inMemoryConfigDiff.directoryView(new RelFile(new String[]{"projects", this.projectKey}));
        if (!exportForNewBranch) {
            ProjectImportExportUtils.regenerateAPIKeys(projectConfig, true);
            this.clearConfig(projectConfig);
        }
        ProjectImportExportUtils.decryptApiServiceApiKeys(projectConfig);
        if (stripNotebooksCellsOutputsFromConfig) {
            this.stripNotebooksCellsOutputsFromConfig(projectConfig);
        }
        if (!exportGitRepository) {
            logger.info((Object)"Removing Git repository");
            if (projectConfig.isDirectory(".git")) {
                projectConfig.deleteDirectory(".git");
            }
        }
        FSUtils.newRecursiveCopy().from((ReadOnlyFS)inMemoryConfigDiff, new RelFile(new String[]{"projects", this.projectKey})).to((ReadWriteFS)this.targetZipFS, "project_config").filter(filter).run();
    }

    private void clearConfig(ReadWriteFS projectConfig) throws Exception {
        String paramsFilePath = "params.json";
        if (projectConfig.isFile(paramsFilePath)) {
            SerializedProject sp = (SerializedProject)projectConfig.readObject(paramsFilePath, SerializedProject.class);
            sp.projectStatus = null;
            projectConfig.writeObject(paramsFilePath, (Object)sp);
        }
    }

    protected void gatherUsedConnections(ExportedProject ep, @Nullable InfoMessage.InfoMessages messages) throws IOException, DKUSecurityException {
        Boolean hasPartitionedDataset = false;
        for (SerializedDataset sd : this.datasetsDAO.listUnsafe(this.projectKey)) {
            if (!sd.isPartitioned()) continue;
            hasPartitionedDataset = true;
        }
        ep.hasPartitionedDataset = hasPartitionedDataset;
        Map<String, DatasetConnectionUtils.UsedConnection> used = this.connectionUsagesService.listUsages(this.authCtx, this.projectKey, true);
        for (Map.Entry<String, DatasetConnectionUtils.UsedConnection> entry : used.entrySet()) {
            if (entry.getValue().isMissing) {
                ep.allowedMissingConnections.add(entry.getKey());
                if (messages == null) continue;
                messages.withWarningV((InfoMessage.MessageCode)ProjectImportExportCodes.ERR_MISSING_CONNECTION_WHEN_EXPORTING, "Connection %s is missing", new Object[]{entry.getKey()});
                continue;
            }
            ep.requiredConnections.put(entry.getKey(), entry.getValue());
        }
    }

    protected void gatherUsedCodeEnvs(ExportedProject ep, @Nullable InfoMessage.InfoMessages messages, boolean includeNotebookCodeEnv) throws IOException {
        HashMap deploymentModes = Maps.newHashMap();
        if (ApplicationConfigurator.getNodeType() == ApplicationConfigurator.DSSNodeType.AUTOMATION) {
            for (CodeEnvModel.CodeEnvListItem env : this.automationNodeCodeEnvsService.listCodeEnvs()) {
                deploymentModes.put(new CodeEnvModel.UsedCodeEnvRef(env.envLang, env.envName), env.deploymentMode);
            }
        } else {
            for (CodeEnvModel.CodeEnvListItem env : this.designNodeCodeEnvsService.listCodeEnvs()) {
                deploymentModes.put(new CodeEnvModel.UsedCodeEnvRef(env.envLang, env.envName), env.deploymentMode);
            }
        }
        List<CodeEnvModel.CodeEnvUsage> usages = this.codeEnvUsagesService.listUsages((CodeEnvModel.UsedCodeEnvRef)null, this.projectKey);
        HashSet used = Sets.newHashSet();
        for (CodeEnvModel.CodeEnvUsage usage : usages) {
            if (StringUtils.isBlank((String)usage.envName)) continue;
            CodeEnvModel.UsedCodeEnvRef use = new CodeEnvModel.UsedCodeEnvRef(usage.envLang, usage.envName);
            CodeEnvModel.CodeEnvDeploymentMode deploymentMode = (CodeEnvModel.CodeEnvDeploymentMode)((Object)deploymentModes.get(use));
            if (deploymentMode == null) {
                if (messages != null) {
                    messages.withWarningV((InfoMessage.MessageCode)ProjectImportExportCodes.ERR_MISSING_CODE_ENV_WHEN_EXPORTING, "Code env %s is missing", new Object[]{usage.envName});
                }
                logger.warn((Object)("Skipping referencing of code env " + usage.envName + " because it doesn't exist"));
                continue;
            }
            if (deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED || deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_NON_MANAGED) {
                logger.info((Object)("Skipping referencing of code env " + usage.envName + " because it's a plugin's code env"));
                continue;
            }
            if (usage.envUsage == CodeEnvModel.EnvUsage.NOTEBOOK && !includeNotebookCodeEnv) {
                logger.info((Object)("Skipping referencing of code env " + usage.envName + " because it's used by a notebook and they're not included in this export"));
                continue;
            }
            used.add(use);
        }
        ep.usedCodeEnvRefs.addAll(used);
    }

    protected void gatherUsedContainerExecConfs(ExportedProject ep, @Nullable InfoMessage.InfoMessages messages) throws IOException {
        ClusterSettings clusterSettings = new ClusterSelector().selectGlobal();
        List existingConfigs = clusterSettings.getContainerSettings().executionConfigs.stream().map(c2 -> c2.name).collect(Collectors.toList());
        List<UsedContainerExec> usages = this.containerExecUsagesService.listUsages(this.projectKey);
        HashSet used = Sets.newHashSet();
        for (UsedContainerExec usage : usages) {
            String containerConf = usage.name;
            if (!existingConfigs.contains(containerConf)) {
                if (messages != null) {
                    messages.withWarningV((InfoMessage.MessageCode)ProjectImportExportCodes.ERR_MISSING_CONTAINER_EXEC_WHEN_EXPORTING, "Containerized execution config %s is missing", new Object[]{containerConf});
                }
                logger.warn((Object)("Skipping referencing of container exec '" + containerConf + "' because it doesn't exist"));
                continue;
            }
            used.add(usage);
        }
        ep.usedContainerExecConfs.addAll(used);
    }

    protected void gatherInstalledPlugins(ExportedProject ep) {
        for (InstalledPluginDesc ipd : this.pluginsService.getLoadedPlugins()) {
            ExportedProject.InstalledPluginRef ipr = new ExportedProject.InstalledPluginRef();
            ipr.pluginId = ipd.desc.id;
            ipr.version = ipd.desc.version;
            ep.exportedWithPlugins.add(ipr);
        }
    }

    protected void gatherCodeStudioTemplates_T(ExportedProject ep) throws IOException {
        Set usedTemplateIds = this.gatherCodeStudiosUsedByWebapps_T().stream().map(cs2 -> cs2.templateId).collect(Collectors.toSet());
        for (CodeStudioTemplate cst : this.codeStudioTemplatesDAO.list()) {
            ExportedProject.InstalledCodeStudioTemplateRef icstr = new ExportedProject.InstalledCodeStudioTemplateRef();
            icstr.templateId = cst.id;
            icstr.templateLabel = cst.getLabel();
            ep.exportedWithCodeStudioTemplates.add(icstr);
            if (!usedTemplateIds.contains(cst.id)) continue;
            ep.requiredCodeStudioTemplates.add(icstr);
        }
    }

    protected List<ProjectExportOptions.IncludedCodeStudio> gatherIncludedCodeStudiosUsedByWebapps_T() throws IOException {
        return this.gatherCodeStudiosUsedByWebapps_T().stream().map(cs2 -> {
            ProjectExportOptions.IncludedCodeStudio ics = new ProjectExportOptions.IncludedCodeStudio();
            ics.id = cs2.id;
            return ics;
        }).collect(Collectors.toList());
    }

    private Set<CodeStudioObject> gatherCodeStudiosUsedByWebapps_T() throws IOException {
        HashSet<CodeStudioObject> usedTemplates = new HashSet<CodeStudioObject>();
        for (WebApp webApp : this.webAppsDAO.listUnsafe(this.projectKey)) {
            try {
                if (!"CODE_STUDIO_AS_WEBAPP".equals(webApp.type)) continue;
                CodeStudioWebAppMeta.CodeStudioWebAppParams params = webApp.getParamsAs(CodeStudioWebAppMeta.CodeStudioWebAppParams.class);
                if (!StringUtils.isNotBlank((String)params.codeStudioId)) continue;
                CodeStudioObject codeStudio = (CodeStudioObject)this.codeStudioObjectsDAO.getMandatoryUnsafe(this.projectKey, params.codeStudioId);
                usedTemplates.add(codeStudio);
            }
            catch (Exception e) {
                logger.warn((Object)("Cannot check if webapp " + webApp.getFullId() + " uses a Code Studio, ignoring"), (Throwable)e);
            }
        }
        return usedTemplates;
    }

    protected RelFileFilter makeConfigCopyFilter(List<ProjectExportOptions.IncludedCodeStudio> kubToExport) {
        final RelFile projectCodeStudios = new RelFile(new String[]{"projects", this.projectKey, "code_studios"});
        final Set kubIdsToExport = kubToExport.stream().map(e -> e.id).collect(Collectors.toSet());
        RelFileFilter filter = new RelFileFilter(){

            public boolean accept(ReadOnlyFS fs, RelFile file) throws IOException {
                if (file.isStrictChildOf(projectCodeStudios)) {
                    String fileName = file.length() > 3 ? file.getElements()[3] : "__not_found__";
                    String kubId = fileName.endsWith(".json") ? fileName.substring(0, fileName.length() - 5) : fileName;
                    return kubIdsToExport.contains(kubId);
                }
                return true;
            }
        };
        return filter;
    }

    protected RelFileFilter makeConfigCopyExcludeEditableDatasetsFilter() {
        final RelFile projectConfigDatasets = new RelFile(new String[]{"projects", this.projectKey, "datasets"});
        return new RelFileFilter(){

            public boolean accept(ReadOnlyFS fs, RelFile file) {
                if (file.isStrictChildOf(projectConfigDatasets)) {
                    String fileName = file.length() > 3 ? file.getElements()[3] : "__not_found__";
                    return !fileName.endsWith(".data") && !fileName.endsWith(".changes");
                }
                return true;
            }
        };
    }

    protected RelFileFilter makeConfigCopyIncludeNotebook(boolean includeNotebooks) {
        if (includeNotebooks) {
            return new AcceptAllFilter();
        }
        final RelFile projectConfigNotebooks = new RelFile(new String[]{"projects", this.projectKey, "ipython_notebooks"});
        return new RelFileFilter(){

            public boolean accept(ReadOnlyFS fs, RelFile file) {
                return !file.isStrictChildOf(projectConfigNotebooks);
            }
        };
    }

    protected void exportTimelines() {
        try {
            RelFile tgt = new RelFile(new String[]{"timelines", "timeline.txt"});
            logger.info((Object)("Export timelines -> " + tgt.getFullPath()));
            ProjectTimeline projectTimeline = this.timelinesService.getProjectTimeLineForExport_NT(this.projectKey);
            try (PrintStream printStream = new PrintStream((OutputStream)this.targetZipFS.writeStream(tgt));){
                int lastItemIndex = projectTimeline.items.size() - 1;
                for (int i = 0; i <= lastItemIndex; ++i) {
                    TimelineItem timelineItem = projectTimeline.items.get(i);
                    String timeLineItemAsJson = new TimelineItemToJSONConverter().convertToJSON(timelineItem);
                    if (i == lastItemIndex) {
                        printStream.print(timeLineItemAsJson);
                        continue;
                    }
                    printStream.println(timeLineItemAsJson);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to export timelines", (Throwable)e);
        }
    }

    protected void exportSavedModelsData(List<ProjectExportOptions.IncludedSavedModel> list, BundleContentSummary contentSummary, InfoMessage.InfoMessages messages) throws Exception {
        this.exportSavedModelsData(list, contentSummary, messages, false);
    }

    protected void exportSavedModelsData(List<ProjectExportOptions.IncludedSavedModel> list, BundleContentSummary contentSummary, InfoMessage.InfoMessages messages, boolean exportSavedModelsRequiredVersions) throws Exception {
        try (FutureProgress.AutocloseableFutureProgressState f = FutureProgress.pushAutoCloseableState((String)"Exporting saved models", (double)list.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            int i = 0;
            for (ProjectExportOptions.IncludedSavedModel ism : list) {
                SavedModel sm;
                logger.infoV("Exporting saved model %s", new Object[]{ism.id});
                try (Transaction t = this.transactionService.beginRead();){
                    sm = (SavedModel)this.savedModelsDAO.getOrNullUnsafe(this.projectKey, ism.id);
                }
                if (sm == null) {
                    if (messages == null) {
                        throw new Exception("Cannot export saved model, it has been deleted from the project.");
                    }
                    messages.withFatal((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_EXPORT_SAVED_MODEL_EXPORT_FAILED, "Cannot export saved model, it has been deleted from the project.");
                    continue;
                }
                BundleContentSummary.IncludedSavedModel includedSavedModel = new BundleContentSummary.IncludedSavedModel();
                includedSavedModel.id = sm.id;
                includedSavedModel.name = sm.name;
                if (exportSavedModelsRequiredVersions) {
                    logger.infoV("Bundle includes only required versions of saved model %s.", new Object[]{ism.id});
                    Set<String> smVersionList = this.getModelUsedVersions(sm);
                    includedSavedModel.size = this.exportSavedModelUsedVersions(sm, smVersionList);
                } else {
                    logger.infoV("Bundle includes all versions of saved model %s.", new Object[]{ism.id});
                    includedSavedModel.size = this.exportSavedModel(ism.id);
                }
                contentSummary.includedSavedModels.add(includedSavedModel);
            }
            FutureProgress.updateState((double)(++i));
        }
    }

    private Set<String> getModelUsedVersions(SavedModel sm) throws Exception {
        HashSet<String> smVersionSet = new HashSet<String>();
        smVersionSet.add(sm.activeVersion);
        logger.infoV("Adding active version %s to bundle export for saved model %s", new Object[]{sm.activeVersion, sm.id});
        if (sm.isPartitioned()) {
            ProjectFlowGraph fGraph;
            try (Transaction t = this.transactionService.beginRead();){
                fGraph = this.graphService.getProjectGraphWithOrphansUnsafe(this.projectKey, false);
            }
            if (fGraph == null) {
                throw new Exception("Cannot get Flow graph from project " + this.projectKey);
            }
            List<? extends GraphNode> predecessors = fGraph.getModel(this.projectKey, sm.id).getPredecessors();
            if (predecessors.isEmpty()) {
                logger.infoV("Saved model %s is partitioned but haven't predecessor in flow. Not looking for a specified version for retraining.", new Object[]{sm.id});
            } else {
                AbstractPredictionTrainingRecipePayloadParams trainRecipePayload;
                FlowRecipe trainRecipe = (FlowRecipe)predecessors.get(0);
                try (Transaction t = this.transactionService.beginRead();){
                    trainRecipePayload = (AbstractPredictionTrainingRecipePayloadParams)JSON.parse((String)this.recipesDAO.getPayloadOrNull(this.projectKey, trainRecipe.getName()), AbstractPredictionTrainingRecipePayloadParams.class);
                }
                if (trainRecipePayload == null) {
                    throw new Exception("Cannot get " + trainRecipe.getName() + " train recipe payload.");
                }
                String partitionedModelTrainRecipeVersion = this.getPartitionedModelTrainRecipeVersion(sm, trainRecipePayload);
                if (partitionedModelTrainRecipeVersion != null) {
                    smVersionSet.add(partitionedModelTrainRecipeVersion);
                }
            }
        }
        return smVersionSet;
    }

    private String getPartitionedModelTrainRecipeVersion(SavedModel sm, AbstractPredictionTrainingRecipePayloadParams trainRecipePayload) throws Exception {
        TabularPredictionTrainingRecipePayloadParams.PartitionedTrainingSource partSmSourceType = ((TabularPredictionTrainingRecipePayloadParams)trainRecipePayload).partSource;
        switch (partSmSourceType) {
            case EXPLICIT_VERSION: {
                String explicitVersion = ((TabularPredictionTrainingRecipePayloadParams)trainRecipePayload).partSourceVersionId;
                if (sm.activeVersion.equals(explicitVersion)) {
                    logger.infoV("Retraining of partitioned model is configured with 'explicit version' version, which is also the 'active' version. Not adding it twice to the bundle.", new Object[]{sm.id});
                    break;
                }
                logger.infoV("Partitioned saved model %s used an explicit version for retraining, adding %s version to bundle export", new Object[]{sm.id, explicitVersion});
                return explicitVersion;
            }
            case LATEST_VERSION: {
                File[] smVersions = MLPaths.savedModelVersionsFolder(sm).listFiles();
                if (smVersions == null) {
                    throw new Exception("No version found for partitioned saved model " + sm.id);
                }
                String latestVersion = PredictionSMMgmtService.getLatestSMVersionId(this.psmmService.getStatus_NT((SavedModel)sm).versions);
                if (latestVersion.equals(sm.activeVersion)) {
                    logger.infoV("Retraining of partitioned model is configured with 'latest'  version, which is also the 'active' version. Not adding it twice to the bundle.", new Object[]{sm.id});
                    break;
                }
                logger.infoV("Partitioned saved model %s used the latest version for retraining, adding %s version to bundle export", new Object[]{sm.id, latestVersion});
                return latestVersion;
            }
            case ACTIVE_VERSION: {
                logger.infoV("Retraining of partitioned model %s is configured to 'active version' version. No other version added to bundle export.", new Object[]{sm.id});
                break;
            }
            case NONE: {
                logger.infoV("Retraining of partitioned model %s is configured to reuse no prior version. No other version added to bundle export.", new Object[]{sm.id});
                break;
            }
            default: {
                throw new Exception("Partitioned model " + sm.id + " retraining version type in training recipe not found.");
            }
        }
        return null;
    }

    private long exportSavedModel(String modelId) throws Exception {
        RelFile src = this.dataDirFS.relativize(MLPaths.savedModelBaseFolder(this.projectKey, modelId));
        RelFile tgt = new RelFile(new String[]{"saved_models", modelId});
        if (this.dataDirFS.isDirectory(src)) {
            this.zipDirectoryMaybeWithoutSymlinks(src, tgt);
            return FSUtils.calculateSize((ReadOnlyFS)this.targetZipFS, (RelFile)tgt);
        }
        logger.warn((Object)("Saved model " + modelId + " base folder not found (" + String.valueOf(src) + ")."));
        return 0L;
    }

    private long exportSavedModelUsedVersions(SavedModel sm, Set<String> versions) throws Exception {
        RelFile src = this.dataDirFS.relativize(MLPaths.savedModelBaseFolder(sm));
        RelFile tgt = new RelFile(new String[]{"saved_models", sm.id});
        if (this.dataDirFS.isDirectory(src)) {
            this.savedModelVersionExportFolder(sm, versions);
            if (MLPaths.savedModelCoreFolder(sm).exists()) {
                this.zipDirectoryMaybeWithoutSymlinks(this.dataDirFS.relativize(MLPaths.savedModelCoreFolder(sm)), new RelFile(new String[]{"saved_models", sm.id, "core"}));
            }
            return FSUtils.calculateSize((ReadOnlyFS)this.targetZipFS, (RelFile)tgt);
        }
        logger.warn((Object)("Saved model " + sm.id + " base folder not found (" + String.valueOf(src) + ")."));
        return 0L;
    }

    private void savedModelVersionExportFolder(SavedModel sm, Set<String> versions) throws Exception {
        for (String version : versions) {
            RelFile src = this.dataDirFS.relativize(MLPaths.savedModelVersionFolder(sm, version));
            if (this.dataDirFS.isDirectory(src)) {
                this.zipDirectoryMaybeWithoutSymlinks(src, new RelFile(new String[]{"saved_models", sm.id, "versions", version}));
                if (!sm.isPartitioned()) continue;
                for (File partitionPath : new FullModelId(sm.projectKey, sm.id, version).getPartitionModelFolders().values()) {
                    this.savedModelPartVersionExportFolder(sm, this.dataDirFS.relativize(partitionPath));
                }
                continue;
            }
            throw new Exception("Cannot export saved model " + sm.id + ", saved model version folder not found (" + String.valueOf(src) + ").");
        }
    }

    private void savedModelPartVersionExportFolder(SavedModel sm, RelFile partitionPath) throws Exception {
        if (!this.dataDirFS.isDirectory(partitionPath)) {
            throw new Exception("Cannot export saved model " + sm.id + ", saved model partitioned version folder not found (" + String.valueOf(partitionPath) + ").");
        }
        String partitionVersion = partitionPath.getLeafName();
        String partitionId = partitionPath.getParent().getLeafName();
        this.zipDirectoryMaybeWithoutSymlinks(partitionPath, new RelFile(new String[]{"saved_models", sm.id, "pversions", partitionId, partitionVersion}));
    }

    protected void exportLabelingTasksData(List<ProjectExportOptions.IncludedLabelingTask> list, BundleContentSummary contentSummary, InfoMessage.InfoMessages messages) throws Exception {
        try (FutureProgress.AutocloseableFutureProgressState f = FutureProgress.pushAutoCloseableState((String)"Exporting labeling task", (double)list.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            int i = 0;
            for (ProjectExportOptions.IncludedLabelingTask includedLabelingTask : list) {
                LabelingTask labelingTask;
                logger.infoV("Exporting labeling task %s", new Object[]{includedLabelingTask.id});
                try (Transaction t = this.transactionService.beginRead();){
                    labelingTask = (LabelingTask)this.labelingTasksDAO.getOrNullUnsafe(this.projectKey, includedLabelingTask.id);
                }
                if (labelingTask == null) {
                    if (messages == null) {
                        throw new Exception("Cannot export labeling task, it has been deleted from the project.");
                    }
                    messages.withFatal((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_EXPORT_LABELING_TASK_EXPORT_FAILED, "Cannot export labeling task, it has been deleted from the project.");
                    continue;
                }
                BundleContentSummary.IncludedLabelingTask bundleIncludedLabelingTask = new BundleContentSummary.IncludedLabelingTask();
                bundleIncludedLabelingTask.id = labelingTask.id;
                bundleIncludedLabelingTask.name = labelingTask.name;
                bundleIncludedLabelingTask.size = this.exportLabelingTask(this.authCtx, includedLabelingTask.id);
                contentSummary.includedLabelingTasks.add(bundleIncludedLabelingTask);
            }
            FutureProgress.updateState((double)(++i));
        }
    }

    private long exportLabelingTask(AuthCtx authCtx, String labelingTaskId) throws Exception {
        RelFile tgtLabelingAnswers = new RelFile(new String[]{"labeling", labelingTaskId, "labeling-answers.json"});
        List<LabelingAnswer> labelingAnswers = this.labelingAnswerCRUDService.listAllNoCheckMetadata(authCtx, this.projectKey, labelingTaskId);
        this.targetZipFS.writeObject(tgtLabelingAnswers, (Object)new AnswerList.LabelingAnswerList(labelingAnswers));
        RelFile tgtVerifiedLabelingAnswers = new RelFile(new String[]{"labeling", labelingTaskId, "verified-labeling-answers.json"});
        List<VerifiedLabelingAnswer> verifiedLabelingAnswers = this.labelingAnswerCRUDService.listAllVerifiedNoCheckMetadata(authCtx, this.projectKey, labelingTaskId);
        this.targetZipFS.writeObject(tgtVerifiedLabelingAnswers, (Object)new AnswerList.VerifiedLabelingAnswerList(verifiedLabelingAnswers));
        return FSUtils.calculateSize((ReadOnlyFS)this.targetZipFS, (RelFile)new RelFile(new String[]{"labeling"}));
    }

    protected void exportModelEvaluationStoresData(List<ProjectExportOptions.IncludedModelEvaluationStore> list, BundleContentSummary contentSummary, InfoMessage.InfoMessages messages) throws Exception {
        try (FutureProgress.AutocloseableFutureProgressState f = FutureProgress.pushAutoCloseableState((String)"Exporting saved models", (double)list.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            int i = 0;
            for (ProjectExportOptions.IncludedModelEvaluationStore imes : list) {
                ModelEvaluationStore mes;
                logger.infoV("Exporting saved model %s", new Object[]{imes.id});
                try (Transaction t = this.transactionService.beginRead();){
                    mes = (ModelEvaluationStore)this.modelEvaluationStoresDAO.getOrNullUnsafe(this.projectKey, imes.id);
                }
                if (mes == null) {
                    if (messages == null) {
                        throw new Exception("Cannot export model evaluation store, it has been deleted from the project.");
                    }
                    messages.withFatal((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_EXPORT_MODEL_EVALUATION_STORE_EXPORT_FAILED, "Cannot export model evaluation store, it has been deleted from the project.");
                    continue;
                }
                BundleContentSummary.IncludedModelEvaluationStore includedModelEvaluationStore = new BundleContentSummary.IncludedModelEvaluationStore();
                includedModelEvaluationStore.id = mes.id;
                includedModelEvaluationStore.name = mes.name;
                includedModelEvaluationStore.size = this.exportModelEvaluationStore(imes.id);
                contentSummary.includedModelEvaluationStores.add(includedModelEvaluationStore);
            }
            FutureProgress.updateState((double)(++i));
        }
    }

    private long exportModelEvaluationStore(String modelId) throws IOException {
        RelFile src = new RelFile(new String[]{"model_evaluation_stores", this.projectKey, modelId});
        RelFile tgt = new RelFile(new String[]{"model_evaluation_stores", modelId});
        if (this.dataDirFS.isDirectory(src)) {
            this.zipDirectory(src, tgt);
            return FSUtils.calculateSize((ReadOnlyFS)this.targetZipFS, (RelFile)tgt);
        }
        return 0L;
    }

    protected void exportManagedFoldersData(List<ProjectExportOptions.IncludedManagedFolder> list, BundleContentSummary contentSummary, InfoMessage.InfoMessages messages) throws Exception {
        try (FutureProgress.AutocloseableFutureProgressState f = FutureProgress.pushAutoCloseableState((String)"Exporting managed folders", (double)list.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            int i = 0;
            for (ProjectExportOptions.IncludedManagedFolder imf : list) {
                ManagedFolder folder;
                logger.infoV("Exporting managed folder %s", new Object[]{imf.id});
                try (Transaction t = this.transactionService.beginRead();){
                    folder = (ManagedFolder)this.managedFolderDAO.getOrNullUnsafe(this.projectKey, imf.id);
                }
                if (folder == null) {
                    if (messages == null) {
                        throw new Exception("Cannot export managed folder, it has been deleted from the project.");
                    }
                    messages.withFatal((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_EXPORT_MANAGED_FOLDER_EXPORT_FAILED, "Cannot export managed folder, it has been deleted from the project.");
                    continue;
                }
                BundleContentSummary.IncludedManagedFolder includedManagedFolder = new BundleContentSummary.IncludedManagedFolder();
                includedManagedFolder.id = folder.id;
                includedManagedFolder.name = folder.name;
                includedManagedFolder.size = this.exportManagedFolder(folder);
                contentSummary.includedManagedFolders.add(includedManagedFolder);
            }
            FutureProgress.updateState((double)(++i));
        }
    }

    private long exportManagedFolder(ManagedFolder folder) throws Exception {
        RelFile tgt = new RelFile(new String[]{"managed_folders", folder.id});
        try (ManagedFolderHandler handler = (ManagedFolderHandler)folder.buildHandler(this.authCtx);){
            long l = handler.transferToReadWriteFS((ReadWriteFS)this.targetZipFS, tgt);
            return l;
        }
    }

    protected void exportDatasetsData(List<ProjectExportOptions.IncludedDatasetData> list, BundleContentSummary contentSummary, InfoMessage.InfoMessages messages) throws Exception {
        try (FutureProgress.AutocloseableFutureProgressState f = FutureProgress.pushAutoCloseableState((String)"Exporting datasets data", (double)list.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            int i = 0;
            for (ProjectExportOptions.IncludedDatasetData idd : list) {
                try (FutureProgress.AutocloseableFutureProgressState f2 = FutureProgress.pushAutoCloseableState((String)("Exporting dataset data: " + idd.name));){
                    logger.infoV("Exporting dataset data %s", new Object[]{idd.name});
                    Dataset dataset = null;
                    try (Transaction t = this.transactionService.beginRead();){
                        dataset = this.datasetAccessService.getMandatory(this.projectKey, idd.name);
                        if (dataset.getPartitioningSchema().isPartitioned()) {
                            throw ErrorContext.iaef((String)"Cannot export data for a partitioned dataset: %s", (Object)dataset.getFullName(), (Object[])new Object[0]);
                        }
                        if (dataset.getType().equals(JobsdbDatasetHandler.META.getType()) || dataset.getType().equals(StatsDBDatasetHandler.META.getType())) {
                            throw ErrorContext.iaef((String)"Cannot export data for this dataset type (%s): %s", (Object)dataset.getType(), (Object[])new Object[]{dataset.getFullName()});
                        }
                        if (DatasetInspector.isHive(dataset)) {
                            throw ErrorContext.iaef((String)"Cannot export data for this dataset type (%s as hive): %s", (Object)dataset.getType(), (Object[])new Object[]{dataset.getFullName()});
                        }
                        if (DatasetInspector.isSQL(dataset) && !DatasetInspector.isSQLTable(dataset)) {
                            throw ErrorContext.iaef((String)"Cannot export data for this dataset type (%s as query): %s", (Object)dataset.getType(), (Object[])new Object[]{dataset.getFullName()});
                        }
                    }
                    try {
                        BundleContentSummary.IncludedDataset id = new BundleContentSummary.IncludedDataset();
                        id.name = idd.name;
                        id.type = dataset.getType();
                        switch (dataset.getType()) {
                            case "Filesystem": {
                                id.size = this.exportFSDatasetData(dataset);
                                id.usedTransferMethod = ProjectExportOptions.DatasetDataTransferMethod.RAW_FILES;
                                break;
                            }
                            case "UploadedFiles": {
                                id.size = this.exportUploadedDatasetData(dataset);
                                id.usedTransferMethod = ProjectExportOptions.DatasetDataTransferMethod.UPLOAD;
                                break;
                            }
                            case "Inline": {
                                id.size = this.exportInlineDatasetData(dataset);
                                id.usedTransferMethod = ProjectExportOptions.DatasetDataTransferMethod.INLINE;
                                break;
                            }
                            default: {
                                id.size = this.exportAnyDatasetData(dataset);
                                id.usedTransferMethod = ProjectExportOptions.DatasetDataTransferMethod.DATA_BUNDLE;
                            }
                        }
                        contentSummary.includedDatasets.add(id);
                        logger.infoV("Export of %s done: size=%d", new Object[]{dataset.getFullName(), id.size});
                    }
                    catch (DataExportFailedException e) {
                        logger.warn((Object)("Export of " + dataset.getFullName() + " failed"), (Throwable)e);
                        this.throwIfExportTooLarge(e);
                        if (messages == null) {
                            throw e;
                        }
                        messages.withFatal((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_EXPORT_DATASET_EXPORT_FAILED, "For dataset " + dataset.getFullName() + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e));
                    }
                }
                FutureProgress.updateState((double)(++i));
            }
        }
    }

    protected void throwIfExportTooLarge(Exception e) {
        Throwable t = e;
        while (t.getCause() != null) {
            if (t.getCause() instanceof CodedRuntimeException && ExportCodes.ERR_EXPORT_OUTPUT_TOO_LARGE.equals(((CodedRuntimeException)t.getCause()).getCode())) {
                throw (CodedRuntimeException)t.getCause();
            }
            t = t.getCause();
        }
    }

    protected void exportCodeStudiosData(List<ProjectExportOptions.IncludedCodeStudio> list, BundleContentSummary contentSummary, InfoMessage.InfoMessages messages) throws Exception {
        try (FutureProgress.AutocloseableFutureProgressState f = FutureProgress.pushAutoCloseableState((String)"Exporting Code Studios", (double)list.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            int i = 0;
            for (ProjectExportOptions.IncludedCodeStudio icodeStudio : list) {
                CodeStudioObject codeStudio;
                logger.infoV("Exporting Code Studio %s", new Object[]{icodeStudio.id});
                try (Transaction t = this.transactionService.beginRead();){
                    codeStudio = (CodeStudioObject)this.codeStudioObjectsDAO.getOrNullUnsafe(this.projectKey, icodeStudio.id);
                }
                if (codeStudio == null) {
                    if (messages == null) {
                        throw new Exception("Cannot export Code Studio, it has been deleted from the project.");
                    }
                    messages.withFatal((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_EXPORT_CODE_STUDIO_EXPORT_FAILED, "Cannot export Code Studio, it has been deleted from the project.");
                    continue;
                }
                BundleContentSummary.IncludedCodeStudio includedCodeStudio = new BundleContentSummary.IncludedCodeStudio();
                includedCodeStudio.id = codeStudio.id;
                includedCodeStudio.name = codeStudio.name;
                includedCodeStudio.size = this.exportCodeStudio(codeStudio);
                contentSummary.includedCodeStudios.add(includedCodeStudio);
            }
            FutureProgress.updateState((double)(++i));
        }
    }

    private long exportCodeStudio(CodeStudioObject codeStudio) throws IOException {
        RelFile src = new RelFile(new String[]{"lib", "code_studio", codeStudio.projectKey, codeStudio.libName});
        RelFile tgt = new RelFile(new String[]{"code_studios", codeStudio.id});
        if (this.dataDirFS.isDirectory(src)) {
            this.zipDirectory(src, tgt);
            return FSUtils.calculateSize((ReadOnlyFS)this.targetZipFS, (RelFile)tgt);
        }
        return 0L;
    }

    private long exportAnyDatasetData(Dataset dataset) throws DataExportFailedException {
        try {
            DatasetFileTransferer transferer = new DatasetFileTransferer();
            RelFile tgt = new RelFile(new String[]{"any_datasets_data", dataset.getName()});
            this.targetZipFS.makeDirectory(tgt);
            transferer.dumpDatasetToZip(this.authCtx, this.projectKey, (ReadWriteFS)this.targetZipFS, tgt, dataset);
            return FSUtils.calculateSize((ReadOnlyFS)this.targetZipFS, (RelFile)tgt);
        }
        catch (Exception e) {
            throw new DataExportFailedException("Failed to export data for " + dataset.getFullName(), e);
        }
    }

    protected long exportUploadedDatasetData(Dataset dataset) throws DataExportFailedException {
        long l;
        block8: {
            AbstractFSDatasetHandler fsHandler = (AbstractFSDatasetHandler)DatasetHandlerFactory.build(this.authCtx, dataset);
            try {
                this.targetZipFS.makeDirectory("uploads");
                RelFile tgt = new RelFile(new String[]{"uploads", dataset.getName()});
                l = fsHandler.transferToZip(this.targetZipFS, tgt);
                if (fsHandler == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fsHandler != null) {
                        try {
                            fsHandler.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new DataExportFailedException("Failed to export data for " + dataset.getFullName(), e);
                }
            }
            fsHandler.close();
        }
        return l;
    }

    private long exportFSDatasetData(Dataset dataset) throws DataExportFailedException {
        long l;
        block8: {
            AbstractFSDatasetHandler fsHandler = (AbstractFSDatasetHandler)DatasetHandlerFactory.build(this.authCtx, dataset);
            try {
                RelFile tgt = new RelFile(new String[]{"fs_datasets_data", dataset.getName()});
                l = fsHandler.transferToZip(this.targetZipFS, tgt);
                if (fsHandler == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fsHandler != null) {
                        try {
                            fsHandler.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new DataExportFailedException("Failed to export data for " + dataset.getFullName(), e);
                }
            }
            fsHandler.close();
        }
        return l;
    }

    private long exportInlineDatasetData(Dataset dataset) throws IOException, DataExportFailedException {
        InlineDatasetHandler fsHandler = (InlineDatasetHandler)DatasetHandlerFactory.build(this.authCtx, dataset);
        try {
            RelFile srcData = new RelFile(new String[]{"config", "projects", dataset.getProjectKey(), "datasets", dataset.getName() + ".data"});
            RelFile srcChanges = new RelFile(new String[]{"config", "projects", dataset.getProjectKey(), "datasets", dataset.getName() + ".changes"});
            RelFile tgtData = new RelFile(new String[]{"project_config", "datasets", dataset.getName() + ".data"});
            RelFile tgtChanges = new RelFile(new String[]{"project_config", "datasets", dataset.getName() + ".changes"});
            if (this.dataDirFS.isFile(srcData)) {
                this.zipDirectory(srcData, tgtData);
                if (this.dataDirFS.isFile(srcChanges)) {
                    this.zipDirectory(srcChanges, tgtChanges);
                }
            }
            long res = 0L;
            if (this.targetZipFS.isFile(tgtData)) {
                res += FSUtils.calculateSize((ReadOnlyFS)this.targetZipFS, (RelFile)tgtData);
                if (this.targetZipFS.isFile(tgtChanges)) {
                    res += FSUtils.calculateSize((ReadOnlyFS)this.targetZipFS, (RelFile)tgtChanges);
                }
            }
            long l = res;
            if (fsHandler != null) {
                fsHandler.close();
            }
            return l;
        }
        catch (Throwable throwable) {
            try {
                if (fsHandler != null) {
                    try {
                        fsHandler.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new DataExportFailedException("Failed to export data for " + dataset.getFullName(), e);
            }
        }
    }

    protected void exportCodeEnvs(ExportedProject ep) throws Exception {
        try (FutureProgress.AutocloseableFutureProgressState f = FutureProgress.pushAutoCloseableState((String)"Exporting Python environments");){
            for (CodeEnvModel.UsedCodeEnvRef ref : ep.usedCodeEnvRefs) {
                RelFile tgt;
                if (ref.envLang == CodeEnvModel.EnvLang.PYTHON) {
                    tgt = new RelFile(new String[]{"python-envs", ref.envName});
                    this.targetZipFS.makeDirectory(tgt);
                    logger.infoV("Exporting Code env %s: %s to %s", new Object[]{ref.envLang, ref.envName, tgt.getFullPath()});
                    if (ApplicationConfigurator.isAutomation()) {
                        this.automationNodeCodeEnvsService.exportEnvDefToFS(ep.originalProjectKey, CodeEnvModel.EnvLang.PYTHON, ref.envName, this.targetZipFS.directoryView(tgt));
                        continue;
                    }
                    this.designNodeCodeEnvsService.exportEnvDefToFS(CodeEnvModel.EnvLang.PYTHON, ref.envName, this.targetZipFS.directoryView(tgt));
                    continue;
                }
                if (ref.envLang == CodeEnvModel.EnvLang.R) {
                    tgt = new RelFile(new String[]{"r-envs", ref.envName});
                    this.targetZipFS.makeDirectory(tgt);
                    logger.infoV("Exporting Code env %s: %s to %s", new Object[]{ref.envLang, ref.envName, tgt.getFullPath()});
                    if (ApplicationConfigurator.isAutomation()) {
                        this.automationNodeCodeEnvsService.exportEnvDefToFS(ep.originalProjectKey, CodeEnvModel.EnvLang.R, ref.envName, this.targetZipFS.directoryView(tgt));
                        continue;
                    }
                    this.designNodeCodeEnvsService.exportEnvDefToFS(CodeEnvModel.EnvLang.R, ref.envName, this.targetZipFS.directoryView(tgt));
                    continue;
                }
                logger.infoV("Unknown code env lang %s: %s, not exporting", new Object[]{ref.envLang, ref.envName});
            }
        }
    }

    protected void exportKnowledgeBankData(List<ProjectExportOptions.IncludedKnowledgeBank> list, BundleContentSummary contentSummary, InfoMessage.InfoMessages messages) throws Exception {
        try (FutureProgress.AutocloseableFutureProgressState f = FutureProgress.pushAutoCloseableState((String)"Exporting Retrievable Knowledge", (double)list.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            int i = 0;
            for (ProjectExportOptions.IncludedKnowledgeBank includedKnowledgeBank : list) {
                RetrievableKnowledge retrievableKnowledge;
                logger.infoV("Exporting Knowledge bank %s", new Object[]{includedKnowledgeBank.id});
                try (Transaction t = this.transactionService.beginRead();){
                    retrievableKnowledge = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getOrNullUnsafe(this.projectKey, includedKnowledgeBank.id);
                }
                if (retrievableKnowledge == null) {
                    if (messages == null) {
                        throw new Exception("Cannot export knowledge bank, it has been deleted from the project.");
                    }
                    messages.withFatal((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_EXPORT_RETRIEVABLE_KNOWLEDGE_EXPORT_FAILED, "Cannot export knowledge bank, it has been deleted from the project.");
                } else {
                    BundleContentSummary.IncludedKnowledgeBank knowledgeBankSummary = new BundleContentSummary.IncludedKnowledgeBank();
                    knowledgeBankSummary.id = retrievableKnowledge.id;
                    knowledgeBankSummary.name = retrievableKnowledge.name;
                    knowledgeBankSummary.size = this.exportKnowledgeBank(retrievableKnowledge);
                    contentSummary.includedKnowledgeBanks.add(knowledgeBankSummary);
                }
                FutureProgress.updateState((double)(++i));
            }
        }
    }

    private long exportKnowledgeBank(RetrievableKnowledge retrievableKnowledge) throws IOException {
        RelFile src = new RelFile(new String[]{"knowledge-banks", this.projectKey, retrievableKnowledge.id});
        RelFile tgt = new RelFile(new String[]{"knowledge-banks", retrievableKnowledge.id});
        if (this.dataDirFS.isDirectory(src)) {
            this.zipDirectory(src, tgt);
            return FSUtils.calculateSize((ReadOnlyFS)this.targetZipFS, (RelFile)tgt);
        }
        return 0L;
    }

    protected void exportPromptStudioHistories(List<ProjectExportOptions.IncludedPromptStudioHistory> list, BundleContentSummary contentSummary, InfoMessage.InfoMessages messages) throws Exception {
        try (FutureProgress.AutocloseableFutureProgressState f = FutureProgress.pushAutoCloseableState((String)"Exporting Retrievable Knowledge", (double)list.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            int i = 0;
            for (ProjectExportOptions.IncludedPromptStudioHistory includedPromptStudioHistory : list) {
                PromptStudio.PromptStudioPromptHistory promptStudioPromptHistory;
                logger.infoV("Exporting Prompt Studio History %s-%s", new Object[]{includedPromptStudioHistory.promptStudioId, includedPromptStudioHistory.promptId});
                try (Transaction t = this.transactionService.beginRead();){
                    promptStudioPromptHistory = this.promptStudiosCRUDService.getPromptHistory(this.projectKey, includedPromptStudioHistory.promptStudioId, includedPromptStudioHistory.promptId);
                }
                if (promptStudioPromptHistory == null) {
                    if (messages == null) {
                        throw new Exception("Cannot export prompt studio prompt history, it has been deleted from the project.");
                    }
                    messages.withFatal((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_EXPORT_PROMPT_STUDIOS_HISTORIES_FAILED, "Cannot export prompt studio prompt history " + includedPromptStudioHistory.promptId + " it has been deleted from the project.");
                } else {
                    BundleContentSummary.IncludedPromptStudioHistory includedPromptStudioSummary = new BundleContentSummary.IncludedPromptStudioHistory();
                    includedPromptStudioSummary.promptId = includedPromptStudioHistory.promptId;
                    includedPromptStudioSummary.promptStudioId = includedPromptStudioHistory.promptStudioId;
                    includedPromptStudioSummary.size = this.exportPromptStudioHistory(includedPromptStudioHistory);
                    contentSummary.includedPromptStudiosHistories.add(includedPromptStudioSummary);
                }
                FutureProgress.updateState((double)(++i));
            }
        }
    }

    private long exportPromptStudioHistory(ProjectExportOptions.IncludedPromptStudioHistory includedPromptStudioHistory) throws IOException {
        RelFile src = new RelFile(new String[]{"prompt-studios", this.projectKey, includedPromptStudioHistory.promptStudioId, "prompts", includedPromptStudioHistory.promptId});
        RelFile tgt = new RelFile(new String[]{"prompt-studios", includedPromptStudioHistory.promptStudioId, "prompts", includedPromptStudioHistory.promptId});
        if (this.dataDirFS.isDirectory(src)) {
            this.zipDirectory(src, tgt);
            return FSUtils.calculateSize((ReadOnlyFS)this.targetZipFS, (RelFile)tgt);
        }
        return 0L;
    }

    protected void gatherUsedForeignObjects(FlowGraph projectGraph, ExportedProject ep) {
        this.gatherUsedForeignObjects(ep, projectGraph.datasets);
        this.gatherUsedForeignObjects(ep, projectGraph.folders);
        this.gatherUsedForeignObjects(ep, projectGraph.models);
        this.gatherUsedForeignObjects(ep, projectGraph.streamingEndpoints);
        this.gatherUsedForeignObjects(ep, projectGraph.evaluationStores);
        this.gatherUsedForeignObjects(ep, projectGraph.retrievableKnowledges);
    }

    private void gatherUsedForeignObjects(ExportedProject ep, Map<String, ? extends FlowComputable> computables) {
        if (computables != null) {
            for (FlowComputable flowComputable : computables.values()) {
                AnyLoc loc = AnyLoc.resolveFull(flowComputable.getFullId());
                boolean isLocal = loc.getProjectKey().equals(this.projectKey);
                if (isLocal) continue;
                ep.foreignObjects.add(new TaggableObjectsService.TaggableObjectRef(loc.getProjectKey(), flowComputable.getType().toTaggableType(), loc.getId()));
            }
        }
    }
}

