/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projectstandards;

import com.dataiku.common.stereotype.PartOfPublicAPI;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

@UIModel
@PartOfPublicAPI
public class ProjectStandardsScope {
    public static final String DEFAULT_SCOPE_NAME = "Default";
    public static final String DEFAULT_SCOPE_DESCRIPTION = "Project Standards will run these checks only if the project matches no other scope.";
    public String name;
    public String description;
    public List<String> checks = new ArrayList<String>();
    public SelectionMethod selectionMethod = SelectionMethod.BY_PROJECT;
    public List<String> selectedProjects = new ArrayList<String>();
    public List<String> selectedFolders = new ArrayList<String>();
    public List<String> selectedTags = new ArrayList<String>();

    @Nonnull
    public static ProjectStandardsScope createDefaultScope() {
        ProjectStandardsScope defaultScope = new ProjectStandardsScope();
        defaultScope.name = DEFAULT_SCOPE_NAME;
        defaultScope.description = DEFAULT_SCOPE_DESCRIPTION;
        defaultScope.selectionMethod = SelectionMethod.ALL;
        return defaultScope;
    }

    public boolean projectFitsScope(SerializedProject serializedProject, List<String> projectFolderIds) {
        return switch (this.selectionMethod) {
            default -> throw new IncompatibleClassChangeError();
            case SelectionMethod.BY_PROJECT -> this.selectedProjects.contains(serializedProject.projectKey);
            case SelectionMethod.BY_FOLDER -> {
                if (projectFolderIds != null) {
                    if (this.selectedFolders.stream().anyMatch(projectFolderIds::contains)) {
                        yield true;
                    }
                }
                yield false;
            }
            case SelectionMethod.BY_TAG -> this.selectedTags.stream().anyMatch(serializedProject.tags::contains);
            case SelectionMethod.ALL -> true;
        };
    }

    public static enum SelectionMethod {
        BY_PROJECT,
        BY_FOLDER,
        BY_TAG,
        ALL;

    }
}

