/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.sparksql;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.common.JobProcessExecution;
import com.dataiku.dip.dataflow.exec.AbstractSparkBasedRecipeRunner;
import com.dataiku.dip.dataflow.exec.SparkExecutionEnginesHelper;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.code.spark.SparkRecipeUtils;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLLogParser;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLQueryJobDefBuilder;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLQueryRecipeJobDef;
import com.dataiku.dip.spark.SparkCodes;
import com.dataiku.dip.spark.SparkJob;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.util.List;

public abstract class SparkSQLQueryRecipeRunnerBase
extends AbstractSparkBasedRecipeRunner {
    protected final SparkSQLQueryJobDefBuilder jobDefBuilder;
    private final SparkSQLLogParser sparkSQLLogParser = new SparkSQLLogParser();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sparksql");

    public SparkSQLQueryRecipeRunnerBase(JobActivity activity) {
        super(activity);
        this.jobDefBuilder = new SparkSQLQueryJobDefBuilder(activity);
    }

    protected void executeJobDef(final SparkSQLQueryRecipeJobDef jobDef, final SparkOverrideConfig sparkConfig, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine) throws Exception {
        logger.info((Object)("Executing SparkSQL with sparkConfig: " + JSON.json((Object)sparkConfig)));
        this.runSpark("Spark", executionEngine, new SparkExecutionEnginesHelper.SparkRecipeJobBuilder(){

            @Override
            public <T extends SparkJob> T buildSparkJob(SparkJobHelper<T> helper, File runDir, SparkSettings sparkSettings, List<SimpleKeyValue> effectiveConf) throws Exception {
                File serializedFile = FlowJobUtils.getJobFile("sparksql-query", "recipedesc.json");
                JSON.prettyToFile((Object)jobDef, (File)serializedFile);
                T job = helper.makeClassJob("DSS (SQL): " + SparkSQLQueryRecipeRunnerBase.this.activity.id(), false, effectiveConf, "com.dataiku.dip.spark.SparkSQLRecipeJob", serializedFile.getAbsolutePath());
                ((SparkJob)job).secretDriverFiles.add(serializedFile.getAbsolutePath());
                return job;
            }

            @Override
            public SparkOverrideConfig getRecipeOverrideConf() {
                return sparkConfig;
            }
        }, null);
        this.activity.setAllSourcesCompletelyRead();
        this.activity.fillTargetWrittenSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Done");
    }

    @Override
    protected JobProcessExecution getProcessExecution() {
        return new JobProcessExecution(this.authCtxService.getAuthCtx(), this.projectKey){

            @Override
            protected void prepareExecOutputConsumer(DKUtils.ExecOutputConsumer eoc, DKUtils.LineSubscription fwr) throws Exception {
                super.prepareExecOutputConsumer(eoc, fwr);
                eoc.withErrorConsumer((DKUtils.ExecSubscription)SparkSQLQueryRecipeRunnerBase.this.sparkSQLLogParser);
            }

            @Override
            protected void checkErrorsFromLogSniffers() {
                SparkCodes lastExplainableError = SparkSQLQueryRecipeRunnerBase.this.sparkSQLLogParser.getLastExplainableError();
                if (lastExplainableError != null) {
                    throw new CodedRuntimeException((InfoMessage.MessageCode)lastExplainableError, "Failed to execute Spark SQL script");
                }
            }
        };
    }

    protected void clearOutputIfNeeded() throws Exception {
        SparkRecipeUtils.clearActivityOutputsIfNeeded(this.activity, this.datasetsDAO, this.recipe, this.authCtxService.getAuthCtx());
    }

    @Override
    public void notifyBeforeAborting() {
    }
}

