/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.common;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;

public class BigQueryRecipeEngineHelper {
    public static void disableEngineForBigQuery(RecipeEngineStatus engine, Dataset outputDataset) {
        if (engine.isSelectable && BigQueryRecipeEngineHelper.isBigQueryDataset(outputDataset)) {
            engine.markAsNonSelectable("Output dataset is in Google BigQuery", RecipeEngineStatus.WarningLevel.ERROR);
        }
    }

    private static boolean isBigQueryDataset(Dataset outputDataset) {
        return outputDataset != null && DatasetHandlerFactory.getMeta(outputDataset) == BuiltinSQLDatasets.BIGQUERY_META;
    }
}

