/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.customcode;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.exec.AbstractPythonRecipeRunner;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.customcode.CustomCodeRecipeMeta;
import com.dataiku.dip.recipes.customcode.CustomCodeRecipeParams;
import com.dataiku.dip.recipes.customcode.CustomCodeRecipesService;
import com.dataiku.dip.recipes.customcode.LoadedCustomCodeRecipeDesc;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.util.AutoDelete;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomPythonRecipeRunner
extends AbstractPythonRecipeRunner {
    @Autowired
    private CustomCodeRecipesService service;
    @Autowired
    private JobAuthCtxService authCtxService;
    private static Logger logger = Logger.getLogger((String)"dku.flow.custompython");
    private LoadedCustomCodeRecipeDesc desc;

    public CustomPythonRecipeRunner(JobActivity activity) {
        super(activity);
        this.desc = ((CustomCodeRecipeMeta)RecipeRegistry.getMeta(activity)).getPluginDesc();
    }

    @Override
    protected EnvironmentStash prepareEnvStash(File tmpDir, Map<String, String> extraEnv, ContainerExecRuntimeConfig containerConfig, String envName) throws IOException, SQLException, CodedException, DKUSecurityException, InterruptedException {
        EnvironmentStash stash = super.prepareEnvStash(tmpDir, extraEnv, containerConfig, envName);
        CustomCodeRecipeParams params = RecipeRegistry.getParamsAs(this.activity, CustomCodeRecipeParams.class);
        stash.fillForPlugin(this.authCtxService.getAuthCtx(), this.recipe.getProjectKey(), containerConfig, params, this.desc, this.service);
        stash.fillForCustomPythonRecipe(this.desc, this.service);
        return stash;
    }

    @Override
    public void run() throws Exception {
        File additionalLogsFolder = FlowJobUtils.getJobMadeDir("custom-python-recipe", "logs");
        File mainLogFile = FlowJobUtils.getJobTouchedFile("custom-python-recipe", "python-output.log");
        JobContext.getCurrentActivityObj().getStatus().addStatutOutput("Plugin output", mainLogFile, "text/plain");
        try (AutoDelete recipeTmpDir = FlowJobUtils.getTmpFolder("custom-python-recipe", "pyout");){
            File tmpScriptData = new File((File)recipeTmpDir, "script.py");
            logger.info((Object)("Dumping Python script to " + String.valueOf(tmpScriptData)));
            Object pyScriptData = this.service.getCode(this.desc.recipeType);
            pyScriptData = (String)pyScriptData + "\n\n\nimport dataiku as _private_dataiku_import\n_private_dataiku_import._dataset_writer_atexit_handler()\n_private_dataiku_import._folder_writer_atexit_handler()";
            CodeEnvSelector envSelector = new CodeEnvSelector();
            String envName = envSelector.selectForCustomPythonRecipe(this.desc.ownerPluginId);
            CodeEnvModel.UsedCodeEnvRef codeEnvRef = new CodeEnvModel.UsedCodeEnvRef(CodeEnvModel.EnvLang.PYTHON, envName);
            CustomCodeRecipeParams params = RecipeRegistry.getParamsAs(this.activity, CustomCodeRecipeParams.class);
            ContainerExecRuntimeConfig containerConfig = new ContainerExecConfigSelector().select_autoTXN(this.authCtxService.getAuthCtx(), this.recipe.getProjectKey(), params.containerSelection);
            this.activity.setStatusMessage("Executing Python script");
            if (containerConfig == null) {
                this.executeScript((File)recipeTmpDir, mainLogFile, (String)pyScriptData, envName);
            } else {
                switch (containerConfig.type) {
                    case DOCKER: {
                        this.executeDockerCodeRecipe(codeEnvRef, containerConfig, (File)recipeTmpDir, mainLogFile, recipeTmpDir, RemoteRunsRegistry.ExecutionType.RECIPE_PYTHON, (String)pyScriptData, new HashMap<String, String>(), null);
                        break;
                    }
                    case KUBERNETES: {
                        this.executeKubernetesCodeRecipe(codeEnvRef, containerConfig, (File)recipeTmpDir, mainLogFile, additionalLogsFolder, recipeTmpDir, RemoteRunsRegistry.ExecutionType.RECIPE_PYTHON, (String)pyScriptData, new HashMap<String, String>(), null, new KubernetesExecUtils.KubernetesFailureCodeProvider(){

                            @Override
                            public InfoMessage.MessageCode codeForOOMKilled() {
                                return RecipeCodes.ERR_RECIPE_PLUGIN_K8S_OOM;
                            }
                        });
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown execution container: " + String.valueOf((Object)containerConfig.type));
                    }
                }
            }
            this.activity.setAllSourcesCompletelyRead();
            this.activity.fillTargetWrittenSizes(this.datasetsDAO);
            this.activity.setStatusMessage("Done");
        }
    }

    @Override
    public void init() throws Exception {
        this.activity.fillSourceTotalSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Initializing");
    }
}

