/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.recipes.FakeJobActivityFromRecipeBuilder;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.eda.EDARecipeParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;

public class EDARecipeStatusComputer
extends RecipeStatusComputer {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.eda.status");

    public EDARecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    @Override
    public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            RecipeStatus status = this.fastStatusIgnorePartitions(authCtx);
            EDARecipeParams params = this.recipe.getParamsAs(EDARecipeParams.class);
            this.checkContainerConfiguration(authCtx, status, params, status.selectedEngine);
            RecipeStatus recipeStatus = status;
            return recipeStatus;
        }
    }

    @Override
    public RecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws Exception {
        RecipeEngineStatus engineStatus = new RecipeEngineStatus("DSS", "DSS", "MEMORY", "In-memory", "DSS");
        RecipeStatus status = RecipeStatus.buildSingleEngine(engineStatus);
        this.performBasicStructureChecks(status, authCtx);
        JobActivity activity = new FakeJobActivityFromRecipeBuilder().buildFakeJobActivity(this.recipe);
        try {
            this.recipesValidationService.checkTargetsAreWritable(activity);
        }
        catch (CodedRuntimeException e) {
            status.topLevelMessages.withFatalV(e.code, e.getMessage(), new Object[0]);
        }
        return status;
    }
}

