/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.export;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.common.GenericRecipeCreator;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.SingleOutputDatasetRecipeCreator;
import com.dataiku.dip.recipes.services.PDepsFixuper;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ExportRecipeCreator
extends GenericRecipeCreator {
    @Autowired
    private ManagedFoldersService managedFoldersService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.export.creator");

    public ExportRecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta);
    }

    @Override
    public RecipeCreator.CreationResult create_NT(SerializedRecipe recipe, JsonObject creationData) throws Exception {
        assert (StringUtils.isNotBlank((String)recipe.projectKey));
        assert (this.meta.getType().equals(recipe.type));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)recipe.name), (Object)"Recipe has no name");
        List<SerializedRecipe.RecipeOutput> outputs = recipe.getOutputsForRole("main");
        Preconditions.checkArgument((outputs.size() == 1 ? 1 : 0) != 0, (Object)(this.meta.getType() + " recipes require one output"));
        String outputFolderRef = outputs.get((int)0).ref;
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);){
            SingleOutputDatasetRecipeCreator.SingleOutputRecipeCreationSettings settings = (SingleOutputDatasetRecipeCreator.SingleOutputRecipeCreationSettings)JSON.parse((JsonElement)creationData, SingleOutputDatasetRecipeCreator.SingleOutputRecipeCreationSettings.class);
            recipe.name = this.recipeSaveService.transmogrifyName(recipe.projectKey, recipe.name);
            recipe.params = this.makeInitialParams(recipe, creationData);
            if (settings.createOutputFolder) {
                logger.info((Object)("Creating managed folder in project " + recipe.projectKey));
                ManagedFolder odb = this.managedFoldersService.create(recipe.projectKey, outputFolderRef, settings.outputFolderSettings, t.getUser());
                logger.info((Object)"Managed folder ready to commit ");
                outputs.get((int)0).ref = outputFolderRef = odb.id;
            }
            String payload = this.makeInitialPayload(recipe, creationData);
            this.checkOutputOwnership_T(recipe);
            new PDepsFixuper().fixupInPlace(recipe);
            this.assignZone(recipe, creationData.has("zone") ? creationData.get("zone").getAsString() : null);
            this.recipeSaveService.create(recipe.projectKey, recipe, payload);
            t.commitV("Created %s recipe: %s", new Object[]{recipe.type, recipe.getFullId()});
            RecipeCreator.CreationResult creationResult = new RecipeCreator.CreationResult().withId(recipe.name);
            return creationResult;
        }
    }
}

